/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.management.dynamicproxy.AggregationHandler;
import com.ibm.websphere.management.dynamicproxy.ServantMBeanResult;
import com.ibm.websphere.management.dynamicproxy.StateObject;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ControlAdminServiceImpl;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws390.management.ServantMBeanInvoker;
import com.ibm.ws390.management.ServantMBeanInvokerData;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.RuntimeMBeanException;

public abstract class ProxyMBeanSupport
extends RuntimeCollaborator
implements NotificationListener {
    private static TraceComponent tc = Tr.register(ProxyMBeanSupport.class, "Admin", "com.ibm.ws390.management.resources.jmx");
    private HashSet servants = new HashSet();
    private HashSet adjuncts = new HashSet();
    protected ServantMBeanInvoker _mbeanInvoker = new ServantMBeanInvoker();

    public ProxyMBeanSupport(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public ProxyMBeanSupport() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    protected Set currentServants() {
        return Collections.unmodifiableSet(this.servants);
    }

    protected Set currentAdjuncts() {
        return Collections.unmodifiableSet(this.adjuncts);
    }

    protected ServantMBeanInvoker getInvoker() {
        return this._mbeanInvoker;
    }

    protected void handleInternalNotification(Notification notification) {
    }

    public final void handleNotification(Notification notification, Object object) {
        block33: {
            boolean bl;
            String string = notification.getType();
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "handleNotification", string);
            }
            ServantMBeanStatus servantMBeanStatus = (ServantMBeanStatus)notification.getUserData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServantMBeanStatus", servantMBeanStatus);
            }
            String string2 = servantMBeanStatus.getServantStoken();
            ObjectName objectName = this.getObjectName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "MBean proxy objectName", objectName);
            }
            if (string.equals("websphere.ws390.servant.started")) {
                this.handleInternalNotification(notification);
            } else if (string.equals("websphere.ws390.adjunct.started")) {
                this.adjuncts.add(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adjunct started", string2);
                }
                this.handleInternalNotification(notification);
            } else if (string.equals("websphere.ws390.servant.wlm.queueable")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Servant WLMQueueable", string2);
                }
                this.handleInternalNotification(notification);
            } else if (string.equals("websphere.ws390.servant.mbean.registered")) {
                this.servants.add(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Added servant", string2);
                }
                this.handleInternalNotification(notification);
            } else if (string.equals("websphere.ws390.servant.mbean.unregistered")) {
                this.servants.remove(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed servant", string2);
                }
                if ((bl = this.adjuncts.remove(string2)) && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Removed adjunct", string2);
                }
                this.handleInternalNotification(notification);
            } else if (string.equals("websphere.ws390.servant.terminated")) {
                this.servants.remove(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Servant terminated", string2);
                }
                this.handleInternalNotification(notification);
            } else if (string.equals("websphere.ws390.adjunct.terminated")) {
                this.adjuncts.remove(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adjunct terminated", string2);
                }
                this.handleInternalNotification(notification);
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "unsupported event type", string);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servants with MBean managed by " + objectName + " = " + this.servants);
                Tr.debug(tc, "Adjuncts with MBean managed by " + objectName + " = " + this.adjuncts);
            }
            if (this.servants.isEmpty() && this.adjuncts.isEmpty() && (bl = this.prepareToUnregister())) {
                try {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    MBeanServer mBeanServer = adminService.getMBeanFactory().getMBeanServer();
                    ControlAdminServiceImpl.getInstance().removeListener(objectName);
                    mBeanServer.unregisterMBean(objectName);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "MBean proxy  " + objectName + " was unregistered from control MBean server");
                    }
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws390.management.ProxyMBeanSupport.handleNotification", "474", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ControlAdminService not found", instanceNotFoundException);
                    }
                }
                catch (MBeanRegistrationException mBeanRegistrationException) {
                    FFDCFilter.processException((Throwable)mBeanRegistrationException, "com.ibm.ws390.management.ProxyMBeanSupport.handleNotification", "481", this);
                    if (!tc.isDebugEnabled()) break block33;
                    Tr.debug(tc, "Unable to unregister proxy Mbean " + objectName, mBeanRegistrationException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleNotification");
        }
    }

    public String getName() {
        return this.zOSProxyMBeanGetName();
    }

    protected final String zOSProxyMBeanGetName() {
        String string = "";
        ObjectName objectName = this.getObjectName();
        if (objectName != null) {
            string = objectName.getKeyProperty("name");
        }
        return string;
    }

    public String getType() {
        return this.zOSProxyMBeanGetType();
    }

    public String getApplication() {
        return this.zOSProxyMBeanGetApplication();
    }

    protected final String zOSProxyMBeanGetType() {
        String string = "";
        ObjectName objectName = this.getObjectName();
        if (objectName != null) {
            string = objectName.getKeyProperty("type");
        }
        return string;
    }

    protected final String zOSProxyMBeanGetApplication() {
        String string = "";
        ObjectName objectName = this.getObjectName();
        if (objectName != null) {
            string = objectName.getKeyProperty("Application");
        }
        return string;
    }

    protected boolean prepareToUnregister() {
        return true;
    }

    protected Object mbeanInvokerSpray(String string, Object[] objectArray, String[] stringArray, AggregationHandler[] aggregationHandlerArray, StateObject stateObject) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanInvokerSpray", new Object[]{string, objectArray, stringArray, aggregationHandlerArray});
        }
        Object object = null;
        Vector vector = this._mbeanInvoker.invokeSpecifiedServants(this.servants, this.getObjectName(), string, objectArray, stringArray);
        if (aggregationHandlerArray != null && aggregationHandlerArray.length > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking aggregator");
            }
            Object object2 = null;
            for (int i = 0; i < aggregationHandlerArray.length; ++i) {
                if (aggregationHandlerArray[i] != null) {
                    object2 = aggregationHandlerArray[i].aggregateResults(string, objectArray, stringArray, vector.toArray(new ServantMBeanResult[0]), stateObject);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Return from aggregator", object2);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Current returnval", object);
                }
                if (object2 != null) {
                    object = object2;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Return from aggregator", object);
            }
        } else if (vector != null && vector.size() > 0) {
            ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)vector.elementAt(0);
            if (servantMBeanInvokerData.resultThrowable()) {
                Throwable throwable = (Throwable)servantMBeanInvokerData.getResult();
                if (throwable instanceof ConnectorException) {
                    throw this.processConnectorException((ConnectorException)throwable);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught during _mbeanInvoker call", throwable);
                }
                throw throwable;
            }
            object = servantMBeanInvokerData.getResult();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanInvokerSpray", object);
        }
        return object;
    }

    protected Object mbeanInvokerSpray(String string, Object[] objectArray, String[] stringArray, AggregationHandler aggregationHandler, StateObject stateObject) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanInvokerSpray", new Object[]{string, objectArray, stringArray, aggregationHandler});
        }
        Object object = null;
        Vector vector = this._mbeanInvoker.invokeSpecifiedServants(this.servants, this.getObjectName(), string, objectArray, stringArray);
        if (aggregationHandler != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking aggregator");
            }
            object = aggregationHandler.aggregateResults(string, objectArray, stringArray, vector.toArray(new ServantMBeanResult[0]), stateObject);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from aggregator");
            }
        } else if (vector != null && vector.size() > 0) {
            ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)vector.elementAt(0);
            if (servantMBeanInvokerData.resultThrowable()) {
                Throwable throwable = (Throwable)servantMBeanInvokerData.getResult();
                if (throwable instanceof ConnectorException) {
                    throw this.processConnectorException((ConnectorException)throwable);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught during _mbeanInvoker call", throwable);
                }
                throw throwable;
            }
            object = servantMBeanInvokerData.getResult();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanInvokerSpray", object);
        }
        return object;
    }

    protected Object mbeanInvokerSpray(String string) throws Throwable {
        return this.mbeanInvokerSpray(string, null, null, (AggregationHandler[])null, null);
    }

    protected Object mbeanInvokerSimple(String string, Object[] objectArray, String[] stringArray) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanInvokerSimple", new Object[]{string, objectArray, stringArray});
        }
        Object object = null;
        ServantMBeanInvokerData servantMBeanInvokerData = this._mbeanInvoker.invokeAnyServant(this.servants, this.getObjectName(), string, objectArray, stringArray);
        if (servantMBeanInvokerData.resultThrowable()) {
            Throwable throwable = (Throwable)servantMBeanInvokerData.getResult();
            if (throwable instanceof ConnectorException) {
                throw this.processConnectorException((ConnectorException)throwable);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during _mbeanInvoker call", throwable);
            }
            throw throwable;
        }
        object = servantMBeanInvokerData.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanInvokerSimple", object);
        }
        return object;
    }

    protected Object mbeanInvokerSimple(String string) throws Throwable {
        return this.mbeanInvokerSimple(string, null, null);
    }

    protected Object mbeanGetterSimple(String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanGetterSimple", new Object[]{string});
        }
        Object object = null;
        ServantMBeanInvokerData servantMBeanInvokerData = this._mbeanInvoker.getAnyServantMBeanAttribute(this.servants, this.getObjectName(), string);
        if (servantMBeanInvokerData.resultThrowable()) {
            Throwable throwable = (Throwable)servantMBeanInvokerData.getResult();
            if (throwable instanceof ConnectorException) {
                throw this.processConnectorException((ConnectorException)throwable);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during _mbeanGetter call", throwable);
            }
            throw throwable;
        }
        object = servantMBeanInvokerData.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanGetterSimple", object);
        }
        return object;
    }

    protected Object mbeanSetterSimple(String string, Object object) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanSetterSimple", new Object[]{string, object});
        }
        Object object2 = null;
        Iterator iterator = this.servants.iterator();
        HashSet hashSet = new HashSet(1);
        hashSet.add(iterator.next());
        Vector vector = this._mbeanInvoker.setSpecifiedServantsMBeanAttribute(hashSet, this.getObjectName(), string, object);
        ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)vector.elementAt(0);
        if (servantMBeanInvokerData.resultThrowable()) {
            Throwable throwable = (Throwable)servantMBeanInvokerData.getResult();
            if (throwable instanceof ConnectorException) {
                throw this.processConnectorException((ConnectorException)throwable);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught during _mbeanSetter call", throwable);
            }
            throw throwable;
        }
        object2 = servantMBeanInvokerData.getResult();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanSetterSimple", object2);
        }
        return object2;
    }

    protected void mbeanSetterSpray(String string, Object object) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mbeanSetterSpray", new Object[]{string, object});
        }
        Vector vector = this._mbeanInvoker.setSpecifiedServantsMBeanAttribute(this.servants, this.getObjectName(), string, object);
        for (int i = 0; i < vector.size(); ++i) {
            ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)vector.elementAt(i);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServantMBeanInvokerData", servantMBeanInvokerData);
            }
            if (!servantMBeanInvokerData.resultThrowable()) continue;
            Throwable throwable = (Throwable)servantMBeanInvokerData.getResult();
            if (tc.isEventEnabled()) {
                Tr.event(tc, "mbeanSetterSpray error", throwable);
            }
            if (throwable instanceof ConnectorException) {
                throw this.processConnectorException((ConnectorException)throwable);
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mbeanSetterSpray");
        }
    }

    public String getObjectNameStr() {
        return this.getObjectName().toString();
    }

    protected Throwable processConnectorException(ConnectorException connectorException) {
        Throwable throwable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processConnectorException", connectorException);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ConnectorException caught during _mbeanInvoker call", connectorException);
        }
        if ((throwable = connectorException.getCause()) instanceof MBeanException) {
            throwable = ((MBeanException)throwable).getTargetException();
        } else if (throwable instanceof RuntimeMBeanException) {
            throwable = ((RuntimeMBeanException)throwable).getTargetException();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "cause", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processConnectorException");
        }
        return throwable;
    }

    protected void proxyHelperTraceThrowable(String string, ServantMBeanInvokerData servantMBeanInvokerData, TraceComponent traceComponent) {
        if (traceComponent.isEventEnabled() && servantMBeanInvokerData.resultThrowable()) {
            Tr.event(traceComponent, "Error invoking servant MBean: servant = " + servantMBeanInvokerData.getStoken() + ", operation = " + string + ",MBean = " + this.getObjectName(), servantMBeanInvokerData.getResult());
        }
    }

    protected void proxyHelperTraceThrowables(String string, Vector vector, TraceComponent traceComponent) {
        if (traceComponent.isEventEnabled()) {
            for (int i = 0; i < vector.size(); ++i) {
                ServantMBeanInvokerData servantMBeanInvokerData = (ServantMBeanInvokerData)vector.elementAt(i);
                if (!servantMBeanInvokerData.resultThrowable()) continue;
                Tr.event(traceComponent, "Error invoking servant MBean: servant = " + servantMBeanInvokerData.getStoken() + ", operation = " + string + ",MBean = " + this.getObjectName(), servantMBeanInvokerData.getResult());
            }
        }
    }

    public Object getValueFromAnyServant(String string, Object[] objectArray, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValueFromAnyServant", string);
        }
        Object object = null;
        Set set = this.currentServants();
        Iterator iterator = set.iterator();
        while (object == null && iterator.hasNext()) {
            ServantMBeanInvokerData servantMBeanInvokerData;
            Object object2;
            String string2 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken for _mbeanInvoker", string2);
            }
            if ((object2 = (servantMBeanInvokerData = this._mbeanInvoker.invokeSpecificServant(string2, this.getObjectName(), string, objectArray, stringArray)).getResult()) instanceof Throwable) {
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "Exception driving _mbeanInvoker", (Throwable)object2);
                continue;
            }
            object = object2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValueFromAnyServant", object);
        }
        return object;
    }

    public Object getAttributeValueFromAnyServant(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeValueFromAnyServant", string);
        }
        Object object = null;
        ServantMBeanInvokerData servantMBeanInvokerData = this._mbeanInvoker.getAnyServantMBeanAttribute(this.currentServants(), this.getObjectName(), string);
        Object object2 = servantMBeanInvokerData.getResult();
        if (servantMBeanInvokerData.resultThrowable()) {
            if (tc.isEventEnabled()) {
                this.proxyHelperTraceThrowable("getAttribute: " + string, servantMBeanInvokerData, tc);
            }
        } else {
            object = object2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeValueFromAnyServant", object);
        }
        return object;
    }

    public Object getValueFromAnyServantWithException(String string, Object[] objectArray, String[] stringArray) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getValueFromAnyServant", string);
        }
        Object object = null;
        Set set = this.currentServants();
        Iterator iterator = set.iterator();
        while (object == null && iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken for _mbeanInvoker", string2);
            }
            ServantMBeanInvokerData servantMBeanInvokerData = this._mbeanInvoker.invokeSpecificServant(string2, this.getObjectName(), string, objectArray, stringArray);
            Object object2 = servantMBeanInvokerData.getResult();
            if (servantMBeanInvokerData.resultThrowable()) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception driving _mbeanInvoker", (Throwable)object2);
                }
                if (object2 instanceof ConnectorException) {
                    throw this.processConnectorException((ConnectorException)object2);
                }
                throw (Throwable)object2;
            }
            object = object2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getValueFromAnyServant", object);
        }
        return object;
    }

    public Object getAttributeValueFromAnyServantWithException(String string) throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributeValueFromAnyServant", string);
        }
        Object object = null;
        ServantMBeanInvokerData servantMBeanInvokerData = this._mbeanInvoker.getAnyServantMBeanAttribute(this.currentServants(), this.getObjectName(), string);
        Object object2 = servantMBeanInvokerData.getResult();
        if (servantMBeanInvokerData.resultThrowable()) {
            if (tc.isEventEnabled()) {
                this.proxyHelperTraceThrowable("getAttribute: " + string, servantMBeanInvokerData, tc);
            }
            if (object2 instanceof ConnectorException) {
                throw this.processConnectorException((ConnectorException)object2);
            }
            throw (Throwable)object2;
        }
        object = object2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributeValueFromAnyServant", object);
        }
        return object;
    }
}

