/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.util.JVMListenerInterface;
import java.util.Iterator;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ServantJVMListener
implements JVMListenerInterface {
    private static final TraceComponent tc = Tr.register(ServantJVMListener.class, "Admin", "com.ibm.ws390.management.resources.jmx");
    private AdminService adminService;
    private MBeanServer mbServer;
    private ObjectName controlMBeanName;

    public ServantJVMListener() {
        block7: {
            this.adminService = null;
            this.mbServer = null;
            this.controlMBeanName = null;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "<init>");
            }
            try {
                this.adminService = AdminServiceFactory.getAdminService();
                String string = this.adminService.getNodeName();
                String string2 = this.adminService.getProcessName();
                ObjectName objectName = new ObjectName(this.adminService.getDomainName() + ":" + "type=ControlAdminService,node=" + string + ",process=" + string2 + ",*");
                this.mbServer = this.adminService.getMBeanFactory().getMBeanServer();
                Set<ObjectName> set = this.mbServer.queryNames(objectName, null);
                if (set.isEmpty()) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ControlAdminService MBean not registered");
                    }
                } else {
                    Iterator<ObjectName> iterator = set.iterator();
                    this.controlMBeanName = iterator.next();
                }
                AdminHelper.getPlatformHelper().registerListener(this);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, "com.ibm.ws390.management.ServantJVMListener.ServantJVMListener", "119", this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "ControlAdminService object name error", malformedObjectNameException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public synchronized void servantTerminated(String string) {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "servantTerminated", string);
            }
            if (this.controlMBeanName != null) {
                String string2 = null;
                if (string != null && string.length() > 0) {
                    string2 = string;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "stringStoken", string2);
                    }
                } else {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Servant stoken not present");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Throwing illegal argument exception", illegalArgumentException);
                    }
                    throw illegalArgumentException;
                }
                try {
                    this.mbServer.invoke(this.controlMBeanName, "cleanupServantJVM", new Object[]{string2}, new String[]{"java.lang.String"});
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws390.management.ServantJVMListener.servantTerminated", "201", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to invoke ControlAdminService MBean", instanceNotFoundException);
                    }
                }
                catch (MBeanException mBeanException) {
                    FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws390.management.ServantJVMListener.servantTerminated", "207", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Unable to invoke ControlAdminService MBean", mBeanException);
                    }
                }
                catch (ReflectionException reflectionException) {
                    FFDCFilter.processException((Throwable)reflectionException, "com.ibm.ws390.management.ServantJVMListener.servantTerminated", "213", this);
                    if (!tc.isDebugEnabled()) break block13;
                    Tr.debug(tc, "Unable to invoke ControlAdminService MBean", reflectionException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "servantTerminated");
        }
    }
}

