/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.connector.corba;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.websphere.management.exception.ConnectorNotAvailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.management.connector.AdminServiceProxy;
import com.ibm.ws.management.connector.rmi.RMINotificationListener;
import com.ibm.ws.management.connector.rmi.RMINotificationListenerService;
import com.ibm.ws.management.event.ConsolidatedFilter;
import com.ibm.ws.management.event.ListenerIdentifier;
import com.ibm.ws.management.event.PushNotificationListener;
import com.ibm.ws.management.event.PushRemoteReceiver;
import com.ibm.ws.management.event.RemoteReceiver;
import com.ibm.ws.management.exception.ReceiverNotFoundException;
import com.ibm.ws390.management.NotAControllerException;
import com.ibm.ws390.management.connector.corba.CorbaConnector;
import com.ibm.ws390.management.connector.corba.CorbaConnectorImpl;
import com.ibm.ws390.management.connector.corba.CorbaConnectorPackage.ServerExceptionWrapper;
import com.ibm.ws390.management.connector.corba.JavaObjectSerializer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.rmi.CORBA.Stub;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.ORB;

public class CorbaConnectorClient
implements AdminServiceProxy {
    private static TraceComponent tc = Tr.register(CorbaConnectorClient.class, "Admin", "com.ibm.ws390.management.resources.jmx");
    private RMINotificationListener rmiListener = null;
    private Properties proxyProps = null;
    public static final String CONNECTOR_TYPE_CORBA = "CORBA";
    public static final String CONNECTOR_SERVANT = "servant";
    public static final String CONNECTOR_IOR = "ior";
    private String servantStoken = null;
    private String iorString = null;
    private CorbaConnector connector = null;

    public CorbaConnectorClient(Properties properties) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", properties);
        }
        this.servantStoken = properties.getProperty(CONNECTOR_SERVANT);
        if (this.servantStoken == null) {
            this.iorString = properties.getProperty(CONNECTOR_IOR);
            if (this.iorString != null) {
                this.iorString.trim();
            }
            if (this.iorString == null || this.iorString.length() == 0) {
                throw new ConnectorException("Servant stoken nor IOR specified");
            }
        } else {
            if (!AdminHelper.getPlatformHelper().isControlJvm()) {
                NotAControllerException notAControllerException = new NotAControllerException();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Throwing NotAControllerException", notAControllerException);
                }
                throw notAControllerException;
            }
            this.servantStoken = this.servantStoken.trim();
            if (this.servantStoken.length() == 0) {
                throw new ConnectorException("Servant stoken nor IOR specified");
            }
        }
        this.proxyProps = new Properties();
        this.proxyProps.setProperty("type", CONNECTOR_TYPE_CORBA);
        if (this.servantStoken == null) {
            this.proxyProps.setProperty(CONNECTOR_IOR, this.iorString);
        } else {
            this.proxyProps.setProperty(CONNECTOR_SERVANT, this.servantStoken);
        }
        this.reconnect();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public CorbaConnector getCorbaConnector() {
        return this.connector;
    }

    public String getType() {
        return CONNECTOR_TYPE_CORBA;
    }

    public Properties getProxyProperties() {
        return this.proxyProps;
    }

    public void reconnect() throws ConnectorNotAvailableException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "reconnect");
        }
        this.connector = null;
        if (this.servantStoken == null) {
            this.connector = AdminServiceImpl.getPlatformUtils().getConnectorStub(this.iorString);
        } else {
            Iterator iterator;
            object = this.servantStoken.toUpperCase().toCharArray();
            byte[] byArray = new byte[((char[])object).length / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = object[i * 2] >= '0' && object[i * 2] <= '9' ? (byte)((object[i * 2] - 48) * 16) : (byte)((object[i * 2] - 65 + 10) * 16);
                if (object[i * 2 + 1] >= '0' && object[i * 2 + 1] <= '9') {
                    int n = i;
                    byArray[n] = (byte)(byArray[n] + (object[i * 2 + 1] - 48));
                    continue;
                }
                int n = i;
                byArray[n] = (byte)(byArray[n] + (object[i * 2 + 1] - 65 + 10));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "binary stoken", byArray);
            }
            if ((iterator = AdminServiceImpl.getPlatformUtils().getSRAggregator(new CorbaConnectorImpl(), false, byArray)).hasNext()) {
                this.connector = (CorbaConnector)iterator.next();
            }
        }
        if (this.connector == null) {
            object = new ConnectorNotAvailableException("Nonexistant stoken/IOR");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "throwing exception", object);
            }
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "reconnect");
        }
    }

    public RemoteReceiver openRemoteNotificationChannel(AdminServiceProxy adminServiceProxy) {
        PushRemoteReceiver pushRemoteReceiver;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "openRemoteNotificationChannel", adminServiceProxy);
            }
            pushRemoteReceiver = new PushRemoteReceiver(adminServiceProxy);
            try {
                this.rmiListener = (RMINotificationListener)PortableRemoteObject.toStub((Remote)new RMINotificationListenerService(pushRemoteReceiver));
                ((Stub)this.rmiListener).connect(ORB.init((String[])new String[0], null));
            }
            catch (RemoteException remoteException) {
                FFDCFilter.processException((Throwable)remoteException, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.openRemoteNotificationChannel", "322", this);
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "Error creating RMI stub", remoteException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "openRemoteNotificationChannel", pushRemoteReceiver);
        }
        return pushRemoteReceiver;
    }

    public Session isAlive() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isAlive");
        }
        Session session = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking isAlive");
            }
            byte[] byArray = this.connector.isAlive();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray != null && byArray.length > 0) {
                session = (Session)JavaObjectSerializer.getObject(byArray);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isAlive", "360", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isAlive", "366", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isAlive", session);
        }
        return session;
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ConnectorException, InstanceAlreadyExistsException, MBeanException, MBeanRegistrationException, NotCompliantMBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createMBean", new Object[]{string, objectName});
        }
        ObjectInstance objectInstance = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray2 = this.connector.createMBean(string, byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray2 != null && byArray2.length > 0) {
                objectInstance = (ObjectInstance)JavaObjectSerializer.getObject(byArray2);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.createMBean", "426", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            if (exception instanceof InstanceAlreadyExistsException) {
                throw (InstanceAlreadyExistsException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof MBeanRegistrationException) {
                throw (MBeanRegistrationException)exception;
            }
            if (exception instanceof NotCompliantMBeanException) {
                throw (NotCompliantMBeanException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.createMBean", "443", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", objectInstance);
        }
        return objectInstance;
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryNames", objectName);
        }
        Set set = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            byte[] byArray2 = JavaObjectSerializer.getByteArray(queryExp);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray3 = this.connector.queryNames(byArray, byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray3 != null && byArray3.length > 0) {
                set = (Set)JavaObjectSerializer.getObject(byArray3);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.queryNames", "498", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.queryNames", "504", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryNames", set);
        }
        return set;
    }

    public Object getAttribute(ObjectName objectName, String string) throws AttributeNotFoundException, ConnectorException, InstanceNotFoundException, MBeanException, ReflectionException {
        Object object;
        if (tc.isEntryEnabled()) {
            object = new Object[]{objectName, string};
            Tr.entry(tc, "getAttribute", object);
        }
        object = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray2 = this.connector.getAttribute(byArray, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray2 != null && byArray2.length > 0) {
                object = JavaObjectSerializer.getObject(byArray2);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getAttribute", "562", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            if (exception instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getAttribute", "577", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", object);
        }
        return object;
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws ConnectorException, InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", objectName);
        }
        AttributeList attributeList = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            byte[] byArray2 = JavaObjectSerializer.getByteArray(stringArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray3 = this.connector.getAttributes(byArray, byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray3 != null && byArray3.length > 0) {
                attributeList = (AttributeList)JavaObjectSerializer.getObject(byArray3);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getAttributes", "632", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getAttributes", "643", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", attributeList);
        }
        return attributeList;
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws AttributeNotFoundException, ConnectorException, InstanceNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttribute", objectName);
        }
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            byte[] byArray2 = JavaObjectSerializer.getByteArray(attribute);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.setAttribute(byArray, byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.setAttribute", "694", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            if (exception instanceof AttributeNotFoundException) {
                throw (AttributeNotFoundException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof InvalidAttributeValueException) {
                throw (InvalidAttributeValueException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.setAttribute", "711", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttribute");
        }
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws ConnectorException, InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", objectName);
        }
        AttributeList attributeList2 = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            byte[] byArray2 = JavaObjectSerializer.getByteArray(attributeList);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray3 = this.connector.setAttributes(byArray, byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray3 != null && byArray3.length > 0) {
                attributeList2 = (AttributeList)JavaObjectSerializer.getObject(byArray3);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.setAttributes", "764", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.setAttributes", "775", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes", attributeList2);
        }
        return attributeList2;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws ConnectorException, InstanceNotFoundException, MBeanException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "invoke", objectName);
        }
        Object object = null;
        try {
            String[] stringArray2;
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            byte[] byArray2 = new byte[]{};
            if (objectArray != null && objectArray.length > 0) {
                byArray2 = JavaObjectSerializer.getByteArray(objectArray);
            }
            if ((stringArray2 = stringArray) == null) {
                stringArray2 = new String[]{};
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray3 = this.connector.invoke(byArray, string, byArray2, stringArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray3 != null && byArray3.length > 0) {
                object = JavaObjectSerializer.getObject(byArray3);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.invoke", "843", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof MBeanException) {
                throw (MBeanException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.invoke", "856", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "invoke", object);
        }
        return object;
    }

    public String getDefaultDomain() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultDomain");
        }
        String string = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            string = this.connector.getDefaultDomain();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getDefaultDomain", "894", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultDomain", string);
        }
        return string;
    }

    public String getDomainName() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDomainName");
        }
        String string = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            string = this.connector.getDomainName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getDomainName", "930", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDomainName", string);
        }
        return string;
    }

    public Integer getMBeanCount() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanCount");
        }
        Integer n = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray = this.connector.getMBeanCount();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray != null && byArray.length > 0) {
                n = (Integer)JavaObjectSerializer.getObject(byArray);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getMBeanCount", "969", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getMBeanCount", "975", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanCount", n);
        }
        return n;
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws ConnectorException, IntrospectionException, InstanceNotFoundException, ReflectionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMBeanInfo", objectName);
        }
        MBeanInfo mBeanInfo = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray2 = this.connector.getMBeanInfo(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray2 != null && byArray2.length > 0) {
                mBeanInfo = (MBeanInfo)JavaObjectSerializer.getObject(byArray2);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getMBeanInfo", "1027", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            if (exception instanceof IntrospectionException) {
                throw (IntrospectionException)exception;
            }
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            if (exception instanceof ReflectionException) {
                throw (ReflectionException)exception;
            }
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getMBeanInfo", "1040", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMBeanInfo", mBeanInfo);
        }
        return mBeanInfo;
    }

    public ObjectName getServerMBean() throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerMBean");
        }
        ObjectName objectName = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray = this.connector.getServerMBean();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray != null && byArray.length > 0) {
                objectName = (ObjectName)JavaObjectSerializer.getObject(byArray);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getServerMBean", "1081", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getServerMBean", "1087", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerMBean", objectName);
        }
        return objectName;
    }

    public boolean isRegistered(ObjectName objectName) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRegistered", objectName);
        }
        boolean bl = false;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            bl = this.connector.isRegistered(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isRegistered", "1129", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isRegistered", "1135", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRegistered", new Boolean(bl));
        }
        return bl;
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isInstanceOf", objectName);
        }
        boolean bl = false;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            bl = this.connector.isInstanceOf(byArray, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isInstanceOf", "1181", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            if (exception instanceof InstanceNotFoundException) {
                throw (InstanceNotFoundException)exception;
            }
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.isInstanceOf", "1190", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isInstanceOf", new Boolean(bl));
        }
        return bl;
    }

    public ListenerIdentifier addNotificationListener(ConsolidatedFilter consolidatedFilter, PushNotificationListener pushNotificationListener) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", pushNotificationListener);
        }
        ListenerIdentifier listenerIdentifier = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(consolidatedFilter);
            byte[] byArray2 = JavaObjectSerializer.getByteArray(pushNotificationListener);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray3 = this.connector.addRMINotificationListener(byArray, byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray3 != null && byArray3.length > 0) {
                listenerIdentifier = (ListenerIdentifier)JavaObjectSerializer.getObject(byArray3);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.addNotificationListener", "1238", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.addNotificationListener", "1244", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener", listenerIdentifier);
        }
        return listenerIdentifier;
    }

    public void removeNotificationListener(ListenerIdentifier listenerIdentifier) throws ConnectorException, ReceiverNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener", listenerIdentifier);
        }
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(listenerIdentifier);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.removeNotificationListener(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", "1287", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            if (exception instanceof ReceiverNotFoundException) {
                throw (ReceiverNotFoundException)exception;
            }
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", "1296", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener");
        }
    }

    public void resetFilter(ListenerIdentifier listenerIdentifier, ConsolidatedFilter consolidatedFilter) throws ConnectorException, ReceiverNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetFilter", listenerIdentifier);
        }
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(listenerIdentifier);
            byte[] byArray2 = JavaObjectSerializer.getByteArray(consolidatedFilter);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.resetFilter(byArray, byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.resetFilter", "1340", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            if (exception instanceof ReceiverNotFoundException) {
                throw (ReceiverNotFoundException)exception;
            }
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.resetFilter", "1349", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetFilter");
        }
    }

    public Notification[] pullNotifications(ListenerIdentifier listenerIdentifier, Integer n) throws ConnectorException, ReceiverNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pullNotifications", listenerIdentifier);
        }
        Notification[] notificationArray = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(listenerIdentifier);
            byte[] byArray2 = JavaObjectSerializer.getByteArray(n);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray3 = this.connector.pullNotifications(byArray, byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray3 != null && byArray3.length > 0) {
                notificationArray = (Notification[])JavaObjectSerializer.getObject(byArray3);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.pullNotifications", "1399", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            if (exception instanceof ReceiverNotFoundException) {
                throw (ReceiverNotFoundException)exception;
            }
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.pullNotifications", "1408", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pullNotifications", notificationArray);
        }
        return notificationArray;
    }

    private Exception getRemoteException(ServerExceptionWrapper serverExceptionWrapper) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteException", (Object)serverExceptionWrapper);
        }
        if (tc.isDebugEnabled()) {
            object = JavaObjectSerializer.getStackTrace(serverExceptionWrapper);
            Tr.debug(tc, "Remote exception or error", object);
        }
        object = null;
        try {
            Throwable throwable = JavaObjectSerializer.getException(serverExceptionWrapper);
            object = throwable instanceof AttributeNotFoundException || throwable instanceof InstanceNotFoundException || throwable instanceof InvalidAttributeValueException || throwable instanceof MBeanException || throwable instanceof ReceiverNotFoundException || throwable instanceof ReflectionException ? (Exception)throwable : new ConnectorException("Remote exception received", throwable);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getRemoteException", "1469", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Nested connector error", exception);
            }
            object = new ConnectorException("Controller local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemoteException", object);
        }
        return object;
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryMBeans", objectName);
        }
        Set set = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            byte[] byArray2 = JavaObjectSerializer.getByteArray(queryExp);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray3 = this.connector.queryMBeans(byArray, byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray3 != null && byArray3.length > 0) {
                set = (Set)JavaObjectSerializer.getObject(byArray3);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.queryMBeans", "538", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.queryMBeans", "544", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryMBeans", set);
        }
        return set;
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoaderFor", objectName);
        }
        ClassLoader classLoader = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray2 = this.connector.getClassLoaderFor(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray2 != null && byArray2.length > 0) {
                classLoader = (ClassLoader)JavaObjectSerializer.getObject(byArray2);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getClassLoaderFor", "1550", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getClassLoaderFor", "1557", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoaderFor", classLoader);
        }
        return classLoader;
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassLoader", objectName);
        }
        ClassLoader classLoader = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray2 = this.connector.getClassLoader(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray2 != null && byArray2.length > 0) {
                classLoader = (ClassLoader)JavaObjectSerializer.getObject(byArray2);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getClassLoader", "1597", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getClassLoader", "1604", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassLoader", classLoader);
        }
        return classLoader;
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getObjectInstance", objectName);
        }
        ObjectInstance objectInstance = null;
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            byte[] byArray2 = this.connector.getObjectInstance(byArray);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
            if (byArray2 != null && byArray2.length > 0) {
                objectInstance = (ObjectInstance)JavaObjectSerializer.getObject(byArray2);
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getObjectInstance", "1545", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.getObjectInstance", "1190", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getObjectInstance", objectInstance);
        }
        return objectInstance;
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addNotificationListener", new Object[]{objectName, objectName2});
        }
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            byte[] byArray2 = JavaObjectSerializer.getByteArray(objectName2);
            byte[] byArray3 = JavaObjectSerializer.getByteArray(notificationFilter);
            byte[] byArray4 = JavaObjectSerializer.getByteArray(object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.addNotificationListener(byArray, byArray2, byArray3, byArray4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.addNotificationListener", "1587", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw (ConnectorException)exception;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.addNotificationListener", "1593", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addNotificationListener");
        }
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener2", new Object[]{objectName, objectName2});
        }
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            byte[] byArray2 = JavaObjectSerializer.getByteArray(objectName2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.removeNotificationListener_2(byArray, byArray2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", "1623", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw new ConnectorException("Local exception", exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", "11632", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener2");
        }
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeNotificationListener4", new Object[]{objectName, objectName2, notificationFilter, object});
        }
        try {
            byte[] byArray = JavaObjectSerializer.getByteArray(objectName);
            byte[] byArray2 = JavaObjectSerializer.getByteArray(objectName2);
            byte[] byArray3 = JavaObjectSerializer.getByteArray(notificationFilter);
            byte[] byArray4 = JavaObjectSerializer.getByteArray(object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Invoking JMX connector");
            }
            this.connector.removeNotificationListener_4(byArray, byArray2, byArray3, byArray4);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Return from JMX connector");
            }
        }
        catch (ServerExceptionWrapper serverExceptionWrapper) {
            FFDCFilter.processException((Throwable)((Object)serverExceptionWrapper), "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", "1623", this);
            Exception exception = this.getRemoteException(serverExceptionWrapper);
            throw new ConnectorException("Local exception", exception);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.connector.corba.CorbaConnectorClient.removeNotificationListener", "1632", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Local exception", exception);
            }
            throw new ConnectorException("Local exception", exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeNotificationListener4");
        }
    }
}

