/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.connector.corba;

import com.ibm.ws.util.WsObjectInputStream;
import com.ibm.ws390.management.connector.corba.CorbaConnectorPackage.ServerExceptionWrapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class JavaObjectSerializer {
    private JavaObjectSerializer() {
    }

    public static byte[] getByteArray(Object object) throws IOException {
        byte[] byArray = new byte[]{};
        if (object != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    public static Object getObject(byte[] byArray) throws IOException, ClassNotFoundException {
        Object object = null;
        if (byArray != null && byArray.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
            object = wsObjectInputStream.readObject();
        }
        return object;
    }

    public static ServerExceptionWrapper getExceptionWrapper(Throwable throwable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(throwable);
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        ServerExceptionWrapper serverExceptionWrapper = new ServerExceptionWrapper(byteArrayOutputStream.toByteArray(), stringWriter.toString());
        return serverExceptionWrapper;
    }

    public static Throwable getException(ServerExceptionWrapper serverExceptionWrapper) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(serverExceptionWrapper.exceptionData);
        WsObjectInputStream wsObjectInputStream = new WsObjectInputStream(byteArrayInputStream);
        Throwable throwable = (Throwable)wsObjectInputStream.readObject();
        return throwable;
    }

    public static String getStackTrace(ServerExceptionWrapper serverExceptionWrapper) {
        return serverExceptionWrapper.stacktrace;
    }
}

