/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.configservice.ValidationResult;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ControlAdminServiceImpl;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.ServantMBeanInvokerData;
import com.ibm.ws390.management.proxy.WorkSpaceManagerMBeanProxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import javax.management.QueryExp;

public class ConfigServiceManager
extends ProxyMBeanSupport
implements ConfigService {
    private static TraceComponent tc = Tr.register(ConfigServiceManager.class, "management", "com.ibm.ws.management.resources.configservice");
    protected static Map sessionToSR = Collections.synchronizedMap(new HashMap());
    private SortedSet currentServants = Collections.synchronizedSortedSet(new TreeSet());
    private String waitLock = "My Lock";
    private int DEAD_SERVANT_WAIT = 5000;

    public ConfigServiceManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ConfigServiceManager");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConfigServiceManager");
        }
    }

    protected static Map getSessions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessions");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessions", sessionToSR);
        }
        return sessionToSR;
    }

    public void setProperties(Session session, HashMap hashMap) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setProperties", new Object[]{session, hashMap});
        }
        this.voidPlayer(session, null, "setProperties", new Object[]{session, hashMap}, new String[]{"com.ibm.websphere.management.Session", "java.util.HashMap"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setProperties");
        }
    }

    public ValidationResult validate(Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate", new Object[]{session, objectName});
        }
        ValidationResult validationResult = null;
        validationResult = (ValidationResult)this.objectPlayer(session, null, "validate", new Object[]{session, objectName}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate", validationResult);
        }
        return validationResult;
    }

    public void save(Session session, boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "save", new Object[]{session, new Boolean(bl)});
        }
        this.voidPlayer(session, null, "save", new Object[]{session, new Boolean(bl)}, new String[]{"com.ibm.websphere.management.Session", "boolean"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "save", session);
        }
    }

    public void discard(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "discard", session);
        }
        this.voidPlayer(session, null, "discard", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        String string = ConfigServiceManager.getSessionKey(session);
        sessionToSR.remove(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "discard", session);
        }
    }

    public String[] getUnsavedChanges(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUnsavedChanges", session);
        }
        String[] stringArray = null;
        stringArray = (String[])this.objectPlayer(session, null, "getUnsavedChanges", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUnsavedChanges", stringArray);
        }
        return stringArray;
    }

    public Map getConflictDocuments(Session session) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConflictDocuments", session);
        }
        Map map = null;
        map = (Map)this.objectPlayer(session, null, "getConflictDocuments", new Object[]{session}, new String[]{"com.ibm.websphere.management.Session"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConflictDocuments", map);
        }
        return map;
    }

    public String[] getSupportedConfigObjectTypes() throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSupportedConfigObjectTypes");
        }
        String[] stringArray = null;
        stringArray = (String[])this.objectPlayer("getSupportedConfigObjectTypes", null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSupportedConfigObjectTypes", stringArray);
        }
        return stringArray;
    }

    public AttributeList getAttributesMetaInfo(String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributesMetaInfo", string);
        }
        AttributeList attributeList = null;
        attributeList = (AttributeList)this.objectPlayer("getAttributesMetaInfo", new Object[]{string}, new String[]{"java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributesMetaInfo", attributeList);
        }
        return attributeList;
    }

    public AttributeList getRelationshipsMetaInfo(String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationshipsMetaInfo", string);
        }
        AttributeList attributeList = null;
        attributeList = (AttributeList)this.objectPlayer("getRelationshipsMetaInfo", new Object[]{string}, new String[]{"java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationshipsMetaInfo", attributeList);
        }
        return attributeList;
    }

    public ObjectName[] queryConfigObjects(Session session, ObjectName objectName, ObjectName objectName2, QueryExp queryExp) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryConfigObjects", new Object[]{session, objectName, objectName2, queryExp});
        }
        ObjectName[] objectNameArray = null;
        objectNameArray = (ObjectName[])this.objectPlayer(session, null, "queryConfigObjects", new Object[]{session, objectName, objectName2, queryExp}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.ObjectName", "javax.management.QueryExp"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryConfigObjects", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] queryTemplates(Session session, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "queryTemplates", new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        objectNameArray = (ObjectName[])this.objectPlayer(session, null, "queryTemplates", new Object[]{session, string}, new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "queryTemplates", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] resolve(Session session, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        objectNameArray = (ObjectName[])this.objectPlayer(session, null, "resolve", new Object[]{session, string}, new String[]{"com.ibm.websphere.management.Session", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName[] resolve(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve", new Object[]{session, string});
        }
        ObjectName[] objectNameArray = null;
        objectNameArray = (ObjectName[])this.objectPlayer(session, null, "resolve", new Object[]{session, objectName, string}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", objectNameArray);
        }
        return objectNameArray;
    }

    public ObjectName createConfigDataByTemplate(Session session, ObjectName objectName, String string, AttributeList attributeList, ObjectName objectName2) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigDataByTemplate", new Object[]{session, objectName, string, attributeList, objectName2});
        }
        ObjectName objectName3 = null;
        objectName3 = (ObjectName)this.objectPlayer(session, null, "createConfigDataByTemplate", new Object[]{session, objectName, string, attributeList, objectName2}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "javax.management.AttributeList", "javax.management.ObjectName"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigDataByTemplate", objectName3);
        }
        return objectName3;
    }

    public ObjectName createConfigData(Session session, ObjectName objectName, String string, String string2, AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createConfigData", new Object[]{session, objectName, string, string2, attributeList});
        }
        ObjectName objectName2 = null;
        objectName2 = (ObjectName)this.objectPlayer(session, null, "createConfigData", new Object[]{session, objectName, string, string2, attributeList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.String", "javax.management.AttributeList"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createConfigData", objectName2);
        }
        return objectName2;
    }

    public void setAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAttributes", new Object[]{session, objectName, attributeList});
        }
        this.voidPlayer(session, null, "setAttributes", new Object[]{session, objectName, attributeList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAttributes");
        }
    }

    public void addElement(Session session, ObjectName objectName, String string, Object object, int n) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addElement", new Object[]{session, objectName, string, object, new Integer(n)});
        }
        this.voidPlayer(session, null, "addElement", new Object[]{session, objectName, string, object, new Integer(n)}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object", "int"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addElement");
        }
    }

    public void removeElement(Session session, ObjectName objectName, String string, Object object) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeElement", new Object[]{session, objectName, string, object});
        }
        this.voidPlayer(session, null, "removeElement", new Object[]{session, objectName, string, object}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String", "java.lang.Object"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeElement");
        }
    }

    public void unsetAttributes(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unsetAttributes", new Object[]{session, objectName, stringArray});
        }
        this.voidPlayer(session, null, "unsetAttributes", new Object[]{session, objectName, stringArray}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "unsetAttributes");
        }
    }

    public void resetAttributes(Session session, ObjectName objectName, AttributeList attributeList) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetAttributes", new Object[]{session, objectName, attributeList});
        }
        this.voidPlayer(session, null, "resetAttributes", new Object[]{session, objectName, attributeList}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "javax.management.AttributeList"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetAttributes");
        }
    }

    public AttributeList getAttributes(Session session, ObjectName objectName, String[] stringArray, boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttributes", new Object[]{session, objectName, stringArray, new Boolean(bl)});
        }
        AttributeList attributeList = null;
        attributeList = (AttributeList)this.objectPlayer(session, null, "getAttributes", new Object[]{session, objectName, stringArray, new Boolean(bl)}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;", "boolean"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttributes", attributeList);
        }
        return attributeList;
    }

    public Object getAttribute(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAttribute", new Object[]{session, objectName, string});
        }
        Object object = null;
        object = this.objectPlayer(session, null, "getAttribute", new Object[]{session, objectName, string}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAttribute", object);
        }
        return object;
    }

    public Object getAttribute(Session session, ObjectName objectName, String string, boolean bl) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "Enter - ConfigServiceManager.getAttribute", new Object[]{session, objectName, string, new Boolean(bl)});
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Exit - ConfigServiceManager.getAttribute");
            }
            return this.getAttribute(session, objectName, string);
        }
        AttributeList attributeList = this.getAttributes(session, objectName, new String[]{string}, false);
        Object object = null;
        try {
            object = ConfigServiceHelper.getAttributeValue(attributeList, string);
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            FFDCFilter.processException(attributeNotFoundException, "com.ibm.websphere.management.configservice.ConfigServiceHelper.getConfigDataId", "39");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "Exit - ConfigServiceManager.getAttribute");
        }
        return object;
    }

    public void deleteConfigData(Session session, ObjectName objectName) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteConfigData", new Object[]{session, objectName});
        }
        this.voidPlayer(session, null, "deleteConfigData", new Object[]{session, objectName}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteConfigData");
        }
    }

    public AttributeList getRelationships(Session session, ObjectName objectName, String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationships", new Object[]{session, objectName, stringArray});
        }
        AttributeList attributeList = null;
        attributeList = (AttributeList)this.objectPlayer(session, null, "getRelationships", new Object[]{session, objectName, stringArray}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "[Ljava.lang.String;"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationships", attributeList);
        }
        return attributeList;
    }

    public ObjectName[] getRelationship(Session session, ObjectName objectName, String string) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRelationship", new Object[]{session, objectName, string});
        }
        ObjectName[] objectNameArray = null;
        objectNameArray = (ObjectName[])this.objectPlayer(session, null, "getRelationship", new Object[]{session, objectName, string}, new String[]{"com.ibm.websphere.management.Session", "javax.management.ObjectName", "java.lang.String"});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRelationship", objectNameArray);
        }
        return objectNameArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getServantStoken(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServantStoken", session);
        }
        String string = "";
        Map map = sessionToSR;
        synchronized (map) {
            String string2 = ConfigServiceManager.getSessionKey(session);
            string = string2 != null && sessionToSR.containsKey(string2) ? (String)sessionToSR.get(string2) : null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServantStoken", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String addServantStoken(Session session, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addServantStoken", new Object[]{session, string});
        }
        String string2 = null;
        Map map = sessionToSR;
        synchronized (map) {
            string2 = ConfigServiceManager.getSessionKey(session);
            if (string2 != null && sessionToSR.containsKey(string2)) {
                string = (String)sessionToSR.get(string2);
            } else {
                sessionToSR.put(string2, string);
            }
        }
        WorkSpaceManagerMBeanProxy.setServantStoken(string2, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addServantStoken", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeServantStoken(Session session, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeServantStoken", new Object[]{session, string});
        }
        Map map = sessionToSR;
        synchronized (map) {
            String string2 = ConfigServiceManager.getSessionKey(session);
            if (string2 != null) {
                String string3 = (String)sessionToSR.get(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stoken2", string3);
                }
                if (string3 != null && string3.equals(string)) {
                    sessionToSR.remove(string2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeServantStoken");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void removeServantStoken(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeServantStoken", new Object[]{string, string2});
        }
        Map map = sessionToSR;
        synchronized (map) {
            if (string != null) {
                String string3 = (String)sessionToSR.get(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "stoken2", string3);
                }
                if (string3 != null && string3.equals(string2)) {
                    sessionToSR.remove(string);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeServantStoken");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStoken(Session session) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStoken", session);
        }
        String string = "";
        Map map = sessionToSR;
        synchronized (map) {
            String string2 = ConfigServiceManager.getSessionKey(session);
            if (string2 != null && sessionToSR.containsKey(string2)) {
                string = (String)sessionToSR.get(string2);
            } else {
                if (this.currentServants.size() == 0) {
                    this.currentServants.addAll(super.currentServants());
                    Set set = ControlAdminServiceImpl.getInstance().currentAdjuncts();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Removing Adjuncts Stoken", set);
                    }
                    this.currentServants.removeAll(set);
                }
                string = (String)this.currentServants.first();
                this.currentServants.remove(string);
                if (string2 != null) {
                    sessionToSR.put(string2, string);
                    WorkSpaceManagerMBeanProxy.setServantStoken(string2, string);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "sessionToSR", sessionToSR);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStoken", string);
        }
        return string;
    }

    private static String getSessionKey(Session session) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSessionKey", session);
        }
        if (session == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getSessionKey", null);
            }
            return null;
        }
        if (session.isShareWorkspace()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "shared");
            }
            string = session.getUserName();
        } else {
            string = session.toString();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSessionKey", string);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInternalNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleInternalNotification", notification);
        }
        String string = notification.getType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "event type", string);
        }
        ServantMBeanStatus servantMBeanStatus = (ServantMBeanStatus)notification.getUserData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServantMBeanStatus", servantMBeanStatus);
        }
        if (string.equals("websphere.ws390.servant.terminated")) {
            String string2 = servantMBeanStatus.getServantStoken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken", string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Before Removal: ", sessionToSR);
            }
            Map map = sessionToSR;
            synchronized (map) {
                Collection collection = sessionToSR.values();
                collection.remove(string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "After Removal: ", sessionToSR);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleInternalNotification");
        }
    }

    private void unwrapException(Throwable throwable) throws ConfigServiceException, ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "unwrapException", new Object[]{throwable});
        }
        if (throwable instanceof ConfigServiceException) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ConfigServiceException - 1");
            }
            throw (ConfigServiceException)throwable;
        }
        if (throwable instanceof ConnectorException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConnectorException");
            }
            Throwable throwable2 = throwable.getCause();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Cause", throwable2);
            }
            if (throwable2 != null && throwable2 instanceof ConfigServiceException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "ConfigServiceException - 2");
                }
                throw (ConfigServiceException)throwable2;
            }
            if (throwable2 != null && throwable2 instanceof MBeanException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "MBeanException - 1");
                }
                Throwable throwable3 = throwable2.getCause();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Cause", throwable3);
                }
                if (throwable3 != null && throwable3 instanceof ConfigServiceException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "ConfigServiceException - 3");
                    }
                    throw (ConfigServiceException)throwable3;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ConnectorException - 1");
            }
            throw (ConnectorException)throwable;
        }
        if (throwable instanceof InstanceNotFoundException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Servant missing");
            }
            throw (InstanceNotFoundException)throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ConnectorException - 2");
        }
        throw new ConnectorException(throwable);
    }

    private void voidPlayer(String string, Object[] objectArray, String[] stringArray) throws ConfigServiceException, ConnectorException {
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "voidPlayer", new Object[]{string, objectArray, stringArray});
            }
            ServantMBeanInvokerData servantMBeanInvokerData = this.getInvoker().invokeAnyServant(this.currentServants(), this.getObjectName(), string, objectArray, stringArray);
            Object object = servantMBeanInvokerData.getResult();
            if (servantMBeanInvokerData.resultThrowable()) {
                Throwable throwable = (Throwable)object;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Result was throwable", throwable);
                }
                try {
                    this.unwrapException(throwable);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws390.management.proxy.ConfigServiceManager.voidPlayer", "755", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "InstanceNotFoundException, servant must be dead", instanceNotFoundException);
                    }
                }
                catch (ConnectorException connectorException) {
                    FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws390.management.proxy.ConfigServiceManager.voidPlayer", "758", this);
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "ConnectorException, servant might be dead?", connectorException);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "voidPlayer");
        }
    }

    private void voidPlayer(Session session, Set hashSet, String string, Object[] objectArray, String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "voidPlayer", new Object[]{session, hashSet, string, objectArray, stringArray});
        }
        String string2 = null;
        if (hashSet == null) {
            string2 = this.getStoken(session);
        } else {
            Iterator iterator;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failover mode");
            }
            if ((iterator = hashSet.iterator()).hasNext()) {
                string2 = (String)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new stoken chosen", string2);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "we are totally out of servants I give up!");
                }
                throw new ConnectorException("Could not find a valid servant");
            }
        }
        try {
            this.voidInvoke(string, objectArray, stringArray, string2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws390.management.proxy.ConfigServiceManager.voidPlayer", "789", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InstanceNotFoundException, servant must be dead", instanceNotFoundException);
            }
            ConfigServiceManager.removeServantStoken(session, string2);
            if (hashSet == null) {
                hashSet = new HashSet(super.currentServants());
                hashSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
            }
            hashSet.remove(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken Set", hashSet);
            }
            this.pauseForServant();
            this.voidPlayer(session, hashSet, string, objectArray, stringArray);
        }
        catch (ConnectorException connectorException) {
            FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws390.management.proxy.ConfigServiceManager.voidPlayer", "805", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConnectorException, servant might be dead?", connectorException);
            }
            ConfigServiceManager.removeServantStoken(session, string2);
            if (hashSet == null) {
                hashSet = new HashSet(super.currentServants());
                hashSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
            }
            hashSet.remove(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken Set", hashSet);
            }
            this.pauseForServant();
            this.voidPlayer(session, hashSet, string, objectArray, stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "voidPlayer");
        }
    }

    private void voidInvoke(String string, Object[] objectArray, String[] stringArray, String string2) throws ConfigServiceException, ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "voidInvoke", new Object[]{string, objectArray, stringArray, string2});
        }
        ServantMBeanInvokerData servantMBeanInvokerData = this.getInvoker().invokeSpecificServant(string2, this.getObjectName(), string, objectArray, stringArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servant mbeanInvokerData", servantMBeanInvokerData);
        }
        if (servantMBeanInvokerData == null) {
            throw new ConnectorException("null ServantMBeanInvokerData returned from Servant");
        }
        if (servantMBeanInvokerData.resultThrowable()) {
            Throwable throwable = (Throwable)servantMBeanInvokerData.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result was throwable", throwable);
            }
            this.unwrapException(throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "voidInvoke");
        }
    }

    private Object objectPlayer(String string, Object[] objectArray, String[] stringArray) throws ConfigServiceException, ConnectorException {
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "objectPlayer", new Object[]{string, objectArray, stringArray});
            }
            ServantMBeanInvokerData servantMBeanInvokerData = this.getInvoker().invokeAnyServant(this.currentServants(), this.getObjectName(), string, objectArray, stringArray);
            Object object = servantMBeanInvokerData.getResult();
            if (servantMBeanInvokerData.resultThrowable()) {
                Throwable throwable = (Throwable)object;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Result was throwable", throwable);
                }
                try {
                    this.unwrapException(throwable);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws390.management.proxy.ConfigServiceManager.objectPlayer", "875", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "InstanceNotFoundException, servant must be dead", instanceNotFoundException);
                    }
                    break block10;
                }
                catch (ConnectorException connectorException) {
                    FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws390.management.proxy.ConfigServiceManager.objectPlayer", "878", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ConnectorException, servant might be dead?", connectorException);
                    }
                    break block10;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "objectPlayer", object);
            }
            return object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectPlayer");
        }
        throw new ConfigServiceException("No Servant available to invoke");
    }

    private Object objectPlayer(Session session, Set hashSet, String string, Object[] objectArray, String[] stringArray) throws ConfigServiceException, ConnectorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "voidPlayer", new Object[]{session, hashSet, string, objectArray, stringArray});
        }
        Object object = null;
        String string2 = null;
        if (hashSet == null) {
            string2 = this.getStoken(session);
        } else {
            Iterator iterator;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "failover mode");
            }
            if ((iterator = hashSet.iterator()).hasNext()) {
                string2 = (String)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new stoken chosen", string2);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "we are totally out of servants I give up!");
                }
                throw new ConnectorException("Could not find a valid servant");
            }
        }
        try {
            object = this.objectInvoke(string, objectArray, stringArray, string2);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            FFDCFilter.processException((Throwable)instanceNotFoundException, "com.ibm.ws390.management.proxy.ConfigServiceManager.objectPlayer", "918", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InstanceNotFoundException, servant must be dead", instanceNotFoundException);
            }
            ConfigServiceManager.removeServantStoken(session, string2);
            if (hashSet == null) {
                hashSet = new HashSet(super.currentServants());
                hashSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
            }
            hashSet.remove(string2);
            this.pauseForServant();
            object = this.objectPlayer(session, hashSet, string, objectArray, stringArray);
        }
        catch (ConnectorException connectorException) {
            FFDCFilter.processException((Throwable)connectorException, "com.ibm.ws390.management.proxy.ConfigServiceManager.objectPlayer", "932", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ConnectorException, servant might be dead?", connectorException);
            }
            ConfigServiceManager.removeServantStoken(session, string2);
            if (hashSet == null) {
                hashSet = new HashSet(super.currentServants());
                hashSet.removeAll(ControlAdminServiceImpl.getInstance().currentAdjuncts());
            }
            hashSet.remove(string2);
            this.pauseForServant();
            object = this.objectPlayer(session, hashSet, string, objectArray, stringArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "voidPlayer", object);
        }
        return object;
    }

    private Object objectInvoke(String string, Object[] objectArray, String[] stringArray, String string2) throws ConfigServiceException, ConnectorException, InstanceNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "objectInvoke", new Object[]{string, objectArray, stringArray, string2});
        }
        Object object = null;
        ServantMBeanInvokerData servantMBeanInvokerData = this.getInvoker().invokeSpecificServant(string2, this.getObjectName(), string, objectArray, stringArray);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Servant mbeanInvokerData", servantMBeanInvokerData);
        }
        if (servantMBeanInvokerData == null) {
            throw new ConnectorException("null ServantMBeanInvokerData returned from Servant");
        }
        if (servantMBeanInvokerData.resultThrowable()) {
            Throwable throwable = (Throwable)servantMBeanInvokerData.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Result was throwable", throwable);
            }
            this.unwrapException(throwable);
        } else {
            object = servantMBeanInvokerData.getResult();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Expected Result", object);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "objectInvoke", object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseForServant() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pauseForServant - " + this.DEAD_SERVANT_WAIT + " millis");
        }
        try {
            String string = this.waitLock;
            synchronized (string) {
                this.waitLock.wait(this.DEAD_SERVANT_WAIT);
            }
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, "com.ibm.ws390.management.proxy.ConfigServiceManager.pauseForServant", "989", this);
            Tr.debug(tc, "pauseForServant - interrupted");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pauseForServant");
        }
    }
}

