/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.toad.cfparse.ClassFile;
import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.MethodInfo;
import com.ibm.toad.cfparse.MethodInfoList;
import com.ibm.toad.cfparse.attributes.AttrInfoList;
import com.ibm.toad.cfparse.attributes.ExceptionAttrInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.AdminHelper;
import com.ibm.ws.management.descriptor.MBeanDescriptorManager;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class DynamicProxyInterfaceGenerator {
    private static final TraceComponent tc = Tr.register(DynamicProxyInterfaceGenerator.class, "MBeanFactory", "com.ibm.ws.management.resources.adminservice");
    protected DynamicProxyClassLoader dpCL = null;
    protected String packageName = null;

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Usage: java DynamicProxyInterfaceGenerator <mbean_descriptor_name>");
            return;
        }
        try {
            MBeanDescriptorManager mBeanDescriptorManager = MBeanDescriptorManager.getInstance();
            ModelMBeanInfo modelMBeanInfo = mBeanDescriptorManager.getDescriptor(stringArray[0], null);
            System.out.println("YJY: created ModelMBeanInfo of MBean type ==> " + stringArray[0] + " <==");
            System.out.println("====================================================================");
            System.out.println(DynamicProxyInterfaceGenerator.printModelMBeanInfo(modelMBeanInfo));
            System.out.println("--------------------------------------------------------------------");
            String string = "com.ibm.ws.management.descriptor.dynamicproxy";
            DynamicProxyInterfaceGenerator dynamicProxyInterfaceGenerator = new DynamicProxyInterfaceGenerator(string);
            Class clazz = dynamicProxyInterfaceGenerator.generate(modelMBeanInfo);
            if (clazz == null) {
                System.out.println("FAILED to create dynamic proxy class!");
            } else {
                System.out.println("====================================================================");
                System.out.println(DynamicProxyInterfaceGenerator.printClassInfo(clazz));
                System.out.println("--------------------------------------------------------------------");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws390.management.proxy.DynamicProxyInterfaceGenerator.main", "144");
            exception.printStackTrace();
        }
    }

    public DynamicProxyInterfaceGenerator(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", string);
        }
        this.packageName = string;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this.packageName);
        }
    }

    public Class generate(ModelMBeanInfo modelMBeanInfo) throws Exception {
        try {
            String string;
            String string2;
            Descriptor descriptor = modelMBeanInfo.getMBeanDescriptor();
            String string3 = (String)descriptor.getFieldValue("type");
            if (string3 == null) {
                string3 = (String)descriptor.getFieldValue("j2eeType");
            }
            if (string3 == null) {
                string2 = (String)descriptor.getFieldValue("name");
                string = AdminHelper.getPlatformHelper().getUniqueId();
                string3 = string2 + string;
            }
            string2 = this.packageName + "." + string3;
            string = (String)descriptor.getFieldValue("since");
            if (string == null) {
                string = "5.0";
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "generate: ", "classname ==|" + string2 + "|==");
            }
            if (this.dpCL == null) {
                this.dpCL = new DynamicProxyClassLoader(Thread.currentThread().getContextClassLoader());
            }
            Class clazz = null;
            try {
                clazz = this.dpCL.loadClass(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "generate: ", "class is FOUND in cache ==> " + clazz + " <== proceeding...");
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Object object;
                Object object2;
                MBeanAttributeInfo[] mBeanAttributeInfoArray;
                int n;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "generate: ", "class is NOT found ==> " + classNotFoundException.getMessage() + " <== proceeding...");
                }
                ClassFile classFile = new ClassFile();
                ConstantPool constantPool = classFile.getCP();
                classFile.setName(string2);
                classFile.setAccess(1537);
                MBeanOperationInfo[] mBeanOperationInfoArray = modelMBeanInfo.getOperations();
                MBeanParameterInfo[] mBeanParameterInfoArray = null;
                StringBuffer stringBuffer = null;
                String string4 = null;
                MethodInfo methodInfo = null;
                MethodInfoList methodInfoList = classFile.getMethods();
                AttrInfoList attrInfoList = new AttrInfoList(constantPool, 1);
                ExceptionAttrInfo exceptionAttrInfo = (ExceptionAttrInfo)attrInfoList.add("Exceptions");
                exceptionAttrInfo.add("java.lang.Throwable");
                HashMap<String, MethodInfo> hashMap = new HashMap<String, MethodInfo>(23);
                if (mBeanOperationInfoArray != null && mBeanOperationInfoArray.length > 0) {
                    for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
                        stringBuffer = new StringBuffer("public abstract ");
                        if (mBeanOperationInfoArray[i].getReturnType() == null || mBeanOperationInfoArray[i].getReturnType().equals("")) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "generate: ", "return type for " + string3 + "." + mBeanOperationInfoArray[i].getName() + " is NULL. Using \"void\" as its return type.");
                            }
                            stringBuffer.append("void");
                        } else {
                            stringBuffer.append(DynamicProxyInterfaceGenerator.fixArrayType(mBeanOperationInfoArray[i].getReturnType()));
                        }
                        stringBuffer.append(' ');
                        stringBuffer.append(mBeanOperationInfoArray[i].getName());
                        stringBuffer.append('(');
                        mBeanParameterInfoArray = mBeanOperationInfoArray[i].getSignature();
                        for (n = 0; n < mBeanParameterInfoArray.length; ++n) {
                            stringBuffer.append(DynamicProxyInterfaceGenerator.fixArrayType(mBeanParameterInfoArray[n].getType()));
                            stringBuffer.append(' ');
                            stringBuffer.append("arg_name");
                            if (n >= mBeanParameterInfoArray.length - 1) continue;
                            stringBuffer.append(',');
                        }
                        stringBuffer.append(')');
                        string4 = stringBuffer.toString();
                        if (hashMap.get(string4) == null) {
                            methodInfo = methodInfoList.add(string4);
                            hashMap.put(string4, methodInfo);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "generate: ", "[" + i + "] DUPLICATE ==> " + stringBuffer + " <==");
                        }
                        methodInfo.setAttrs(attrInfoList);
                    }
                }
                if ((mBeanAttributeInfoArray = modelMBeanInfo.getAttributes()) != null && mBeanAttributeInfoArray.length > 0) {
                    for (n = 0; n < mBeanAttributeInfoArray.length; ++n) {
                        CharSequence charSequence;
                        Serializable serializable;
                        object2 = mBeanAttributeInfoArray[n].getName();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "generate: ", "attrInfo[" + n + "] name ==> " + (String)object2 + " <==");
                        }
                        stringBuffer = new StringBuffer("public abstract ");
                        if (mBeanAttributeInfoArray[n].isReadable()) {
                            stringBuffer.append(DynamicProxyInterfaceGenerator.fixArrayType(mBeanAttributeInfoArray[n].getType()));
                            stringBuffer.append(' ');
                            object = modelMBeanInfo.getAttribute((String)object2);
                            serializable = ((ModelMBeanAttributeInfo)object).getDescriptor();
                            charSequence = (String)serializable.getFieldValue("getMethod");
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "generate: ", "attrInfo[" + n + "] getMethod ==> " + (String)charSequence + " <==");
                            }
                            stringBuffer.append((String)charSequence);
                            stringBuffer.append("()");
                            string4 = stringBuffer.toString();
                            if (hashMap.get(string4) == null) {
                                methodInfo = methodInfoList.add(string4);
                                hashMap.put(string4, methodInfo);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "generate: ", "attrInfo[" + n + "] NEW GETTER        ==> " + stringBuffer + " <==");
                                }
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "generate: ", "attrInfo[" + n + "] GETTER DUPLICATE ==> " + stringBuffer + " <==");
                            }
                            methodInfo.setAttrs(attrInfoList);
                        }
                        if (!mBeanAttributeInfoArray[n].isWritable()) continue;
                        object = new StringBuffer("public abstract void ");
                        serializable = new StringBuffer("public abstract java.lang.Void ");
                        charSequence = new StringBuffer("public abstract Void ");
                        stringBuffer = new StringBuffer();
                        ModelMBeanAttributeInfo modelMBeanAttributeInfo = modelMBeanInfo.getAttribute((String)object2);
                        Descriptor descriptor2 = modelMBeanAttributeInfo.getDescriptor();
                        String string5 = (String)descriptor2.getFieldValue("setMethod");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "generate: ", "attrInfo[" + n + "] setMethod ==> " + string5 + " <==");
                        }
                        stringBuffer.append(string5);
                        stringBuffer.append('(');
                        stringBuffer.append(DynamicProxyInterfaceGenerator.fixArrayType(mBeanAttributeInfoArray[n].getType()));
                        stringBuffer.append(' ');
                        stringBuffer.append("arg_name");
                        stringBuffer.append(')');
                        string4 = ((StringBuffer)object).toString() + stringBuffer.toString();
                        String string6 = ((StringBuffer)serializable).toString() + stringBuffer.toString();
                        String string7 = ((StringBuffer)charSequence).toString() + stringBuffer.toString();
                        Object v = hashMap.get(string4);
                        Object v2 = hashMap.get(string6);
                        Object v3 = hashMap.get(string7);
                        if (v == null && v2 == null && v3 == null) {
                            methodInfo = methodInfoList.add(string4);
                            hashMap.put(string4, methodInfo);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "generate: ", "attrInfo[" + n + "] NEW SETTER        ==> " + stringBuffer + " <==");
                            }
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "generate: ", "attrInfo[" + n + "] SETTER DUPLICATE ==> (" + v + ") (" + v2 + ") (" + v3 + ")  <==");
                        }
                        Tr.debug(tc, "generate: ", "{" + n + "} " + stringBuffer + " <==");
                        methodInfo.setAttrs(attrInfoList);
                    }
                }
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
                object2 = new DataOutputStream(byteArrayOutputStream);
                classFile.write((DataOutputStream)object2);
                object = byteArrayOutputStream.toByteArray();
                try {
                    clazz = this.dpCL.loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    clazz = this.dpCL.defineClass(string2, (byte[])object);
                }
                return clazz;
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws390.management.proxy.DynamicProxyInterfaceGenerator.generate", "504", this);
            throwable.printStackTrace();
            return null;
        }
    }

    public static String printClassInfo(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = clazz.getName();
        stringBuffer.append("\nClass info for " + string);
        try {
            Method[] methodArray = clazz.getDeclaredMethods();
            stringBuffer.append("\n\n" + methodArray.length + " methods are declared:");
            for (int i = 0; i < methodArray.length; ++i) {
                stringBuffer.append("\n\n[" + i + "] " + methodArray[i]);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.ws390.management.proxy.DynamicProxyInterfaceGenerator.printClassInfo", "530");
            throwable.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static String printModelMBeanInfo(ModelMBeanInfo modelMBeanInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nMBeanInfo for ModelMBean is:");
        stringBuffer.append("\nCLASSNAME: \t" + modelMBeanInfo.getClassName());
        stringBuffer.append("\nDESCRIPTION: \t" + modelMBeanInfo.getDescription());
        try {
            stringBuffer.append("\nMBEAN DESCRIPTOR: \t" + modelMBeanInfo.getMBeanDescriptor());
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws.management.MBeanFactoryImpl.printModelMBeanInfo", "313");
            stringBuffer.append("\nMBEAN DESCRIPTOR: \t is invalid");
        }
        stringBuffer.append("\n\nATTRIBUTES");
        MBeanAttributeInfo[] mBeanAttributeInfoArray = modelMBeanInfo.getAttributes();
        if (mBeanAttributeInfoArray != null && mBeanAttributeInfoArray.length > 0) {
            for (int i = 0; i < mBeanAttributeInfoArray.length; ++i) {
                stringBuffer.append("\n    ** NAME: \t" + mBeanAttributeInfoArray[i].getName());
                stringBuffer.append("    DESCR: \t" + mBeanAttributeInfoArray[i].getDescription());
                stringBuffer.append("    TYPE: \t" + mBeanAttributeInfoArray[i].getType());
                stringBuffer.append("\tREAD: " + mBeanAttributeInfoArray[i].isReadable());
                stringBuffer.append("\tWRITE: " + mBeanAttributeInfoArray[i].isWritable());
                stringBuffer.append("    DESCRIPTOR: " + ((ModelMBeanAttributeInfo)mBeanAttributeInfoArray[i]).getDescriptor().toString());
            }
        } else {
            stringBuffer.append(" ** No attributes **");
        }
        stringBuffer.append("\n\nCONSTRUCTORS");
        MBeanConstructorInfo[] mBeanConstructorInfoArray = modelMBeanInfo.getConstructors();
        if (mBeanConstructorInfoArray != null && mBeanConstructorInfoArray.length > 0) {
            for (int i = 0; i < mBeanConstructorInfoArray.length; ++i) {
                stringBuffer.append("\n    ** NAME: \t" + mBeanConstructorInfoArray[i].getName());
                stringBuffer.append("    DESCR: \t" + mBeanConstructorInfoArray[i].getDescription());
                stringBuffer.append("    PARAM: \t" + mBeanConstructorInfoArray[i].getSignature().length + " parameter(s)");
                stringBuffer.append("    DESCRIPTOR: " + ((ModelMBeanConstructorInfo)mBeanConstructorInfoArray[i]).getDescriptor().toString());
            }
        } else {
            stringBuffer.append(" ** No Constructors **");
        }
        stringBuffer.append("\n\nOPERATIONS");
        MBeanOperationInfo[] mBeanOperationInfoArray = modelMBeanInfo.getOperations();
        if (mBeanOperationInfoArray != null && mBeanOperationInfoArray.length > 0) {
            for (int i = 0; i < mBeanOperationInfoArray.length; ++i) {
                stringBuffer.append("\n    ** NAME: \t" + mBeanOperationInfoArray[i].getName());
                stringBuffer.append("    DESCR: \t" + mBeanOperationInfoArray[i].getDescription());
                stringBuffer.append("    PARAM: \t" + mBeanOperationInfoArray[i].getSignature().length + " parameter(s)");
                stringBuffer.append("    DESCRIPTOR: " + ((ModelMBeanOperationInfo)mBeanOperationInfoArray[i]).getDescriptor().toString());
            }
        } else {
            stringBuffer.append(" ** No operations ** ");
        }
        stringBuffer.append("\n\nNOTIFICATIONS");
        MBeanNotificationInfo[] mBeanNotificationInfoArray = modelMBeanInfo.getNotifications();
        if (mBeanNotificationInfoArray != null && mBeanNotificationInfoArray.length > 0) {
            for (int i = 0; i < mBeanNotificationInfoArray.length; ++i) {
                stringBuffer.append("\n    ** NAME: \t" + mBeanNotificationInfoArray[i].getName());
                stringBuffer.append("    DESCR: \t" + mBeanNotificationInfoArray[i].getDescription());
                stringBuffer.append("    DESCRIPTOR: " + ((ModelMBeanNotificationInfo)mBeanNotificationInfoArray[i]).getDescriptor().toString());
            }
        } else {
            stringBuffer.append(" ** No notifications **");
        }
        stringBuffer.append(" ** ModelMBean: End of MBeanInfo ** ");
        return stringBuffer.toString();
    }

    public static String fixArrayType(String string) {
        if (string == null) {
            return null;
        }
        char c = string.charAt(0);
        if (c != '[') {
            return string;
        }
        int n = 0;
        while (string.charAt(n) == '[') {
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        c = (string = string.substring(n)).charAt(0);
        if (DynamicProxyInterfaceGenerator.isBaseType(c)) {
            stringBuffer.append(DynamicProxyInterfaceGenerator.getBaseTypeStr(c));
        } else if (DynamicProxyInterfaceGenerator.isObjectType(c)) {
            stringBuffer.append(DynamicProxyInterfaceGenerator.parseObjectType(string));
        } else {
            System.out.print("ERROR: com.ibm.ws390.metadata.archive.JavaMethod.fixArrayType: ");
            System.out.println("found BAD inputType ==| " + string + "|==");
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("[]");
        }
        return stringBuffer.toString();
    }

    private static boolean isBaseType(char c) {
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }

    private static String getBaseTypeStr(char c) {
        switch (c) {
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'D': {
                return "double";
            }
            case 'F': {
                return "float";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'S': {
                return "short";
            }
            case 'Z': {
                return "boolean";
            }
        }
        return null;
    }

    private static boolean isObjectType(char c) {
        return c == 'L';
    }

    private static String parseObjectType(String string) {
        int n = string.indexOf(59);
        return string.substring(1, n);
    }

    class DynamicProxyClassLoader
    extends ClassLoader {
        public DynamicProxyClassLoader(ClassLoader classLoader) {
            super(classLoader);
        }

        public Class defineClass(String string, byte[] byArray) throws ClassFormatError {
            return super.defineClass(string, byArray, 0, byArray.length);
        }
    }
}

