/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.ManagerAdmin;
import com.ibm.ejs.ras.RasException;
import com.ibm.ejs.ras.RasMessageImpl2;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.logging.WsLevel;
import com.ibm.websphere.management.RuntimeCollaborator;
import com.ibm.websphere.ras.RasMessage;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.TraceLogFormatter;
import com.ibm.ws.logging.WsHandler;
import com.ibm.ws.logging.cbe.CBEHelper;
import com.ibm.ws.management.ServantNotificationHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.management.MBeanException;
import javax.management.Notification;
import javax.management.ObjectName;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class RasLoggingServiceMBeanProxy
extends RuntimeCollaborator
implements WsHandler,
ServantNotificationHandler {
    public static final String NOTIFICATION_LOG_FATAL = "websphere.ras.fatal";
    public static final String NOTIFICATION_LOG_ERROR = "websphere.ras.error";
    public static final String NOTIFICATION_LOG_WARNING = "websphere.ras.warning";
    public static final String NOTIFICATION_LOG_AUDIT = "websphere.ras.audit";
    public static final String NOTIFICATION_LOG_SERVICE = "websphere.ras.service";
    public static final String NOTIFICATION_LOG_INFO = "websphere.ras.info";
    private static TraceComponent tc = Tr.register(RasLoggingServiceMBeanProxy.class, "RasLoggingService", null);
    private long ntfySeqNum = 0L;

    public void setObjectName(ObjectName objectName) {
        super.setObjectName(objectName);
        this.registerWithRas();
    }

    public String getMessageFilterLevel() {
        return ManagerAdmin.getMessageFilterLevel();
    }

    public void setMessageFilterLevel(String string) {
        ManagerAdmin.setMessageFilterLevel(string);
    }

    public Level getLevel() {
        return WsLevel.DETAIL;
    }

    public Boolean containsRASHeader(String string) {
        boolean bl = ManagerAdmin.containsRASHeader(string);
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void processEvent(LogRecord logRecord) {
        int n = logRecord.getLevel().intValue();
        if (n < WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[8]]) {
            return;
        }
        if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[15]]) {
            this.sendEvent(NOTIFICATION_LOG_FATAL, logRecord);
        } else if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[13]]) {
            this.sendEvent(NOTIFICATION_LOG_ERROR, logRecord);
        } else if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[12]]) {
            this.sendEvent(NOTIFICATION_LOG_WARNING, logRecord);
        } else if (n >= WsLevel.LEVEL_VALUES[LevelConstants.DISTINCT_LEVELS[11]]) {
            this.sendEvent(NOTIFICATION_LOG_AUDIT, logRecord);
        } else {
            this.sendEvent(NOTIFICATION_LOG_INFO, logRecord);
        }
    }

    private void registerWithRas() {
        try {
            ManagerAdmin.addJmxListener(this);
        }
        catch (RasException rasException) {
            FFDCFilter.processException((Throwable)rasException, "com.ibm.ws.management.RasLoggingServiceMBean.RasLoggingServiceMBean", "48", this);
        }
    }

    private void sendEvent(String string, LogRecord logRecord) {
        try {
            RasMessageImpl2 rasMessageImpl2 = RasLoggingServiceMBeanProxy.parseLogRec(logRecord);
            Notification notification = new Notification(string, this.getObjectName(), this.ntfySeqNum++);
            notification.setUserData(rasMessageImpl2);
            this.sendNotification(notification);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.RasLoggingServiceMBeanProxy.sendEvent", "168", this);
        }
    }

    private static RasMessageImpl2 parseLogRec(LogRecord logRecord) {
        CommonBaseEvent commonBaseEvent;
        String string = Integer.toHexString(logRecord.getThreadID());
        String string2 = RasMessageImpl2.convertSeverity(logRecord.getLevel().intValue());
        Locale locale = Locale.getDefault();
        String string3 = TraceLogFormatter.formatMessage(logRecord, locale, 0);
        String string4 = null;
        if (logRecord instanceof CommonBaseEventLogRecord && (commonBaseEvent = ((CommonBaseEventLogRecord)logRecord).getCommonBaseEvent()) != null) {
            string4 = CBEHelper.getExtendedDataElementString(commonBaseEvent, "DiagnosticProvider");
        }
        return new RasMessageImpl2(logRecord.getMillis(), string, string2, logRecord.getMessage(), logRecord.getParameters(), logRecord.getResourceBundleName(), logRecord.getLoggerName(), string3, locale.toString(), string4);
    }

    public void handleServantNotification(Notification notification) {
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleServantNotification", notification);
        }
        long l = this.ntfySeqNum++;
        if (tc.isDebugEnabled()) {
            serializable = new StringBuffer();
            ((StringBuffer)serializable).append("Servant Ras notification; source = " + notification.getSource());
            ((StringBuffer)serializable).append(", type = " + notification.getType());
            ((StringBuffer)serializable).append(", servant sequence number = " + notification.getSequenceNumber());
            ((StringBuffer)serializable).append(", control sequence number = " + l);
            Object object = notification.getUserData();
            if (object instanceof RasMessage) {
                RasMessage rasMessage = (RasMessage)object;
                ((StringBuffer)serializable).append(", user data msg = " + rasMessage.getLocalizedMessage(null));
                ((StringBuffer)serializable).append(", user data severity = " + rasMessage.getMessageSeverity());
            }
            Tr.debug(tc, ((StringBuffer)serializable).toString());
        }
        try {
            serializable = new Notification(notification.getType(), (Object)this, l, notification.getMessage());
            ((Notification)serializable).setUserData(notification.getUserData());
            this.sendNotification((Notification)serializable);
        }
        catch (MBeanException mBeanException) {
            FFDCFilter.processException((Throwable)mBeanException, "com.ibm.ws.management.RasLoggingServiceMBean.handleServantNotification", "195", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleServantNotification");
        }
    }
}

