/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.management.proxy;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.ServantMBeanStatus;
import com.ibm.ws.management.ServantNotificationHandler;
import com.ibm.ws.sm.workspace.WorkSpaceJMXEvent;
import com.ibm.ws390.management.ProxyMBeanSupport;
import com.ibm.ws390.management.ServantMBeanInvoker;
import com.ibm.ws390.management.proxy.ConfigServiceManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.Notification;
import javax.management.NotificationFilterSupport;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class WorkSpaceManagerMBeanProxy
extends ProxyMBeanSupport
implements ServantNotificationHandler {
    private ServantMBeanInvoker mbeanInvoker = new ServantMBeanInvoker();
    private static Map workspaces = Collections.synchronizedMap(new HashMap());
    private static final TraceComponent tc = Tr.register(WorkSpaceManagerMBeanProxy.class, null, null);
    private static SelfListener self = new SelfListener();

    public WorkSpaceManagerMBeanProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WorkSpaceManagerMBeanProxy");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WorkSpaceManagerMBeanProxy", self);
        }
    }

    protected static Map getWorkSpaces() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkSpaces");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkSpaces", workspaces);
        }
        return workspaces;
    }

    public void setObjectName(ObjectName objectName) {
        super.setObjectName(objectName);
    }

    protected static void setServantStoken(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setServantStoken", new Object[]{string, string2});
        }
        workspaces.put(string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setServantStoken");
        }
    }

    public void handleServantNotification(Notification notification) {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleServantNotification", new Object[]{notification});
        }
        String string = notification.getType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Notification Event", new Object[]{string});
        }
        if (string.equals("websphere.workspace.event") && (object = notification.getUserData()) instanceof WorkSpaceJMXEvent) {
            WorkSpaceJMXEvent workSpaceJMXEvent = (WorkSpaceJMXEvent)object;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WorkSpace event", new Object[]{new Integer(workSpaceJMXEvent.getType())});
            }
            String string2 = workSpaceJMXEvent.getWorkSpaceID();
            String string3 = workSpaceJMXEvent.getStoken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ID / stoken", new Object[]{string2, string3});
            }
            switch (workSpaceJMXEvent.getType()) {
                case 11: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WorkSpace created");
                    }
                    workspaces.put(string2, string3);
                    break;
                }
                case 10: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WorkSpace invalidated");
                    }
                }
                case 12: {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "WorkSpace removed");
                    }
                    workspaces.remove(string2);
                    ConfigServiceManager.removeServantStoken(string2, string3);
                    break;
                }
                default: {
                    if (!tc.isDebugEnabled()) break;
                    Tr.debug(tc, "Invalid type: " + workSpaceJMXEvent.getType());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleServantNotification", new Object[]{workspaces});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleInternalNotification(Notification notification) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "handleInternalNotification", notification);
        }
        String string = notification.getType();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "event type", string);
        }
        ServantMBeanStatus servantMBeanStatus = (ServantMBeanStatus)notification.getUserData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ServantMBeanStatus", servantMBeanStatus);
        }
        if (string.equals("websphere.ws390.servant.terminated")) {
            String string2 = servantMBeanStatus.getServantStoken();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Stoken", string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Before Removal: ", workspaces);
            }
            Map map = workspaces;
            synchronized (map) {
                Collection collection = workspaces.values();
                collection.remove(string2);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "After Removal: ", workspaces);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "handleInternalNotification");
        }
    }

    private static class SelfListener
    implements NotificationListener {
        public SelfListener() {
            block8: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "SelfListener");
                }
                try {
                    AdminService adminService = AdminServiceFactory.getAdminService();
                    String string = adminService.getNodeName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Node: ", string);
                    }
                    String string2 = adminService.getProcessName();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Proc: ", string2);
                    }
                    String string3 = "WebSphere:*,type=WorkSpaceManager,node=" + string + ",process=" + string2;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Query: ", string3);
                    }
                    ObjectName objectName = new ObjectName(string3);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Work: ", objectName);
                    }
                    NotificationFilterSupport notificationFilterSupport = new NotificationFilterSupport();
                    adminService.addNotificationListenerExtended(objectName, this, notificationFilterSupport, null);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "SelfListener");
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.management.proxy.WorkSpaceManagerMBeanProxy.SelfListener", "166", this);
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug(tc, "Error", exception);
                }
            }
        }

        public void handleNotification(Notification notification, Object object) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "handleNotification", new Object[]{notification, object});
            }
        }
    }
}

