/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.outofband;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.wsspi.channel.framework.VirtualConnection;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;

public class OutOfBandData {
    private static final TraceComponent tc = Tr.register(OutOfBandData.class, "OutOfBand", null);
    private static final String OUT_OF_BAND_VC_KEY = "OUT_OF_BAND_DATA";
    private static final byte[] BBOCXRCD_EYE = new byte[]{-62, -62, -42, -61, -25, -39, -61, -60};
    private static final byte XRCD_STOR_TYPE_C = 2;
    public static final int xrcdTagTimeStamp = 1;
    public static final int xrcdTagSecurityData = 2;
    public static final int xrcdTagSecurityDataType = 3;
    private ByteBuffer _data;
    private byte _version;
    private HashMap _chunks;

    public OutOfBandData(ByteArray byteArray) {
        this(byteArray != null ? byteArray.getBytes() : null);
    }

    public OutOfBandData(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byArray);
        }
        if (byArray == null) {
            throw new IllegalArgumentException();
        }
        this._data = ByteBuffer.wrap(byArray);
        byte[] byArray2 = new byte[BBOCXRCD_EYE.length];
        this._data.get(byArray2);
        if (!Arrays.equals(byArray2, BBOCXRCD_EYE)) {
            throw new IllegalArgumentException("Invalid eyecatcher");
        }
        this._version = this._data.get();
        this._data.put((byte)2);
        this._data.getShort();
        this._data.putInt(byArray.length);
        this._data.putInt(byArray.length);
        int n = this._data.getInt();
        this._data.get(new byte[16]);
        this._chunks = new HashMap();
        for (int i = 0; i < n; ++i) {
            int n2 = this._data.getInt();
            int n3 = this._data.getInt();
            byte[] byArray3 = new byte[n3];
            this._data.get(byArray3);
            this._chunks.put(new Integer(n2), byArray3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public byte[] getChunk(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getChunk", new Integer(n));
        }
        byte[] byArray = (byte[])this._chunks.get(new Integer(n));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getChunk", byArray);
        }
        return byArray;
    }

    public byte[] getRawData() {
        return this._data.array();
    }

    public String toString() {
        return new ByteArray(this._data.array()).toString();
    }

    public static void setOutOfBandData(VirtualConnection virtualConnection, byte[] byArray) {
        if (virtualConnection == null) {
            return;
        }
        virtualConnection.getStateMap().put(OUT_OF_BAND_VC_KEY, new OutOfBandData(byArray));
    }

    public static void setOutOfBandData(VirtualConnection virtualConnection, ByteArray byteArray) {
        if (virtualConnection == null) {
            return;
        }
        virtualConnection.getStateMap().put(OUT_OF_BAND_VC_KEY, new OutOfBandData(byteArray));
    }

    public static OutOfBandData getOutOfBandData(VirtualConnection virtualConnection) {
        if (virtualConnection == null) {
            return null;
        }
        return (OutOfBandData)virtualConnection.getStateMap().get(OUT_OF_BAND_VC_KEY);
    }
}

