/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.sm.smf;

import com.ibm.ws390.sm.smf.SmfProperty;
import com.ibm.ws390.sm.smf.SmfPropertyVector;
import java.util.Vector;

public final class SmfServletData {
    private String m_name = "";
    private long m_loadedSince = 0L;
    private int m_responseTime = 0;
    private int m_loadCount = 0;
    private int m_errorCount = 0;
    private Vector m_properties = new Vector(5);
    private boolean m_propertiesInSync = false;
    private int m_propertiesByteSize = 0;
    private long m_cpuStartTime = 0L;
    private String m_cpuTimeString = "";

    protected SmfServletData(String string) {
        if (string != null) {
            this.m_name = string.length() > 128 ? string.substring(0, 128) : string;
        }
    }

    private void addProperty(SmfProperty smfProperty) {
        this.m_properties.addElement(smfProperty);
        this.m_propertiesByteSize += smfProperty.getByteSize();
    }

    protected boolean addTo(SmfPropertyVector smfPropertyVector) {
        this.resyncProperties();
        if (smfPropertyVector.getRemainingByteArraySize() >= this.m_propertiesByteSize) {
            int n = this.m_properties.size();
            for (int i = 0; i < n; ++i) {
                smfPropertyVector.addElement(this.m_properties.elementAt(i));
            }
            this.reset();
            return true;
        }
        return false;
    }

    protected int getErrorCount() {
        return this.m_errorCount;
    }

    protected int getLoadCount() {
        return this.m_loadCount;
    }

    protected long getLoadedSince() {
        return this.m_loadedSince;
    }

    protected String getName() {
        return this.m_name;
    }

    protected int getResponseTime() {
        return this.m_responseTime;
    }

    protected void incrementErrorCount() {
        ++this.m_errorCount;
        this.m_propertiesInSync = false;
    }

    protected void incrementLoadCount() {
        ++this.m_loadCount;
        this.m_propertiesInSync = false;
    }

    private void reset() {
        this.m_errorCount = 0;
        this.m_loadCount = 0;
        this.m_loadedSince = 0L;
        this.m_responseTime = 0;
        this.m_propertiesInSync = false;
        this.resyncProperties();
    }

    protected void calculateCpuTime(long l) {
        long l2;
        if (l > 0L && (l2 = l - this.m_cpuStartTime) > 0L) {
            this.m_cpuTimeString = Long.toHexString(l2);
        }
    }

    private void resyncProperties() {
        if (!this.m_propertiesInSync) {
            this.m_properties.clear();
            this.m_propertiesByteSize = 0;
            if (this.m_name.length() > 0 && (this.m_responseTime > 0 || this.m_loadedSince > 0L || this.m_loadCount > 0 || this.m_errorCount > 0)) {
                this.addProperty(new SmfProperty(11, this.m_name, null));
                if (this.m_responseTime > 0) {
                    this.addProperty(new SmfProperty(12, this.m_responseTime));
                }
                if (this.m_loadedSince > 0L) {
                    this.addProperty(new SmfProperty(8, Long.toHexString(this.m_loadedSince), SmfProperty.getEbcdicEncoding()));
                }
                if (this.m_loadCount > 0) {
                    this.addProperty(new SmfProperty(9, this.m_loadCount));
                }
                if (this.m_errorCount > 0) {
                    this.addProperty(new SmfProperty(10, this.m_errorCount));
                }
                if (this.m_cpuTimeString.length() > 0) {
                    this.addProperty(new SmfProperty(15, this.m_cpuTimeString, SmfProperty.getEbcdicEncoding()));
                }
            }
            this.m_propertiesInSync = true;
        }
    }

    protected void setLoadedSince(long l) {
        if (l > 0L) {
            this.m_loadedSince = l;
            this.m_propertiesInSync = false;
        }
    }

    protected void setResponseTime(int n) {
        if (n >= 0) {
            this.m_responseTime = n;
            this.m_propertiesInSync = false;
        }
    }

    protected void setCpuStartTime(long l) {
        if (l > 0L) {
            this.m_cpuStartTime = l;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SmfServletData(");
        stringBuffer.append(this.m_name).append(", ");
        stringBuffer.append("loadCount=").append(this.m_loadCount).append(", ");
        stringBuffer.append("errorCount=").append(this.m_errorCount).append(", ");
        stringBuffer.append("responseTime=").append(this.m_responseTime).append(", ");
        stringBuffer.append("loadedSince=").append(this.m_loadedSince).append(")");
        return stringBuffer.toString();
    }
}

