/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.rrs.RRS;
import com.ibm.ws390.tx.rrs.RetrieveSideInformationReturnType;

public class AsyncSyncpointIndicators {
    private static final TraceComponent tc = Tr.register(AsyncSyncpointIndicators.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private boolean _backoutRequired = false;
    private boolean _sdsrmInitiated = false;
    private boolean _resolvedInDoubt = false;
    private boolean _terminatingSyncpoint = false;
    private boolean _applicationBackout = false;
    private boolean _committed = false;
    private boolean _heuristicMixed = false;

    public AsyncSyncpointIndicators(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byArray);
        }
        int[] nArray = new int[]{1, 21, 22, 23, 32, 24, 0};
        RetrieveSideInformationReturnType retrieveSideInformationReturnType = RRS.retrieveSideInformation(byArray, nArray);
        int n = retrieveSideInformationReturnType.getReturnCode();
        switch (n) {
            case 0: {
                int[] nArray2 = retrieveSideInformationReturnType.getSideInfo();
                this._backoutRequired = nArray2[0] == 1;
                this._sdsrmInitiated = nArray2[1] == 1;
                this._resolvedInDoubt = nArray2[2] == 1;
                this._terminatingSyncpoint = nArray2[3] == 1;
                this._applicationBackout = nArray2[4] == 1;
                this._committed = nArray2[5] == 1;
                this._heuristicMixed = nArray2[6] == 1;
                break;
            }
            case 1794: 
            case 3840: {
                RasHelper.exit(-910026662, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{new String("ATRRUSI2"), Integer.toHexString(n)});
                RasHelper.exit(-910026653, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean getBackoutRequired() {
        return this._backoutRequired;
    }

    public boolean getSdsrmInitiated() {
        return this._sdsrmInitiated;
    }

    public boolean getResolvedInDoubt() {
        return this._resolvedInDoubt;
    }

    public boolean getTerminatingSyncpoint() {
        return this._terminatingSyncpoint;
    }

    public boolean getApplicationBackout() {
        return this._applicationBackout;
    }

    public boolean getCommitted() {
        return this._committed;
    }

    public boolean getHeuristicMixed() {
        return this._heuristicMixed;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AsyncSyncpointIndicators: backoutRequired = ");
        stringBuffer.append(this._backoutRequired);
        stringBuffer.append(", sdsrmInitiated = ");
        stringBuffer.append(this._sdsrmInitiated);
        stringBuffer.append(", resolvedInDoubt = ");
        stringBuffer.append(this._resolvedInDoubt);
        stringBuffer.append(", terminatingSyncpoint = ");
        stringBuffer.append(this._terminatingSyncpoint);
        stringBuffer.append(", applicationBackout = ");
        stringBuffer.append(this._applicationBackout);
        stringBuffer.append(", committed = ");
        stringBuffer.append(this._committed);
        stringBuffer.append(", heuristicMixed = ");
        stringBuffer.append(this._heuristicMixed);
        stringBuffer.append("; ");
        return stringBuffer.toString();
    }
}

