/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.LockHierarchy;
import com.ibm.ws390.tx.LockableHashMap;
import com.ibm.ws390.tx.LockableObject;
import com.ibm.ws390.tx.ReaderWriterLock;
import com.ibm.ws390.tx.TranAffinityMarker;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public final class BranchRegistryTable
implements LockableObject {
    private static final TraceComponent tc = Tr.register(BranchRegistryTable.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final short MAX_BRANCHES = 255;
    private byte[] _gtrid;
    private HashMap _inboundMap;
    private HashMap _outboundMap;
    private short _nextIndex;
    private ReaderWriterLock _lock;
    private int _hash;
    private TranAffinityMarker _affinityMarker;
    private byte[] _orbStoken;
    private volatile int _wsatCount;

    BranchRegistryTable(byte[] byArray, TranAffinityMarker tranAffinityMarker) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{byArray == null ? null : new ByteArray(byArray), tranAffinityMarker});
        }
        this._gtrid = new byte[byArray.length];
        System.arraycopy(byArray, 0, this._gtrid, 0, byArray.length);
        this._inboundMap = new HashMap();
        this._outboundMap = new HashMap();
        this._nextIndex = 1;
        this._lock = new ReaderWriterLock(4);
        this._hash = new ByteArray(byArray).hashCode();
        this._affinityMarker = tranAffinityMarker;
        this._orbStoken = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    byte[] getBqual(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBqual", new Integer(n));
        }
        byte[] byArray = null;
        Collection collection = this._inboundMap.values();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            byte[] byArray2 = new byte[]{};
            while (iterator.hasNext() && byArray == null) {
                byte[] byArray3 = ((ByteArray)iterator.next()).getBytes();
                XidImpl xidImpl = new XidImpl(0, byArray2, byArray3);
                int n2 = xidImpl.getBqualBranchIndex();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "current index", new Integer(n2));
                }
                if (n != n2) continue;
                byArray = byArray3;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBqual", byArray);
        }
        return byArray;
    }

    void addEntry(byte[] byArray, byte[] byArray2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addEntry", new Object[]{byArray, byArray2});
        }
        ByteArray byteArray = new ByteArray(byArray);
        ByteArray byteArray2 = new ByteArray(byArray2);
        this._inboundMap.put(byteArray, byteArray2);
        this._outboundMap.put(byteArray2, byteArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addEntry", new Object[]{byArray, byArray2});
        }
    }

    byte[] findOutboundBranch(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findOutboundBranch", byArray);
        }
        ByteArray byteArray = new ByteArray(byArray);
        ByteArray byteArray2 = (ByteArray)this._inboundMap.get(byteArray);
        byte[] byArray2 = null;
        if (byteArray2 != null) {
            byArray2 = byteArray2.getBytes();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findOutboundBranch", byArray2);
        }
        return byArray2;
    }

    boolean removeEntry(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEntry", byArray);
        }
        boolean bl = false;
        ByteArray byteArray = new ByteArray(byArray);
        ByteArray byteArray2 = (ByteArray)this._outboundMap.remove(byteArray);
        if (byteArray2 != null) {
            ByteArray byteArray3 = (ByteArray)this._inboundMap.remove(byteArray2);
            if (byteArray.equals(byteArray3)) {
                bl = true;
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Could not remove branch, equality check");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Could not remove branch, inbound not found");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEntry", new Boolean(bl));
        }
        return bl;
    }

    short getNextIndex() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextIndex");
        }
        short s = this._nextIndex = (short)(this._nextIndex + 1);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextIndex", new Short(s));
        }
        return s;
    }

    boolean isEmpty() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEmpty");
        }
        boolean bl = this._inboundMap.isEmpty();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEmpty", new Boolean(bl));
        }
        return bl;
    }

    public ReaderWriterLock getLock() {
        return this._lock;
    }

    private LockHierarchy getLockHierarchy() {
        ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
        return controllerTransactionManagerSet.getLockHierarchy();
    }

    public void releaseLockExclusive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseLockExclusive");
        }
        LockHierarchy lockHierarchy = this.getLockHierarchy();
        this._lock.releaseWrite(lockHierarchy);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseLockExclusive");
        }
    }

    public byte[] getGtrid() {
        return this._gtrid;
    }

    public int hashCode() {
        return this._hash;
    }

    public boolean equals(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals", new Object[]{this, object});
        }
        boolean bl = false;
        if (object != null && object instanceof BranchRegistryTable) {
            byte[] byArray = ((BranchRegistryTable)object).getGtrid();
            bl = Arrays.equals(this._gtrid, byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "equals", new Boolean(bl));
        }
        return bl;
    }

    public TranAffinityMarker getAffinityMarker() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAffinityMarker");
            Tr.exit(tc, "getAffinityMarker", this._affinityMarker);
        }
        return this._affinityMarker;
    }

    public void setStoken(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setStoken", byArray);
        }
        this._orbStoken = new byte[byArray.length];
        System.arraycopy(byArray, 0, this._orbStoken, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setStoken");
        }
    }

    public byte[] getStoken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStoken");
            Tr.exit(tc, "getStoken", this._orbStoken);
        }
        return this._orbStoken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static XidImpl gtidToXid(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "gtidToXid", byArray);
        }
        XidImpl xidImpl = null;
        ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
        LockableHashMap lockableHashMap = controllerTransactionManagerSet.getPsbrMap();
        byte[] byArray2 = new byte[byArray.length - 9];
        System.arraycopy(byArray, 9, byArray2, 0, byArray2.length);
        ByteArray byteArray = new ByteArray(byArray2);
        BranchRegistryTable branchRegistryTable = (BranchRegistryTable)lockableHashMap.get(byteArray, true);
        if (branchRegistryTable != null) {
            try {
                byte[] byArray3 = branchRegistryTable.getBqual(byArray[8]);
                xidImpl = new XidImpl(XidImpl.WAS_FORMAT_ID, byArray2, byArray3);
            }
            finally {
                branchRegistryTable.releaseLockExclusive();
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "no psbr found", byArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "gtidToXid", xidImpl);
        }
        return xidImpl;
    }

    static byte[] xidToGtid(XidImpl xidImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "xidToGtid", xidImpl);
        }
        byte[] byArray = xidImpl.getGlobalTransactionId();
        byte[] byArray2 = new byte[byArray.length + 9];
        Util.setBytesFromInt(byArray2, 0, 4, byArray2.length);
        Util.setBytesFromInt(byArray2, 4, 4, XidImpl.WAS_FORMAT_ID);
        byArray2[8] = (byte)xidImpl.getBqualBranchIndex();
        System.arraycopy(byArray, 0, byArray2, 9, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "xidToGtid", byArray2);
        }
        return byArray2;
    }

    public int incrementWSATCount() {
        return ++this._wsatCount;
    }

    public void decrementWSATCount() {
        --this._wsatCount;
    }
}

