/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.ExtendedClientRequestInfo;
import com.ibm.CORBA.iiop.ExtendedORBInitInfo;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ws.Transaction.JTS.WSCascadedPropagationData;
import com.ibm.ws.Transaction.JTS.WSCascadedPropagationDataHelper;
import com.ibm.ws390.tx.CascadedTranInfo;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.otid_t;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;

public class CascadedClientReqInterceptor
extends LocalObject
implements ClientRequestInterceptor,
ORBInitializer {
    private static final String header = new String(" CascadedClientRequestInterceptor: ");
    private static final String nativeLibName = new String("bbotccri");
    private static final int TAG_TransactionService = 1229081860;
    private static final boolean debug;
    private static final boolean generateXid;
    private static final int timeout;

    public void send_request(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (debug) {
            System.out.println(header + "PI send_request entered");
        }
        TaggedComponent taggedComponent = ((ExtendedClientRequestInfo)clientRequestInfo).getEffectiveComponent(1229081860);
        if (debug) {
            System.out.println(header + "taggedComponent: " + taggedComponent);
            if (taggedComponent != null && taggedComponent.component_data != null) {
                System.out.println(header + "taggedComponent.component_data[2] -> " + taggedComponent.component_data[2]);
            }
        }
        if (taggedComponent != null && taggedComponent.component_data[2] == 3) {
            if (debug) {
                System.out.println(header + "Talking to an IBM4 " + "Version 3 server");
            }
            CascadedTranInfo cascadedTranInfo = new CascadedTranInfo();
            int n = 0;
            if (debug) {
                System.out.println(header + "calling native...");
            }
            try {
                n = CascadedClientReqInterceptor.obtainOTSContextData(cascadedTranInfo, generateXid, debug);
            }
            catch (Throwable throwable) {
                System.out.println(header + "Exception message -> " + throwable.getMessage());
                throwable.printStackTrace();
                throw new INTERNAL(throwable.getMessage());
            }
            if (debug) {
                System.out.println(header + "back from native, RC=" + Integer.toHexString(n));
            }
            if (n != 0) {
                String string = new String("WebSphere CascadedClientRequestInterceptor failed with RC=" + Integer.toHexString(n));
                throw new INTERNAL(string);
            }
            byte[] byArray = cascadedTranInfo.getURID();
            byte[] byArray2 = cascadedTranInfo.getURTOK();
            byte[] byArray3 = cascadedTranInfo.getXID();
            if (byArray3 != null) {
                int n2;
                int n3;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                byte[] byArray4 = null;
                try {
                    n3 = dataInputStream.readInt();
                    int n4 = dataInputStream.readInt();
                    n2 = dataInputStream.readInt();
                    byArray4 = new byte[n4 + n2];
                    dataInputStream.readFully(byArray4);
                    dataInputStream.close();
                }
                catch (Throwable throwable) {
                    String string = new String("Error encountered parsing the current XID, " + throwable.getMessage());
                    throw new INTERNAL(string);
                }
                PropagationContext propagationContext = null;
                Any any = ((ORB)((LocalObject)clientRequestInfo)._orb()).create_any();
                any.insert_boolean(false);
                Any any2 = ((ORB)((LocalObject)clientRequestInfo)._orb()).create_any();
                WSCascadedPropagationData wSCascadedPropagationData = new WSCascadedPropagationData(1, byArray, byArray2, any);
                WSCascadedPropagationDataHelper.insert(any2, wSCascadedPropagationData);
                if (debug) {
                    System.out.println(header + "just inserted an ANY" + " into WSCascadedPropagationData");
                }
                otid_t otid_t2 = new otid_t(n3, n2, byArray4);
                propagationContext = new PropagationContext(timeout, new TransIdentity(null, null, otid_t2), new TransIdentity[0], any2);
                byte[] byArray5 = null;
                CDROutputStream cDROutputStream = ORB.createCDROutputStream((ORB)((ORB)((LocalObject)clientRequestInfo)._orb()));
                cDROutputStream.putEndian();
                PropagationContextHelper.write((OutputStream)cDROutputStream, propagationContext);
                byArray5 = cDROutputStream.toByteArray();
                cDROutputStream.releaseBuffer();
                byte[] byArray6 = byArray5;
                if (debug) {
                    System.out.println(header + "about to get the " + "serviceContext");
                }
                ServiceContext serviceContext = new ServiceContext(0, byArray6);
                clientRequestInfo.add_request_service_context(serviceContext, true);
            } else if (debug) {
                System.out.println(header + "There is no " + "current UR");
            }
        } else if (debug) {
            System.out.println(header + "Tag IBM4 not encountered");
        }
    }

    public void send_poll(ClientRequestInfo clientRequestInfo) {
        if (debug) {
            System.out.println(header + "PI send_poll entered");
        }
    }

    public void receive_reply(ClientRequestInfo clientRequestInfo) {
        if (debug) {
            System.out.println(header + "PI receive_reply entered");
        }
    }

    public void receive_exception(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (debug) {
            System.out.println(header + "PI receive_exception entered");
        }
    }

    public void receive_other(ClientRequestInfo clientRequestInfo) throws ForwardRequest {
        if (debug) {
            System.out.println(header + "PI receive_other entered");
        }
    }

    public String name() {
        if (debug) {
            System.out.println(header + "PI name entered");
        }
        return "CascadedClientReqInterceptor";
    }

    public void destroy() {
        if (debug) {
            System.out.println(header + "PI destroy entered");
        }
    }

    public void pre_init(ORBInitInfo oRBInitInfo) {
        if (debug) {
            System.out.println(header + "PI pre_init entered");
        }
        CascadedClientReqInterceptor cascadedClientReqInterceptor = new CascadedClientReqInterceptor();
        try {
            ((ExtendedORBInitInfo)oRBInitInfo).add_client_request_interceptor((ClientRequestInterceptor)cascadedClientReqInterceptor, false);
            if (debug) {
                System.out.println(header + "registered the interceptor");
            }
        }
        catch (Throwable throwable) {
            System.out.println(header + "Failed trying to register the " + "interceptor, " + throwable.toString());
            throwable.printStackTrace();
        }
        if (debug) {
            System.out.println(header + "PI pre_init exited");
        }
    }

    public void post_init(ORBInitInfo oRBInitInfo) {
        if (debug) {
            System.out.println(header + "PI post_init entered");
        }
    }

    public static native int obtainOTSContextData(CascadedTranInfo var0, boolean var1, boolean var2);

    static {
        try {
            System.loadLibrary(nativeLibName);
        }
        catch (Throwable throwable) {
            System.out.println(header + "Tried to load " + nativeLibName + " but failed");
            throwable.printStackTrace();
        }
        debug = Boolean.getBoolean("was.ccri.debug");
        generateXid = Boolean.getBoolean("was.ccri.generateXid");
        timeout = Integer.getInteger("was.ccri.timeout", 360);
    }
}

