/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.Profile;
import com.ibm.ejs.oa.UserKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ejs.util.Util;
import com.ibm.ejs.util.locking.Lockable;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.adminservice.AdminService;
import com.ibm.websphere.models.config.applicationserver.ApplicationServer;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.TransactionGiopFilter;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.security.auth.zOS.SAFAuthorizationFactory;
import com.ibm.ws.security.auth.zOS.SAFAuthorizationInterface;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws390.tx.ControllerTransactionManagerImpl;
import com.ibm.ws390.tx.Enq;
import com.ibm.ws390.tx.LockHierarchy;
import com.ibm.ws390.tx.LockableHashMap;
import com.ibm.ws390.tx.NativeServerInstanceData;
import com.ibm.ws390.tx.PersistentInterestData;
import com.ibm.ws390.tx.ResourceManager;
import com.ibm.ws390.tx.RestartURData;
import com.ibm.ws390.tx.SyncpointInterest;
import com.ibm.ws390.tx.TranAffinityMap;
import com.ibm.ws390.tx.TranAffinityRouterHelper;
import com.ibm.ws390.tx.TransactionByteBufferPoolManager;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionalUnitOfWork;
import com.ibm.ws390.tx.WSATCRRecoveryCoordinator;
import com.ibm.ws390.tx.XaRecoveryAlarm;
import com.ibm.ws390.tx.rrs.RetrieveURInterestReturnType;
import com.ibm.ws390.tx.xarecovery.XID;
import com.ibm.wsspi.iiop.channel.ConnectionStateElement;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.omg.CORBA.Object;

public final class ControllerTransactionManagerSet
implements TransactionGiopFilter,
TranAffinityMap {
    private static final TraceComponent tc = Tr.register(ControllerTransactionManagerSet.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static ControllerTransactionManagerSet _instance = new ControllerTransactionManagerSet();
    private ResourceManager _rm = null;
    private final LockableHashMap _gtidMap = new LockableHashMap(1, true);
    private final LockableHashMap _psbrMap = new LockableHashMap(3, true);
    private boolean _txDebug = false;
    private TransactionByteBufferPoolManager _poolMgr = TransactionByteBufferPoolManager.instance();
    private static String _configuredSystemName = null;
    private static String _mainEnqName = null;
    private final WSThreadLocal _thread = new WSThreadLocal(){

        public java.lang.Object initialValue() {
            return new ControllerTransactionManagerImpl(ControllerTransactionManagerSet.this._gtidMap, ControllerTransactionManagerSet.this._psbrMap);
        }
    };

    public static ControllerTransactionManagerSet instance() {
        return _instance;
    }

    private ControllerTransactionManagerSet() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        TranAffinityRouterHelper tranAffinityRouterHelper = TranAffinityRouterHelper.instance();
        tranAffinityRouterHelper.setTranAffinityMap(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    private final ControllerTransactionManagerImpl self() {
        return (ControllerTransactionManagerImpl)this._thread.get();
    }

    public final LockHierarchy getLockHierarchy() {
        return this.self().getLockHierarchy();
    }

    public final LockableHashMap getGtidMap() {
        return this._gtidMap;
    }

    final LockableHashMap getPsbrMap() {
        return this._psbrMap;
    }

    public final ResourceManager getResourceManager() {
        return this._rm;
    }

    public void receive_request(GIOPMessageContext gIOPMessageContext, GIOPConnectionContext gIOPConnectionContext, ConnectionStateElement connectionStateElement) {
        this.self().receive_request(gIOPMessageContext, gIOPConnectionContext, connectionStateElement);
    }

    public void send_reply(GIOPMessageContext gIOPMessageContext, GIOPConnectionContext gIOPConnectionContext, ConnectionStateElement connectionStateElement) {
        this.self().send_reply(gIOPMessageContext, gIOPConnectionContext, connectionStateElement);
    }

    public void send_request(GIOPMessageContext gIOPMessageContext, GIOPConnectionContext gIOPConnectionContext, ConnectionStateElement connectionStateElement) {
        this.self().send_request(gIOPMessageContext, gIOPConnectionContext, connectionStateElement);
    }

    public void receive_reply(GIOPMessageContext gIOPMessageContext, GIOPConnectionContext gIOPConnectionContext, ConnectionStateElement connectionStateElement) {
        this.self().receive_reply(gIOPMessageContext, gIOPConnectionContext, connectionStateElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void divorceContext(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "divorceContext", byArray);
        }
        ByteBuffer byteBuffer = this._poolMgr.allocateDirect(byArray.length);
        try {
            byteBuffer.put(byArray);
            this.self().divorceContext(byteBuffer);
        }
        finally {
            if (byteBuffer != null) {
                this._poolMgr.returnBufferToPool(byteBuffer);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "divorceContext");
        }
    }

    public synchronized void restartWithRRS() throws ConfigurationError {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restartWithRRS");
        }
        _configuredSystemName = this.findConfiguredSystemName();
        if (this._rm != null) {
            throw new IllegalStateException();
        }
        byte[] byArray = NativeServerInstanceData.getResourceManagerToken();
        this._rm = new ResourceManager(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restartWithRRS");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resync(RecoveryManager recoveryManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resync");
        }
        ArrayList<XID> arrayList = new ArrayList<XID>();
        LockHierarchy lockHierarchy = this.self().getLockHierarchy();
        this._rm.getRestartMapLock(lockHierarchy);
        try {
            java.lang.Object object;
            java.lang.Object object2;
            XID[] xIDArray;
            int n = 0;
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = this._rm.getRestartURs();
            while (iterator.hasNext()) {
                java.lang.Object object3;
                xIDArray = (XID[])iterator.next();
                object2 = xIDArray.getSyncpointInterest();
                if (xIDArray.isResolutionRequired()) {
                    if (this._rm.isRestartOnlyMode()) {
                        if (object2 != null && ((SyncpointInterest)object2).getRecoveryCoordinator() instanceof WSATCRRecoveryCoordinator) {
                            bl = true;
                        } else {
                            object = xIDArray.getResourceIterator();
                            while (object.hasNext()) {
                                object3 = (RetrieveURInterestReturnType)object.next();
                                byte by = PersistentInterestData.getType(((RetrieveURInterestReturnType)object3).getPdata());
                                if (by != 3) continue;
                                bl = true;
                                break;
                            }
                        }
                        if (bl) {
                            ++n;
                            stringBuffer.append(new ByteArray(xIDArray.getURID()));
                            stringBuffer.append(" ");
                            if (((SyncpointInterest)object2).getXaResourceData() != null) {
                                object = xIDArray.getXid();
                                arrayList.add(this.buildXid((XidImpl)object));
                            }
                            iterator.remove();
                            bl = false;
                            continue;
                        }
                    }
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Scheduling resolution", xIDArray);
                    }
                    object = xIDArray.getXid();
                    if (((SyncpointInterest)object2).getXaResourceData() != null) {
                        arrayList.add(this.buildXid((XidImpl)object));
                    }
                    object3 = new TransactionControlRep((RestartURData)xIDArray);
                    this._gtidMap.put(xIDArray.getXid(), object3, true, lockHierarchy);
                    try {
                        ((TransactionControlRep)object3).changeState(1);
                        TransactionalUnitOfWork transactionalUnitOfWork = ((TransactionControlRep)object3).getUnitOfWork();
                        transactionalUnitOfWork.respondToRestartInterests();
                        continue;
                    }
                    finally {
                        ((TransactionControlRep)object3).getLock().releaseWrite(lockHierarchy);
                        continue;
                    }
                }
                ((PersistentInterestData)object2).respond(1);
                object = xIDArray.getResourceIterator();
                while (object.hasNext()) {
                    object3 = ((RetrieveURInterestReturnType)object.next()).getUriToken();
                    PersistentInterestData.respond((byte[])object3, 1, null);
                }
                iterator.remove();
            }
            if (this._rm.isRestartOnlyMode() && n > 0) {
                Tr.event(tc, "PRR mode. Home system restart required to recover the following transaction with WSAT involvement: ", new java.lang.Object[]{new Integer(n), stringBuffer.toString()});
            }
            xIDArray = new XID[arrayList.size()];
            xIDArray = arrayList.toArray(xIDArray);
            object2 = AdminServiceFactory.getAdminService().getProcessType();
            if (!((String)object2).equals("NodeAgent")) {
                object = new XaRecoveryAlarm(null, xIDArray, n > 0);
            }
            recoveryManager.replayComplete();
            this._rm.endRestartPhaseOne();
            this._rm.endRestartPhaseTwo();
        }
        finally {
            this._rm.releaseRestartMapLock(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resync");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServantRecovery(byte[] byArray) {
        java.lang.Object object;
        XID[] xIDArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startServantRecovery", byArray);
        }
        ArrayList<XID> arrayList = new ArrayList<XID>();
        LockHierarchy lockHierarchy = this.getLockHierarchy();
        this._gtidMap.obtainMapLockShared(lockHierarchy);
        try {
            xIDArray = this._gtidMap.iterator();
            while (xIDArray != null && xIDArray.hasNext()) {
                object = (TransactionControlRep)xIDArray.next();
                ((TransactionControlRep)object).getLock().obtainRead(lockHierarchy);
                try {
                    int n = ((TransactionControlRep)object).getState();
                    if (n != 8 && n != 9 && n != 17 && n != 12) continue;
                    XID xID = this.buildXid(((TransactionControlRep)object).getXid());
                    arrayList.add(xID);
                }
                finally {
                    ((TransactionControlRep)object).getLock().releaseRead(lockHierarchy);
                }
            }
        }
        finally {
            this._gtidMap.releaseMapLockShared(lockHierarchy);
        }
        xIDArray = new XID[arrayList.size()];
        xIDArray = arrayList.toArray(xIDArray);
        object = new XaRecoveryAlarm(byArray, xIDArray, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startServantRecovery", byArray);
        }
    }

    private XID buildXid(XidImpl xidImpl) {
        int n = xidImpl.getFormatId();
        byte[] byArray = xidImpl.getGlobalTransactionId();
        byte[] byArray2 = xidImpl.getBranchQualifier();
        byte[] byArray3 = xidImpl.getOtidBytes();
        return new XID(n, byArray.length, byArray2.length, byArray3);
    }

    private void processTxDebug(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTxDebug", new Boolean(bl));
        }
        this._txDebug = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTxDebug");
        }
    }

    public boolean isTxDebugEnabled() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isTxDebugEnabled", new Boolean(this._txDebug));
        }
        return this._txDebug;
    }

    public boolean seenDistributedTran(byte[] byArray) {
        java.lang.Object object;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "seenDistributedTran", byArray);
        }
        boolean bl2 = bl = (object = this._psbrMap.get(new ByteArray(byArray), false)) != null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "seenDistributedTran", new Boolean(bl));
        }
        return bl;
    }

    String[] getHostInfoFromObject(Object object) {
        Profile profile;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHostInfoFromObject", object);
        }
        String[] stringArray = new String[3];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "UNKNOWN";
        }
        ORB oRB = GlobalORBFactory.globalORB();
        IOR iOR = oRB.objectToIOR(object);
        if (iOR != null && (profile = iOR.getProfile()) != null) {
            block6: {
                try {
                    UserKey userKey = (UserKey)profile.getObjectKeyObject().getUserKeyObject();
                    stringArray[0] = userKey.getName();
                }
                catch (Throwable throwable) {
                    if (!tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "Problem getting server name", throwable);
                }
            }
            stringArray[1] = profile.getHost();
            stringArray[2] = Integer.toString(profile.getPort());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHostInfoFromObject", stringArray);
        }
        return stringArray;
    }

    public XidImpl createNewServerXid() {
        return this.self().createNewServerXid();
    }

    public TransactionControlRep import_WSAT_request(XidImpl xidImpl, Lockable lockable) {
        return this.self().import_WSAT_request(xidImpl, lockable);
    }

    public void dispatch_WSAT_request(TransactionControlRep transactionControlRep, byte[] byArray, int n, byte[] byArray2) {
        this.self().dispatch_WSAT_request(transactionControlRep, byArray, n, byArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getJcaIds() {
        java.lang.Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJcaIds");
        }
        ArrayList<java.lang.Object> arrayList = new ArrayList<java.lang.Object>();
        LockHierarchy lockHierarchy = this.getLockHierarchy();
        LockableHashMap lockableHashMap = this.getGtidMap();
        lockableHashMap.obtainMapLockExclusive(lockHierarchy);
        int n = 0;
        try {
            object = lockableHashMap.iterator();
            while (object.hasNext()) {
                TransactionControlRep transactionControlRep = null;
                try {
                    java.lang.Object object2;
                    transactionControlRep = (TransactionControlRep)object.next();
                    transactionControlRep.obtainExclusiveTxLock();
                    TransactionalUnitOfWork transactionalUnitOfWork = transactionControlRep.getUnitOfWork();
                    if (!transactionControlRep.isJCA() || !transactionalUnitOfWork.getHeuristicFlag() && transactionControlRep.getState() != 7) continue;
                    XidImpl xidImpl = null;
                    XidImpl xidImpl2 = transactionControlRep.getXid();
                    byte[] byArray = xidImpl2.getGlobalTransactionId();
                    byte[] byArray2 = transactionControlRep.getJcaBqual();
                    int n2 = transactionControlRep.getJcaFormatId();
                    if (byArray2 != null && byArray2.length > 0 && byArray != null && byArray.length > 0) {
                        xidImpl = new XidImpl(n2, byArray, byArray2);
                    } else {
                        object2 = byArray2 == null ? "null" : Util.toHexString(byArray2);
                        String string = byArray == null ? "null" : Util.toHexString(byArray);
                        Tr.event(tc, "Invalid JCA ID.", new java.lang.Object[]{Integer.toHexString(n2), object2, string, xidImpl2});
                    }
                    if (xidImpl == null) continue;
                    object2 = xidImpl.toBytes();
                    int n3 = ((java.lang.Object)object2).length;
                    arrayList.add(new Integer(n3));
                    arrayList.add(object2);
                    n += n3 + 4;
                }
                finally {
                    transactionControlRep.releaseTxLock();
                }
            }
        }
        finally {
            lockableHashMap.releaseMapLockExclusive(lockHierarchy);
        }
        object = ByteBuffer.allocate(n);
        for (int i = 0; i < arrayList.size(); ++i) {
            ((ByteBuffer)object).putInt((Integer)arrayList.get(i));
            ((ByteBuffer)object).put((byte[])arrayList.get(++i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJcaIds", object);
        }
        return ((ByteBuffer)object).array();
    }

    public void shutdown() {
        java.lang.Object object;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "shutdown");
        }
        if (_mainEnqName != null && (n = ((Enq)(object = Enq.instance())).release(_mainEnqName, 42)) != 0 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "release main ENQ during server shutdown failed", new java.lang.Object[]{new Integer(n), _mainEnqName, new Integer(42)});
        }
        if (this._gtidMap != null && this._gtidMap.size() == 0) {
            boolean bl;
            String string;
            block12: {
                object = PlatformHelperFactory.getPlatformHelper();
                String string2 = object.getSysplexName();
                String string3 = object.getSystemName();
                if (string2 != null) {
                    string2 = string2.trim();
                }
                if (string3 != null) {
                    string3 = string3.trim();
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("MVSADMIN.RRS.COMMANDS.");
                stringBuffer.append(string2);
                stringBuffer.append(".");
                stringBuffer.append(string3);
                string = stringBuffer.toString();
                SAFAuthorizationInterface sAFAuthorizationInterface = SAFAuthorizationFactory.getInstance();
                bl = false;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Calling SAF for resource " + string);
                    }
                    bl = sAFAuthorizationInterface.isCallerAuthorized("FACILITY", string, "UPDATE", true, "NOFAIL");
                }
                catch (Throwable throwable) {
                    if (!tc.isEventEnabled()) break block12;
                    Tr.event(tc, "Exception calling SAF", throwable);
                }
            }
            if (bl) {
                NativeServerInstanceData.setCleanShutdown();
            } else if (tc.isEventEnabled()) {
                Tr.event(tc, "Not authorized to call ATRSRV DELETERM", string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "shutdown");
        }
    }

    public static String getConfiguredSystemName() {
        return _configuredSystemName;
    }

    private String findConfiguredSystemName() throws ConfigurationError {
        String string;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "findConfiguredSystemName");
            }
            string = null;
            PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
            if (platformHelper.runningWhereConfigured()) {
                string = platformHelper.getSystemName();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "findConfiguredSystemName", string.trim());
                }
                return string.trim();
            }
            try {
                java.lang.Object object;
                EList eList;
                EList eList2;
                java.lang.Object object2;
                java.lang.Object object3;
                Repository repository2 = (Repository)WsServiceRegistry.getService((java.lang.Object)this, (Class)Repository.class);
                Server server2 = (Server)repository2.getConfigRoot().getResource(4, "server.xml").getContents().get(0);
                EList eList3 = server2.getServices();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server.xml service list has size: " + eList3.size());
                }
                EList eList4 = eList3.iterator();
                block2: while (eList4.hasNext()) {
                    object3 = eList4.next();
                    if (!(object3 instanceof AdminService)) continue;
                    object2 = (AdminService)object3;
                    eList2 = object2.getProperties();
                    eList = eList2.iterator();
                    while (eList.hasNext()) {
                        object = (Property)eList.next();
                        if (object == null || !"was.ConfiguredSystemName".equals(object.getName())) continue;
                        string = object.getValue().trim();
                        if (!tc.isDebugEnabled()) break block2;
                        Tr.debug(tc, "found was.ConfiguredSystemName:" + string);
                        break block2;
                    }
                    break block2;
                }
                if (string != null) break block14;
                eList4 = server2.getComponents();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "server.xml component list has size: " + eList4.size());
                }
                object3 = eList4.iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    if (!(object2 instanceof ApplicationServer)) continue;
                    eList2 = (ApplicationServer)object2;
                    eList = eList2.getProperties();
                    object = eList.iterator();
                    while (object.hasNext()) {
                        Property property = (Property)object.next();
                        if (property == null || !"was.ConfiguredSystemName".equals(property.getName())) continue;
                        string = property.getValue().trim();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "found was.ConfiguredSystemName:" + string);
                        }
                        break block14;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception caught getting the server config object, rethrowing as a ConfigurationError");
                }
                throw new ConfigurationError(throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findConfiguredSystemName", string);
        }
        return string;
    }

    public static void setMainEnqName(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "setMainEnqName", string);
        }
        _mainEnqName = string;
    }
}

