/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.tx.NativeTransactionContext;

public final class EpochSequenceFactory {
    private static final TraceComponent tc = Tr.register(EpochSequenceFactory.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int SEQUENCE_ALLOCATION = 8192;
    private static final EpochSequenceFactory _instance = new EpochSequenceFactory();
    private final Object _lock = new Object();
    private int _currentEpoch = 0;
    private int _baseSequence = 0;
    private int _currentSequence = 0;

    public static final EpochSequenceFactory instance() {
        return _instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EpochSequenceFactory() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        Object object = this._lock;
        synchronized (object) {
            this.fetchSequenceRange();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    private void fetchSequenceRange() {
        long l = NativeTransactionContext.allocateSequence();
        this._currentEpoch = (int)(l >>> 32);
        this._baseSequence = this._currentSequence = (int)(l & 0xFFFFFFFFL);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "New Epoch and Sequence", new Object[]{new Long(l), new Integer(this._currentEpoch), new Integer(this._currentSequence)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long obtainEpochSequence() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "obtainEpochSequence");
        }
        long l = 0L;
        Object object = this._lock;
        synchronized (object) {
            int n = this._baseSequence + 8192 - 1;
            int n2 = this._currentSequence + 1;
            if (n2 > n || n2 < this._baseSequence || n2 == 0) {
                this.fetchSequenceRange();
            } else {
                this._currentSequence = n2;
            }
            l = (long)this._currentSequence & 0xFFFFFFFFL;
            l |= (long)this._currentEpoch << 32;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "obtainEpochSequence", Long.toHexString(l));
        }
        return l;
    }
}

