/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.lock.WriterPriorityReadersWriterLock;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public final class LockHierarchy {
    private static final TraceComponent tc = Tr.register(LockHierarchy.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final int RESTART_UOW_MAP_LOCK_ID = 0;
    public static final int GTID_MAP_LOCK_ID = 1;
    public static final int TRANSACTION_LOCK_ID = 2;
    public static final int PSBR_MAP_LOCK_ID = 3;
    public static final int PSBR_TABLE_LOCK_ID = 4;
    public static final int MAX_LOCK_ID = 31;
    private int _lockBitmask = 0;
    private Thread _thread = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LockHierarchy: ");
        stringBuffer.append("Thread Name = ");
        stringBuffer.append(this._thread.getName());
        stringBuffer.append(", Bitmask = ");
        stringBuffer.append(Integer.toHexString(this._lockBitmask));
        return stringBuffer.toString();
    }

    LockHierarchy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this._thread = Thread.currentThread();
        this._lockBitmask = 0;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    boolean checkAccess(int n) {
        boolean bl = true;
        int n2 = this._lockBitmask;
        n2 >>= n;
        if ((n2 <<= n) >= 1 << n) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Access check failed", new Object[]{new Integer(this._lockBitmask), new Integer(n)});
            }
            bl = false;
        }
        return bl;
    }

    void obtainLock(WriterPriorityReadersWriterLock writerPriorityReadersWriterLock, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "obtainLock", new Object[]{writerPriorityReadersWriterLock, new Integer(n), new Integer(n2)});
        }
        if (this._thread.equals(Thread.currentThread())) {
            block10: {
                if (!this.checkAccess(n)) {
                    throw new INTERNAL(-910026575, CompletionStatus.COMPLETED_NO);
                }
                try {
                    if (n2 == 0) {
                        writerPriorityReadersWriterLock.startReading();
                        break block10;
                    }
                    if (n2 == 1) {
                        writerPriorityReadersWriterLock.startWriting();
                        break block10;
                    }
                    throw new INTERNAL(-910026574, CompletionStatus.COMPLETED_NO);
                }
                catch (InterruptedException interruptedException) {
                    throw new INTERNAL(-910026171, CompletionStatus.COMPLETED_NO);
                }
            }
            this._lockBitmask |= 1 << n;
        } else {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Threads do not match", new Object[]{Thread.currentThread(), this._thread});
            }
            throw new INTERNAL(-910026204, CompletionStatus.COMPLETED_NO);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "obtainLock", new Object[]{writerPriorityReadersWriterLock, new Integer(n2)});
        }
    }

    void releaseLock(WriterPriorityReadersWriterLock writerPriorityReadersWriterLock, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseLock", new Object[]{writerPriorityReadersWriterLock, new Integer(n), new Integer(n2)});
        }
        if (this._thread.equals(Thread.currentThread())) {
            if ((this._lockBitmask & 1 << n) == 0) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "This thread does not hold this lock", new Object[]{new Integer(n), new Integer(this._lockBitmask)});
                }
                throw new INTERNAL(-910026179, CompletionStatus.COMPLETED_NO);
            }
            if (n2 == 0) {
                writerPriorityReadersWriterLock.stopReading();
            } else if (n2 == 1) {
                writerPriorityReadersWriterLock.stopWriting();
            } else {
                throw new IllegalArgumentException(n2 + " is not a valid lock mode");
            }
            this._lockBitmask &= ~(1 << n);
        } else {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Threads to not match", new Object[]{Thread.currentThread(), this._thread});
            }
            throw new INTERNAL(-910026203, CompletionStatus.COMPLETED_NO);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseLock", new Object[]{writerPriorityReadersWriterLock, new Integer(n2)});
        }
    }
}

