/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.LockHierarchy;
import com.ibm.ws390.tx.LockableObject;
import com.ibm.ws390.tx.ReaderWriterLock;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public final class LockableHashMap {
    private static final TraceComponent tc = Tr.register(LockableHashMap.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private HashMap _map = null;
    private ReaderWriterLock _lock = null;
    private boolean _lockableObjects = false;

    LockableHashMap(int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{new Integer(n), new Boolean(bl)});
        }
        this._map = new HashMap();
        this._lock = new ReaderWriterLock(n);
        this._lockableObjects = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    private LockHierarchy getLockHierarchy() {
        ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
        return controllerTransactionManagerSet.getLockHierarchy();
    }

    boolean put(Object object, Object object2, boolean bl) {
        return this.put(object, object2, bl, this.getLockHierarchy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean put(Object object, Object object2, boolean bl, LockHierarchy lockHierarchy) {
        if (tc.isEntryEnabled()) {
            Boolean bl2 = new Boolean(bl);
            Tr.entry(tc, "put", new Object[]{object, object2, bl2, lockHierarchy});
        }
        boolean bl3 = false;
        boolean bl4 = false;
        try {
            this._lock.obtainWrite(lockHierarchy);
            bl4 = true;
            if (!this._map.containsKey(object)) {
                if (bl && this._lockableObjects && object2 instanceof LockableObject) {
                    ReaderWriterLock readerWriterLock = ((LockableObject)object2).getLock();
                    readerWriterLock.obtainWrite(lockHierarchy);
                }
                this._map.put(object, object2);
                bl3 = true;
            }
        }
        catch (Throwable throwable) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Could not put item", throwable);
            }
        }
        finally {
            if (bl4) {
                this._lock.releaseWrite(lockHierarchy);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "put", new Boolean(bl3));
        }
        return bl3;
    }

    Object get(Object object, boolean bl) {
        return this.get(object, bl, this.getLockHierarchy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object get(Object object, boolean bl, LockHierarchy lockHierarchy) {
        Boolean bl2;
        if (tc.isEntryEnabled()) {
            bl2 = new Boolean(bl);
            Tr.entry(tc, "get", new Object[]{object, bl2, lockHierarchy});
        }
        bl2 = null;
        boolean bl3 = false;
        try {
            this._lock.obtainRead(lockHierarchy);
            bl3 = true;
            bl2 = this._map.get(object);
            if (bl2 != null && bl && this._lockableObjects && bl2 instanceof LockableObject) {
                ReaderWriterLock readerWriterLock = ((LockableObject)((Object)bl2)).getLock();
                readerWriterLock.obtainWrite(lockHierarchy);
            }
        }
        catch (Throwable throwable) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Could not get item", throwable);
            }
            bl2 = null;
        }
        finally {
            if (bl3) {
                this._lock.releaseRead(lockHierarchy);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get", bl2);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "contains", object);
        }
        LockHierarchy lockHierarchy = this.getLockHierarchy();
        boolean bl = false;
        this._lock.obtainRead(lockHierarchy);
        try {
            bl = this._map.containsKey(object);
        }
        catch (Throwable throwable) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Contains threw an exception", throwable);
            }
        }
        finally {
            this._lock.releaseRead(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "contains", new Boolean(bl));
        }
        return bl;
    }

    Object remove(Object object) {
        return this.remove(object, this.getLockHierarchy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object remove(Object object, LockHierarchy lockHierarchy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "remove", new Object[]{object, lockHierarchy});
        }
        Object var3_3 = null;
        boolean bl = false;
        try {
            this._lock.obtainWrite(lockHierarchy);
            bl = true;
            var3_3 = this._map.remove(object);
        }
        catch (Throwable throwable) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Could not remove key", throwable);
            }
            var3_3 = null;
        }
        finally {
            if (bl) {
                this._lock.releaseWrite(lockHierarchy);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "remove", var3_3);
        }
        return var3_3;
    }

    public Iterator iterator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "iterator");
        }
        Collection collection = this._map.values();
        Iterator iterator = null;
        if (collection != null) {
            iterator = collection.iterator();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "iterator", iterator);
        }
        return iterator;
    }

    int size() {
        return this._map.size();
    }

    public void obtainMapLockExclusive(LockHierarchy lockHierarchy) {
        this._lock.obtainWrite(lockHierarchy);
    }

    boolean obtainMapLockShared(LockHierarchy lockHierarchy) {
        boolean bl;
        block2: {
            bl = false;
            try {
                this._lock.obtainRead(lockHierarchy);
                bl = true;
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "Could not obtain lock", throwable);
            }
        }
        return bl;
    }

    public void releaseMapLockExclusive(LockHierarchy lockHierarchy) {
        this._lock.releaseWrite(lockHierarchy);
    }

    boolean releaseMapLockShared(LockHierarchy lockHierarchy) {
        boolean bl;
        block2: {
            bl = false;
            try {
                this._lock.releaseRead(lockHierarchy);
                bl = true;
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) break block2;
                Tr.event(tc, "Could not release lock", throwable);
            }
        }
        return bl;
    }
}

