/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.TxPrimaryKey;
import com.ibm.ws.Transaction.JTA.XAPdataWrapper;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.NativeJDBCDriverHelper;
import com.ibm.ws390.tx.BranchRegistryTable;
import com.ibm.ws390.tx.EpochSequenceFactory;
import com.ibm.ws390.tx.NativeTransactionContext;
import com.ibm.ws390.tx.TransactionByteBufferPoolManager;
import com.ibm.ws390.tx.TransactionMessagePipe;
import com.ibm.ws390.tx.rrs.RRS;
import com.ibm.ws390.tx.rrs.RetrieveURDataReturnType;
import com.ibm.zosrrs.BeginReturnType;
import com.ibm.zosrrs.EndReturnType;
import java.util.Arrays;
import javax.transaction.HeuristicMixedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public final class NativeGlobalTransactionContext
extends NativeTransactionContext {
    private byte[] _urToken;
    private byte[] _nativeTxID;
    private XidImpl _nativeXid;
    private XAPdataWrapper _piData;
    private XAPdataWrapper _failedResourceData;
    private boolean _deferredExpressionOfInterest;
    private TransactionImpl _tx;
    private byte[] _jcaBqual;
    private int _jcaFid;
    private static final TraceComponent tc = Tr.register(NativeGlobalTransactionContext.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final TransactionByteBufferPoolManager _poolMgr = TransactionByteBufferPoolManager.instance();
    private static final EpochSequenceFactory _esf = EpochSequenceFactory.instance();

    public static final NativeGlobalTransactionContext create(TransactionImpl transactionImpl, int n) throws SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create", new Object[]{transactionImpl, new Integer(n), new Boolean(false)});
        }
        NativeGlobalTransactionContext nativeGlobalTransactionContext = null;
        XidImpl xidImpl = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        byArray2 = NativeGlobalTransactionContext.getCurrentContextToken();
        long l = _esf.obtainEpochSequence();
        TxPrimaryKey txPrimaryKey = new TxPrimaryKey(l);
        xidImpl = new XidImpl(txPrimaryKey);
        BeginReturnType beginReturnType = com.ibm.zosrrs.RRS.begin((int)1);
        int n2 = beginReturnType.getReturnCode();
        if (n2 != 0) {
            throw new SystemException("ATRBEG Failed, RC = " + n2);
        }
        byArray = beginReturnType.getUrToken();
        boolean bl = Arrays.equals(byArray, com.ibm.zosrrs.RRS.nullUrToken);
        if (bl) {
            RetrieveURDataReturnType retrieveURDataReturnType = RRS.retrieveURData(com.ibm.zosrrs.RRS.nullUrToken, 1);
            n2 = retrieveURDataReturnType.getReturnCode();
            if (n2 != 0) {
                throw new SystemException("ATRRURD2 failed, RC = " + n2);
            }
            byArray = retrieveURDataReturnType.getUrToken();
        }
        if ((n2 = NativeGlobalTransactionContext.setWorkID(xidImpl.toBytes(), byArray)) != 0) {
            throw new SystemException("ATRSWID2 failed, RC = " + n2);
        }
        nativeGlobalTransactionContext = new NativeGlobalTransactionContext(transactionImpl, xidImpl, byArray2, byArray, null, 0, false);
        nativeGlobalTransactionContext.connectGtidToORBR();
        NativeGlobalTransactionContext.reportSMF(true, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create", nativeGlobalTransactionContext);
        }
        return nativeGlobalTransactionContext;
    }

    public static final NativeGlobalTransactionContext setupImportedTx(TransactionImpl transactionImpl, XidImpl xidImpl, boolean bl, boolean bl2) throws SystemException {
        NativeGlobalTransactionContext nativeGlobalTransactionContext;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setupImportedTx", transactionImpl);
            }
            XidImpl xidImpl2 = null;
            byte[] byArray = null;
            byte[] byArray2 = null;
            byte[] byArray3 = xidImpl.toBytes();
            byte[] byArray4 = null;
            int n = 0;
            if (bl) {
                n = xidImpl.getFormatId();
                byArray4 = xidImpl.getBranchQualifier();
            }
            byArray2 = NativeGlobalTransactionContext.getCurrentContextToken();
            if (bl) {
                long l = _esf.obtainEpochSequence();
                TxPrimaryKey txPrimaryKey = new TxPrimaryKey(l);
                xidImpl2 = new XidImpl(xidImpl.getGlobalTransactionId(), txPrimaryKey, 1);
                BeginReturnType beginReturnType = com.ibm.zosrrs.RRS.begin((int)1);
                int n2 = beginReturnType.getReturnCode();
                if (n2 != 0) {
                    throw new SystemException("ATRBEG Failed, rc = " + n2);
                }
                byArray = beginReturnType.getUrToken();
                boolean bl3 = Arrays.equals(byArray, com.ibm.zosrrs.RRS.nullUrToken);
                if (bl3) {
                    RetrieveURDataReturnType retrieveURDataReturnType = RRS.retrieveURData(com.ibm.zosrrs.RRS.nullUrToken, 1);
                    n2 = retrieveURDataReturnType.getReturnCode();
                    if (n2 != 0) {
                        throw new SystemException("ATRRURD2 failed, RC = " + n2);
                    }
                    byArray = retrieveURDataReturnType.getUrToken();
                }
                if ((n2 = NativeGlobalTransactionContext.setWorkID(xidImpl2.toBytes(), byArray)) != 0) {
                    throw new SystemException("ATRSWID failed, RC = " + n2);
                }
            } else {
                xidImpl2 = xidImpl;
                BeginReturnType beginReturnType = com.ibm.zosrrs.RRS.begin((int)1);
                int n3 = beginReturnType.getReturnCode();
                if (n3 != 0) {
                    throw new SystemException("ATRBEG failed, rc = " + n3);
                }
                byArray = beginReturnType.getUrToken();
            }
            nativeGlobalTransactionContext = new NativeGlobalTransactionContext(transactionImpl, xidImpl2, byArray2, byArray, byArray4, n, bl2);
            if (!bl) {
                byte[] byArray5 = BranchRegistryTable.xidToGtid(xidImpl2);
                try {
                    NativeGlobalTransactionContext.contextAssociation(byArray5, byArray2);
                }
                catch (SystemException systemException) {
                    if (!nativeGlobalTransactionContext.hasInterests()) {
                        if (!transactionImpl.isCascaded()) {
                            try {
                                nativeGlobalTransactionContext.endCurrentUR(byArray, false);
                            }
                            catch (RollbackException rollbackException) {
                            }
                            catch (HeuristicMixedException heuristicMixedException) {
                                Tr.audit(tc, "WTRN0044_HEURISTIC_MAY_HAVE_OCCURED", xidImpl2.toString());
                            }
                        }
                        NativeGlobalTransactionContext.contextDisassociation(byArray5);
                        throw systemException;
                    }
                    if (!tc.isEventEnabled()) break block19;
                    Tr.event(tc, "Caught exception during context association, cannot roll back since there are interests", xidImpl2);
                }
            }
        }
        nativeGlobalTransactionContext.suspend();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setupImportedTx", nativeGlobalTransactionContext);
        }
        return nativeGlobalTransactionContext;
    }

    private NativeGlobalTransactionContext(TransactionImpl transactionImpl, XidImpl xidImpl, byte[] byArray, byte[] byArray2, byte[] byArray3, int n, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", xidImpl);
        }
        this._nativeXid = xidImpl;
        this._tx = transactionImpl;
        this._urToken = byArray2;
        this._jcaBqual = byArray3;
        this._jcaFid = n;
        boolean bl2 = this._jcaBqual != null;
        boolean bl3 = this._tx.isSubordinate();
        this._deferredExpressionOfInterest = !bl3 || bl2;
        this.setContextToken(byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public byte[] getNativeTranID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNativeTranID");
        }
        if (this._nativeTxID == null) {
            this._nativeTxID = BranchRegistryTable.xidToGtid(this._nativeXid);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNativeTranID", this._nativeTxID);
        }
        return this._nativeTxID;
    }

    public byte[] getUrToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUrToken");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUrToken", this._urToken);
        }
        return this._urToken;
    }

    public XidImpl getNativeXID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNativeXID");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNativeXID", this._nativeXid);
        }
        return this._nativeXid;
    }

    public void setXAInterestData(XAPdataWrapper xAPdataWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setXAInterestData", xAPdataWrapper);
        }
        this._piData = xAPdataWrapper;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setXAInterestData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare() throws RollbackException, HeuristicMixedException, SystemException {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare");
        }
        try {
            byArray = this._piData == null ? null : this._piData.getBytes();
        }
        catch (SystemException systemException) {
            RollbackException rollbackException = new RollbackException(systemException.toString());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "prepare", (Object)rollbackException);
            }
            throw rollbackException;
        }
        TransactionMessagePipe transactionMessagePipe = null;
        try {
            transactionMessagePipe = new TransactionMessagePipe(10, byArray);
            this.populateMessagePipe(transactionMessagePipe);
            transactionMessagePipe.setReportHeuristicsFlag();
            TransactionMessagePipe transactionMessagePipe2 = null;
            try {
                transactionMessagePipe2 = NativeGlobalTransactionContext.processTmp(transactionMessagePipe, true);
            }
            catch (Throwable throwable) {
                Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"prepare", this.getClass().getName(), throwable});
            }
            if (transactionMessagePipe.getExpressInterestFlag() && transactionMessagePipe2.getBeginFailedFlag()) {
                this._deferredExpressionOfInterest = true;
            }
            if (transactionMessagePipe2.getExceptionCode() != 0) {
                NativeGlobalTransactionContext.processTmpException(transactionMessagePipe2);
            }
        }
        finally {
            if (transactionMessagePipe != null && transactionMessagePipe.getBackingBuffer() != null) {
                _poolMgr.returnBufferToPool(transactionMessagePipe.getBackingBuffer());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare");
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logXAInterestData() throws RollbackException {
        block15: {
            byte[] byArray;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "logXAInterestData");
            }
            try {
                byArray = this._piData == null ? null : this._piData.getBytes();
            }
            catch (SystemException systemException) {
                RollbackException rollbackException = new RollbackException(systemException.toString());
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "logXAInterestData", (Object)rollbackException);
                }
                throw rollbackException;
            }
            TransactionMessagePipe transactionMessagePipe = null;
            TransactionMessagePipe transactionMessagePipe2 = null;
            try {
                transactionMessagePipe2 = new TransactionMessagePipe(13, byArray);
                this.populateMessagePipe(transactionMessagePipe2);
                try {
                    transactionMessagePipe = NativeGlobalTransactionContext.processTmp(transactionMessagePipe2, true);
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"logXAInterestData", this.getClass().getName(), throwable});
                }
                if (transactionMessagePipe2.getExpressInterestFlag() && transactionMessagePipe.getBeginFailedFlag()) {
                    this._deferredExpressionOfInterest = true;
                }
                if (transactionMessagePipe.getExceptionCode() == 0) break block15;
                try {
                    NativeGlobalTransactionContext.processTmpException(transactionMessagePipe);
                }
                catch (HeuristicMixedException heuristicMixedException) {
                    throw new RuntimeException(heuristicMixedException);
                }
                catch (SystemException systemException) {
                    throw new RuntimeException(systemException);
                }
            }
            finally {
                if (transactionMessagePipe2 != null && transactionMessagePipe2.getBackingBuffer() != null) {
                    _poolMgr.returnBufferToPool(transactionMessagePipe2.getBackingBuffer());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logXAInterestData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws HeuristicMixedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit");
        }
        if (this._deferredExpressionOfInterest) {
            throw new IllegalStateException("Commit while deferred");
        }
        NativeTransactionContext.reportTranEnd(false);
        TransactionMessagePipe transactionMessagePipe = null;
        try {
            transactionMessagePipe = new TransactionMessagePipe(2, null);
            this.populateMessagePipe(transactionMessagePipe);
            try {
                TransactionMessagePipe transactionMessagePipe2 = NativeGlobalTransactionContext.processTmp(transactionMessagePipe, false);
            }
            catch (SystemException systemException) {
                throw new HeuristicMixedException(systemException.toString());
            }
            catch (RollbackException rollbackException) {
                throw new HeuristicMixedException(rollbackException.toString());
            }
        }
        finally {
            if (transactionMessagePipe != null && transactionMessagePipe.getBackingBuffer() != null) {
                _poolMgr.returnBufferToPool(transactionMessagePipe.getBackingBuffer());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commitOnePhase() throws HeuristicMixedException, RollbackException, SystemException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commitOnePhase");
        }
        byte[] byArray = null;
        NativeTransactionContext.reportTranEnd(false);
        try {
            if (this._piData != null) {
                byArray = this._piData.getBytes();
            }
        }
        catch (SystemException systemException) {
            RollbackException rollbackException = new RollbackException(systemException.toString());
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "commitOnePhase", (Object)rollbackException);
            }
            throw rollbackException;
        }
        if (this._deferredExpressionOfInterest && this._piData == null) {
            byte[] byArray2 = this.getUrToken();
            this.endCurrentUR(byArray2, true);
        } else {
            TransactionMessagePipe transactionMessagePipe = null;
            TransactionMessagePipe transactionMessagePipe2 = null;
            try {
                transactionMessagePipe2 = new TransactionMessagePipe(2, byArray);
                this.populateMessagePipe(transactionMessagePipe2);
                transactionMessagePipe2.setBossInitiatedFlag();
                transactionMessagePipe2.setReportHeuristicsFlag();
                transactionMessagePipe2.setCommitOnePhaseFlag();
                try {
                    transactionMessagePipe = NativeGlobalTransactionContext.processTmp(transactionMessagePipe2, true);
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"commitOnePhase", this.getClass().getName(), throwable});
                }
                if (transactionMessagePipe2.getExpressInterestFlag() && transactionMessagePipe.getBeginFailedFlag()) {
                    EndReturnType endReturnType = com.ibm.zosrrs.RRS.end((int)2, (byte[])com.ibm.zosrrs.RRS.nullUrToken);
                    int n = endReturnType.getReturnCode();
                    if (n != 0 && tc.isEventEnabled()) {
                        Tr.event(tc, "Backout failed after 1PC failure", new Integer(n));
                    }
                    this._deferredExpressionOfInterest = true;
                }
                if (transactionMessagePipe.getExceptionCode() != 0) {
                    NativeGlobalTransactionContext.processTmpException(transactionMessagePipe);
                }
            }
            finally {
                if (transactionMessagePipe2 != null && transactionMessagePipe2.getBackingBuffer() != null) {
                    _poolMgr.returnBufferToPool(transactionMessagePipe2.getBackingBuffer());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commitOnePhase");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void rollback() throws SystemException, HeuristicMixedException {
        block27: {
            boolean bl;
            byte[] byArray;
            block26: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "rollback");
                }
                byArray = null;
                bl = false;
                NativeTransactionContext.reportTranEnd(false);
                try {
                    if (this._piData != null) {
                        byArray = this._piData.getBytes();
                    }
                }
                catch (SystemException systemException) {
                    if (!tc.isEventEnabled()) break block26;
                    Tr.event(tc, "Unexpected exception during rollback", (Object)systemException);
                }
            }
            if (this._deferredExpressionOfInterest && this._piData == null) {
                byte[] byArray2 = this.getUrToken();
                try {
                    this.endCurrentUR(byArray2, false);
                }
                catch (RollbackException rollbackException) {}
            } else {
                TransactionMessagePipe transactionMessagePipe = null;
                TransactionMessagePipe transactionMessagePipe2 = null;
                try {
                    boolean bl2;
                    transactionMessagePipe2 = new TransactionMessagePipe(3, byArray);
                    this.populateMessagePipe(transactionMessagePipe2);
                    transactionMessagePipe2.setBossInitiatedFlag();
                    try {
                        transactionMessagePipe = NativeGlobalTransactionContext.processTmp(transactionMessagePipe2, true);
                    }
                    catch (Throwable throwable) {
                        Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"rollback", this.getClass().getName(), throwable});
                    }
                    if (transactionMessagePipe2.getExpressInterestFlag() && transactionMessagePipe.getBeginFailedFlag()) {
                        EndReturnType endReturnType = com.ibm.zosrrs.RRS.end((int)2, (byte[])com.ibm.zosrrs.RRS.nullUrToken);
                        int n = endReturnType.getReturnCode();
                        if (n != 0 && tc.isEventEnabled()) {
                            Tr.event(tc, "Backout failed after 1PC failure", new Integer(n));
                        }
                        this._deferredExpressionOfInterest = true;
                    }
                    try {
                        if (transactionMessagePipe.getExceptionCode() != 0) {
                            NativeGlobalTransactionContext.processTmpException(transactionMessagePipe);
                        }
                        if (byArray != null) break block27;
                        bl2 = this._jcaBqual != null;
                    }
                    catch (RollbackException rollbackException) {
                        try {
                            throw new SystemException(rollbackException.toString());
                            catch (HeuristicMixedException heuristicMixedException) {
                                bl = true;
                                throw heuristicMixedException;
                            }
                        }
                        catch (Throwable throwable) {
                            if (byArray == null) {
                                boolean bl3;
                                boolean bl4 = bl3 = this._jcaBqual != null;
                                if (!bl3 || !bl) {
                                    this.cleanupTransaction();
                                }
                            }
                            throw throwable;
                        }
                    }
                    boolean bl5 = bl2;
                    if (!bl5 || !bl) {
                        this.cleanupTransaction();
                    }
                }
                finally {
                    if (transactionMessagePipe2 != null && transactionMessagePipe2.getBackingBuffer() != null) {
                        _poolMgr.returnBufferToPool(transactionMessagePipe2.getBackingBuffer());
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    public void setFailedResourceData(XAPdataWrapper xAPdataWrapper) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFailedResourceData", xAPdataWrapper);
        }
        this._failedResourceData = xAPdataWrapper;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFailedResourceData");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setRollbackOnly() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRollbackOnly");
        }
        TransactionMessagePipe transactionMessagePipe = null;
        TransactionMessagePipe transactionMessagePipe2 = null;
        try {
            transactionMessagePipe2 = new TransactionMessagePipe(4, null);
            this.populateMessagePipe(transactionMessagePipe2);
            try {
                transactionMessagePipe = NativeGlobalTransactionContext.processTmp(transactionMessagePipe2, true);
            }
            catch (Throwable throwable) {
                Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"setRollbackOnly", this.getClass().getName(), throwable});
            }
            if (transactionMessagePipe2.getExpressInterestFlag() && transactionMessagePipe.getBeginFailedFlag()) {
                this._deferredExpressionOfInterest = true;
            }
            if (transactionMessagePipe.getExceptionCode() != 0) {
                try {
                    NativeGlobalTransactionContext.processTmpException(transactionMessagePipe);
                }
                catch (Exception exception) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unexpected exception from setRollbackOnly", exception);
                    }
                }
            }
        }
        finally {
            if (transactionMessagePipe2 != null && transactionMessagePipe2.getBackingBuffer() != null) {
                _poolMgr.returnBufferToPool(transactionMessagePipe2.getBackingBuffer());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRollbackOnly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeuristic() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHeuristic");
        }
        TransactionMessagePipe transactionMessagePipe = null;
        TransactionMessagePipe transactionMessagePipe2 = null;
        try {
            transactionMessagePipe2 = new TransactionMessagePipe(12, null);
            this.populateMessagePipe(transactionMessagePipe2);
            try {
                transactionMessagePipe = NativeGlobalTransactionContext.processTmp(transactionMessagePipe2, true);
            }
            catch (Throwable throwable) {
                Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"setHeuristic", this.getClass().getName(), throwable});
            }
            if (transactionMessagePipe2.getExpressInterestFlag() && transactionMessagePipe.getBeginFailedFlag()) {
                this._deferredExpressionOfInterest = true;
            }
            if (transactionMessagePipe.getExceptionCode() != 0) {
                try {
                    NativeGlobalTransactionContext.processTmpException(transactionMessagePipe);
                }
                catch (Exception exception) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unexpected exception from setHeuristic", exception);
                    }
                }
            }
        }
        finally {
            if (transactionMessagePipe2 != null && transactionMessagePipe2.getBackingBuffer() != null) {
                _poolMgr.returnBufferToPool(transactionMessagePipe2.getBackingBuffer());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHeuristic");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cleanupTransaction() {
        block17: {
            Object object;
            Object object2;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanupTransaction");
            }
            if (this._failedResourceData != null) {
                object2 = null;
                try {
                    object = this._failedResourceData.getBytes();
                    object2 = new TransactionMessagePipe(14, (byte[])object);
                    this.populateMessagePipe((TransactionMessagePipe)object2);
                    TransactionMessagePipe transactionMessagePipe = NativeGlobalTransactionContext.processTmp((TransactionMessagePipe)object2, false);
                }
                catch (Exception exception) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Error setting failed XA resource data", exception);
                    }
                }
                finally {
                    if (object2 != null && ((TransactionMessagePipe)object2).getBackingBuffer() != null) {
                        _poolMgr.returnBufferToPool(((TransactionMessagePipe)object2).getBackingBuffer());
                    }
                }
            }
            try {
                if (this._deferredExpressionOfInterest) {
                    if (!this.isEnded()) {
                        object2 = this.getUrToken();
                        this.endCurrentUR((byte[])object2, true);
                    }
                } else {
                    object2 = this.getNativeTranID();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "driving context_disassociation", object2);
                    }
                    NativeGlobalTransactionContext.contextDisassociation((byte[])object2);
                }
            }
            catch (Exception exception) {
                object = "Unexpected exception from cleanupTransaction";
                if (!tc.isEventEnabled()) break block17;
                Tr.event(tc, (String)object, exception);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupTransaction");
        }
    }

    private static final native void contextAssociation(byte[] var0, byte[] var1) throws SystemException;

    private static final native void contextDisassociation(byte[] var0);

    private static final native int setWorkID(byte[] var0, byte[] var1);

    public boolean isLocal() {
        return false;
    }

    public int hashCode() {
        return this._nativeXid.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof NativeGlobalTransactionContext) {
            NativeGlobalTransactionContext nativeGlobalTransactionContext = null;
            nativeGlobalTransactionContext = (NativeGlobalTransactionContext)object;
            return this._nativeXid.equals(nativeGlobalTransactionContext._nativeXid);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void promoteToDistributedTx() throws SystemException {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "promoteToDistributedTx");
            }
            if (this._deferredExpressionOfInterest) {
                TransactionMessagePipe transactionMessagePipe = null;
                TransactionMessagePipe transactionMessagePipe2 = null;
                try {
                    transactionMessagePipe2 = new TransactionMessagePipe(1, null);
                    this.populateMessagePipe(transactionMessagePipe2);
                    try {
                        transactionMessagePipe = NativeGlobalTransactionContext.processTmp(transactionMessagePipe2, true);
                    }
                    catch (Throwable throwable) {
                        Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"promoteToDistributedTx", this.getClass().getName(), throwable});
                    }
                    if (transactionMessagePipe2.getExpressInterestFlag() && transactionMessagePipe.getBeginFailedFlag()) {
                        this._deferredExpressionOfInterest = true;
                    }
                    if (transactionMessagePipe.getExceptionCode() == 0) break block14;
                    try {
                        NativeGlobalTransactionContext.processTmpException(transactionMessagePipe);
                    }
                    catch (Throwable throwable) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "promoteToDistributedTx", throwable);
                        }
                        if (throwable instanceof SystemException) {
                            throw (SystemException)throwable;
                        }
                        throw new SystemException(throwable.toString());
                    }
                }
                finally {
                    if (transactionMessagePipe2 != null && transactionMessagePipe2.getBackingBuffer() != null) {
                        _poolMgr.returnBufferToPool(transactionMessagePipe2.getBackingBuffer());
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promoteToDistributedTx");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void promoteToDistributedTx(String string) throws SystemException {
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "promoteToDistributedTx", string);
            }
            byte[] byArray = string.getBytes();
            TransactionMessagePipe transactionMessagePipe = null;
            TransactionMessagePipe transactionMessagePipe2 = null;
            try {
                transactionMessagePipe2 = new TransactionMessagePipe(22, byArray);
                this.populateMessagePipe(transactionMessagePipe2);
                try {
                    transactionMessagePipe = NativeGlobalTransactionContext.processTmp(transactionMessagePipe2, true);
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"promoteToDistributedTx", this.getClass().getName(), throwable});
                }
                if (transactionMessagePipe2.getExpressInterestFlag() && transactionMessagePipe.getBeginFailedFlag()) {
                    this._deferredExpressionOfInterest = true;
                }
                if (transactionMessagePipe.getExceptionCode() == 0) break block13;
                try {
                    NativeGlobalTransactionContext.processTmpException(transactionMessagePipe);
                }
                catch (Throwable throwable) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "promoteToDistributedTx", throwable);
                    }
                    if (throwable instanceof SystemException) {
                        throw (SystemException)throwable;
                    }
                    throw new SystemException(throwable.toString());
                }
            }
            finally {
                if (transactionMessagePipe2 != null && transactionMessagePipe2.getBackingBuffer() != null) {
                    _poolMgr.returnBufferToPool(transactionMessagePipe2.getBackingBuffer());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "promoteToDistributedTx");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerParticipant(byte[] byArray) throws SystemException {
        block16: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "registerParticipant", byArray);
            }
            if (this._deferredExpressionOfInterest) {
                IllegalStateException illegalStateException = new IllegalStateException("WSAT registerParticipant detected deferred expression of interest");
                Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"registerParticipant", this.getClass().getName(), illegalStateException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerParticipant", illegalStateException);
                }
                throw new SystemException(illegalStateException.toString());
            }
            if (byArray.length > 3072) {
                ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException = new ArrayIndexOutOfBoundsException("Async resource too large to serialize");
                Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"registerParticipant", this.getClass().getName(), arrayIndexOutOfBoundsException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerParticipant", arrayIndexOutOfBoundsException);
                }
                throw new SystemException(arrayIndexOutOfBoundsException.toString());
            }
            TransactionMessagePipe transactionMessagePipe = null;
            TransactionMessagePipe transactionMessagePipe2 = null;
            try {
                transactionMessagePipe2 = new TransactionMessagePipe(20, byArray);
                this.populateMessagePipe(transactionMessagePipe2);
                try {
                    transactionMessagePipe = NativeGlobalTransactionContext.processTmp(transactionMessagePipe2, true);
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"registerParticipant", this.getClass().getName(), throwable});
                }
                if (transactionMessagePipe.getExceptionCode() == 0) break block16;
                try {
                    NativeGlobalTransactionContext.processTmpException(transactionMessagePipe);
                }
                catch (Throwable throwable) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "registerParticipant", throwable);
                    }
                    if (throwable instanceof SystemException) {
                        throw (SystemException)throwable;
                    }
                    throw new SystemException(throwable.toString());
                }
            }
            finally {
                if (transactionMessagePipe2 != null && transactionMessagePipe2.getBackingBuffer() != null) {
                    _poolMgr.returnBufferToPool(transactionMessagePipe2.getBackingBuffer());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerParticipant");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decrementWSATCount() throws SystemException {
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "decrementWSATCount");
            }
            if (this._deferredExpressionOfInterest) {
                IllegalStateException illegalStateException = new IllegalStateException("decrementWSATCount detected deferred expression of interest");
                Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"decrementWSATCount", this.getClass().getName(), illegalStateException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "decrementWSATCount", illegalStateException);
                }
                throw new SystemException(illegalStateException.toString());
            }
            TransactionMessagePipe transactionMessagePipe = null;
            TransactionMessagePipe transactionMessagePipe2 = null;
            try {
                transactionMessagePipe2 = new TransactionMessagePipe(23, null);
                this.populateMessagePipe(transactionMessagePipe2);
                try {
                    transactionMessagePipe = NativeGlobalTransactionContext.processTmp(transactionMessagePipe2, true);
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"logXAInterestData", this.getClass().getName(), throwable});
                }
                if (transactionMessagePipe.getExceptionCode() == 0) break block14;
                try {
                    NativeGlobalTransactionContext.processTmpException(transactionMessagePipe);
                }
                catch (Throwable throwable) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "decrementWSATCount", throwable);
                    }
                    if (throwable instanceof SystemException) {
                        throw (SystemException)throwable;
                    }
                    throw new SystemException(throwable.toString());
                }
            }
            finally {
                if (transactionMessagePipe2 != null && transactionMessagePipe2.getBackingBuffer() != null) {
                    _poolMgr.returnBufferToPool(transactionMessagePipe2.getBackingBuffer());
                }
                NativeJDBCDriverHelper.threadSwitch();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "decrementWSATCount");
        }
    }

    private void populateMessagePipe(TransactionMessagePipe transactionMessagePipe) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "populateMessagePipe");
        }
        byte[] byArray = this.getContextToken();
        byte[] byArray2 = this.getNativeTranID();
        transactionMessagePipe.setContextToken(byArray);
        transactionMessagePipe.setGtid(byArray2);
        if (this._deferredExpressionOfInterest) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Un-defer request");
            }
            transactionMessagePipe.setExpressInterestFlag();
            if (this._jcaBqual != null) {
                transactionMessagePipe.setJcaInitiatedTransactionFlag();
                transactionMessagePipe.setJCAInboundBqual(this._jcaBqual);
                transactionMessagePipe.setJCAInboundFormatId(this._jcaFid);
                transactionMessagePipe.setNewJCABqual(this._nativeXid.getBranchQualifier());
            }
            int n = this._tx.getTimeout();
            int n2 = (int)((this._tx.getExpirationTime() - System.currentTimeMillis()) / 1000L);
            if (n2 < 0) {
                n2 = 0;
            }
            transactionMessagePipe.setInitialTimeout(n);
            transactionMessagePipe.setTimeout(n2);
            this._deferredExpressionOfInterest = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "populateMessagePipe");
        }
    }
}

