/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.nio.ByteBuffer;

public final class NativeServerInstanceData {
    private static final TraceComponent tc = Tr.register(NativeServerInstanceData.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int FLAGS_OFFSET = 72;
    private static final int SEQUENCE_NUMBER_OFFSET = 76;
    private static final int EPOCH_NUMBER_OFFSET = 80;
    private static final int RESTART_EPOCH_OFFSET = 84;
    private static final int DEFAULT_TIMEOUT_OFFSET = 88;
    private static final int MAXIMUM_TIMEOUT_OFFSET = 92;
    private static final int ORB_GIOP_VERSION_OFFSET = 104;
    private static final int ORB_FLAGS_OFFSET = 106;
    private static final int START_WITH_RECOVERY_OPTION_MASK = 32;
    private static final int RECOVERY_COMPLETE_MASK = 0x20000000;
    private static int RM_TOKEN_OFFSET = 0;
    private static final int RM_TOKEN_LENGTH = 16;
    private static int STOKEN_OFFSET = 0;
    private static final int STOKEN_LENGTH = 8;
    private static int CRUUID_OFFSET = 0;
    private static final int CRUUID_LENGTH = 20;
    private static int RPCX_OFFSET = 0;
    private static int RECOVERY_STOKEN_OFFSET = 0;
    private static int BOAM_JTS_FLAGS_OFFSET = 0;
    private static final byte CLEAN_SHUTDOWN_MASK = -128;
    private static ByteBuffer _sid = null;
    private static ByteBuffer _bacb = null;
    private static ByteBuffer _crpc = null;
    private static ByteBuffer _boam = null;
    private static int _recoveryTimeout = 0;

    private NativeServerInstanceData() {
    }

    public static int getFlags() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFlags");
        }
        int n = _sid.getInt(72);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFlags", new Integer(n));
        }
        return n;
    }

    private static void setFlags(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFlags", new Integer(n));
        }
        _sid.putInt(72, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFlags");
        }
    }

    public static boolean getRecoveryComplete() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoveryComplete");
        }
        boolean bl = false;
        if (_sid != null) {
            int n = NativeServerInstanceData.getFlags();
            boolean bl2 = bl = (n & 0x20000000) > 0;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoveryComplete", new Boolean(bl));
        }
        return bl;
    }

    public static void setRecoveryComplete(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRecoveryComplete", new Boolean(bl));
        }
        if (_sid != null) {
            int n = NativeServerInstanceData.getFlags();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Flags before operation", Integer.toHexString(n));
            }
            n = bl ? (n |= 0x20000000) : (n &= 0xDFFFFFFF);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Flags after operation", Integer.toHexString(n));
            }
            NativeServerInstanceData.setFlags(n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRecoveryComplete");
        }
    }

    public static int getSequenceNumber() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSequenceNumber");
        }
        int n = _sid.getInt(76);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSequenceNumber", new Integer(n));
        }
        return n;
    }

    static void setSequenceNumber(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSequenceNumber", new Integer(n));
        }
        if (!NativeServerInstanceData.isControllerJvm()) {
            throw new UnsupportedOperationException("setSequenceNumber");
        }
        _sid.putInt(76, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSequenceNumber");
        }
    }

    public static int getEpochNumber() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEpochNumber");
        }
        int n = _sid.getInt(80);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEpochNumber", new Integer(n));
        }
        return n;
    }

    static void setEpochNumber(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setEpochNumber", new Integer(n));
        }
        if (!NativeServerInstanceData.isControllerJvm()) {
            throw new UnsupportedOperationException("setEpochNumber");
        }
        _sid.putInt(80, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setEpochNumber");
        }
    }

    public static int getRestartEpoch() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRestartEpoch");
        }
        int n = _sid.getInt(84);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRestartEpoch", new Integer(n));
        }
        return n;
    }

    static void setRestartEpoch(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setRestartEpoch", new Integer(n));
        }
        if (!NativeServerInstanceData.isControllerJvm()) {
            throw new UnsupportedOperationException("setRestartEpoch");
        }
        _sid.putInt(84, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setRestartEpoch");
        }
    }

    public static int getDefaultTransactionTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDefaultTransactionTimeout");
        }
        int n = _sid.getInt(88);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDefaultTransactionTimeout", new Integer(n));
        }
        return n;
    }

    public static void setDefaultTransactionTimeout(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDefaultTransactionTimeout", new Integer(n));
        }
        _sid.putInt(88, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDefaultTransactionTimeout");
        }
    }

    public static int getMaximumTransactionTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaximumTransactionTimeout");
        }
        int n = _sid.getInt(92);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaximumTransactionTimeout", new Integer(n));
        }
        return n;
    }

    public static void setMaximumTransactionTimeout(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMaximumTransactionTimeout", new Integer(n));
        }
        _sid.putInt(92, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMaximumTransactionTimeout");
        }
    }

    public static byte[] getResourceManagerToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceManagerToken");
        }
        byte[] byArray = new byte[16];
        for (int i = 0; i < 16; ++i) {
            byArray[i] = _bacb.get(RM_TOKEN_OFFSET + i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceManagerToken", byArray);
        }
        return byArray;
    }

    public static byte[] getStoken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStoken");
        }
        byte[] byArray = PlatformHelperFactory.getPlatformHelper().getStoken();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStoken", byArray);
        }
        return byArray;
    }

    public static byte[] getCRUUID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCRUUID");
        }
        byte[] byArray = new byte[20];
        for (int i = 0; i < 20; ++i) {
            byArray[i] = _bacb.get(CRUUID_OFFSET + i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCRUUID", byArray);
        }
        return byArray;
    }

    public static int getRRSExitInfo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRRSExitInfo", _crpc);
        }
        int n = _crpc.getInt(RPCX_OFFSET);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRRSExitInfo", new Integer(n));
        }
        return n;
    }

    public static byte[] getRecoveryServantStoken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRecoveryServantStoken");
        }
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = _boam.get(RECOVERY_STOKEN_OFFSET + i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRecoveryServantStoken", byArray);
        }
        return byArray;
    }

    public static int getTransactionRecoveryTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransactionRecoveryTimeout");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransactionRecoveryTimeout", new Integer(_recoveryTimeout));
        }
        return _recoveryTimeout;
    }

    private static boolean isControllerJvm() {
        PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
        return platformHelper != null && platformHelper.isZOS() && platformHelper.isControlJvm();
    }

    public static boolean isRestartWithRecoveryOptionEnabled() {
        byte by;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRestartWithRecoveryOptionEnabled");
        }
        boolean bl = false;
        if (_sid != null && ((by = NativeServerInstanceData.getORBFlags()) & 0x20) == 32) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRestartWithRecoveryOptionEnabled", new Boolean(bl));
        }
        return bl;
    }

    public static byte getORBFlags() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getORBFlags");
        }
        byte by = _sid.get(106);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getORBFlags", new Byte(by));
        }
        return by;
    }

    public static void setCleanShutdown() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "setCleanShutdown");
        }
        NativeServerInstanceData.setBoamFlag((byte)-128);
    }

    public static boolean getCleanShutdown() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getCleanShutdown");
        }
        return NativeServerInstanceData.getBoamFlag((byte)-128);
    }

    private static final synchronized void setBoamFlag(byte by) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setBoamFlag", new Byte(by));
        }
        if (_boam != null) {
            byte by2 = _boam.get(BOAM_JTS_FLAGS_OFFSET);
            boolean bl = tc.isDebugEnabled();
            if (bl) {
                Tr.debug(tc, "Flags before operation", Integer.toHexString(by2));
            }
            by2 = (byte)(by2 | by);
            if (bl) {
                Tr.debug(tc, "Flags after operation", Integer.toHexString(by2));
            }
            _boam.put(BOAM_JTS_FLAGS_OFFSET, by2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setBoamFlag");
        }
    }

    private static final synchronized boolean getBoamFlag(byte by) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBoamFlag", new Byte(by));
        }
        boolean bl = false;
        if (_boam != null) {
            byte by2 = _boam.get(BOAM_JTS_FLAGS_OFFSET);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Flags", Integer.toHexString(by2));
            }
            boolean bl2 = bl = (by2 & by) == by;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBoamFlag", new Boolean(bl));
        }
        return bl;
    }
}

