/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws390.tx.NativeServerInstanceData;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.TransactionByteBufferPoolManager;
import com.ibm.ws390.tx.TransactionMessagePipe;
import com.ibm.zosrrs.EndReturnType;
import com.ibm.zosrrs.RRS;
import java.nio.ByteBuffer;
import javax.transaction.HeuristicMixedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

public abstract class NativeTransactionContext {
    private static final TraceComponent tc = Tr.register(NativeTransactionContext.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    protected static byte[] _currentStoken = null;
    protected static byte[] _serverUUID = null;
    protected static Long _restartEpoch = null;
    protected static byte[] _wsTxPortData = null;
    private byte[] _contextToken;
    private boolean _suspended;
    private byte[] _bbootti = null;
    private boolean _urEnded = false;
    private static final TransactionByteBufferPoolManager _poolMgr = TransactionByteBufferPoolManager.instance();

    protected NativeTransactionContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public abstract byte[] getNativeTranID();

    public final void suspend() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "suspend");
        }
        if (this._bbootti != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Already suspended", this._bbootti);
            }
            throw new IllegalStateException("Context is already suspended");
        }
        if (this.isSuspended()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Already suspended");
            }
            throw new IllegalStateException("Context is already suspended");
        }
        this._bbootti = NativeTransactionContext.suspend_tti();
        this.setSuspended(true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "suspend");
        }
    }

    private static final native byte[] suspend_tti();

    public final void resume() throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resume");
        }
        if (this._bbootti == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Transaction is not suspended", this._contextToken);
            }
            throw new IllegalStateException("Context is not currently suspended");
        }
        if (!this.isSuspended()) {
            throw new IllegalStateException("Context is not currently suspended");
        }
        byte[] byArray = this.getNativeTranID();
        NativeTransactionContext.resume_tti(this._bbootti, byArray);
        this._bbootti = null;
        this.setSuspended(false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resume");
        }
    }

    final void connectGtidToORBR() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "connectGtidToORBR");
        }
        if (this._bbootti != null) {
            throw new IllegalStateException("Cannot connect to ORBR: Context is currently suspended");
        }
        byte[] byArray = this.getNativeTranID();
        NativeTransactionContext.resume_tti(null, byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "connectGtidToORBR");
        }
    }

    private static final native void resume_tti(byte[] var0, byte[] var1);

    public final boolean hasInterests() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasInterests");
        }
        boolean bl = NativeTransactionContext.hasInterests(this._contextToken);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasInterests", new Boolean(bl));
        }
        return bl;
    }

    private static final native boolean hasInterests(byte[] var0);

    public final boolean isSuspended() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isSuspended");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isSuspended", new Boolean(this._suspended));
        }
        return this._suspended;
    }

    protected final void setSuspended(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSuspended", new Boolean(bl));
        }
        this._suspended = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSuspended");
        }
    }

    protected final void setTaskTransactionInfo(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTaskTransactionInfo", byArray);
        }
        this._bbootti = byArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTaskTransactionInfo");
        }
    }

    public final boolean isActive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isActive");
        }
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isActive", new Boolean(bl));
        }
        return bl;
    }

    public final byte[] getContextToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextToken");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextToken", this._contextToken);
        }
        return Util.duplicateByteArray(this._contextToken);
    }

    protected final void setContextToken(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setContextToken", byArray);
        }
        this._contextToken = byArray;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setContextToken");
        }
    }

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract boolean isLocal();

    public static final byte[] getCurrentStoken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCurrentStoken");
        }
        if (_currentStoken == null) {
            byte[] byArray = NativeServerInstanceData.getStoken();
            _currentStoken = byArray;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCurrentStoken", _currentStoken);
        }
        return _currentStoken;
    }

    public static final byte[] getServerUUID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getServerUUID");
        }
        if (_serverUUID == null) {
            byte[] byArray = NativeServerInstanceData.getCRUUID();
            _serverUUID = byArray;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServerUUID", _serverUUID);
        }
        return _serverUUID;
    }

    public static final long getRestartEpoch() {
        long l;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRestartEpoch");
        }
        if (_restartEpoch == null) {
            l = NativeServerInstanceData.getRestartEpoch();
            _restartEpoch = new Long(l);
        } else {
            l = _restartEpoch;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRestartEpoch", new Long(l));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] getWsTxPortData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWsTxPortData");
        }
        if (_wsTxPortData == null) {
            TransactionMessagePipe transactionMessagePipe = null;
            try {
                transactionMessagePipe = new TransactionMessagePipe(21, null);
                try {
                    TransactionMessagePipe transactionMessagePipe2 = NativeTransactionContext.processTmp(transactionMessagePipe);
                    _wsTxPortData = transactionMessagePipe2.getVariableData();
                }
                catch (Throwable throwable) {
                    Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"getWsTxPortData", "com.ibm.ws390.tx.NativeTransactionContext", throwable});
                }
            }
            finally {
                if (transactionMessagePipe != null && transactionMessagePipe.getBackingBuffer() != null) {
                    _poolMgr.returnBufferToPool(transactionMessagePipe.getBackingBuffer());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWsTxPortData", _wsTxPortData);
        }
        return _wsTxPortData;
    }

    static final TransactionMessagePipe processTmp(TransactionMessagePipe transactionMessagePipe) throws SystemException, HeuristicMixedException, RollbackException {
        return NativeTransactionContext.processTmp(transactionMessagePipe, false);
    }

    static final TransactionMessagePipe processTmp(TransactionMessagePipe transactionMessagePipe, boolean bl) throws SystemException, HeuristicMixedException, RollbackException {
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2;
        TransactionMessagePipe transactionMessagePipe2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTmp", transactionMessagePipe);
        }
        if ((transactionMessagePipe2 = new TransactionMessagePipe(byteBuffer2 = NativeTransactionContext.processTmp(byteBuffer = transactionMessagePipe.getBackingBuffer()))).getExceptionCode() != 0 && !bl) {
            NativeTransactionContext.processTmpException(byteBuffer2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTmp", transactionMessagePipe2);
        }
        return transactionMessagePipe2;
    }

    static final void processTmpException(TransactionMessagePipe transactionMessagePipe) throws SystemException, HeuristicMixedException, RollbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processTmpException", transactionMessagePipe);
        }
        if (transactionMessagePipe.getExceptionCode() != 0) {
            ByteBuffer byteBuffer = transactionMessagePipe.getBackingBuffer();
            NativeTransactionContext.processTmpException(byteBuffer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processTmpException", transactionMessagePipe);
        }
    }

    final boolean isEnded() {
        return this._urEnded;
    }

    public static final boolean isCurrentContextClean() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCurrentContextClean");
        }
        boolean bl = NativeTransactionContext.isCurrentContextCleanNative();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCurrentContextClean", new Boolean(bl));
        }
        return bl;
    }

    private static native boolean isCurrentContextCleanNative();

    protected final void endCurrentUR(byte[] byArray, boolean bl) throws HeuristicMixedException, RollbackException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endCurrentUR", new Object[]{byArray, new Boolean(bl)});
        }
        boolean bl2 = this.isLocal();
        if (byArray == null && !bl2) {
            throw new IllegalStateException("UR token cannot be null for global tx");
        }
        byte[] byArray2 = NativeTransactionContext.getCurrentContextToken();
        int n = bl ? 1 : 2;
        EndReturnType endReturnType = RRS.end((int)n, (byte[])byArray);
        int n2 = endReturnType.getReturnCode();
        switch (n2) {
            case 0: {
                break;
            }
            case 101: {
                if (bl || bl2) break;
                throw new HeuristicMixedException();
            }
            case 300: 
            case 301: {
                if (!bl || bl2) break;
                throw new RollbackException();
            }
            case 102: 
            case 302: {
                if (bl2) break;
                throw new HeuristicMixedException();
            }
            case 3840: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATREND", new Integer(n2)});
                RasHelper.exit(-910026547, true);
                break;
            }
            case 200: {
                this.endCurrentUR(byArray, false);
                throw new RollbackException();
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATREND", new Integer(n2)});
                RasHelper.exit(-910026546, true);
            }
        }
        this._urEnded = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endCurrentUR", new Object[]{byArray, new Boolean(bl)});
        }
    }

    static long allocateSequence() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "allocateSequence");
        }
        long l = NativeTransactionContext.getNewSequence();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "allocateSequence", new Long(l));
        }
        return l;
    }

    protected static final void reportTranEnd(boolean bl) {
        NativeTransactionContext.reportSMF(false, bl);
    }

    protected static final native void reportSMF(boolean var0, boolean var1);

    private static final native ByteBuffer processTmp(ByteBuffer var0);

    private static final native void processTmpException(ByteBuffer var0) throws SystemException, HeuristicMixedException, RollbackException;

    protected static final native byte[] getCurrentContextToken();

    private static final native long getNewSequence();
}

