/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.tx.ExitHandler;
import com.ibm.ws390.tx.TransactionByteBufferPoolManager;
import java.nio.ByteBuffer;

public final class NonPersistentInterestData {
    private static final TraceComponent tc = Tr.register(NonPersistentInterestData.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int PRE_PREPARE_OFFSET = 0;
    private static final int STATE_CHECK_OFFSET = 4;
    private static final int PREPARE_OFFSET = 8;
    private static final int COMMIT_OFFSET = 12;
    private static final int BACKOUT_OFFSET = 16;
    private static final int ENDUR_OFFSET = 20;
    private static final int ONLY_AGENT_OFFSET = 24;
    private static final int PRE_PREPARE_SET_OFFSET = 28;
    private static final int STATE_CHECK_SET_OFFSET = 29;
    private static final int PREPARE_SET_OFFSET = 30;
    private static final int COMMIT_SET_OFFSET = 31;
    private static final int BACKOUT_SET_OFFSET = 32;
    private static final int ENDUR_SET_OFFSET = 33;
    private static final int ONLY_AGENT_SET_OFFSET = 34;
    private static final int EXIT_NUMBER_OFFSET = 44;
    private static final int EXIT_FLAGS_OFFSET = 128;
    private static final int FRONTEND_LENGTH = 152;
    private ByteBuffer _buffer;
    private ExitHandler _handler;
    private boolean _redrive;
    private byte[] _bytes;
    private TransactionByteBufferPoolManager _poolMgr = TransactionByteBufferPoolManager.instance();

    NonPersistentInterestData(ExitHandler exitHandler) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", exitHandler);
        }
        this._redrive = false;
        this._handler = exitHandler;
        this._bytes = null;
        this._buffer = this._poolMgr.allocateDirect(152);
        this._poolMgr.clearByteBuffer(this._buffer);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    void preReplyPrePrepare(int n) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "preReplyPrePrepare", new Integer(n));
        }
        this._buffer.putInt(0, n);
        this._buffer.put(28, (byte)1);
    }

    void preReplyStateCheck(int n) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "preReplyStateCheck", new Integer(n));
        }
        this._buffer.putInt(4, n);
        this._buffer.put(29, (byte)1);
    }

    void preReplyPrepare(int n) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "preReplyPrepare", new Integer(n));
        }
        this._buffer.putInt(8, n);
        this._buffer.put(30, (byte)1);
    }

    void preReplyCommit(int n) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "preReplyCommit", new Integer(n));
        }
        this._buffer.putInt(12, n);
        this._buffer.put(31, (byte)1);
    }

    void preReplyBackout(int n) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "preReplyBackout", new Integer(n));
        }
        this._buffer.putInt(16, n);
        this._buffer.put(32, (byte)1);
    }

    void preReplyEndUR(int n) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "preReplyEndUR", new Integer(n));
        }
        this._buffer.putInt(20, n);
        this._buffer.put(33, (byte)1);
    }

    void preReplyOnlyAgent(int n) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "preReplyOnlyAgent", new Integer(n));
        }
        this._buffer.putInt(24, n);
        this._buffer.put(34, (byte)1);
    }

    int getLastExit() {
        return this._buffer.getInt(44);
    }

    boolean exitFailed() {
        return this._redrive;
    }

    boolean isCascaded() {
        int n = this._buffer.getInt(128);
        if (tc.isEventEnabled()) {
            Tr.event(tc, "isCascaded", Integer.toHexString(n));
        }
        return (n & 0x100000) != 0;
    }

    void markFailed(boolean bl) {
        this._redrive = bl;
    }

    synchronized byte[] toBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toBytes");
        }
        if (this._bytes == null) {
            this._bytes = this.convertToByteArray(this._handler, this._buffer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toBytes", this._bytes);
        }
        return this._bytes;
    }

    synchronized void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy", this);
        }
        if (this._bytes != null) {
            ByteBuffer byteBuffer = this._poolMgr.allocateDirect(this._bytes.length);
            byteBuffer.put(this._bytes);
            this.freeData(byteBuffer);
            this._bytes = null;
            this._poolMgr.returnBufferToPool(byteBuffer);
        }
        if (this._buffer != null) {
            this._poolMgr.returnBufferToPool(this._buffer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy");
        }
    }

    private native byte[] convertToByteArray(ExitHandler var1, ByteBuffer var2);

    private native void freeData(ByteBuffer var1);
}

