/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.CDROutputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws390.tx.AsyncSyncpointIndicators;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.ExitHandler;
import com.ibm.ws390.tx.NonPersistentInterestData;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.ResourceManager;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionalUnitOfWork;
import com.ibm.ws390.tx.VariableLengthPDataElement;
import com.ibm.ws390.tx.rrs.ExpressInterestReturnType;
import com.ibm.ws390.tx.rrs.RRS;
import com.ibm.ws390.tx.rrs.RetrieveSideInformationReturnType;
import com.ibm.ws390.tx.rrs.RetrieveURDataReturnType;
import com.ibm.ws390.tx.rrs.RetrieveURInterestReturnType;
import com.ibm.ws390.tx.rrs.RetrieveWorkIdentifierReturnType;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.portable.InputStream;

abstract class PersistentInterestData
implements ExitHandler {
    private static final TraceComponent tc = Tr.register(PersistentInterestData.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final byte[] SECTION_EYECATCHER = new byte[]{-62, -62, -42, -29, -39, -41, -30, -56};
    public static final byte UNKNOWN_INTEREST_TYPE = -1;
    public static final byte SYNCPOINT_INTEREST_TYPE = 1;
    public static final byte RESOURCE_INTEREST_TYPE = 2;
    public static final byte ASYNC_RESOURCE_INTEREST_TYPE = 3;
    public static final byte MAX_INTEREST_TYPE = 127;
    public static final int HEADER_LENGTH = 16;
    public static final int PRIMARY_KEY_LENGTH = 36;
    private static final int EYECATCHER_OFFSET = 0;
    private static final int LENGTH_OFFSET = 8;
    private static final int TYPE_OFFSET = 12;
    private static final int VERSION_OFFSET = 13;
    private byte _type;
    private byte _originalVersion;
    private byte[] _pdataHeader;
    private byte[] _cachedPdataBuffer;
    private boolean _isBufferDirty;
    private TransactionalUnitOfWork _uow;
    private byte[] _uriToken;
    private boolean _isNormal;
    protected NonPersistentInterestData _npdata;

    PersistentInterestData(byte by, TransactionalUnitOfWork transactionalUnitOfWork) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new java.lang.Object[]{new Integer(by), transactionalUnitOfWork});
        }
        this._type = by;
        this._originalVersion = this.getCurrentVersion();
        this._pdataHeader = new byte[16];
        System.arraycopy(SECTION_EYECATCHER, 0, this._pdataHeader, 0, SECTION_EYECATCHER.length);
        Util.setBytesFromInt(this._pdataHeader, 8, 4, 16);
        this._pdataHeader[12] = by;
        this._pdataHeader[13] = this.getCurrentVersion();
        this._cachedPdataBuffer = null;
        this._isBufferDirty = true;
        this._uow = transactionalUnitOfWork;
        this._uriToken = null;
        this._isNormal = true;
        this._npdata = new NonPersistentInterestData(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    PersistentInterestData(RetrieveURInterestReturnType retrieveURInterestReturnType, TransactionalUnitOfWork transactionalUnitOfWork) {
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new java.lang.Object[]{retrieveURInterestReturnType, transactionalUnitOfWork});
        }
        if ((byArray = retrieveURInterestReturnType.getPdata()) == null || byArray.length < 16) {
            throw new IllegalArgumentException("pdata invalid");
        }
        this._pdataHeader = new byte[16];
        System.arraycopy(byArray, 0, this._pdataHeader, 0, 16);
        this._type = this._pdataHeader[12];
        this._originalVersion = this._pdataHeader[13];
        this._pdataHeader[13] = this.getCurrentVersion();
        this._cachedPdataBuffer = null;
        this._isBufferDirty = true;
        this._uow = transactionalUnitOfWork;
        this._uriToken = retrieveURInterestReturnType.getUriToken();
        this._isNormal = false;
        this._npdata = new NonPersistentInterestData(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public byte getType() {
        return this._type;
    }

    static byte getType(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getType", byArray);
        }
        byte by = -1;
        if (byArray != null && byArray.length >= 16) {
            by = byArray[12];
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getType", new Byte(by));
        }
        return by;
    }

    public byte getOriginalVersion() {
        return this._originalVersion;
    }

    XidImpl getWorkIdentifier() {
        return PersistentInterestData.getWorkIdentifier(this._uriToken);
    }

    static XidImpl getWorkIdentifier(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkIdentifier", byArray);
        }
        RetrieveWorkIdentifierReturnType retrieveWorkIdentifierReturnType = RRS.retrieveWorkIdentifier(byArray);
        XidImpl xidImpl = null;
        switch (retrieveWorkIdentifierReturnType.getReturnCode()) {
            case 0: {
                xidImpl = retrieveWorkIdentifierReturnType.getXid();
                break;
            }
            case 1794: 
            case 3840: {
                RasHelper.exit(-910026662, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRRWID", new Integer(retrieveWorkIdentifierReturnType.getReturnCode())});
                RasHelper.exit(-910026661, false);
            }
        }
        return xidImpl;
    }

    boolean getHeuristicMixedIndicator() {
        return PersistentInterestData.getHeuristicMixedIndicator(this._uriToken);
    }

    static boolean getHeuristicMixedIndicator(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHeuristicMixedIndicator", byArray);
        }
        boolean bl = false;
        int[] nArray = new int[]{0};
        RetrieveSideInformationReturnType retrieveSideInformationReturnType = RRS.retrieveSideInformation(byArray, nArray);
        switch (retrieveSideInformationReturnType.getReturnCode()) {
            case 0: {
                bl = retrieveSideInformationReturnType.getSideInfo(0) != 0;
                break;
            }
            case 1794: 
            case 3840: {
                RasHelper.exit(-910026662, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRRUSI2", new Integer(retrieveSideInformationReturnType.getReturnCode())});
                RasHelper.exit(-910026653, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHeuristicMixedIndicator", new Boolean(bl));
        }
        return bl;
    }

    boolean isUriTokenValid() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isUriTokenValid");
        }
        boolean bl = true;
        int[] nArray = new int[]{0};
        RetrieveSideInformationReturnType retrieveSideInformationReturnType = RRS.retrieveSideInformation(this._uriToken, nArray);
        switch (retrieveSideInformationReturnType.getReturnCode()) {
            case 0: {
                break;
            }
            case 880: 
            case 931: {
                bl = false;
                break;
            }
            case 1794: 
            case 3840: {
                RasHelper.exit(-910026662, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRRUSI2", Integer.toHexString(retrieveSideInformationReturnType.getReturnCode())});
                RasHelper.exit(-910026182, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isUriTokenValid", new Boolean(bl));
        }
        return bl;
    }

    void setHeuristicMixedIndicator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHeuristicMixedIndicator");
        }
        int[] nArray = new int[]{0};
        int n = RRS.setSideInformation(this._uriToken, nArray);
        switch (n) {
            case 0: {
                break;
            }
            case 1794: 
            case 3840: {
                RasHelper.exit(-910026662, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRSUSI", new Integer(n)});
                RasHelper.exit(-910026654, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHeuristicMixedIndicator");
        }
    }

    int getState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getState");
        }
        int n = 0;
        RetrieveURDataReturnType retrieveURDataReturnType = RRS.retrieveURData(this._uriToken, 1);
        int n2 = retrieveURDataReturnType.getReturnCode();
        switch (n2) {
            case 0: {
                n = retrieveURDataReturnType.getState();
                break;
            }
            case 1794: 
            case 3840: {
                RasHelper.exit(-910026662, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{new String("ATRRURD"), Integer.toHexString(n2)});
                RasHelper.exit(-910026656, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getState", new Integer(n));
        }
        return n;
    }

    protected byte[] generateHeader() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateHeader");
        }
        int n = 16 + this.getDerivedSize();
        byte[] byArray = new byte[n];
        Util.setBytesFromInt(this._pdataHeader, 8, 4, n);
        System.arraycopy(this._pdataHeader, 0, byArray, 0, 16);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateHeader", byArray);
        }
        return byArray;
    }

    protected VariableLengthPDataElement[] getVariableLengthData(byte[] byArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariableLengthData", new java.lang.Object[]{byArray, new Integer(n)});
        }
        if (byArray == null || byArray.length < n) {
            throw new IllegalArgumentException("VarData is bad");
        }
        int n2 = Util.getIntFromBytes(byArray, n, 4);
        VariableLengthPDataElement[] variableLengthPDataElementArray = null;
        if (n2 > 0) {
            variableLengthPDataElementArray = new VariableLengthPDataElement[n2];
            int n3 = n + 4;
            for (int i = 0; i < n2; ++i) {
                int n4 = Util.getIntFromBytes(byArray, n3, 4);
                int n5 = Util.getIntFromBytes(byArray, n3 += 4, 4);
                byte[] byArray2 = new byte[n5];
                System.arraycopy(byArray, n3 += 4, byArray2, 0, n5);
                n3 += n5;
                n3 += this.calcPadding(n5);
                variableLengthPDataElementArray[i] = new VariableLengthPDataElement(n4, byArray2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVariableLengthData", variableLengthPDataElementArray);
        }
        return variableLengthPDataElementArray;
    }

    public final int getDerivedSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDerivedSize");
        }
        if (this._isBufferDirty) {
            this._cachedPdataBuffer = this.getDerivedData();
            this._isBufferDirty = false;
        }
        int n = 0;
        if (this._cachedPdataBuffer != null) {
            n = this._cachedPdataBuffer.length;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDerivedSize", new Integer(n));
        }
        return n;
    }

    public byte[] generateData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "generateData");
        }
        byte[] byArray = this.generateHeader();
        byte[] byArray2 = null;
        if (this._isBufferDirty) {
            byArray2 = this.getDerivedData();
            this._cachedPdataBuffer = byArray2;
            this._isBufferDirty = false;
        } else {
            byArray2 = this._cachedPdataBuffer;
        }
        if (byArray == null || byArray2 == null || byArray.length != byArray2.length + 16) {
            throw new INTERNAL("Computed PIData size does not match actual", -910026176, CompletionStatus.COMPLETED_NO);
        }
        if (byArray.length > 4096) {
            throw new INTERNAL("Computed PIData size " + byArray.length + " is too big", -910026175, CompletionStatus.COMPLETED_NO);
        }
        System.arraycopy(byArray2, 0, byArray, 16, byArray2.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateData", byArray);
        }
        return byArray;
    }

    int logPersistentInterestData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logPersistentInterestData");
        }
        byte[] byArray = this.generateData();
        int n = RRS.setPersistentInterestData(this._uriToken, byArray);
        switch (n) {
            case 0: {
                break;
            }
            case 1841: {
                TransactionControlRep transactionControlRep = this._uow.getControl();
                int n2 = transactionControlRep.getState();
                AsyncSyncpointIndicators asyncSyncpointIndicators = new AsyncSyncpointIndicators(this._uriToken);
                if ((n2 == 4 || n2 == 5) && asyncSyncpointIndicators.getApplicationBackout()) {
                    throw new TRANSACTION_ROLLEDBACK("UR State Error -- async backout", -910026616, CompletionStatus.COMPLETED_NO);
                }
                int n3 = this.getState();
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "UR state error", new java.lang.Object[]{new Integer(n2), new Integer(n3), asyncSyncpointIndicators});
                }
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRSPID", Integer.toHexString(n)});
                RasHelper.exit(-910026174, false);
                break;
            }
            case 1794: 
            case 3840: {
                RasHelper.exit(-910026662, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRSPID", new Integer(n)});
                RasHelper.exit(-910026659, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logPersistentInterestData", new Integer(n));
        }
        return n;
    }

    protected final ExpressInterestReturnType expressInterest(int n, XidImpl xidImpl, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expressInterest", new java.lang.Object[]{new Integer(n), xidImpl, byArray});
        }
        ExpressInterestReturnType expressInterestReturnType = null;
        byte[] byArray2 = this._uow.getContextToken();
        byte[] byArray3 = this._npdata.toBytes();
        ResourceManager resourceManager = ControllerTransactionManagerSet.instance().getResourceManager();
        expressInterestReturnType = resourceManager.expressInterest(byArray2, n, byArray3, this, xidImpl, byArray);
        this._uriToken = expressInterestReturnType.getUriToken();
        this._uow.setURID(expressInterestReturnType.getUrid());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expressInterest", expressInterestReturnType);
        }
        return expressInterestReturnType;
    }

    void respond(int n) {
        PersistentInterestData.respond(this._uriToken, n, this._npdata);
    }

    static void respond(byte[] byArray, int n, NonPersistentInterestData nonPersistentInterestData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "respond", new java.lang.Object[]{byArray, new Integer(n), nonPersistentInterestData});
        }
        byte[] byArray2 = null;
        byArray2 = nonPersistentInterestData != null ? nonPersistentInterestData.toBytes() : new byte[16];
        int n2 = RRS.respondToRetrievedInterest(byArray, n, byArray2);
        switch (n2) {
            case 0: {
                break;
            }
            case 1794: 
            case 3840: {
                RasHelper.exit(-910026662, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRIRRI", new Integer(n2)});
                RasHelper.exit(-910026655, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "respond", new java.lang.Object[]{byArray, new Integer(n), nonPersistentInterestData});
        }
    }

    protected final int setSyncpointControls(int n, int n2, int n3, int n4) {
        int n5 = RRS.setSyncpointControls(this._uriToken, n, n2, n3, n4);
        switch (n5) {
            case 0: {
                break;
            }
            case 1794: 
            case 3840: {
                RasHelper.exit(-910026662, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRSSPC", new Integer(n5)});
                RasHelper.exit(-910026652, false);
            }
        }
        return n5;
    }

    protected void setApplComplete(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setApplComplete", new Boolean(bl));
        }
        int[] nArray = new int[]{bl ? 33 : 34};
        int n = RRS.setSideInformation(this._uriToken, nArray);
        switch (n) {
            case 0: {
                break;
            }
            case 1794: 
            case 3840: {
                RasHelper.exit(-910026662, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRSUSI", new Integer(n)});
                RasHelper.exit(-910026654, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setApplComplete");
        }
    }

    public void scheduleRetry() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scheduleRetry");
        }
        if (this._uow != null) {
            this._uow.rescheduleResolverIfRequired(false);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Retry on invalid interest", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scheduleRetry");
        }
    }

    public NonPersistentInterestData getNonPersistentInterestData() {
        return this._npdata;
    }

    public byte[] getURIToken() {
        return this._uriToken;
    }

    public byte[] getURID() {
        byte[] byArray = null;
        if (this._uow != null) {
            byArray = this._uow.getURID();
        }
        return byArray;
    }

    TransactionalUnitOfWork getUnitOfWork() {
        if (!this._isNormal) {
            throw new UnsupportedOperationException("getUnitOfWork not valid for restart interests");
        }
        return this._uow;
    }

    public void setDirty() {
        this._isBufferDirty = true;
    }

    public boolean isNormal() {
        return this._isNormal;
    }

    public int commit() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "commit", this);
        }
        return 0;
    }

    public int backout() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "backout", this);
        }
        return 0;
    }

    public int prePrepare() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "prePrepare", this);
        }
        return 0;
    }

    public int prepare() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "prepare", this);
        }
        return 0;
    }

    public int endUR() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "endUR", this);
        }
        return 0;
    }

    public int stateCheck() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "stateCheck", this);
        }
        return 0;
    }

    public int onlyAgent() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "onlyAgent", this);
        }
        return 0;
    }

    public int calcPadding(int n) {
        return (4 - n % 4) % 4;
    }

    protected byte[] object_to_IOR(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "object_to_IOR", object);
        }
        byte[] byArray = null;
        if (object != null) {
            ORB oRB = GlobalORBFactory.globalORB();
            IOR iOR = oRB.objectToIOR(object);
            CDROutputStream cDROutputStream = ORB.createCDROutputStream((ORB)oRB);
            cDROutputStream.putEndian();
            iOR.write(cDROutputStream);
            byArray = cDROutputStream.toByteArray();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "object_to_IOR", byArray);
        }
        return byArray;
    }

    protected Object IOR_to_object(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "IOR_to_object", byArray);
        }
        Object object = null;
        if (byArray != null) {
            ORB oRB = GlobalORBFactory.globalORB();
            CDRInputStream cDRInputStream = ORB.createCDRInputStream((ORB)oRB, (byte[])byArray, (int)byArray.length);
            IOR iOR = oRB.createIOR();
            cDRInputStream.consumeEndian();
            iOR.read((InputStream)cDRInputStream);
            object = oRB.IORToObject(iOR);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "IOR_to_object", object);
        }
        return object;
    }

    public abstract byte getCurrentVersion();

    public abstract byte[] getDerivedData();
}

