/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.recoverylog.spi.RecoveryDirectorFactory;
import com.ibm.ws.recoverylog.spi.ScalableFailureScope;
import com.ibm.ws.util.PlatformHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.tx.AsyncSyncpointIndicators;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.Enq;
import com.ibm.ws390.tx.LockHierarchy;
import com.ibm.ws390.tx.LockableHashMap;
import com.ibm.ws390.tx.NativeServerInstanceData;
import com.ibm.ws390.tx.PersistentInterestData;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.RestartURData;
import com.ibm.ws390.tx.SyncpointInterest;
import com.ibm.ws390.tx.SyncpointRestartAlarm;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionHARecoveryAlarm;
import com.ibm.ws390.tx.TransactionalUnitOfWork;
import com.ibm.ws390.tx.rrs.ATRRINS;
import com.ibm.ws390.tx.rrs.ExpressInterestReturnType;
import com.ibm.ws390.tx.rrs.RRS;
import com.ibm.ws390.tx.rrs.RetrieveLogNameReturnType;
import com.ibm.ws390.tx.rrs.RetrieveURInterestReturnType;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public final class ResourceManager {
    private static final TraceComponent tc = Tr.register(ResourceManager.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int NUMBER_OF_EXITS = 6;
    private static final String EBCDIC_CODEPAGE = new String("Cp1047");
    private static final byte[] LOGNAME_STRUCT = new byte[]{-62, -62, -42, -29, -59, -43, -42, 75, 0, 0, 0, 0, 0, 0, 0, 0, 75, -55, -62, -44};
    private static final int LOGNAME_EPOCH_OFFSET = 8;
    private static final int LOGNAME_EPOCH_LENGTH = 8;
    private static final int COLD_START_EPOCH = 1;
    private static final int INITIAL_SEQUENCE = 1;
    private byte[] _rmToken;
    private int _restartEpochNumber;
    private String _serverShortName;
    private boolean _coldStart;
    private boolean _coldStartInRecoveryMode;
    private boolean _restartOnlyMode;
    private LockableHashMap _restartMap;
    private int _restartUWCount;
    private boolean _rrsRecoveryComplete;
    private SyncpointRestartAlarm _restartAlarm;
    private boolean _xaRecoveryDriven;
    private boolean _xaRecoveryComplete;

    ResourceManager(byte[] byArray) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byArray);
        }
        this._rmToken = byArray;
        this._restartUWCount = 0;
        this._rrsRecoveryComplete = false;
        this._xaRecoveryComplete = false;
        this._xaRecoveryDriven = false;
        this._coldStartInRecoveryMode = false;
        this._restartOnlyMode = !PlatformHelperFactory.getPlatformHelper().runningWhereConfigured();
        this._restartMap = new LockableHashMap(0, false);
        try {
            object2 = RecoveryDirectorFactory.recoveryDirector();
            object = (ScalableFailureScope)object2.currentFailureScope();
            this._serverShortName = object.serverShortName();
        }
        catch (Throwable throwable) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Could not get server short name", throwable);
            }
            throw new IllegalStateException(throwable);
        }
        this._restartAlarm = new SyncpointRestartAlarm(this);
        object2 = null;
        object = null;
        try {
            object2 = TransactionHARecoveryAlarm.getEnqName(this._serverShortName);
            object = TransactionHARecoveryAlarm.getHAEnqName(this._serverShortName);
        }
        catch (Throwable throwable) {
            RasHelper.exit(-910026189, true);
        }
        Enq enq = Enq.instance();
        int n = enq.obtainExclusive((String)object2, 42);
        ControllerTransactionManagerSet.setMainEnqName((String)object2);
        if (n != 0) {
            RasHelper.exit(-910026392, true);
        }
        if (enq.test((String)object, 42) != 0) {
            Tr.info(tc, "BBOT0027_WAIT_HA_TERM", this._serverShortName);
            while (enq.test((String)object, 42) != 0) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    RasHelper.exit(-910026188, true);
                }
            }
        }
        boolean bl = NativeServerInstanceData.isRestartWithRecoveryOptionEnabled();
        this.setExitInformation();
        byte[] byArray2 = this.retrieveLogname();
        if (byArray2 == null) {
            if (!this._restartOnlyMode) {
                Tr.audit(tc, "BBOT0011_COLD_START_RRS", this._serverShortName);
            } else {
                PlatformHelper platformHelper = PlatformHelperFactory.getPlatformHelper();
                String string = platformHelper.getSystemName();
                String string2 = string.trim();
                String string3 = ControllerTransactionManagerSet.getConfiguredSystemName();
                if (string3 != null && string3.equalsIgnoreCase(string2) && bl) {
                    this._coldStartInRecoveryMode = true;
                    Tr.audit(tc, "BBOT0011_COLD_START_RRS", this._serverShortName);
                } else {
                    RasHelper.exit(-910026539, true);
                }
            }
            byArray2 = this.generateLogname(1);
            this.setLogname(byArray2);
            this._restartEpochNumber = 1;
        } else {
            Tr.audit(tc, "BBOT0012_WARM_START_RRS", this._serverShortName);
            int n2 = 1 + this.extractEpoch(byArray2);
            byArray2 = this.generateLogname(n2);
            this.setLogname(byArray2);
            this._restartEpochNumber = n2;
        }
        NativeServerInstanceData.setEpochNumber(this._restartEpochNumber);
        NativeServerInstanceData.setRestartEpoch(this._restartEpochNumber);
        NativeServerInstanceData.setSequenceNumber(1);
        this.beginRestart();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    int getRestartEpoch() {
        return this._restartEpochNumber;
    }

    ExpressInterestReturnType expressInterest(byte[] byArray, int n, byte[] byArray2, PersistentInterestData persistentInterestData, XidImpl xidImpl, byte[] byArray3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "expressInterest", xidImpl);
        }
        byte[] byArray4 = persistentInterestData.generateData();
        ExpressInterestReturnType expressInterestReturnType = RRS.expressURInterest(this._rmToken, byArray, n, byArray2, byArray4, xidImpl, byArray3);
        int n2 = expressInterestReturnType.getReturnCode();
        switch (n2) {
            case 0: {
                break;
            }
            case 1841: {
                TransactionalUnitOfWork transactionalUnitOfWork = persistentInterestData.getUnitOfWork();
                TransactionControlRep transactionControlRep = transactionalUnitOfWork.getControl();
                int n3 = transactionControlRep.getState();
                AsyncSyncpointIndicators asyncSyncpointIndicators = new AsyncSyncpointIndicators(transactionalUnitOfWork.getURID());
                if (!(n3 != 1 && n3 != 2 && n3 != 3 || !asyncSyncpointIndicators.getApplicationBackout() && !asyncSyncpointIndicators.getTerminatingSyncpoint() && asyncSyncpointIndicators.getSdsrmInitiated())) {
                    throw new TRANSACTION_ROLLEDBACK(-910026614, CompletionStatus.COMPLETED_NO);
                }
                int n4 = transactionalUnitOfWork.getState();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UR State Error", new Object[]{new Integer(n3), new Integer(n4), asyncSyncpointIndicators});
                }
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATREINT5", Integer.toHexString(n2)});
                RasHelper.exit(-910026177, false);
                break;
            }
            case 865: {
                TransactionalUnitOfWork transactionalUnitOfWork = persistentInterestData.getUnitOfWork();
                TransactionControlRep transactionControlRep = transactionalUnitOfWork.getControl();
                if (transactionControlRep.isServantAlive()) {
                    byte[] byArray5 = transactionControlRep.getServantStoken();
                    RasHelper.dump(-910026424, byArray5, byArray, null, null);
                }
                throw new INTERNAL(-910026424, CompletionStatus.COMPLETED_NO);
            }
            case 769: 
            case 1794: 
            case 3840: 
            case 3846: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATREINT5", new Integer(n2)});
                RasHelper.exit(-910026648, true);
                break;
            }
            case 1865: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATREINT5", Integer.toHexString(n2)});
                if (persistentInterestData.getType() == 1) {
                    RasHelper.exit(-910026644, false);
                    break;
                }
                TransactionalUnitOfWork transactionalUnitOfWork = persistentInterestData.getUnitOfWork();
                transactionalUnitOfWork.rollbackOnly();
                throw new TRANSACTION_ROLLEDBACK(-910026614, CompletionStatus.COMPLETED_NO);
            }
            case 922: {
                throw new INTERNAL(-910026161, CompletionStatus.COMPLETED_NO);
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATREINT5", Integer.toHexString(n2)});
                RasHelper.exit(-910026644, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "expressInterest", expressInterestReturnType);
        }
        return expressInterestReturnType;
    }

    byte[] retrieveLogname() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveLogname");
        }
        byte[] byArray = null;
        RetrieveLogNameReturnType retrieveLogNameReturnType = RRS.retrieveLogName(this._rmToken);
        switch (retrieveLogNameReturnType.getReturnCode()) {
            case 0: {
                this._coldStart = false;
                byArray = retrieveLogNameReturnType.getRmLogName();
                break;
            }
            case 6: {
                this._coldStart = true;
                break;
            }
            case 769: 
            case 1794: 
            case 3840: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRIRLN", new Integer(retrieveLogNameReturnType.getReturnCode())});
                RasHelper.exit(-910026648, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRIRLN", new Integer(retrieveLogNameReturnType.getReturnCode())});
                RasHelper.exit(-910026648, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveLogname", byArray);
        }
        return byArray;
    }

    private void setLogname(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLogname", byArray);
        }
        int n = RRS.setLogName(this._rmToken, byArray);
        switch (n) {
            case 0: {
                break;
            }
            case 769: 
            case 1794: 
            case 3840: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRISLN", new Integer(n)});
                RasHelper.exit(-910026648, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRISLN", new Integer(n)});
                RasHelper.exit(-910026649, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLogname", byArray);
        }
    }

    private void setExitInformation() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setExitInformation");
        }
        int n2 = NativeServerInstanceData.getRRSExitInfo();
        ATRRINS aTRRINS = RRS.getInstalledFunction();
        boolean bl = aTRRINS.isPrePrepareSupported();
        int n3 = 6;
        if (!bl) {
            --n3;
        }
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        nArray[0] = 2;
        nArray[1] = 4;
        nArray[2] = 5;
        nArray[3] = 7;
        nArray[4] = 6;
        if (bl) {
            nArray[5] = 11;
        }
        for (n = 0; n < n3; ++n) {
            nArray2[n] = n2;
            nArray3[n] = 2;
        }
        n = RRS.setExitInformation(this._rmToken, 0, 0, RRS.ATR_EXITMGR_NAME, nArray, nArray2, nArray3, 0, 0, 0);
        switch (n) {
            case 0: {
                break;
            }
            case 769: 
            case 1824: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"CRGSEIF", new Integer(n)});
                RasHelper.exit(-910026648, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"CRGSEIF", new Integer(n)});
                RasHelper.exit(-910026647, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setExitInformation");
        }
    }

    int incrementEpoch() {
        int n;
        byte[] byArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "incrementEpoch");
        }
        if ((byArray = this.retrieveLogname()) == null || byArray.length != LOGNAME_STRUCT.length) {
            RasHelper.exit(-910026191, false);
        }
        if ((n = this.extractEpoch(byArray)) == 0) {
            RasHelper.exit(-910026190, false);
        }
        int n2 = n + 1;
        byte[] byArray2 = this.generateLogname(n2);
        this.setLogname(byArray2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "incrementEpoch", new Integer(n2));
        }
        return n2;
    }

    private void beginRestart() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beginRestart");
        }
        Tr.audit(tc, "BBOT0008_RESTART_INIT", this._serverShortName);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        LockHierarchy lockHierarchy = ControllerTransactionManagerSet.instance().getLockHierarchy();
        this.beginRestartRRS();
        do {
            RetrieveURInterestReturnType retrieveURInterestReturnType;
            if ((n6 = (retrieveURInterestReturnType = this.retrieveInterest()).getReturnCode()) == 4) continue;
            ++n;
            ByteArray byteArray = new ByteArray(retrieveURInterestReturnType.getURID());
            RestartURData restartURData = (RestartURData)this._restartMap.get(byteArray, false, lockHierarchy);
            if (restartURData == null) {
                ++n2;
                switch (retrieveURInterestReturnType.getState()) {
                    case 6: {
                        ++n3;
                        break;
                    }
                    case 4: {
                        ++n4;
                        break;
                    }
                    case 5: {
                        ++n5;
                    }
                }
                byte[] byArray = retrieveURInterestReturnType.getUriToken();
                XidImpl xidImpl = PersistentInterestData.getWorkIdentifier(byArray);
                boolean bl = PersistentInterestData.getHeuristicMixedIndicator(byArray);
                restartURData = new RestartURData(xidImpl, bl);
                this._restartMap.put(byteArray, restartURData, false, lockHierarchy);
            }
            restartURData.addInterest(retrieveURInterestReturnType);
        } while (n6 != 4);
        Tr.audit(tc, "BBOT0009_TRAN_COUNT", new Object[]{this._serverShortName, new Integer(n3), new Integer(n4), new Integer(n5)});
        this.endRestartRRS();
        this._restartUWCount = n2;
        if (this._restartMap.size() == 0) {
            this._rrsRecoveryComplete = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beginRestart");
        }
    }

    private void beginRestartRRS() {
        boolean bl = false;
        int n = RRS.beginRestart(this._rmToken);
        switch (n) {
            case 0: {
                break;
            }
            case 769: 
            case 1794: 
            case 3840: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRIBRS", new Integer(n)});
                RasHelper.exit(-910026648, true);
                break;
            }
            case 3841: {
                String[] stringArray = new String[]{this._serverShortName};
                String string = null;
                while ((string = RasHelper.wtorMessage(1, string, false, stringArray)).compareToIgnoreCase("CONTINUE") != 0 && string.compareToIgnoreCase("CANCEL") != 0) {
                }
                if (string.compareToIgnoreCase("CANCEL") != 0) break;
                RasHelper.exit(-910026594, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRIBRS", new Integer(n)});
                RasHelper.exit(-910026646, false);
            }
        }
    }

    private void endRestartRRS() {
        int n = RRS.endRestart(this._rmToken);
        switch (n) {
            case 0: {
                break;
            }
            case 769: 
            case 1794: 
            case 3840: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRIERS", new Integer(n)});
                RasHelper.exit(-910026648, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRIERS", new Integer(n)});
                RasHelper.exit(-910026651, false);
            }
        }
    }

    private RetrieveURInterestReturnType retrieveInterest() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retrieveInterest");
        }
        RetrieveURInterestReturnType retrieveURInterestReturnType = RRS.retrieveURInterest(this._rmToken);
        switch (retrieveURInterestReturnType.getReturnCode()) {
            case 0: 
            case 4: {
                break;
            }
            case 769: 
            case 1794: 
            case 3840: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRIRNI", new Integer(retrieveURInterestReturnType.getReturnCode())});
                RasHelper.exit(-910026648, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRIRNI", new Integer(retrieveURInterestReturnType.getReturnCode())});
                RasHelper.exit(-910026645, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retrieveInterest", retrieveURInterestReturnType);
        }
        return retrieveURInterestReturnType;
    }

    private int extractEpoch(byte[] byArray) {
        int n;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "extractEpoch", byArray);
            }
            n = 0;
            try {
                String string = new String(byArray, EBCDIC_CODEPAGE);
                StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                n = Integer.parseInt(string2, 16);
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) break block4;
                Tr.event(tc, "Could not extract epoch", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractEpoch", new Integer(n));
        }
        return n;
    }

    private byte[] generateLogname(int n) {
        byte[] byArray;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "generateLogname", new Integer(n));
            }
            byArray = null;
            try {
                byArray = new byte[LOGNAME_STRUCT.length];
                System.arraycopy(LOGNAME_STRUCT, 0, byArray, 0, byArray.length);
                String string = Integer.toHexString(n);
                int n2 = string.length();
                StringBuffer stringBuffer = new StringBuffer(8);
                for (int i = n2; i < 8; ++i) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string);
                byte[] byArray2 = stringBuffer.toString().getBytes(EBCDIC_CODEPAGE);
                System.arraycopy(byArray2, 0, byArray, 8, byArray2.length);
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Could not generate new logname", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "generateLogname", byArray);
        }
        return byArray;
    }

    public void restartTranCompleted(byte[] byArray, LockHierarchy lockHierarchy) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restartTranCompleted", byArray);
        }
        if (this._restartOnlyMode) {
            Tr.audit(tc, "BBOT0014_PROCESS_UR_COMPLETE", new Object[]{Util.toHexString(byArray), this._serverShortName});
        }
        this._restartMap.remove(new ByteArray(byArray), lockHierarchy);
        if (this._restartMap.size() == 0) {
            this._rrsRecoveryComplete = true;
            if (this._restartOnlyMode) {
                this.endRestartPhaseOne();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restartTrancompleted");
        }
    }

    public void endRestartPhaseOne() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endRestartPhaseOne");
        }
        if (this._restartMap.size() == 0) {
            if (this._restartOnlyMode) {
                Tr.audit(tc, "BBOT0013_RESTART_ONLY_COMPLETE", this._serverShortName);
                this._restartAlarm.scheduleServerStop();
            }
        } else if (!this._coldStart) {
            Tr.audit(tc, "BBOT0010_RESTART_COMPLETE", this._serverShortName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endRestartPhaseOne");
        }
    }

    public void endRestartPhaseTwo() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "endRestartPhaseTwo");
        }
        if (this._restartOnlyMode) {
            this._restartAlarm.start();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "endRestartPhaseTwo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logUnresolvedTransactions(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "logUnresolvedTransactions", new Boolean(bl));
        }
        int n = 0;
        ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
        LockHierarchy lockHierarchy = controllerTransactionManagerSet.getLockHierarchy();
        this.getRestartMapLock(lockHierarchy);
        try {
            Iterator iterator = this.getRestartURs();
            if (this._restartMap.size() == 0) {
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "Restart map empty");
                }
                return;
            }
            Iterator iterator2 = this.getRestartURs();
            while (iterator2.hasNext()) {
                RestartURData restartURData = (RestartURData)iterator2.next();
                if (bl) {
                    this.printRestartTranDetailedInfo(restartURData, controllerTransactionManagerSet);
                }
                ++n;
            }
            if (!bl) {
                Tr.audit(tc, "BBOT0018_RESTART_STATUS", new Object[]{this._serverShortName, new Integer(n)});
                if (this.isXaRecoveryDriven()) {
                    Tr.audit(tc, "BBOT0026_RESTART_WAIT_XA", this._serverShortName);
                }
            }
        }
        finally {
            this.releaseRestartMapLock(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "logUnresolvedTransactions");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printRestartTranDetailedInfo(RestartURData restartURData, ControllerTransactionManagerSet controllerTransactionManagerSet) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "printRestartTranDetailedInfo");
        }
        TransactionControlRep transactionControlRep = null;
        TransactionalUnitOfWork transactionalUnitOfWork = null;
        RecoveryCoordinator recoveryCoordinator = null;
        boolean bl = false;
        Status status = Status.StatusUnknown;
        boolean bl2 = false;
        int n = 0;
        Object var10_10 = null;
        byte[] byArray = null;
        Iterator iterator = null;
        XidImpl xidImpl = restartURData.getXid();
        int n2 = xidImpl.getFormatId();
        byte[] byArray2 = xidImpl.getGlobalTransactionId();
        byte[] byArray3 = xidImpl.getBranchQualifier();
        SyncpointInterest syncpointInterest = restartURData.getSyncpointInterest();
        LockableHashMap lockableHashMap = controllerTransactionManagerSet.getGtidMap();
        LockHierarchy lockHierarchy = controllerTransactionManagerSet.getLockHierarchy();
        transactionControlRep = (TransactionControlRep)lockableHashMap.get(xidImpl, true, lockHierarchy);
        try {
            transactionalUnitOfWork = transactionControlRep.getUnitOfWork();
            bl = transactionControlRep.isRoot();
            status = transactionControlRep.getStatus();
            bl2 = transactionControlRep.isNormal();
            n = transactionControlRep.getState();
            iterator = transactionalUnitOfWork.getResources();
            if (!bl) {
                recoveryCoordinator = syncpointInterest.getRecoveryCoordinator();
            }
        }
        finally {
            transactionControlRep.releaseTxLock();
        }
        byArray = transactionalUnitOfWork.getURID();
        if (transactionControlRep != null && tc.isEntryEnabled()) {
            Tr.event(tc, "Unresoleved Transaction Information", new Object[]{xidImpl, Util.toHexString(byArray), status, new Boolean(bl), new Boolean(bl2)});
        }
        if (recoveryCoordinator != null && status == Status.StatusPrepared) {
            String[] stringArray = controllerTransactionManagerSet.getHostInfoFromObject(recoveryCoordinator);
            Tr.audit(tc, "BBOT0019_RECOVERY_UNABLE_TO_RESOLVE", new Object[]{Util.toHexString(byArray), new Integer(n2), Util.toHexString(byArray2), Util.toHexString(byArray3), stringArray[0], stringArray[1], stringArray[2]});
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                stringArray = controllerTransactionManagerSet.getHostInfoFromObject(resource);
                Tr.audit(tc, "BBOT0020_RECOVERY_IN_DOUBT_SUBORDINATE", new Object[]{stringArray[0], stringArray[1], stringArray[2], Util.toHexString(byArray), new Integer(n2), Util.toHexString(byArray2), Util.toHexString(byArray3)});
            }
        } else if (recoveryCoordinator != null && n == 12) {
            String[] stringArray = controllerTransactionManagerSet.getHostInfoFromObject(recoveryCoordinator);
            Tr.audit(tc, "BBOT0022_UNABLE_TO_FORGET_TRAN", new Object[]{Util.toHexString(byArray), new Integer(n2), Util.toHexString(byArray2), Util.toHexString(byArray3), stringArray[0], stringArray[1], stringArray[2]});
        } else if (status == Status.StatusCommitted || status == Status.StatusCommitting) {
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                String[] stringArray = controllerTransactionManagerSet.getHostInfoFromObject(resource);
                Tr.audit(tc, "BBOT0021_UNABLE_TO_REACH_SUBORDINATE", new Object[]{"COMMIT", stringArray[0], stringArray[1], stringArray[2], Util.toHexString(byArray), new Integer(n2), Util.toHexString(byArray2), Util.toHexString(byArray3)});
            }
        } else if (status == Status.StatusRolledBack || status == Status.StatusRollingBack) {
            while (iterator.hasNext()) {
                Resource resource = (Resource)iterator.next();
                String[] stringArray = controllerTransactionManagerSet.getHostInfoFromObject(resource);
                Tr.audit(tc, "BBOT0021_UNABLE_TO_REACH_SUBORDINATE", new Object[]{"ROLLBACK", stringArray[0], stringArray[1], stringArray[2], Util.toHexString(byArray), new Integer(n2), Util.toHexString(byArray2), Util.toHexString(byArray3)});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "printRestartTranDetailedInfo");
        }
    }

    void getRestartMapLock(LockHierarchy lockHierarchy) {
        this._restartMap.obtainMapLockExclusive(lockHierarchy);
    }

    void releaseRestartMapLock(LockHierarchy lockHierarchy) {
        this._restartMap.releaseMapLockExclusive(lockHierarchy);
    }

    Iterator getRestartURs() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRestartURs");
        }
        Iterator iterator = this._restartMap.iterator();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRestartURs", iterator);
        }
        return iterator;
    }

    public String getServerShortName() {
        return this._serverShortName;
    }

    boolean isRecoveryComplete() {
        if (this._restartMap.size() == 0) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Setting rrsRecoveryComplete flag to true.");
            }
            this._rrsRecoveryComplete = true;
            if (this._restartOnlyMode) {
                this._restartAlarm.scheduleServerStop();
            }
        }
        return this._rrsRecoveryComplete;
    }

    boolean isXaRecoveryDriven() {
        return this._xaRecoveryDriven;
    }

    void setXaRecoveryDriven() {
        this._xaRecoveryDriven = true;
    }

    boolean isXaRecoveryComplete() {
        return this._xaRecoveryComplete;
    }

    void setXaRecoveryComplete() {
        this._xaRecoveryComplete = true;
    }

    boolean isColdStart() {
        return this._coldStart;
    }

    boolean isColdStartInRecoveryMode() {
        return this._coldStartInRecoveryMode;
    }

    public boolean isRestartOnlyMode() {
        return this._restartOnlyMode;
    }
}

