/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws390.tx.PersistentInterestData;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.SyncpointInterest;
import com.ibm.ws390.tx.rrs.RetrieveURInterestReturnType;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public class RestartURData {
    private static final TraceComponent tc = Tr.register(RestartURData.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private XidImpl _xid = null;
    private boolean _heuristic = false;
    private SyncpointInterest _syncpointInterest = null;
    private RetrieveURInterestReturnType _syncpointInterestData = null;
    private ArrayList _resourceInterests = null;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RestartURData: ");
        stringBuffer.append(this._xid.toString());
        stringBuffer.append(", UR State: ");
        if (this._syncpointInterestData == null) {
            stringBuffer.append("UNKNOWN");
        } else {
            stringBuffer.append(this._syncpointInterestData.getState());
        }
        stringBuffer.append(", Resource Interest Count: ");
        stringBuffer.append(this._resourceInterests.size());
        return stringBuffer.toString();
    }

    RestartURData(XidImpl xidImpl, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{xidImpl, new Boolean(bl)});
        }
        this._xid = xidImpl;
        this._heuristic = bl;
        this._resourceInterests = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    void addInterest(RetrieveURInterestReturnType retrieveURInterestReturnType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addInterest", retrieveURInterestReturnType);
        }
        byte[] byArray = retrieveURInterestReturnType.getPdata();
        byte by = PersistentInterestData.getType(byArray);
        switch (by) {
            case 1: {
                this._syncpointInterestData = retrieveURInterestReturnType;
                this._syncpointInterest = new SyncpointInterest(retrieveURInterestReturnType);
                break;
            }
            case 2: 
            case 3: {
                this._resourceInterests.add(retrieveURInterestReturnType);
                break;
            }
            default: {
                Tr.event(tc, "Invalid interest type " + by, retrieveURInterestReturnType);
                RasHelper.exit(-910026498, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addInterest", retrieveURInterestReturnType);
        }
    }

    boolean isResolutionRequired() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isResolutionRequired");
        }
        boolean bl = false;
        if (this._syncpointInterest != null) {
            if (this._syncpointInterestData.getState() == 4 || this._resourceInterests.size() > 0 || this._syncpointInterest.getXaResourceData() != null || !this._syncpointInterest.isRoot() && this._heuristic) {
                bl = true;
            }
        } else {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "No Syncpoint Interest", this);
            }
            throw new INTERNAL(-910026202, CompletionStatus.COMPLETED_NO);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isResolutionRequired", new Boolean(bl));
        }
        return bl;
    }

    SyncpointInterest getSyncpointInterest() {
        return this._syncpointInterest;
    }

    XidImpl getXid() {
        return this._xid;
    }

    boolean getHeuristicMixed() {
        return this._heuristic;
    }

    byte[] getContextToken() {
        return this._syncpointInterestData.getContextToken();
    }

    byte[] getURID() {
        return this._syncpointInterestData.getURID();
    }

    Iterator getResourceIterator() {
        return this._resourceInterests.iterator();
    }

    int getRestartTxState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRestartTxState");
        }
        int n = this._syncpointInterestData.getState();
        int n2 = 0;
        switch (n) {
            case 4: {
                n2 = 7;
                break;
            }
            case 5: {
                n2 = 15;
                break;
            }
            case 6: {
                n2 = 16;
                break;
            }
            default: {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Restart TX state is invalid", new Integer(n));
                }
                RasHelper.exit(-910026201, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRestartTxState", new Integer(n2));
        }
        return n2;
    }
}

