/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ws.Transaction.JTA.TxPrimaryKey;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.CoordinatorResource;
import com.ibm.ws390.tx.AsyncSyncpointIndicators;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.LockHierarchy;
import com.ibm.ws390.tx.PersistentInterestData;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionalUnitOfWork;
import com.ibm.ws390.tx.VariableLengthPDataElement;
import com.ibm.ws390.tx.WSATCRRecoveryCoordinator;
import com.ibm.ws390.tx.rrs.ExpressInterestReturnType;
import com.ibm.ws390.tx.rrs.RRS;
import com.ibm.ws390.tx.rrs.RetrieveURInterestReturnType;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.Object;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;

public final class SyncpointInterest
extends PersistentInterestData {
    private static final TraceComponent tc = Tr.register(SyncpointInterest.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int CURRENT_VERSION = 4;
    private static final int FIXED_LENGTH = 84;
    private static final int ROOT_OFFSET = 0;
    private static final byte ROOT_MASK = 1;
    private static final int CASCADED_OFFSET = 0;
    private static final byte CASCADED_MASK = 2;
    private static final int DELEGATE_OFFSET = 1;
    private static final int XA_ENLISTED_OFFSET = 2;
    private static final int JCA_TRAN_OFFSET = 3;
    private static final int JCA_FORMAT_ID_OFFSET = 4;
    private static final int PRIMARY_KEY_OFFSET = 32;
    private static final int NUM_VAR_DATA_OFFSET = 80;
    private static final int FIRST_VAR_DATA_OFFSET = 84;
    private byte _root;
    private byte _cascaded;
    private byte _delegate;
    private byte _xaEnlisted;
    private byte _jcaTran;
    private int _jcaFormatId;
    private byte[] _jcaBqual;
    private TxPrimaryKey _pk;
    private RecoveryCoordinator _recCoord;
    private CoordinatorResource _resource;
    private byte[] _xaData;
    private TransactionControlRep _controlRep;
    private boolean _syncpointComplete;
    private boolean _restart = false;
    private byte[] _rcIor = null;

    SyncpointInterest(TransactionControlRep transactionControlRep, RecoveryCoordinator recoveryCoordinator) {
        super((byte)1, transactionControlRep.getUnitOfWork());
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new java.lang.Object[]{transactionControlRep, recoveryCoordinator});
        }
        this._root = transactionControlRep.isRoot() ? (byte)1 : 0;
        this._cascaded = transactionControlRep.isCascaded() ? (byte)1 : 0;
        this._delegate = 0;
        this._xaEnlisted = 0;
        byte by = this._jcaTran = transactionControlRep.isJCA() ? (byte)1 : 0;
        if (this._jcaTran == 1) {
            this._jcaFormatId = transactionControlRep.getJcaFormatId();
            this._jcaBqual = transactionControlRep.getJcaBqual();
        }
        XidImpl xidImpl = transactionControlRep.getXid();
        this._pk = xidImpl.getPrimaryKey();
        this._recCoord = recoveryCoordinator;
        this._xaData = null;
        this._controlRep = transactionControlRep;
        this._syncpointComplete = false;
        this._npdata.preReplyStateCheck(0);
        if (this._cascaded == 0) {
            this._npdata.preReplyPrePrepare(0);
            this._npdata.preReplyPrepare(0);
            this._npdata.preReplyCommit(0);
            this._npdata.preReplyBackout(0);
        }
        int n = transactionControlRep.getTransactionType();
        ExpressInterestReturnType expressInterestReturnType = null;
        byte[] byArray = transactionControlRep.getParentUrToken();
        expressInterestReturnType = n == 2 ? this.expressInterest(1, null, byArray) : this.expressInterest(1, xidImpl, byArray);
        if (this._cascaded == 0) {
            int n2 = this.setSyncpointControls(20, 0, 0, 3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    SyncpointInterest(RetrieveURInterestReturnType retrieveURInterestReturnType) {
        super(retrieveURInterestReturnType, null);
        this._restart = true;
        byte by = this.getOriginalVersion();
        int n = 16;
        byte[] byArray = retrieveURInterestReturnType.getPdata();
        switch (by) {
            case 3: 
            case 4: {
                this._root = (byte)(1 & byArray[n + 0]);
                this._cascaded = (byte)(2 & byArray[n + 0]);
                this._delegate = byArray[n + 1];
                this._xaEnlisted = byArray[n + 2];
                this._jcaTran = byArray[n + 3];
                this._jcaFormatId = Util.getIntFromBytes(byArray, n + 4, 4);
                byte[] byArray2 = new byte[36];
                System.arraycopy(byArray, n + 32, byArray2, 0, byArray2.length);
                this._pk = new TxPrimaryKey(byArray2);
                this._jcaBqual = null;
                this._xaData = null;
                this._recCoord = null;
                this._controlRep = null;
                this._syncpointComplete = false;
                VariableLengthPDataElement[] variableLengthPDataElementArray = this.getVariableLengthData(byArray, n + 80);
                if (variableLengthPDataElementArray == null) break;
                block9: for (int i = 0; i < variableLengthPDataElementArray.length; ++i) {
                    switch (variableLengthPDataElementArray[i].getType()) {
                        case 1: {
                            this._rcIor = variableLengthPDataElementArray[i].getData();
                            continue block9;
                        }
                        case 2: {
                            this._xaData = variableLengthPDataElementArray[i].getData();
                            continue block9;
                        }
                        case 4: {
                            this._jcaBqual = variableLengthPDataElementArray[i].getData();
                            continue block9;
                        }
                        case 6: {
                            this._recCoord = new WSATCRRecoveryCoordinator(variableLengthPDataElementArray[i].getData());
                            continue block9;
                        }
                        default: {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Invalid data", variableLengthPDataElementArray[i]);
                            }
                            RasHelper.exit(-910026493, false);
                        }
                    }
                }
                break;
            }
            default: {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Invalid version", retrieveURInterestReturnType);
                }
                RasHelper.exit(-910026599, false);
            }
        }
    }

    public final byte getCurrentVersion() {
        return 4;
    }

    public byte[] getDerivedData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDerivedData");
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        int n = 1;
        int n2 = 84;
        int n3 = 0;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Building PData buffer");
        }
        if (this._recCoord != null) {
            if (this._recCoord instanceof WSATCRRecoveryCoordinator) {
                byArray2 = ((WSATCRRecoveryCoordinator)this._recCoord).toLogData();
                if (byArray2 != null) {
                    n = 6;
                    n2 += byArray2.length + 8;
                    n2 += this.calcPadding(n2);
                    ++n3;
                }
            } else {
                byArray2 = this.object_to_IOR(this._recCoord);
                n2 += byArray2.length + 8;
                n2 += this.calcPadding(n2);
                ++n3;
            }
        }
        if (this._xaEnlisted == 1) {
            n2 += (this._xaData == null ? 0 : this._xaData.length) + 8;
            n2 += this.calcPadding(n2);
            ++n3;
        }
        if (this._jcaBqual != null) {
            n2 += this._jcaBqual.length + 8;
            n2 += this.calcPadding(n2);
            ++n3;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Computed pdata length to be " + n2);
        }
        byArray = new byte[n2];
        if (this._root == 1) {
            byArray[0] = (byte)(byArray[0] | 1);
        }
        if (this._cascaded == 1) {
            byArray[0] = (byte)(byArray[0] | 2);
        }
        byArray[1] = this._delegate;
        byArray[2] = this._xaEnlisted;
        byArray[3] = this._jcaTran;
        Util.setBytesFromInt(byArray, 4, 4, this._jcaFormatId);
        byte[] byArray3 = this._pk.toBytes();
        System.arraycopy(byArray3, 0, byArray, 32, byArray3.length);
        Util.setBytesFromInt(byArray, 80, 4, n3);
        int n4 = 84;
        if (this._xaEnlisted == 1) {
            Util.setBytesFromInt(byArray, n4, 4, 2);
            Util.setBytesFromInt(byArray, n4 += 4, 4, this._xaData == null ? 0 : this._xaData.length);
            n4 += 4;
            if (this._xaData != null) {
                System.arraycopy(this._xaData, 0, byArray, n4, this._xaData.length);
                n4 += this._xaData.length;
                n4 += this.calcPadding(this._xaData.length);
            }
        }
        if (this._jcaBqual != null) {
            Util.setBytesFromInt(byArray, n4, 4, 4);
            Util.setBytesFromInt(byArray, n4 += 4, 4, this._jcaBqual.length);
            System.arraycopy(this._jcaBqual, 0, byArray, n4 += 4, this._jcaBqual.length);
            n4 += this._jcaBqual.length;
            n4 += this.calcPadding(this._jcaBqual.length);
        }
        if (byArray2 != null) {
            Util.setBytesFromInt(byArray, n4, 4, n);
            Util.setBytesFromInt(byArray, n4 += 4, 4, byArray2.length);
            System.arraycopy(byArray2, 0, byArray, n4 += 4, byArray2.length);
            n4 += byArray2.length;
            n4 += this.calcPadding(byArray2.length);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDerivedData", byArray);
        }
        return byArray;
    }

    void setXaResourceData(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setXaResourceData", byArray);
        }
        this._xaEnlisted = 1;
        this._xaData = byArray;
        this.setDirty();
        this.logPersistentInterestData();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setXaResourceData", byArray);
        }
    }

    byte[] getXaResourceData() {
        return this._xaData;
    }

    void becomeDelegate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "becomeDelegate");
        }
        this._delegate = 1;
        this.setDirty();
        this.logPersistentInterestData();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "becomeDelegate");
        }
    }

    boolean isDelegate() {
        return this._delegate != 0;
    }

    boolean xaEnlisted() {
        return this._xaEnlisted != 0;
    }

    boolean isJcaImported() {
        return this._jcaTran != 0;
    }

    int getJcaFormatId() {
        return this._jcaFormatId;
    }

    byte[] getJcaBqual() {
        return this._jcaBqual;
    }

    void setMarkedBackoutIndicator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMarkedBackoutIndicator");
        }
        byte[] byArray = this.getURIToken();
        int[] nArray = new int[]{1};
        int n = RRS.setSideInformation(byArray, nArray);
        switch (n) {
            case 0: {
                break;
            }
            case 1861: {
                int n2 = this._controlRep.getState();
                int n3 = this.getState();
                AsyncSyncpointIndicators asyncSyncpointIndicators = new AsyncSyncpointIndicators(byArray);
                if ((n2 == 3 || n2 == 4 || n2 == 5 || n2 == 6) && asyncSyncpointIndicators.getApplicationBackout()) {
                    throw new TRANSACTION_ROLLEDBACK(-910026618, CompletionStatus.COMPLETED_NO);
                }
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Invalid state error", asyncSyncpointIndicators);
                }
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRSUSI", Integer.toHexString(n)});
                RasHelper.exit(-910026178, false);
                break;
            }
            case 1794: 
            case 3840: {
                RasHelper.exit(-910026662, true);
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRSUSI", new Integer(n)});
                RasHelper.exit(-910026654, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMarkedBackoutIndicator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int agentPrepare(int var1_1) {
        if (SyncpointInterest.tc.isEntryEnabled()) {
            Tr.entry(SyncpointInterest.tc, "agentPrepare", new Integer(var1_1));
        }
        var2_2 = this.getURIToken();
        var3_3 = 0;
        this._controlRep.releaseTxLock();
        var4_4 = false;
        try {
            var3_3 = RRS.prepareAgentUR(var2_2, var1_1);
            this._controlRep.obtainExclusiveTxLock();
            var4_4 = true;
            var5_5 = ControllerTransactionManagerSet.instance();
            if (var5_5.isTxDebugEnabled() && var3_3 != 8) {
                var6_6 = new String[]{new ByteArray(this.getURID()).toString(), new String("IN-DOUBT")};
                var7_8 = RasHelper.wtorMessage(5, null, false, var6_6);
            }
            switch (var3_3) {
                case 0: 
                case 8: 
                case 200: 
                case 300: 
                case 301: 
                case 302: {
                    ** break;
lbl18:
                    // 1 sources

                    break;
                }
                case 1841: {
                    var6_7 = this._controlRep.getState();
                    var7_9 = this.getState();
                    var8_10 = new AsyncSyncpointIndicators(var2_2);
                    if (var6_7 == 6 && var8_10.getApplicationBackout()) {
                        this._controlRep.releaseTxLock();
                        var4_4 = false;
                        if (var1_1 == 0) {
                            this.agentForget(0);
                        }
                        if (var8_10.getHeuristicMixed()) {
                            var3_3 = 302;
                            ** break;
lbl32:
                            // 1 sources

                        } else {
                            var3_3 = 300;
                            ** break;
                        }
lbl35:
                        // 1 sources

                    } else {
                        if (SyncpointInterest.tc.isEventEnabled()) {
                            Tr.event(SyncpointInterest.tc, "Invalid state", new java.lang.Object[]{new Integer(var6_7), new Integer(var7_9)});
                        }
                        Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRAPRP", Integer.toHexString(var3_3)});
                        RasHelper.exit(-910026185, false);
                        ** break;
                    }
lbl41:
                    // 1 sources

                    break;
                }
                case 1794: 
                case 3840: {
                    Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRAPRP", new Integer(var3_3)});
                    RasHelper.exit(-910026672, true);
                    ** break;
lbl46:
                    // 1 sources

                    break;
                }
                default: {
                    Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRAPRP", new Integer(var3_3)});
                    RasHelper.exit(-910026672, false);
                    break;
                }
            }
        }
        finally {
            if (!var4_4) {
                this._controlRep.obtainExclusiveTxLock();
            }
        }
        if (SyncpointInterest.tc.isEntryEnabled()) {
            Tr.exit(SyncpointInterest.tc, "agentPrepare", new Integer(var3_3));
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int agentCommit(int var1_1) {
        if (SyncpointInterest.tc.isEntryEnabled()) {
            Tr.entry(SyncpointInterest.tc, "agentCommit", new Integer(var1_1));
        }
        var2_2 = this.getURIToken();
        var3_3 = 0;
        this._controlRep.releaseTxLock();
        var4_4 = false;
        try {
            var3_3 = RRS.commitAgentUR(var2_2, var1_1);
            this._controlRep.obtainExclusiveTxLock();
            var4_4 = true;
            switch (var3_3) {
                case 0: 
                case 101: 
                case 102: {
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 1841: {
                    var5_5 = this._controlRep.getState();
                    var6_6 = this.getState();
                    var7_7 = new AsyncSyncpointIndicators(var2_2);
                    if (var5_5 == 8 && (var6_6 == 5 || var6_6 == 6 || var6_6 == 7 || var6_6 == 9 || var6_6 == 11)) {
                        if (SyncpointInterest.tc.isDebugEnabled()) {
                            Tr.debug(SyncpointInterest.tc, "UR is in an expected state");
                        }
                    } else {
                        if (SyncpointInterest.tc.isEventEnabled()) {
                            Tr.event(SyncpointInterest.tc, "Invalid state", new java.lang.Object[]{new Integer(var5_5), new Integer(var6_6)});
                        }
                        Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRACMT", Integer.toHexString(var3_3)});
                        RasHelper.exit(-910026187, false);
                    }
                    if (var7_7.getTerminatingSyncpoint() || var7_7.getResolvedInDoubt() || var7_7.getApplicationBackout() || !this.isNormal()) {
                        if (SyncpointInterest.tc.isDebugEnabled()) {
                            Tr.debug(SyncpointInterest.tc, "UR has an expected async syncpoint");
                        }
                    } else {
                        if (SyncpointInterest.tc.isEventEnabled()) {
                            Tr.event(SyncpointInterest.tc, "Unexpected async syncpoint", var7_7);
                        }
                        Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRACMT", Integer.toHexString(var3_3)});
                        RasHelper.exit(-910026186, false);
                    }
                    if (!var7_7.getCommitted()) {
                        this.setHeuristicMixedIndicator();
                    }
                    this._controlRep.releaseTxLock();
                    var4_4 = false;
                    if (var1_1 == 0) {
                        this.agentForget(0);
                    }
                    if (var7_7.getHeuristicMixed() || !var7_7.getCommitted()) {
                        var3_3 = 102;
                        ** break;
lbl45:
                        // 1 sources

                    } else {
                        var3_3 = 0;
                        ** break;
                    }
lbl48:
                    // 1 sources

                    break;
                }
                case 1794: 
                case 3840: {
                    Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRACMT", new Integer(var3_3)});
                    RasHelper.exit(-910026670, true);
                    ** break;
lbl53:
                    // 1 sources

                    break;
                }
                default: {
                    Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{new String("ATRACMT"), Integer.toHexString(var3_3)});
                    RasHelper.exit(-910026670, false);
                    break;
                }
            }
        }
        finally {
            if (!var4_4) {
                this._controlRep.obtainExclusiveTxLock();
            }
        }
        if (SyncpointInterest.tc.isEntryEnabled()) {
            Tr.exit(SyncpointInterest.tc, "agentCommit", new Integer(var3_3));
        }
        return var3_3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int agentDelegateCommit(int var1_1, int var2_2) {
        if (SyncpointInterest.tc.isEntryEnabled()) {
            Tr.entry(SyncpointInterest.tc, "agentDelegateCommit", new java.lang.Object[]{new Integer(var1_1), new Integer(var2_2)});
        }
        var3_3 = this.getURIToken();
        var4_4 = 0;
        this._controlRep.releaseTxLock();
        var5_5 = false;
        try {
            var4_4 = RRS.delegateCommitAgentUR(var3_3, var1_1, var2_2);
            this._controlRep.obtainExclusiveTxLock();
            var5_5 = true;
            switch (var4_4) {
                case 0: 
                case 8: 
                case 101: 
                case 102: 
                case 200: 
                case 300: 
                case 301: 
                case 302: {
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 1841: {
                    var6_6 = this._controlRep.getCoordinatorImpl();
                    var7_7 = var6_6.get_transaction_name();
                    var8_8 = this.getURID();
                    var9_9 = new ByteArray(var8_8).toString();
                    if (this.isUriTokenValid()) {
                        var10_10 = this._controlRep.getState();
                        var11_11 = this.getState();
                        var12_12 = new AsyncSyncpointIndicators(var3_3);
                        if (var10_10 == 17 && (var11_11 == 5 || var11_11 == 6 || var11_11 == 7 || var11_11 == 9 || var11_11 == 11)) {
                            if (SyncpointInterest.tc.isDebugEnabled()) {
                                Tr.debug(SyncpointInterest.tc, "UR is in an expected state");
                            }
                        } else {
                            if (SyncpointInterest.tc.isEventEnabled()) {
                                Tr.event(SyncpointInterest.tc, "Invalid state", new java.lang.Object[]{new Integer(var10_10), new Integer(var11_11)});
                            }
                            Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRADCT1", Integer.toHexString(var4_4)});
                            RasHelper.exit(-910026184, false);
                        }
                        if (var12_12.getTerminatingSyncpoint() || var12_12.getResolvedInDoubt() || var12_12.getApplicationBackout()) {
                            if (SyncpointInterest.tc.isDebugEnabled()) {
                                Tr.debug(SyncpointInterest.tc, "Expected async syncpoint");
                            }
                        } else {
                            if (SyncpointInterest.tc.isEventEnabled()) {
                                Tr.event(SyncpointInterest.tc, "Bad async syncpoint", var12_12);
                            }
                            Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRADCT1", Integer.toHexString(var4_4)});
                            RasHelper.exit(-910026183, false);
                        }
                        this._controlRep.releaseTxLock();
                        var5_5 = false;
                        if (var1_1 == 0) {
                            this.agentForget(0);
                        }
                        if (var12_12.getHeuristicMixed()) {
                            Tr.audit(SyncpointInterest.tc, "BBOT0006_HEUR_COMPLETION=BBOT0006I", new java.lang.Object[]{var9_9, var7_7});
                            var4_4 = 102;
                            ** break;
lbl49:
                            // 1 sources

                        } else if (!var12_12.getCommitted()) {
                            var4_4 = 300;
                            ** break;
lbl53:
                            // 1 sources

                        } else {
                            var4_4 = 0;
                            ** break;
                        }
lbl56:
                        // 1 sources

                    } else {
                        Tr.audit(SyncpointInterest.tc, "BBOT0007_HEUR_HAZARD", new java.lang.Object[]{var9_9, var7_7});
                        ** break;
                    }
lbl59:
                    // 1 sources

                    break;
                }
                case 1794: 
                case 3840: {
                    Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRADCT1", new Integer(var4_4)});
                    RasHelper.exit(-910026557, true);
                    ** break;
lbl64:
                    // 1 sources

                    break;
                }
                default: {
                    Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRADCT1", new Integer(var4_4)});
                    RasHelper.exit(-910026557, false);
                    break;
                }
            }
        }
        finally {
            if (!var5_5) {
                this._controlRep.obtainExclusiveTxLock();
            }
        }
        if (SyncpointInterest.tc.isEntryEnabled()) {
            Tr.exit(SyncpointInterest.tc, "agentDelegateCommit", new Integer(var4_4));
        }
        return var4_4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int agentBackout(int var1_1) {
        if (SyncpointInterest.tc.isEntryEnabled()) {
            Tr.entry(SyncpointInterest.tc, "agentBackout", new Integer(var1_1));
        }
        var2_2 = this.getURIToken();
        var3_3 = 0;
        this._controlRep.releaseTxLock();
        var4_4 = false;
        try {
            var3_3 = RRS.backoutAgentUR(var2_2, var1_1);
            this._controlRep.obtainExclusiveTxLock();
            var4_4 = true;
            switch (var3_3) {
                case 0: 
                case 301: 
                case 302: {
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                case 1841: {
                    var5_5 = this._controlRep.getState();
                    var6_6 = this.getState();
                    var7_7 = new AsyncSyncpointIndicators(var2_2);
                    if (var5_5 == 10 && (var6_6 == 5 || var6_6 == 6 || var6_6 == 7 || var6_6 == 9 || var6_6 == 11)) {
                        if (SyncpointInterest.tc.isDebugEnabled()) {
                            Tr.debug(SyncpointInterest.tc, "UR is in an expected state");
                        }
                    } else {
                        if (SyncpointInterest.tc.isEventEnabled()) {
                            Tr.event(SyncpointInterest.tc, "Invalid state", new java.lang.Object[]{new Integer(var5_5), new Integer(var6_6)});
                        }
                        Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRABAK", Integer.toHexString(var3_3)});
                        RasHelper.exit(-910026181, false);
                    }
                    if (var7_7.getTerminatingSyncpoint() || var7_7.getResolvedInDoubt() || var7_7.getApplicationBackout() || !this.isNormal()) {
                        if (SyncpointInterest.tc.isDebugEnabled()) {
                            Tr.debug(SyncpointInterest.tc, "UR has an expected async syncpoint");
                        }
                    } else {
                        if (SyncpointInterest.tc.isEventEnabled()) {
                            Tr.event(SyncpointInterest.tc, "Unexpected async syncpoint", var7_7);
                        }
                        Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRABAK", Integer.toHexString(var3_3)});
                        RasHelper.exit(-910026180, false);
                    }
                    if (var7_7.getCommitted()) {
                        this.setHeuristicMixedIndicator();
                    }
                    this._controlRep.releaseTxLock();
                    var4_4 = false;
                    if (var1_1 == 0) {
                        this.agentForget(0);
                    }
                    if (var7_7.getHeuristicMixed() || var7_7.getCommitted()) {
                        var3_3 = 302;
                        ** break;
lbl45:
                        // 1 sources

                    } else {
                        var3_3 = 0;
                        ** break;
                    }
lbl48:
                    // 1 sources

                    break;
                }
                case 1794: 
                case 3840: {
                    Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRABAK", new Integer(var3_3)});
                    RasHelper.exit(-910026668, true);
                    ** break;
lbl53:
                    // 1 sources

                    break;
                }
                default: {
                    Tr.audit(SyncpointInterest.tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{"ATRABAK", new Integer(var3_3)});
                    RasHelper.exit(-910026668, false);
                    break;
                }
            }
        }
        finally {
            if (!var4_4) {
                this._controlRep.obtainExclusiveTxLock();
            }
        }
        if (SyncpointInterest.tc.isEntryEnabled()) {
            Tr.exit(SyncpointInterest.tc, "agentBackout", new Integer(var3_3));
        }
        return var3_3;
    }

    int agentForget(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "agentForget", new Integer(n));
        }
        byte[] byArray = this.getURIToken();
        int n2 = 0;
        n2 = RRS.forgetAgentURInterest(byArray, n);
        switch (n2) {
            case 0: 
            case 16: {
                break;
            }
            case 1794: 
            case 3840: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{new String("ATRAFGT"), Integer.toHexString(n2)});
                RasHelper.exit(-910026666, true);
                break;
            }
            default: {
                Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new java.lang.Object[]{new String("ATRAFGT"), Integer.toHexString(n2)});
                RasHelper.exit(-910026666, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "agentForget", new Integer(n2));
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prePrepare() {
        int n;
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "prePrepare", this);
            }
            n = 0;
            LockHierarchy lockHierarchy = ControllerTransactionManagerSet.instance().getLockHierarchy();
            this._controlRep.getLock().obtainWrite(lockHierarchy);
            try {
                TransactionalUnitOfWork transactionalUnitOfWork = this._controlRep.getUnitOfWork();
                int n2 = this._controlRep.getState();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "prePrepare", new java.lang.Object[]{new Integer(n2), this._controlRep.getXid()});
                }
                if (n2 == 3 && this._controlRep.isCascaded()) {
                    this._controlRep.changeState(5);
                    try {
                        this._controlRep.beforeCompletion();
                    }
                    catch (Throwable throwable) {
                        Tr.error(tc, "WTRN0074_SYNCHRONIZATION_EXCEPTION", new java.lang.Object[]{"before_completion", throwable});
                        try {
                            transactionalUnitOfWork.rollbackOnly();
                            break block15;
                        }
                        catch (Throwable throwable2) {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Exception in RBOnly", throwable2);
                            }
                            break block15;
                        }
                    }
                }
                try {
                    transactionalUnitOfWork.rollbackOnly();
                }
                catch (Throwable throwable) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Exception in RBOnly", throwable);
                    }
                }
            }
            finally {
                this._controlRep.getLock().releaseWrite(lockHierarchy);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prePrepare", new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepare() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare", this);
        }
        int n = 0;
        LockHierarchy lockHierarchy = ControllerTransactionManagerSet.instance().getLockHierarchy();
        this._controlRep.getLock().obtainWrite(lockHierarchy);
        try {
            int n2 = this._controlRep.getState();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "prepare", new java.lang.Object[]{new Integer(n2), this._controlRep.getXid()});
            }
            if (n2 == 5 && this._controlRep.isCascaded()) {
                this._controlRep.changeState(6);
                this._controlRep.changeState(7);
            } else {
                n = 8;
            }
        }
        finally {
            this._controlRep.getLock().releaseWrite(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare", new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int commit() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", this);
        }
        int n = 0;
        LockHierarchy lockHierarchy = ControllerTransactionManagerSet.instance().getLockHierarchy();
        this._controlRep.getLock().obtainWrite(lockHierarchy);
        try {
            int n2 = this._controlRep.getState();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "commit", new java.lang.Object[]{new Integer(n2), this._controlRep.getXid()});
            }
            if (this._controlRep.isCascaded()) {
                switch (n2) {
                    case 7: 
                    case 15: {
                        this._controlRep.changeState(8);
                    }
                    case 8: {
                        break;
                    }
                    default: {
                        Tr.error(tc, "WTRN0069_COMMIT_BAD_STATE", "Cascaded: " + new Integer(n2));
                        n = 44;
                        break;
                    }
                }
            } else {
                byte[] byArray = this.getURIToken();
                AsyncSyncpointIndicators asyncSyncpointIndicators = new AsyncSyncpointIndicators(byArray);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Commit for non-cascaded transaction", new java.lang.Object[]{this._controlRep.getXid(), asyncSyncpointIndicators, new Integer(n2)});
                }
                if (!asyncSyncpointIndicators.getSdsrmInitiated()) {
                    n = 1028;
                }
            }
        }
        finally {
            this._controlRep.getLock().releaseWrite(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit", new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int backout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "backout", this);
        }
        int n = 0;
        LockHierarchy lockHierarchy = ControllerTransactionManagerSet.instance().getLockHierarchy();
        this._controlRep.getLock().obtainWrite(lockHierarchy);
        try {
            int n2 = this._controlRep.getState();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "backout", new java.lang.Object[]{new Integer(n2), this._controlRep.getXid()});
            }
            if (this._controlRep.isCascaded()) {
                switch (n2) {
                    case 5: {
                        this._controlRep.changeState(4);
                    }
                    case 3: 
                    case 4: 
                    case 7: 
                    case 16: {
                        this._controlRep.changeState(10);
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        Tr.error(tc, "WTRN0072_ROLLBACK_BAD_STATE", "Cascaded: " + new Integer(n2));
                        n = 44;
                        break;
                    }
                }
            } else {
                byte[] byArray = this.getURIToken();
                AsyncSyncpointIndicators asyncSyncpointIndicators = new AsyncSyncpointIndicators(byArray);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Backout for non-cascaded transaction", new java.lang.Object[]{this._controlRep.getXid(), asyncSyncpointIndicators, new Integer(n2)});
                }
                if (!asyncSyncpointIndicators.getSdsrmInitiated()) {
                    n = 1028;
                }
            }
        }
        finally {
            this._controlRep.getLock().releaseWrite(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "backout", new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int endUR() {
        if (SyncpointInterest.tc.isEntryEnabled()) {
            Tr.entry(SyncpointInterest.tc, "endUR", this);
        }
        var1_1 = 0;
        this._syncpointComplete = true;
        if (this._controlRep.isCascaded()) {
            var1_1 = -1;
            var2_2 = ControllerTransactionManagerSet.instance().getLockHierarchy();
            this._controlRep.getLock().obtainWrite(var2_2);
            try {
                var3_3 = this._controlRep.getState();
                var4_4 = 9;
                var5_5 = this._controlRep.getUnitOfWork();
                if (SyncpointInterest.tc.isDebugEnabled()) {
                    Tr.debug(SyncpointInterest.tc, "endUR", new java.lang.Object[]{new Integer(var3_3), this._controlRep.getXid()});
                }
                switch (var3_3) {
                    case 10: 
                    case 16: {
                        var4_4 = 11;
                    }
                    case 8: 
                    case 15: {
                        this._controlRep.changeState(var4_4);
                        if (this._controlRep.isNormal()) {
                            try {
                                this._controlRep.afterCompletion(this._controlRep.getStatus());
                            }
                            catch (Throwable var6_6) {
                                Tr.error(SyncpointInterest.tc, "WTRN0074_SYNCHRONIZATION_EXCEPTION", new java.lang.Object[]{"after_completion", var6_6});
                                var5_5.setFailedXAResourceFlag(true);
                            }
                        }
                        if (var5_5.getFailedXAResourceFlag()) {
                            var6_7 = this._controlRep.getResolver();
                            var6_7.setResolutionType(var4_4 == 9 ? 3 : 4);
                            var6_7.start(30);
                            this._controlRep.changeState(12);
                            var5_5.forgetSubordinatePending();
                            ** break;
lbl34:
                            // 1 sources

                        } else if (var5_5.getXAPdata() != null && !this._controlRep.isNormal()) {
                            var5_5.forgetSubordinatePending();
                            ** break;
lbl38:
                            // 1 sources

                        } else {
                            this._controlRep.changeState(12);
                            this._controlRep.destroy(var2_2);
                            var1_1 = 0;
                            ** break;
                        }
lbl43:
                        // 1 sources

                        break;
                    }
                    case 9: 
                    case 11: {
                        if (this._controlRep.isNormal() && SyncpointInterest.tc.isEventEnabled()) {
                            Tr.event(SyncpointInterest.tc, "endUR in invalid state", new java.lang.Object[]{this._controlRep.getXid(), new Integer(var3_3)});
                            ** break;
                        }
lbl48:
                        // 3 sources

                        break;
                    }
                    case 12: {
                        if (var5_5.getXAPdata() == null) {
                            var1_1 = 0;
                            ** break;
lbl53:
                            // 1 sources

                        } else if (!this._controlRep.isNormal() && SyncpointInterest.tc.isEventEnabled()) {
                            Tr.event(SyncpointInterest.tc, "endUR in invalid state", new java.lang.Object[]{this._controlRep.getXid(), new Integer(var3_3)});
                            ** break;
                        }
lbl57:
                        // 3 sources

                        break;
                    }
                    default: {
                        if (SyncpointInterest.tc.isEventEnabled()) {
                            Tr.event(SyncpointInterest.tc, "endUR invalid state", new java.lang.Object[]{this._controlRep.getXid(), new Integer(var3_3)});
                        }
                        break;
                    }
                }
            }
            finally {
                this._controlRep.getLock().releaseWrite(var2_2);
            }
        }
        if (SyncpointInterest.tc.isEntryEnabled()) {
            Tr.exit(SyncpointInterest.tc, "endUR", new Integer(var1_1));
        }
        return var1_1;
    }

    public boolean isSyncpointComplete() {
        return this._syncpointComplete;
    }

    public boolean isRoot() {
        return this._root != 0;
    }

    public boolean isCascaded() {
        return this._cascaded != 0;
    }

    public RecoveryCoordinator getRecoveryCoordinator() {
        if (this._restart && this._recCoord == null && this._rcIor != null) {
            Object object = this.IOR_to_object(this._rcIor);
            if (object == null) {
                throw new INV_OBJREF();
            }
            this._recCoord = RecoveryCoordinatorHelper.narrow(object);
        }
        return this._recCoord;
    }

    void setControlRep(TransactionControlRep transactionControlRep) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setControlRep", transactionControlRep);
        }
        if (transactionControlRep == null || transactionControlRep.isNormal() || this._controlRep == null) {
            // empty if block
        }
        this._controlRep = transactionControlRep;
        if (this._recCoord instanceof WSATCRRecoveryCoordinator) {
            ((WSATCRRecoveryCoordinator)this._recCoord).setControlRep(transactionControlRep);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setControlRep");
        }
    }
}

