/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws390.tx.NativeServerInstanceData;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.ResourceManager;

public class SyncpointRestartAlarm
implements AlarmListener {
    private boolean _recoveryComplete = false;
    private Alarm _alarm = null;
    private int _recoveryTimeout;
    private int _elapsedTimeUnits = 0;
    private int _elapsedTimeUnitsPendingStop = 0;
    private boolean _pendingDeletion = false;
    private String _failedServerShortName;
    private final int _defaultSnoozeDuration = 60;
    private ResourceManager _resourceManager;
    private int _transactionRecoveryTimeout;
    private static final TraceComponent tc = Tr.register(SyncpointRestartAlarm.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");

    SyncpointRestartAlarm(ResourceManager resourceManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this._resourceManager = resourceManager;
        this._recoveryTimeout = this._transactionRecoveryTimeout = NativeServerInstanceData.getTransactionRecoveryTimeout();
        this._failedServerShortName = this._resourceManager.getServerShortName();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", this);
        }
        ++this._elapsedTimeUnits;
        if (this._recoveryComplete) {
            int n = 1;
            AdminService adminService = AdminServiceFactory.getAdminService();
            String string = adminService.getProcessType();
            if (string.equals("NodeAgent") || this._resourceManager.isXaRecoveryComplete()) {
                ++this._elapsedTimeUnitsPendingStop;
                if (this._elapsedTimeUnitsPendingStop > n) {
                    RasHelper.stopServer();
                    this._pendingDeletion = true;
                }
            } else {
                Tr.audit(tc, "BBOT0026_RESTART_WAIT_XA", this._failedServerShortName);
            }
        } else if (this._elapsedTimeUnits >= this._recoveryTimeout) {
            this._resourceManager.logUnresolvedTransactions(true);
            String[] stringArray = new String[]{this._failedServerShortName};
            String string = null;
            while ((string = RasHelper.wtorMessage(15, string, false, stringArray)).compareToIgnoreCase("CONTINUE") != 0 && string.compareToIgnoreCase("TERMINATE") != 0) {
            }
            if (string.compareToIgnoreCase("CONTINUE") == 0) {
                RasHelper.wtorMessage(17, string, true, stringArray);
                this._recoveryTimeout += this._transactionRecoveryTimeout;
            } else if (string.compareToIgnoreCase("TERMINATE") == 0) {
                this._pendingDeletion = true;
                RasHelper.wtorMessage(16, string, true, stringArray);
                RasHelper.stopServer();
            }
        } else {
            this._resourceManager.logUnresolvedTransactions(false);
        }
        if (this._pendingDeletion) {
            this.stop();
        } else {
            this.start();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        this._alarm = AlarmManager.createNonDeferrable(60000L, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (this._alarm != null) {
            this._alarm.cancel();
            this._alarm = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public void scheduleServerStop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "scheduleServerStop");
        }
        this._recoveryComplete = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "scheduleServerStop", new Boolean(this._recoveryComplete));
        }
    }
}

