/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.nio.ByteBuffer;

public class TranAffinityMarker {
    private static final TraceComponent tc = Tr.register(TranAffinityMarker.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private ByteBuffer _gtrid = null;
    private boolean _enqsHeld = false;

    public TranAffinityMarker(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byArray);
        }
        this._gtrid = ByteBuffer.allocateDirect(byArray.length);
        this._gtrid.put(byArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void setEnqsHeld(boolean bl) {
        this._enqsHeld = bl;
    }

    public boolean areEnqsHeld() {
        return this._enqsHeld;
    }

    public void obtainENQs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "obtainENQs");
        }
        if (this._enqsHeld) {
            String string = "Transactional ENQs are already held";
            throw new IllegalStateException(string);
        }
        this.obtainENQsNative(this._gtrid);
        this._enqsHeld = true;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "obtainENQs");
        }
    }

    public void releaseENQs() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseENQs");
        }
        if (!this._enqsHeld) {
            String string = "Transactional ENQs are not held";
            throw new IllegalStateException(string);
        }
        this.releaseENQsNative(this._gtrid);
        this._enqsHeld = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseENQs");
        }
    }

    private native void obtainENQsNative(ByteBuffer var1);

    private native void releaseENQsNative(ByteBuffer var1);
}

