/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.CORBA.iiop.CDRInputStream;
import com.ibm.CORBA.iiop.IOR;
import com.ibm.CORBA.iiop.ORB;
import com.ibm.CORBA.iiop.ServiceContext;
import com.ibm.CORBA.iiop.ServiceContextList;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.orb.GlobalORBFactory;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.TranAffinityMap;
import com.ibm.ws390.tx.TranAffinityMarker;
import com.ibm.wsspi.iiop.channel.ConnectionStateElement;
import com.ibm.wsspi.iiop.channel.StateElement;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;
import org.omg.CosTransactions.ControlHelper;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinatorHelper;
import org.omg.CosTransactions.ResourceHelper;
import org.omg.CosTransactions.TerminatorHelper;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.TransIdentityHelper;
import org.omg.PortableInterceptor.ForwardRequest;

public class TranAffinityRouterHelper {
    private static final TraceComponent tc = Tr.register(TranAffinityRouterHelper.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final String JTS_CONN_STATE = "JTS_CONN_STATE";
    public static final String JTS_PC_KEY = "JTS_PC_KEY";
    public static final String JTS_XID_CACHE_KEY = "JTS_XID_CACHE_KEY";
    public static final String JTS_AFF_MARKER_KEY = "JTS_AFF_MARKER_KEY";
    private static TranAffinityRouterHelper _instance = new TranAffinityRouterHelper();
    private TranAffinityMap _tm = null;

    public static TranAffinityRouterHelper instance() {
        return _instance;
    }

    public static boolean isTransactionalSystemObject(String string) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "isTransactionalSystemObject", string);
        }
        boolean bl = false;
        if (RecoveryCoordinatorHelper.id().equals(string) || CoordinatorHelper.id().equals(string) || ResourceHelper.id().equals(string) || TerminatorHelper.id().equals(string) || ControlHelper.id().equals(string)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "JTS System object", string);
            }
            bl = true;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "isTransactionalSystemObject", new Boolean(bl));
        }
        return bl;
    }

    private TranAffinityRouterHelper() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
            Tr.exit(tc, "<init>", this);
        }
    }

    void setTranAffinityMap(TranAffinityMap tranAffinityMap) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "setTranAffinityMap", tranAffinityMap);
        }
        if (this._tm != null) {
            String string = "TransactionManager already set";
            throw new IllegalStateException(string);
        }
        this._tm = tranAffinityMap;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "setTranAffinityMap");
        }
    }

    public boolean seenDistributedTran(byte[] byArray) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "seenDistributedTran", byArray);
        }
        if (this._tm == null) {
            String string = "TransactionManager not initialized yet";
            throw new IllegalStateException(string);
        }
        boolean bl = this._tm.seenDistributedTran(byArray);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "seenDistributedTran", new Boolean(bl));
        }
        return bl;
    }

    private Throwable createForwardException(ByteBuffer byteBuffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "createForwardException", byteBuffer);
        }
        byte[] byArray = new byte[byteBuffer.capacity()];
        byteBuffer.get(byArray);
        ORB oRB = GlobalORBFactory.globalORB();
        CDRInputStream cDRInputStream = ORB.createCDRInputStream((ORB)oRB, (byte[])byArray, (int)byArray.length);
        cDRInputStream.consumeEndian();
        IOR iOR = ORB.createIOR((ORB)oRB);
        iOR.read((InputStream)cDRInputStream);
        Object object = oRB.IORToObject(iOR);
        ForwardRequest forwardRequest = new ForwardRequest("Transactional Affinity is elsewhere", object);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "createForwardException", (java.lang.Object)forwardRequest);
        }
        return forwardRequest;
    }

    public PropagationContext extractPropagationContext(ServiceContextList serviceContextList) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractPropagationContext", serviceContextList);
        }
        PropagationContext propagationContext = null;
        ServiceContext serviceContext = serviceContextList.get(0);
        if (serviceContext != null) {
            byte[] byArray = serviceContext.getContextData();
            ORB oRB = GlobalORBFactory.globalORB();
            CDRInputStream cDRInputStream = ORB.createCDRInputStream((ORB)oRB, (byte[])byArray, (int)byArray.length);
            cDRInputStream.consumeEndian();
            propagationContext = new PropagationContext();
            propagationContext.timeout = cDRInputStream.read_ulong();
            propagationContext.current = TransIdentityHelper.read((InputStream)cDRInputStream);
            propagationContext.parents = new TransIdentity[cDRInputStream.read_long()];
            for (int i = 0; i < propagationContext.parents.length; ++i) {
                propagationContext.parents[i] = TransIdentityHelper.read((InputStream)cDRInputStream);
            }
            propagationContext.implementation_specific_data = cDRInputStream.read_any();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractPropagationContext", propagationContext);
        }
        return propagationContext;
    }

    public byte[] extractGtrid(PropagationContext propagationContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "extractGtrid", propagationContext);
        }
        byte[] byArray = null;
        if (propagationContext != null && propagationContext.current.otid != null && propagationContext.current.otid.tid.length != 0) {
            int n = propagationContext.current.otid.tid.length - propagationContext.current.otid.bqual_length;
            byArray = new byte[n];
            System.arraycopy(propagationContext.current.otid.tid, 0, byArray, 0, n);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "extractGtrid", byArray);
        }
        return byArray;
    }

    public void cacheTransactionalObjects(Map map, PropagationContext propagationContext, TranAffinityMarker tranAffinityMarker) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "cacheTransactionalObjects", new java.lang.Object[]{map, propagationContext, tranAffinityMarker});
        }
        if (tranAffinityMarker != null) {
            if (map.containsKey(JTS_AFF_MARKER_KEY)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "Marker is already present in state map", map);
                }
                throw new INTERNAL("Internal error - duplicate tran routing marker");
            }
            map.put(JTS_AFF_MARKER_KEY, tranAffinityMarker);
        }
        if (propagationContext != null) {
            if (map.containsKey(JTS_PC_KEY)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event(tc, "PC is already present in state map", new java.lang.Object[]{map, map.get(JTS_PC_KEY)});
                }
                throw new INTERNAL("Internal error - PC conflict");
            }
            map.put(JTS_PC_KEY, propagationContext);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "cacheTransactionalObjects");
        }
    }

    public Map getStateMap(ConnectionStateElement connectionStateElement, int n) {
        String string;
        Map map;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "getStateMap", new java.lang.Object[]{connectionStateElement, new Integer(n)});
        }
        if ((map = (Map)connectionStateElement.getConnectionElement(string = JTS_CONN_STATE + n)) == null) {
            map = new TransactionRequestStateMap(n);
            connectionStateElement.setConnectionElement(string, (StateElement)((java.lang.Object)map));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "getStateMap", map);
        }
        return map;
    }

    public void removeRequestFromStateElementMap(ConnectionStateElement connectionStateElement, int n) {
        java.lang.Object object;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "removeRequestFromStateElementMap", new java.lang.Object[]{connectionStateElement, new Integer(n)});
        }
        String string = JTS_CONN_STATE + n;
        Map map = this.getStateMap(connectionStateElement, n);
        if (map.get(JTS_AFF_MARKER_KEY) != null || map.get(JTS_XID_CACHE_KEY) != null) {
            RasHelper.exit(-910026168, false);
        }
        if ((object = connectionStateElement.removeConnectionElement(string)) == null && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Connection stale or Request not found. Request was not removed from state elemennt map", new java.lang.Object[]{object, string});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "removeRequestFromStateElementMap");
        }
    }

    private native boolean checkEnqsNative(byte[] var1, byte[] var2, boolean var3) throws ForwardRequest;

    public class TransactionRequestStateMap
    extends HashMap
    implements StateElement {
        private int _id;

        public TransactionRequestStateMap(int n) {
            this._id = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry(tc, "destroy", new Integer(this._id));
            }
            try {
                if (!this.isEmpty() && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Set set = this.entrySet();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Tr.event(tc, "Orphaned transaction key for request " + this._id, new java.lang.Object[]{entry.getKey(), entry.getValue()});
                    }
                }
            }
            finally {
                RasHelper.exit(-910026163, false);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit(tc, "destroy", new Integer(this._id));
            }
        }
    }
}

