/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.tx.TranAttributeData;
import java.util.ArrayList;

public final class TranAttributeCollector
implements MetaDataListener {
    private static final TraceComponent tc = Tr.register(TranAttributeCollector.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final String separator = ":";
    private static final String getEJBHomeSig = "getEJBHome:";
    private static final String getHandleSig = "getHandle:";
    private static final String getPrimaryKeySig = "getPrimaryKey:";
    private static final String isIdenticalSig = "isIdentical:java.ejb.EJBObject";
    private static final String removeSig = "remove:";
    public static final String getEJBMetaDataSig = "getEJBMetaData:";
    public static final String getHomeHandleSig = "getHomeHandle:";

    public void metaDataCreated(MetaDataEvent metaDataEvent) throws RuntimeWarning, RuntimeError {
        MetaData metaData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "metaDataCreated", metaDataEvent);
        }
        if ((metaData = metaDataEvent.getMetaData()) != null && metaData instanceof EJBComponentMetaData) {
            EJBComponentMetaData eJBComponentMetaData = (EJBComponentMetaData)metaData;
            EJBMethodInfo[] eJBMethodInfoArray = eJBComponentMetaData.getEJBMethodMetaData(MethodInterface.REMOTE);
            EJBMethodInfo[] eJBMethodInfoArray2 = eJBComponentMetaData.getEJBMethodMetaData(MethodInterface.HOME);
            int n = eJBComponentMetaData.getEJBComponentType();
            int n2 = eJBComponentMetaData.getEJBTransactionPolicy();
            if (eJBComponentMetaData.isSessionBean() || eJBComponentMetaData.isEntityBean()) {
                TransactionAttribute transactionAttribute = this.processRemoteMethodInfo(eJBMethodInfoArray, n, n2);
                TransactionAttribute transactionAttribute2 = this.processHomeMethodInfo(eJBMethodInfoArray2, n);
                if (transactionAttribute != null || transactionAttribute2 != null) {
                    String string = this.getComponentName(eJBMethodInfoArray, eJBMethodInfoArray2);
                    byte[] byArray = PlatformHelperFactory.getPlatformHelper().getStoken();
                    TranAttributeData tranAttributeData = null;
                    try {
                        tranAttributeData = new TranAttributeData(transactionAttribute, transactionAttribute2, string, byArray);
                        byte[] byArray2 = tranAttributeData.deflate();
                        this.addComponentData(byArray2, false);
                    }
                    catch (Throwable throwable) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Could not register data", new Object[]{tranAttributeData, throwable});
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not processing this bean type", new Integer(n));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "metaDataCreated", metaDataEvent);
        }
    }

    public void metaDataDestroyed(MetaDataEvent metaDataEvent) {
        MetaData metaData;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "metaDataDestroyed", metaDataEvent);
        }
        if ((metaData = metaDataEvent.getMetaData()) != null && metaData instanceof EJBComponentMetaData) {
            EJBComponentMetaData eJBComponentMetaData = (EJBComponentMetaData)metaData;
            EJBMethodInfo[] eJBMethodInfoArray = eJBComponentMetaData.getEJBMethodMetaData(MethodInterface.REMOTE);
            EJBMethodInfo[] eJBMethodInfoArray2 = eJBComponentMetaData.getEJBMethodMetaData(MethodInterface.HOME);
            int n = eJBComponentMetaData.getEJBComponentType();
            int n2 = eJBComponentMetaData.getEJBTransactionPolicy();
            if (eJBComponentMetaData.isSessionBean() || eJBComponentMetaData.isEntityBean()) {
                TransactionAttribute transactionAttribute = this.processRemoteMethodInfo(eJBMethodInfoArray, n, n2);
                TransactionAttribute transactionAttribute2 = this.processHomeMethodInfo(eJBMethodInfoArray2, n);
                if (transactionAttribute != null || transactionAttribute2 != null) {
                    String string = this.getComponentName(eJBMethodInfoArray, eJBMethodInfoArray2);
                    byte[] byArray = PlatformHelperFactory.getPlatformHelper().getStoken();
                    TranAttributeData tranAttributeData = null;
                    try {
                        tranAttributeData = new TranAttributeData(transactionAttribute, transactionAttribute2, string, byArray);
                        byte[] byArray2 = tranAttributeData.deflate();
                        this.addComponentData(byArray2, true);
                    }
                    catch (Throwable throwable) {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Could not deregister data", new Object[]{tranAttributeData, throwable});
                        }
                    }
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not processing this bean type", new Integer(n));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "metaDataDestroyed", metaDataEvent);
        }
    }

    private TransactionAttribute processRemoteMethodInfo(EJBMethodInfo[] eJBMethodInfoArray, int n, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processRemoteMethodInfo", eJBMethodInfoArray);
        }
        TransactionAttribute transactionAttribute = null;
        boolean bl = false;
        transactionAttribute = n2 == 1 ? TransactionAttribute.TX_BEAN_MANAGED : TransactionAttribute.TX_NOT_SUPPORTED;
        if (eJBMethodInfoArray == null || eJBMethodInfoArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No remote methods defined");
            }
            bl = true;
        } else {
            int n3;
            ArrayList<EJBMethodInfo> arrayList = new ArrayList<EJBMethodInfo>(eJBMethodInfoArray.length);
            for (n3 = 0; n3 < eJBMethodInfoArray.length; ++n3) {
                boolean bl2 = false;
                String string = eJBMethodInfoArray[n3].getMethodSignature();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "processing remote method", string);
                }
                if (string.equals(getEJBHomeSig) || string.equals(getHandleSig) || string.equals(getPrimaryKeySig) || string.equals(isIdenticalSig)) {
                    bl2 = true;
                } else if ((n == 2 || n == 3) && string.equals(removeSig)) {
                    bl2 = true;
                }
                if (bl2) continue;
                arrayList.add(eJBMethodInfoArray[n3]);
            }
            if (arrayList.size() > 0) {
                transactionAttribute = ((EJBMethodInfo)arrayList.get(0)).getTransactionAttribute();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking for homogeneous tx attribute", transactionAttribute.toString());
                }
                for (n3 = arrayList.size() - 1; n3 >= 0; --n3) {
                    EJBMethodInfo eJBMethodInfo = (EJBMethodInfo)arrayList.get(n3);
                    if (eJBMethodInfo.getTransactionAttribute().equals(transactionAttribute)) {
                        arrayList.remove(n3);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, eJBMethodInfo.getMethodName() + " does not conform to the tx policy", eJBMethodInfo.getTransactionAttribute());
                }
                if (arrayList.size() == 0) {
                    bl = true;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No methods left after fliter");
                }
                bl = true;
            }
        }
        if (!bl) {
            transactionAttribute = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processRemoteMethodInfo", transactionAttribute);
        }
        return transactionAttribute;
    }

    private TransactionAttribute processHomeMethodInfo(EJBMethodInfo[] eJBMethodInfoArray, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "processHomeMethodInfo", eJBMethodInfoArray);
        }
        TransactionAttribute transactionAttribute = TransactionAttribute.TX_NOT_SUPPORTED;
        boolean bl = false;
        if (eJBMethodInfoArray == null || eJBMethodInfoArray.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No home methods defined");
            }
            bl = true;
        } else if (n == 2 || n == 3) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Taking default for session bean");
            }
            bl = true;
        } else {
            int n2;
            ArrayList<EJBMethodInfo> arrayList = new ArrayList<EJBMethodInfo>(eJBMethodInfoArray.length);
            for (n2 = 0; n2 < eJBMethodInfoArray.length; ++n2) {
                boolean bl2 = false;
                String string = eJBMethodInfoArray[n2].getMethodSignature();
                if (string.equals(getEJBMetaDataSig) || string.equals(getHomeHandleSig)) {
                    bl2 = true;
                }
                if (bl2) continue;
                arrayList.add(eJBMethodInfoArray[n2]);
            }
            if (arrayList.size() > 0) {
                transactionAttribute = ((EJBMethodInfo)arrayList.get(0)).getTransactionAttribute();
                for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                    EJBMethodInfo eJBMethodInfo = (EJBMethodInfo)arrayList.get(n2);
                    if (!eJBMethodInfo.getTransactionAttribute().equals(transactionAttribute)) continue;
                    arrayList.remove(n2);
                }
                if (arrayList.size() == 0) {
                    bl = true;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No methods left after fliter");
                }
                bl = true;
            }
        }
        if (!bl) {
            transactionAttribute = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "processHomeMethodInfo", transactionAttribute);
        }
        return transactionAttribute;
    }

    private String getComponentName(EJBMethodInfo[] eJBMethodInfoArray, EJBMethodInfo[] eJBMethodInfoArray2) {
        String string = null;
        if (eJBMethodInfoArray != null && eJBMethodInfoArray.length > 0) {
            string = ((Object)eJBMethodInfoArray[0].getJ2EEName()).toString();
        } else if (eJBMethodInfoArray2 != null && eJBMethodInfoArray2.length > 0) {
            string = ((Object)eJBMethodInfoArray2[0].getJ2EEName()).toString();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "could not get J2EE name");
        }
        return string;
    }

    private native void addComponentData(byte[] var1, boolean var2);
}

