/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.websphere.csi.TransactionAttribute;

public final class TranAttributeData {
    private static final TraceComponent tc = Tr.register(TranAttributeData.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final int BYTE_SIZE = 1;
    private static final int STOKEN_LENGTH = 8;
    private byte[] _stoken = null;
    private int _remoteTxAttr = -1;
    private int _homeTxAttr = -1;
    private String _componentName = null;

    TranAttributeData(TransactionAttribute transactionAttribute, TransactionAttribute transactionAttribute2, String string, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Object[] objectArray = new Object[]{transactionAttribute, transactionAttribute2, string, byArray};
            Tr.entry(tc, "TranAttributeData", objectArray);
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Stoken was null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Component name was null");
        }
        this._stoken = byArray;
        this._componentName = string;
        if (transactionAttribute != null) {
            this._remoteTxAttr = transactionAttribute.getValue();
        }
        if (transactionAttribute2 != null) {
            this._homeTxAttr = transactionAttribute2.getValue();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TranAttributeData", this);
        }
    }

    private TranAttributeData(int n, int n2, String string, byte[] byArray) {
        this._remoteTxAttr = n;
        this._homeTxAttr = n2;
        this._componentName = string;
        this._stoken = byArray;
    }

    public String getComponentName() {
        return this._componentName;
    }

    public byte[] getStoken() {
        return this._stoken;
    }

    public TransactionAttribute getRemoteTxAttr() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteTxAttr");
        }
        TransactionAttribute transactionAttribute = this.findTxAttr(this._remoteTxAttr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemoteTxAttr", transactionAttribute);
        }
        return transactionAttribute;
    }

    public TransactionAttribute getHomeTxAttr() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHomeTxAttr");
        }
        TransactionAttribute transactionAttribute = this.findTxAttr(this._homeTxAttr);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHomeTxAttr", transactionAttribute);
        }
        return transactionAttribute;
    }

    private TransactionAttribute findTxAttr(int n) {
        if (n == TransactionAttribute.TX_NOT_SUPPORTED.getValue()) {
            return TransactionAttribute.TX_NOT_SUPPORTED;
        }
        if (n == TransactionAttribute.TX_BEAN_MANAGED.getValue()) {
            return TransactionAttribute.TX_BEAN_MANAGED;
        }
        if (n == TransactionAttribute.TX_REQUIRED.getValue()) {
            return TransactionAttribute.TX_REQUIRED;
        }
        if (n == TransactionAttribute.TX_SUPPORTS.getValue()) {
            return TransactionAttribute.TX_SUPPORTS;
        }
        if (n == TransactionAttribute.TX_REQUIRES_NEW.getValue()) {
            return TransactionAttribute.TX_REQUIRES_NEW;
        }
        if (n == TransactionAttribute.TX_MANDATORY.getValue()) {
            return TransactionAttribute.TX_MANDATORY;
        }
        if (n == TransactionAttribute.TX_NEVER.getValue()) {
            return TransactionAttribute.TX_NEVER;
        }
        return null;
    }

    public byte[] deflate() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deflate");
        }
        byte[] byArray = this._componentName.getBytes();
        int n = 10 + byArray.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(this._stoken, 0, byArray2, 0, 8);
        byArray2[8] = (byte)this._remoteTxAttr;
        byArray2[9] = (byte)this._homeTxAttr;
        System.arraycopy(byArray, 0, byArray2, 10, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deflate", byArray2);
        }
        return byArray2;
    }

    public static TranAttributeData inflate(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inflate", byArray);
        }
        if (byArray == null || byArray.length < 10) {
            throw new IllegalArgumentException("TranAttributeData array length is too short");
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, 8);
        byte by = byArray[8];
        byte by2 = byArray[9];
        String string = null;
        try {
            string = new String(byArray, 10, byArray.length - 10);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("TranAttributeData component name is truncated");
        }
        TranAttributeData tranAttributeData = new TranAttributeData(by, by2, string, byArray2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inflate", tranAttributeData);
        }
        return tranAttributeData;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TranAttributeData: ");
        stringBuffer.append("Remote: " + this._remoteTxAttr);
        stringBuffer.append(", Home: " + this._homeTxAttr);
        stringBuffer.append(", AMC: " + this._componentName);
        stringBuffer.append(", Stoken: " + Util.toHexString(this._stoken));
        return stringBuffer.toString();
    }
}

