/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import org.omg.CORBA.NO_MEMORY;

public class TransactionByteBufferPoolManager {
    private static final TraceComponent tc = Tr.register(TransactionByteBufferPoolManager.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final int MAX_BUFFER_LENGTH = 4000;
    private final int MAX_LIST_ARRAY_SIZE = 32;
    private final int BUFFER_SIZE_GRANULARITY = 128;
    private LinkedList[] _pool = new LinkedList[32];
    private int _buffersCreated = 0;
    private int _maxLengthBuffer = 0;
    private int _buffersAvailable = 0;
    private static final TransactionByteBufferPoolManager _poolManager = new TransactionByteBufferPoolManager();
    private static final byte[] nullArray = new byte[128];

    private TransactionByteBufferPoolManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public static TransactionByteBufferPoolManager instance() {
        return _poolManager;
    }

    public synchronized ByteBuffer allocateDirect(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "allocateDirect", new Integer(n));
        }
        ByteBuffer byteBuffer = null;
        int n2 = 0;
        if (n < 0 || n > 4000) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "allocateDirect", new Object[]{new Integer(n), new Integer(4000)});
            }
            throw new IllegalArgumentException("Illegal buffer size.");
        }
        for (int i = 0; i < 32; ++i) {
            if ((n2 += 128) > 4000) {
                n2 = 4000;
            }
            if (n > n2) continue;
            LinkedList linkedList = this._pool[i];
            if (linkedList == null) {
                this._pool[i] = linkedList = new LinkedList();
            }
            if (linkedList.size() == 0) {
                byteBuffer = ByteBuffer.allocateDirect(n2);
                if (byteBuffer == null) {
                    String string = "Failed to llocate a direct byte buffer.";
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "<init>", new Object[]{string, byteBuffer, new Integer(n2)});
                    }
                    throw new NO_MEMORY(string);
                }
                if (byteBuffer.capacity() != n2) {
                    String string = "Buffers's capacity does not match specified length.";
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "<init>", new Object[]{string, new Integer(byteBuffer.capacity()), new Integer(n2)});
                    }
                    throw new IndexOutOfBoundsException(string);
                }
                ++this._buffersCreated;
                if (this._maxLengthBuffer >= n2) break;
                this._maxLengthBuffer = n2;
                break;
            }
            byteBuffer = (ByteBuffer)linkedList.removeFirst();
            --this._buffersAvailable;
            break;
        }
        byteBuffer.limit(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "allocateDirect", new Object[]{new Integer(n), new Integer(byteBuffer.limit()), new Integer(n2), new Integer(byteBuffer.capacity())});
        }
        return byteBuffer;
    }

    public synchronized void returnBufferToPool(ByteBuffer byteBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnBufferToPool", byteBuffer);
        }
        int n = byteBuffer.capacity();
        int n2 = 0;
        for (int i = 0; i < 32; ++i) {
            if ((n2 += 128) > 4000) {
                n2 = 4000;
            }
            if (n > n2) continue;
            LinkedList linkedList = this._pool[i];
            byteBuffer.clear();
            linkedList.addLast(byteBuffer);
            ++this._buffersAvailable;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnBufferToPool", byteBuffer);
        }
    }

    public synchronized void clearByteBuffer(ByteBuffer byteBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "clearByteBuffer", byteBuffer);
        }
        try {
            if (byteBuffer.capacity() == 4000) {
                byte[] byArray = new byte[4000];
                byteBuffer.put(byArray);
            } else {
                int n = byteBuffer.limit();
                byteBuffer.clear();
                for (int i = 128; i <= byteBuffer.capacity(); i += 128) {
                    byteBuffer.put(nullArray);
                }
                byteBuffer.limit(n);
            }
        }
        catch (Throwable throwable) {
            String string = "Error clearing byte buffer.";
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "clearbyteBuffer", new Object[]{string, new Integer(byteBuffer.capacity()), throwable});
            }
            throw new IndexOutOfBoundsException(string);
        }
        byteBuffer.rewind();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "clearByteBuffer", byteBuffer);
        }
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TransactionByteBufferPoolManager: ");
        stringBuffer.append("Pool list length: " + this._pool.length);
        stringBuffer.append(", Buffers Created: " + this._buffersCreated);
        stringBuffer.append(", Buffers Available: " + this._buffersAvailable);
        stringBuffer.append(", Max Length Buffer Created: " + this._maxLengthBuffer);
        return stringBuffer.toString();
    }
}

