/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.TxPrimaryKey;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.ResourceCallback;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.runtime.component.TxServiceImpl;
import com.ibm.ws.util.ImplFactory;
import com.ibm.ws.util.SRAggregator;
import com.ibm.ws390.tx.BranchRegistryTable;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.LockHierarchy;
import com.ibm.ws390.tx.LockableHashMap;
import com.ibm.ws390.tx.LockableObject;
import com.ibm.ws390.tx.ReaderWriterLock;
import com.ibm.ws390.tx.ResourceManager;
import com.ibm.ws390.tx.RestartURData;
import com.ibm.ws390.tx.SyncpointInterest;
import com.ibm.ws390.tx.TranAffinityMarker;
import com.ibm.ws390.tx.TransactionByteBufferPoolManager;
import com.ibm.ws390.tx.TransactionCoordinatorImpl;
import com.ibm.ws390.tx.TransactionRecoveryCoordinatorImpl;
import com.ibm.ws390.tx.TransactionResolver;
import com.ibm.ws390.tx.TransactionResourceImpl;
import com.ibm.ws390.tx.TransactionSynchronizer;
import com.ibm.ws390.tx.TransactionTerminatorImpl;
import com.ibm.ws390.tx.TransactionalUnitOfWork;
import com.ibm.ws390.tx.alarm.CorbaTimeout;
import com.ibm.ws390.tx.alarm.TimeoutHelperCorbaImpl;
import com.ibm.ws390.tx.syncpoint.SyncpointFailedException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CosTransactions.Status;

public final class TransactionControlRep
implements LockableObject {
    private static final TraceComponent tc = Tr.register(TransactionControlRep.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private TransactionalUnitOfWork _uow = null;
    private TransactionCoordinatorImpl _coord = null;
    private TransactionTerminatorImpl _termImpl = null;
    private TransactionRecoveryCoordinatorImpl _recCoordImpl = null;
    private TransactionResourceImpl _resImpl = null;
    private TransactionSynchronizer _sync = null;
    private TransactionResolver _resolver = null;
    private ReaderWriterLock _txLock = null;
    private XidImpl _xid = null;
    private int _transactionType;
    private int _transactionExecutionType;
    private boolean _root = true;
    private boolean _normal = true;
    private boolean _cascaded = false;
    private boolean _jca;
    private int _jcaFormatId = 0;
    private byte[] _jcaBqual = null;
    private boolean _wsat = false;
    private int _txState = 0;
    private boolean _committed = false;
    private boolean _mbeanResolved = false;
    private int _threadAssociationCount = 0;
    private boolean _contextDisassociated = false;
    private boolean _contextPinned = false;
    private byte[] _stoken = null;
    private byte[] _parentUrToken = null;
    private boolean _needsManualOutcome;
    private boolean _transactionTimedOut = false;
    private ArrayList _destroyCallbacks = null;
    private static final TransactionByteBufferPoolManager _poolMgr = TransactionByteBufferPoolManager.instance();
    public static final int INITIAL = 0;
    public static final int BEGUN = 1;
    public static final int VISIBLE = 2;
    public static final int ACTIVE = 3;
    public static final int MARKED_ROLLBACK = 4;
    public static final int PRE_PREPARE = 5;
    public static final int PREPARING = 6;
    public static final int PREPARED = 7;
    public static final int COMMITTING = 8;
    public static final int COMMITTED = 9;
    public static final int ROLLING_BACK = 10;
    public static final int ROLLED_BACK = 11;
    public static final int FORGET = 12;
    public static final int DELETING = 13;
    public static final int DELETED = 14;
    public static final int COMMITTING_RESTARTED = 15;
    public static final int ROLLING_BACK_RESTARTED = 16;
    public static final int COMMITTING_DELEGATED = 17;
    public static final int THICK_CLIENT_INITIATED = 0;
    public static final int THIN_CLIENT_INITIATED = 1;
    public static final int SERVER_REGION_INITIATED = 2;
    public static final int CONTROL_REGION_INITIATED = 3;
    public static final int CONTROL_REGION_EXECUTED = 4;
    public static final int SERVER_REGION_EXECUTED = 5;
    public static final int UNKNOWN_EXECUTED = 6;
    public static final int THICK_CLIENT_DEFERRED = 7;
    public static final int SERVER_REGION_DEFERRED = 8;
    static final boolean[][] validStateChange = new boolean[][]{{false, true, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false}, {false, false, true, true, false, false, false, true, false, false, false, false, false, true, false, true, true, false}, {false, false, false, true, false, false, false, false, false, false, false, false, false, true, false, false, false, false}, {false, false, false, false, true, true, false, false, false, false, true, false, false, false, false, false, false, false}, {false, false, false, false, false, false, true, false, false, false, true, false, false, false, false, false, false, true}, {false, false, false, false, true, false, true, false, false, false, false, false, false, false, false, false, false, true}, {false, false, false, false, false, false, true, true, true, true, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, false, true, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, true, true, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, true, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false}, {false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false}, {false, false, false, false, false, false, false, false, true, false, true, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, true, false, true, false, false, true, false, false, false, false}, {false, false, false, false, false, false, false, false, true, true, true, true, false, false, false, false, false, false}};

    TransactionControlRep(boolean bl, boolean bl2, boolean bl3, XidImpl xidImpl, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            ByteArray byteArray = null;
            if (byArray != null) {
                byteArray = new ByteArray(byArray);
            }
            Tr.entry(tc, "TransactionControlRep", new Object[]{new Boolean(bl), new Boolean(bl2), new Boolean(bl3), xidImpl, byteArray});
        }
        this._txLock = new ReaderWriterLock(2);
        this._txState = 0;
        this._xid = xidImpl;
        this._normal = true;
        this._root = bl;
        this._jca = bl2;
        this._wsat = bl3;
        this._cascaded = byArray != null;
        this._parentUrToken = byArray;
        this._uow = new TransactionalUnitOfWork(this);
        this._sync = new TransactionSynchronizer(this);
        this._recCoordImpl = new TransactionRecoveryCoordinatorImpl(this);
        this._coord = new TransactionCoordinatorImpl(this);
        this._resolver = new TransactionResolver(this);
        if (this._root) {
            this._termImpl = new TransactionTerminatorImpl(this);
        } else {
            this._resImpl = new TransactionResourceImpl(this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionControlRep", this);
        }
    }

    TransactionControlRep(RestartURData restartURData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", restartURData);
        }
        this._txLock = new ReaderWriterLock(2);
        SyncpointInterest syncpointInterest = restartURData.getSyncpointInterest();
        this._root = syncpointInterest.isRoot();
        this._normal = false;
        this._cascaded = syncpointInterest.isCascaded();
        this._xid = restartURData.getXid();
        this._jca = syncpointInterest.isJcaImported();
        this._uow = new TransactionalUnitOfWork(this, restartURData);
        this._recCoordImpl = new TransactionRecoveryCoordinatorImpl(this);
        if (!this._root) {
            this._resImpl = new TransactionResourceImpl(this);
        }
        syncpointInterest.setControlRep(this);
        this._resolver = new TransactionResolver(this);
        if (this._jca) {
            this._jcaFormatId = syncpointInterest.getJcaFormatId();
            this._jcaBqual = syncpointInterest.getJcaBqual();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public Status getStatus() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getStatus");
        }
        Status status = Status.StatusUnknown;
        switch (this._txState) {
            case 0: 
            case 1: {
                String string = "Transaction Status check from state INITIAL OR BEGUN to " + this._txState;
                INTERNAL iNTERNAL = new INTERNAL(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getStatus", (Object)iNTERNAL);
                }
                throw iNTERNAL;
            }
            case 2: 
            case 3: {
                status = Status.StatusActive;
                break;
            }
            case 4: {
                status = Status.StatusMarkedRollback;
                break;
            }
            case 5: 
            case 6: 
            case 17: {
                status = Status.StatusPreparing;
                break;
            }
            case 7: {
                status = Status.StatusPrepared;
                break;
            }
            case 8: 
            case 15: {
                status = Status.StatusCommitting;
                break;
            }
            case 9: {
                status = Status.StatusCommitted;
                this._committed = true;
                break;
            }
            case 10: 
            case 16: {
                status = Status.StatusRollingBack;
                break;
            }
            case 11: {
                status = Status.StatusRolledBack;
                this._committed = false;
                break;
            }
            case 12: {
                if (this._committed) {
                    status = Status.StatusCommitted;
                    break;
                }
                status = Status.StatusRolledBack;
                break;
            }
            case 13: 
            case 14: {
                status = Status.StatusNoTransaction;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getStatus", new Integer(status.value()));
        }
        return status;
    }

    void changeState(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "changeState", new Integer(n));
        }
        if (!validStateChange[this._txState][n]) {
            String string = "TransactionState change FAILED from: " + this._txState + ", to: " + n;
            INTERNAL iNTERNAL = new INTERNAL(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "changeState", (Object)iNTERNAL);
            }
            throw iNTERNAL;
        }
        this._txState = n;
    }

    public void setTimedOut() {
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setTimedOut");
            }
            if (this._transactionTimedOut) {
                return;
            }
            this._transactionTimedOut = true;
            byte[] byArray = this._uow.getURID();
            String string = this._uow.getURID() == null ? "null" : Util.toHexString(byArray);
            Tr.info(tc, "BBOT0003_TX_TIMEOUT", new Object[]{string, new Integer(this._coord.getTimeout()), this._coord.get_transaction_name()});
            final byte[] byArray2 = this.getPrimaryKey().toBytes();
            byte[] byArray3 = this.getServantStoken();
            if (byArray3 == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "setTimedOut");
                }
                return;
            }
            Iterator iterator = AdminServiceImpl.getPlatformUtils().getSRAggregator(new TimeoutHelperCorbaImpl(), false, byArray3);
            try {
                final CorbaTimeout corbaTimeout = (CorbaTimeout)iterator.next();
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() {
                        corbaTimeout.processTimeout(byArray2);
                        return null;
                    }
                };
                TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "Security violation during setTimout", privilegedActionException.getCause());
                }
            }
            catch (NoSuchElementException noSuchElementException) {
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "setTimedOut", noSuchElementException);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEntryEnabled()) break block11;
                Tr.event(tc, "setTimedOut", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTimedOut");
        }
    }

    public boolean getTimedOut() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimedOut");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimedOut", new Boolean(this._transactionTimedOut));
        }
        return this._transactionTimedOut;
    }

    void beforeCompletion() throws SyncpointFailedException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeCompletion");
        }
        this._sync.before_completion();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeCompletion");
        }
    }

    void afterCompletion(Status status) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion", new Integer(status.value()));
        }
        this._sync.after_completion(status);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }

    public void obtainExclusiveTxLock() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "obtainExclusiveTxLock");
        }
        LockHierarchy lockHierarchy = this.getLockHierarchy();
        this._txLock.obtainWrite(lockHierarchy);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "obtainExclusiveTxLock");
        }
    }

    public LockHierarchy getLockHierarchy() {
        ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
        return controllerTransactionManagerSet.getLockHierarchy();
    }

    public void releaseTxLock() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseTxLock");
        }
        LockHierarchy lockHierarchy = this.getLockHierarchy();
        this._txLock.releaseWrite(lockHierarchy);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseTxLock");
        }
    }

    public TransactionalUnitOfWork getUnitOfWork() {
        return this._uow;
    }

    TransactionRecoveryCoordinatorImpl getRecoveryCoordinatorImpl() {
        return this._recCoordImpl;
    }

    TransactionTerminatorImpl getTerminatorImpl() {
        return this._termImpl;
    }

    TransactionCoordinatorImpl getCoordinatorImpl() {
        return this._coord;
    }

    public TransactionResolver getResolver() {
        return this._resolver;
    }

    public TransactionResourceImpl getResourceImpl() {
        return this._resImpl;
    }

    TransactionSynchronizer getSynchronizer() {
        return this._sync;
    }

    public XidImpl getXid() {
        return this._xid;
    }

    TxPrimaryKey getPrimaryKey() {
        return this._xid.getPrimaryKey();
    }

    public ReaderWriterLock getLock() {
        return this._txLock;
    }

    int getTransactionType() {
        return this._transactionType;
    }

    void setTransactionType(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 7) {
            throw new IllegalArgumentException("Invalid transaction type: " + n);
        }
        this._transactionType = n;
    }

    int getTransactionExecutionType() {
        return this._transactionExecutionType;
    }

    void setTransactionExecutionType(int n) {
        if (n != 4 && n != 5 && n != 8 && n != 6) {
            throw new IllegalArgumentException("Invalid transaction execution type: " + n);
        }
        this._transactionExecutionType = n;
    }

    public int getState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getState");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getState", new Integer(this._txState));
        }
        return this._txState;
    }

    void incrementAssociation() {
        ++this._threadAssociationCount;
    }

    void decrementAssociation() {
        --this._threadAssociationCount;
    }

    int getThreadAssociationCount() {
        return this._threadAssociationCount;
    }

    boolean outstandingReplies() {
        return this._threadAssociationCount > 0;
    }

    boolean isContextActive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isContextActive");
        }
        boolean bl = true;
        if (!this.isContextPinned() || this._transactionExecutionType == 5 && !this.isServantAlive()) {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isContextActive", new Boolean(bl));
        }
        return bl;
    }

    boolean isJCA() {
        return this._jca;
    }

    boolean isWSAT() {
        return this._wsat;
    }

    void setInboundJcaFormatId(int n) {
        this._jcaFormatId = n;
    }

    int getJcaFormatId() {
        return this._jcaFormatId;
    }

    void setInboundJcaBqual(byte[] byArray) {
        this._jcaBqual = byArray;
    }

    byte[] getJcaBqual() {
        return this._jcaBqual;
    }

    public boolean isRoot() {
        return this._root;
    }

    public boolean isCascaded() {
        return this._cascaded;
    }

    public byte[] getParentUrToken() {
        byte[] byArray = null;
        if (this._normal && this._cascaded) {
            byArray = this._parentUrToken;
        }
        return byArray;
    }

    public boolean isNormal() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isNormal");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isNormal", new Boolean(this._normal));
        }
        return this._normal;
    }

    void setContextDisassociated() {
        this._contextDisassociated = true;
    }

    public void setManualOutcome() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setManualOutcome");
        }
        this._needsManualOutcome = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setManualOutcome");
        }
    }

    public boolean isManualOutcome() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isManualOutcome");
            Tr.exit(tc, "isManualOutcome", new Boolean(this._needsManualOutcome));
        }
        return this._needsManualOutcome;
    }

    boolean isContextDisassociated() {
        return this._contextDisassociated;
    }

    void setContextPinned() {
        this._contextPinned = true;
    }

    void resetContextPinned() {
        this._contextPinned = false;
    }

    boolean isContextPinned() {
        return this._contextPinned;
    }

    void saveServantToken(byte[] byArray) {
        this._stoken = byArray;
    }

    byte[] getServantStoken() {
        return this._stoken;
    }

    boolean isServantAlive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isServantAlive");
        }
        boolean bl = false;
        if (this._stoken != null) {
            try {
                final SRAggregator sRAggregator = (SRAggregator)ImplFactory.loadImplFromKey(SRAggregator.class);
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() {
                        return new Boolean(sRAggregator.isServantActive(TransactionControlRep.this._stoken));
                    }
                };
                bl = (Boolean)TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "Security violation while checking if server is alive.", privilegedActionException.getCause());
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "No stoken, assume servant is dead");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isServantAlive", new Boolean(bl));
        }
        return bl;
    }

    boolean isTxMBeanResolved() {
        return this._mbeanResolved;
    }

    public void setTxMbeanResolved() {
        this._mbeanResolved = true;
    }

    void addDestroyCallback(ResourceCallback resourceCallback) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addDestroyCallback", resourceCallback);
        }
        if (this._destroyCallbacks == null) {
            this._destroyCallbacks = new ArrayList();
        }
        this._destroyCallbacks.add(resourceCallback);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addDestroyCallback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy(LockHierarchy lockHierarchy) {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy", this);
        }
        this.changeState(13);
        this._resolver.stop();
        this._txLock.releaseWrite(lockHierarchy);
        try {
            object2 = ControllerTransactionManagerSet.instance();
            object = ((ControllerTransactionManagerSet)object2).getPsbrMap();
            if (this._normal) {
                boolean bl = false;
                ByteArray byteArray = new ByteArray(this._xid.getGlobalTransactionId());
                BranchRegistryTable branchRegistryTable = (BranchRegistryTable)((LockableHashMap)object).get(byteArray, true, lockHierarchy);
                if (branchRegistryTable == null) {
                    INTERNAL iNTERNAL = new INTERNAL(-910026511, CompletionStatus.COMPLETED_NO);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "destroy", (Object)iNTERNAL);
                    }
                    throw iNTERNAL;
                }
                try {
                    branchRegistryTable.removeEntry(this._xid.getBranchQualifier());
                    bl = branchRegistryTable.isEmpty();
                }
                finally {
                    branchRegistryTable.getLock().releaseWrite(lockHierarchy);
                }
                if (bl) {
                    TranAffinityMarker tranAffinityMarker = branchRegistryTable.getAffinityMarker();
                    if (tranAffinityMarker.areEnqsHeld()) {
                        tranAffinityMarker.releaseENQs();
                    }
                    ((LockableHashMap)object).remove(byteArray, lockHierarchy);
                }
            }
            object = ((ControllerTransactionManagerSet)object2).getGtidMap();
            ((LockableHashMap)object).remove(this._xid, lockHierarchy);
            if (!this._normal) {
                ResourceManager resourceManager = ((ControllerTransactionManagerSet)object2).getResourceManager();
                resourceManager.restartTranCompleted(this.getUnitOfWork().getURID(), lockHierarchy);
            }
        }
        finally {
            this._txLock.obtainWrite(lockHierarchy);
        }
        if (this._destroyCallbacks != null) {
            for (int i = this._destroyCallbacks.size(); i > 0; --i) {
                object = (ResourceCallback)this._destroyCallbacks.get(i - 1);
                object.destroy();
            }
        }
        if (this._normal && !this._contextDisassociated) {
            object2 = BranchRegistryTable.xidToGtid(this._xid);
            this.setContextDisassociated();
            this._txLock.releaseWrite(lockHierarchy);
            try {
                ControllerTransactionManagerSet.instance().divorceContext((byte[])object2);
            }
            finally {
                this._txLock.obtainWrite(lockHierarchy);
            }
        }
        this.changeState(14);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "destroy", _poolMgr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy", this);
        }
    }
}

