/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.TxPrimaryKey;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.ResourceCallback;
import com.ibm.ws.Transaction.JTS.TxStatusHelper;
import com.ibm.ws.wscoor.ProtocolSecurityHelper;
import com.ibm.ws390.tx.LockHierarchy;
import com.ibm.ws390.tx.ReaderWriterLock;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionCoordinatorImpl;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions._CoordinatorImplBase;

public class TransactionCoordinator
extends _CoordinatorImplBase
implements ResourceCallback {
    private static final TraceComponent tc = Tr.register(TransactionCoordinator.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private TransactionCoordinatorImpl _coordImpl;

    public TransactionCoordinator(TransactionCoordinatorImpl transactionCoordinatorImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionCoordinator", transactionCoordinatorImpl);
        }
        this._coordImpl = transactionCoordinatorImpl;
        TransactionControlRep transactionControlRep = transactionCoordinatorImpl.getControlRep();
        FailureScopeController failureScopeController = Configuration.getFailureScopeController();
        TxPrimaryKey txPrimaryKey = transactionControlRep.getPrimaryKey();
        failureScopeController.registerCoordinator(this, txPrimaryKey.toBytes());
        transactionControlRep.addDestroyCallback(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionCoordinator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status get_status() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_status");
        }
        Status status = null;
        ProtocolSecurityHelper.checkAuthorization();
        TransactionControlRep transactionControlRep = this._coordImpl.getControlRep();
        LockHierarchy lockHierarchy = transactionControlRep.getLockHierarchy();
        ReaderWriterLock readerWriterLock = transactionControlRep.getLock();
        readerWriterLock.obtainWrite(lockHierarchy);
        try {
            status = this._coordImpl.get_status();
        }
        finally {
            readerWriterLock.releaseWrite(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get_status", TxStatusHelper.getCORBAStatusAsString(status));
        }
        return status;
    }

    public Status get_parent_status() {
        return this.get_status();
    }

    public Status get_top_level_status() {
        return this.get_status();
    }

    public boolean is_same_transaction(Coordinator coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_same_transaction");
        }
        ProtocolSecurityHelper.checkAuthorization();
        boolean bl = this._coordImpl.is_same_transaction(coordinator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_same_transaction", new Boolean(bl));
        }
        return bl;
    }

    public boolean is_ancestor_transaction(Coordinator coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_ancestor_transaction", coordinator);
        }
        ProtocolSecurityHelper.checkAuthorization();
        boolean bl = this._coordImpl.is_ancestor_transaction(coordinator);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_ancestor_transaction", new Boolean(bl));
        }
        return bl;
    }

    public boolean is_related_transaction(Coordinator coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_realted_transaction", coordinator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_related_transaction");
        }
        return this.is_ancestor_transaction(coordinator);
    }

    public boolean is_descendant_transaction(Coordinator coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_descendant_transaction", coordinator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_descendant_transaction");
        }
        return this.is_same_transaction(coordinator);
    }

    public boolean is_top_level_transaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_top_level_transaction", this);
        }
        ProtocolSecurityHelper.checkAuthorization();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_top_level_transaction", new Boolean(true));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hash_transaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hash_transaction", this);
        }
        int n = 0;
        ProtocolSecurityHelper.checkAuthorization();
        TransactionControlRep transactionControlRep = this._coordImpl.getControlRep();
        LockHierarchy lockHierarchy = transactionControlRep.getLockHierarchy();
        ReaderWriterLock readerWriterLock = transactionControlRep.getLock();
        readerWriterLock.obtainWrite(lockHierarchy);
        try {
            n = this._coordImpl.hash_transaction();
        }
        finally {
            readerWriterLock.releaseWrite(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hash_transaction", new Integer(n));
        }
        return n;
    }

    public int hash_top_level_tran() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hash_top_level_tran", this);
        }
        int n = this.hash_transaction();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hash_top_level_tran", new Integer(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RecoveryCoordinator register_resource(Resource resource) throws Inactive {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register_resource", resource);
        }
        RecoveryCoordinator recoveryCoordinator = null;
        ProtocolSecurityHelper.checkAuthorization();
        TransactionControlRep transactionControlRep = this._coordImpl.getControlRep();
        LockHierarchy lockHierarchy = transactionControlRep.getLockHierarchy();
        ReaderWriterLock readerWriterLock = transactionControlRep.getLock();
        readerWriterLock.obtainWrite(lockHierarchy);
        try {
            recoveryCoordinator = this._coordImpl.register_resource(resource);
        }
        finally {
            readerWriterLock.releaseWrite(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register_resource", recoveryCoordinator);
        }
        return recoveryCoordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register_synchronization(Synchronization synchronization) throws Inactive, SynchronizationUnavailable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register_synchronization", synchronization);
        }
        ProtocolSecurityHelper.checkAuthorization();
        TransactionControlRep transactionControlRep = this._coordImpl.getControlRep();
        LockHierarchy lockHierarchy = transactionControlRep.getLockHierarchy();
        ReaderWriterLock readerWriterLock = transactionControlRep.getLock();
        readerWriterLock.obtainWrite(lockHierarchy);
        try {
            this._coordImpl.register_synchronization(synchronization);
        }
        finally {
            readerWriterLock.releaseWrite(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register_synchronization");
        }
    }

    public void register_subtran_aware(SubtransactionAwareResource subtransactionAwareResource) throws NotSubtransaction {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register_subtran_aware", subtransactionAwareResource);
        }
        ProtocolSecurityHelper.checkAuthorization();
        this._coordImpl.register_subtran_aware(subtransactionAwareResource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback_only() throws Inactive {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "rollback_only", this);
        }
        ProtocolSecurityHelper.checkAuthorization();
        TransactionControlRep transactionControlRep = this._coordImpl.getControlRep();
        LockHierarchy lockHierarchy = transactionControlRep.getLockHierarchy();
        ReaderWriterLock readerWriterLock = transactionControlRep.getLock();
        readerWriterLock.obtainWrite(lockHierarchy);
        try {
            this._coordImpl.rollback_only();
        }
        finally {
            readerWriterLock.releaseWrite(lockHierarchy);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "rollback_only");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_transaction_name() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "get_transaction_name", this);
        }
        String string = null;
        ProtocolSecurityHelper.checkAuthorization();
        TransactionControlRep transactionControlRep = this._coordImpl.getControlRep();
        LockHierarchy lockHierarchy = transactionControlRep.getLockHierarchy();
        ReaderWriterLock readerWriterLock = transactionControlRep.getLock();
        readerWriterLock.obtainWrite(lockHierarchy);
        try {
            string = this._coordImpl.get_transaction_name();
        }
        finally {
            readerWriterLock.releaseWrite(lockHierarchy);
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "get_transaction_name", string);
        }
        return string;
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create_subtransaction", this);
        }
        ProtocolSecurityHelper.checkAuthorization();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create_subtransaction");
        }
        return this._coordImpl.create_subtransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropagationContext get_txcontext() {
        PropagationContext propagationContext;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_txcontext", this);
        }
        ProtocolSecurityHelper.checkAuthorization();
        TransactionControlRep transactionControlRep = this._coordImpl.getControlRep();
        LockHierarchy lockHierarchy = transactionControlRep.getLockHierarchy();
        ReaderWriterLock readerWriterLock = transactionControlRep.getLock();
        readerWriterLock.obtainWrite(lockHierarchy);
        try {
            propagationContext = this._coordImpl.get_txcontext();
        }
        finally {
            readerWriterLock.releaseWrite(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get_txcontext", propagationContext);
        }
        return propagationContext;
    }

    public String toString() {
        return Util.identity(this);
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy", this);
        }
        FailureScopeController failureScopeController = Configuration.getFailureScopeController();
        TxPrimaryKey txPrimaryKey = this._coordImpl.getControlRep().getPrimaryKey();
        failureScopeController.unregisterCoordinator(txPrimaryKey.toBytes());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy", this);
        }
    }
}

