/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.GlobalTID;
import com.ibm.ws.Transaction.JTS.TxStatusHelper;
import com.ibm.ws.runtime.component.TxServiceImpl;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionCoordinator;
import com.ibm.ws390.tx.TransactionRecoveryCoordinator;
import com.ibm.ws390.tx.TransactionResource;
import com.ibm.ws390.tx.TransactionalUnitOfWork;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotSubtransaction;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionAwareResource;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Synchronization;
import org.omg.CosTransactions.SynchronizationUnavailable;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.Unavailable;
import org.omg.CosTransactions.otid_t;

public class TransactionCoordinatorImpl {
    private static final TraceComponent tc = Tr.register(TransactionCoordinatorImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private TransactionCoordinator _remoteCoord;
    private Coordinator _superiorCoord;
    private RecoveryCoordinator _superiorRecCoord;
    private int _timeout;
    private TransactionControlRep _controlRep;
    private TransactionalUnitOfWork _uow;
    private final ORB _orb;

    public TransactionCoordinatorImpl(TransactionControlRep transactionControlRep) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionCoordinatorImpl", transactionControlRep);
        }
        this._controlRep = transactionControlRep;
        this._uow = transactionControlRep.getUnitOfWork();
        this._orb = Configuration.getORB();
        this._remoteCoord = new TransactionCoordinator(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionCoordinatorImpl");
        }
    }

    public Status get_status() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_status");
        }
        Status status = Status.StatusNoTransaction;
        if (this._controlRep != null) {
            status = this._controlRep.getStatus();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get_status", TxStatusHelper.getCORBAStatusAsString(status));
        }
        return status;
    }

    public Status get_parent_status() {
        return this.get_status();
    }

    public Status get_top_level_status() {
        return this.get_status();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean is_same_transaction(Coordinator coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_same_transaction");
        }
        boolean bl = false;
        PropagationContext propagationContext = null;
        if (coordinator == null) {
            String string = "Null Coordinator object parameter.";
            BAD_PARAM bAD_PARAM = new BAD_PARAM(string, -909982202, CompletionStatus.COMPLETED_NO);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "is_same_transaction", (Object)bAD_PARAM);
            }
            throw bAD_PARAM;
        }
        try {
            propagationContext = coordinator.get_txcontext();
        }
        catch (Unavailable unavailable) {
            String string = "Coordinator does not contain a valid context.";
            BAD_PARAM bAD_PARAM = new BAD_PARAM(string, -909982201, CompletionStatus.COMPLETED_NO);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "is_same_transaction", (Object)bAD_PARAM);
            }
            throw bAD_PARAM;
        }
        try {
            this._controlRep.obtainExclusiveTxLock();
            if (this._controlRep.getState() == 13) {
                String string = "Attempted to access transactional objects that no longer exist";
                OBJECT_NOT_EXIST oBJECT_NOT_EXIST = new OBJECT_NOT_EXIST(string, -910026713, CompletionStatus.COMPLETED_NO);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "is_same_transaction", new Object[]{new Boolean(bl), oBJECT_NOT_EXIST});
                }
                throw oBJECT_NOT_EXIST;
            }
            otid_t otid_t2 = propagationContext.current.otid;
            if (otid_t2 == null) {
                String string = "Inbound propagation context contains invalid OTID";
                BAD_PARAM bAD_PARAM = new BAD_PARAM(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "is_same_transaction", new Object[]{new Boolean(bl), bAD_PARAM});
                }
                throw bAD_PARAM;
            }
            GlobalTID globalTID = new GlobalTID(otid_t2);
            GlobalTID globalTID2 = new GlobalTID(this._controlRep.getXid());
            if (globalTID2.equals(globalTID)) {
                bl = true;
            }
        }
        finally {
            this._controlRep.releaseTxLock();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_same_transaction", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean is_ancestor_transaction(Coordinator coordinator) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_ancestor_transaction", coordinator);
        }
        if (!(bl = this.is_same_transaction(coordinator))) {
            this._controlRep.obtainExclusiveTxLock();
            try {
                if (this._controlRep.getState() == 13) {
                    String string = "Attempted to access transactional objects that no longer exist";
                    OBJECT_NOT_EXIST oBJECT_NOT_EXIST = new OBJECT_NOT_EXIST(string, -910026713, CompletionStatus.COMPLETED_NO);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "is_same_transaction", (Object)oBJECT_NOT_EXIST);
                    }
                    throw oBJECT_NOT_EXIST;
                }
                PropagationContext propagationContext = coordinator.get_txcontext();
                if (propagationContext.parents != null && propagationContext.parents.length > 0) {
                    for (int i = 0; i < propagationContext.parents.length; ++i) {
                        if (propagationContext.parents[i].coord == null || !this.is_same_transaction(propagationContext.parents[i].coord)) continue;
                        bl = true;
                    }
                }
            }
            catch (UserException userException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Could not obtain parents", (Object)userException);
                }
            }
            finally {
                this._controlRep.releaseTxLock();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_ancestor_transaction", new Boolean(bl));
        }
        return bl;
    }

    public boolean is_related_transaction(Coordinator coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_realted_transaction", coordinator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_related_transaction");
        }
        return this.is_ancestor_transaction(coordinator);
    }

    public boolean is_descendant_transaction(Coordinator coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_descendant_transaction", coordinator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_descendant_transaction");
        }
        return this.is_same_transaction(coordinator);
    }

    public boolean is_top_level_transaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "is_top_level_transaction", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "is_top_level_transaction", new Boolean(true));
        }
        return true;
    }

    public int hash_transaction() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hash_transaction", this);
        }
        int n = this._controlRep.getXid().hashCode();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hash_transaction", new Integer(n));
        }
        return n;
    }

    public int hash_top_level_tran() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hash_top_level_tran", this);
        }
        int n = this.hash_transaction();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hash_top_level_tran", new Integer(n));
        }
        return n;
    }

    public synchronized RecoveryCoordinator register_resource(Resource resource) throws Inactive {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register_resource", resource);
        }
        if (resource == null) {
            String string = "Null Resource object parameter.";
            BAD_PARAM bAD_PARAM = new BAD_PARAM(string, -909982204, CompletionStatus.COMPLETED_NO);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "register_resource", (Object)bAD_PARAM);
            }
            throw bAD_PARAM;
        }
        int n = this._controlRep.getState();
        if (n == 4) {
            String string = "Transaction is already marked rollback only.";
            TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(string, -910026739, CompletionStatus.COMPLETED_NO);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "register_resource", (Object)tRANSACTION_ROLLEDBACK);
            }
            throw tRANSACTION_ROLLEDBACK;
        }
        if (n != 2 && n != 3) {
            String string = "Inactive transaction. Registration rejected";
            Inactive inactive = new Inactive(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "register_resource", (Object)inactive);
            }
            throw inactive;
        }
        this._uow.registerResource(resource);
        TransactionRecoveryCoordinator transactionRecoveryCoordinator = this._controlRep.getRecoveryCoordinatorImpl().getRemoteRecoveryCoordinator();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register_resource", transactionRecoveryCoordinator);
        }
        return transactionRecoveryCoordinator;
    }

    public void register_synchronization(Synchronization synchronization) throws Inactive, SynchronizationUnavailable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register_synchronization", synchronization);
        }
        if (synchronization == null) {
            String string = "Null Synchronization object parameter.";
            BAD_PARAM bAD_PARAM = new BAD_PARAM(string, -909982203, CompletionStatus.COMPLETED_NO);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "register_synchronization", (Object)bAD_PARAM);
            }
            throw bAD_PARAM;
        }
        int n = this._controlRep.getState();
        if (n == 2 || n == 3) {
            Inactive inactive = new Inactive("Inactive transaction. Sync registration rejected");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "register_synchronization", (Object)inactive);
            }
            throw inactive;
        }
        if (n == 4) {
            TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK("Transaction is already marked rollback only.", -910026738, CompletionStatus.COMPLETED_NO);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "register_synchronization", (Object)tRANSACTION_ROLLEDBACK);
            }
            throw tRANSACTION_ROLLEDBACK;
        }
        if (!this._controlRep.isRoot()) {
            if (this._superiorCoord == null) {
                String string = "Null superior coordinator.";
                OBJECT_NOT_EXIST oBJECT_NOT_EXIST = new OBJECT_NOT_EXIST(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "register_synchronization", (Object)oBJECT_NOT_EXIST);
                }
                throw oBJECT_NOT_EXIST;
            }
            try {
                this._superiorCoord.register_synchronization(synchronization);
            }
            catch (SystemException systemException) {
                this._uow.rollbackOnly();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "register_synchronization", (Object)systemException);
                }
                throw systemException;
            }
            catch (Inactive inactive) {
                this._uow.rollbackOnly();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "register_synchronization", (Object)inactive);
                }
                throw inactive;
            }
            catch (SynchronizationUnavailable synchronizationUnavailable) {
                this._uow.rollbackOnly();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "register_synchronization", (Object)synchronizationUnavailable);
                }
                throw synchronizationUnavailable;
            }
            catch (Throwable throwable) {
                this._uow.rollbackOnly();
                String string = "Unknown error during sync Reg with superior coord";
                UNKNOWN uNKNOWN = new UNKNOWN(string, -910026737, CompletionStatus.COMPLETED_NO);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "register_synchronization", uNKNOWN);
                }
                throw uNKNOWN;
            }
        } else {
            this._controlRep.getSynchronizer().register_synchronization(synchronization);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register_synchronization");
        }
    }

    public void register_subtran_aware(SubtransactionAwareResource subtransactionAwareResource) throws NotSubtransaction {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "register_subtran_aware", subtransactionAwareResource);
        }
        String string = "No subtransaction support";
        NotSubtransaction notSubtransaction = new NotSubtransaction(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "register_subtran_aware", (Object)notSubtransaction);
        }
        throw notSubtransaction;
    }

    public void rollback_only() throws Inactive {
        this.rollback_only(true);
    }

    public void rollback_only(boolean bl) throws Inactive {
        block7: {
            int n;
            if (tc.isDebugEnabled()) {
                Tr.entry(tc, "rollback_only", new Object[]{new Boolean(bl), this});
            }
            if ((n = this._controlRep.getState()) == 4) {
                return;
            }
            if (n != 3 && n != 1 && n != 2 && n != 5) {
                String string = "Inactive Transction. Rollback_only not processed.";
                Inactive inactive = new Inactive(string);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "rollback_only", (Object)inactive);
                }
                throw inactive;
            }
            try {
                this._uow.rollbackOnly(bl);
            }
            catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "rollbackOnly. Expected exception. Do nothing.", (Object)tRANSACTION_ROLLEDBACK);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback_only");
        }
    }

    public String get_transaction_name() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_transaction_name", this);
        }
        byte[] byArray = this._controlRep.getXid().getOtidBytes();
        String string = Util.toHexString(byArray).toUpperCase();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get_transaction_name", string);
        }
        return string;
    }

    public Control create_subtransaction() throws SubtransactionsUnavailable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "create_subtransaction", this);
        }
        SubtransactionsUnavailable subtransactionsUnavailable = new SubtransactionsUnavailable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "create_subtransaction", (Object)subtransactionsUnavailable);
        }
        throw subtransactionsUnavailable;
    }

    public PropagationContext get_txcontext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "get_txcontext", this);
        }
        int n = this._timeout;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "PC context.timeout", new Integer(n));
        }
        Any any = this._orb.create_any();
        any.insert_boolean(false);
        GlobalTID globalTID = new GlobalTID(this._controlRep.getXid());
        otid_t otid_t2 = globalTID.getRealTID();
        PropagationContext propagationContext = new PropagationContext(n, new TransIdentity(this.getRemoteTranCoordinator(), null, otid_t2), new TransIdentity[0], any);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "get_txcontext", propagationContext);
        }
        return propagationContext;
    }

    public String toString() {
        return Util.identity(this);
    }

    public RecoveryCoordinator getSuperiorRecCoord() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSuperiorRecCoord", this._superiorRecCoord);
        }
        return this._superiorRecCoord;
    }

    public void setSuperiorRecCoord(RecoveryCoordinator recoveryCoordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSuperiorRecCoord", recoveryCoordinator);
        }
        this._superiorRecCoord = recoveryCoordinator;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSuperiorRecCoord", this._superiorRecCoord);
        }
    }

    public void setSuperiorCoord(Coordinator coordinator) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setSuperiorCoord", coordinator);
        }
        this._superiorCoord = coordinator;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setSuperiorCoord", this._superiorCoord);
        }
    }

    public Coordinator getSuperiorCoord() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSuperiorCoord");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSuperiorCoord", this._superiorCoord);
        }
        return this._superiorCoord;
    }

    public void setTimeout(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTimeout", new Integer(n));
        }
        this._timeout = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTimeout", new Integer(this._timeout));
        }
    }

    public int getTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeout");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeout", new Integer(this._timeout));
        }
        return this._timeout;
    }

    public TransactionControlRep getControlRep() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getControlRep");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getControlRep", this._controlRep);
        }
        return this._controlRep;
    }

    public TransactionCoordinator getRemoteTranCoordinator() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemoteTranCoordinator");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemoteTranCoordinator", this._remoteCoord);
        }
        return this._remoteCoord;
    }

    void registerWithSuperior() throws Inactive, PrivilegedActionException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerWithSuperior");
        }
        if (this._controlRep.isJCA() || this._controlRep.isCascaded()) {
            FailureScopeController failureScopeController = Configuration.getFailureScopeController();
            this._superiorRecCoord = failureScopeController.getJcaRecoveryCoordinator();
        } else if (!this._controlRep.isWSAT()) {
            if (this._superiorCoord != null) {
                final TransactionResource transactionResource = this._controlRep.getResourceImpl().getRemoteResource();
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws Inactive {
                        return TransactionCoordinatorImpl.this._superiorCoord.register_resource(transactionResource);
                    }
                };
                this._superiorRecCoord = (RecoveryCoordinator)TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
            } else {
                this._uow.rollbackOnly();
                TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(-910026200, CompletionStatus.COMPLETED_NO);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "registerWithSuperior", (Object)tRANSACTION_ROLLEDBACK);
                }
                throw tRANSACTION_ROLLEDBACK;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerWithSuperior");
        }
    }
}

