/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.TxPrimaryKey;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.recoverylog.spi.ScalableFailureScope;
import com.ibm.ws.runtime.component.TxServiceImpl;
import com.ibm.ws390.tx.Enq;
import com.ibm.ws390.tx.NativeServerInstanceData;
import com.ibm.ws390.tx.PersistentInterestData;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.TransactionResource;
import com.ibm.ws390.tx.TransactionURData;
import com.ibm.ws390.tx.TransactionURInterestData;
import com.ibm.ws390.tx.WSATCRAsyncResource;
import com.ibm.ws390.tx.XARecoveryAgentImpl;
import com.ibm.ws390.tx.xarecovery.HeuristicException;
import com.ibm.ws390.tx.xarecovery.RecoveryException;
import com.ibm.ws390.tx.xarecovery.ResourceManagerException;
import com.ibm.ws390.tx.xarecovery.XARecoveryAgent;
import com.ibm.ws390.tx.xarecovery.XID;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.HeuristicCommit;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.HeuristicRollback;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public class TransactionHARecoveryAlarm
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(TransactionHARecoveryAlarm.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static int _configuredRetryWait;
    public static int _configuredRetryLimit;
    public static int _configuredHeuristicCompletion;
    private int _recoveryAttemptsLimit;
    private byte[] _fsToken;
    private String _failedServerShortName;
    private String _hostServerName;
    private byte[] _workManagerName;
    private String _serverUUID;
    private byte[] _logProps;
    private RecoveryManager _recoveryManager;
    private Enq _enq = null;
    private String _enqName = null;
    private String _haEnqName = null;
    private Alarm _alarm = null;
    private ByteBuffer _tranList = null;
    public static final int DEFAULT_RETRY_WAIT = 60;
    public static final int ENQ_LENGTH = 42;
    private int _alarmIterations = 0;
    public static final int AQRY_FC_GET_TRANSACTIONS = 1;
    public static final int AQRY_FC_GET_TRANSACTION = 2;
    public static final int AQRY_FC_GET_OUTCOME = 3;
    public static final int ASRV_FC_COMMIT = 1;
    public static final int ASRV_FC_BACKOUT = 2;
    public static final int ASRV_FC_UNKNOWN = 3;
    public static final int AQRY_OUTCOME_COMMIT = 1;
    public static final int AQRY_OUTCOME_BACKOUT = 2;
    public static final int AQRY_OUTCOME_UNKNOWN = 3;
    public static final int ATRQUERY_SUCCESS = 0;
    public static final int ATRQUERY_WARNING = 4;
    public static final int ATRQUERY_FAILURE = 8;
    public static final int ATRQUERY_ASID_INVALID = 1;
    public static final int ATRQUERY_RRS_NOT_ACTIVE = 2;
    public static final int ATRQUERY_AREA_FULL = 3;
    public static final int ATRQUERY_NOT_SAF_AUTH = 4;
    public static final int ATRQUERY_URSTMASK_RSVD = 5;
    public static final int ATRQUERY_XINFOMASK_RSVD = 6;
    public static final int ATRQUERY_EXCLUSIONMASK_RSVD = 7;
    public static final int ATRQUERY_SORTKEY_INVALID = 8;
    public static final int ATRQUERY_SORTOPT_INVALID = 9;
    public static final int ATRQUERY_SORTNUM_INVALID = 10;
    public static final int ATRQUERY_TID_RANGE_INVALID = 11;
    public static final int ATRQUERY_TOD_RANGE_INVALID = 12;
    public static final int ATRQUERY_LUWIDSTR_INVALID = 13;
    public static final int ATRQUERY_CURDUR_INVALID = 14;
    public static final int ATRQUERY_SORTTABPTR_BAD = 15;
    public static final int ATRQUERY_AREAALET_SECONDARY = 16;
    public static final int ATRQUERY_REQUEST_UNKNOWN = 17;
    public static final int ATRQUERY_GNAME_INVALID = 18;
    public static final int ATRQUERY_SYSNAME_INVALID = 19;
    public static final int ATRQUERY_RESOURCE_ERROR = 20;
    public static final int ATRQUERY_TOO_MANY_ITEMS = 21;
    public static final int ATRQUERY_INSTANCE_FAILURE = 22;
    public static final int ATRQUERY_REMOTE_WARNING = 23;
    public static final int ATRQUERY_REMOTE_ERROR = 24;
    public static final int ATRQUERY_RESP_NOT_RECEIVED = 25;
    public static final int ATRQUERY_REMOTE_NOT_ACTIVE = 26;
    public static final int ATRQUERY_AREALEN_INVALID = 27;
    public static final int ATRQUERY_AREAADDR_INVALID = 28;
    public static final int ATRQUERY_UNEXPECTED_ERROR = 4095;
    public static final int ATRSRV_SUCCESS = 0;
    public static final int ATRSRV_WARNING = 4;
    public static final int ATRSRV_FAILURE = 8;
    public static final int ATRSRV_UR_NOT_IN_DOUBT = 1;
    public static final int ATRSRV_RM_IS_ACTIVE = 2;
    public static final int ATRSRV_RRS_NOT_ACTIVE = 3;
    public static final int ATRSRV_UR_HAS_DSRM = 4;
    public static final int ATRSRV_BAD_REMOVINT_PARM = 5;
    public static final int ATRSRV_URID_NOT_VALID = 6;
    public static final int ATRSRV_RID_NOT_SUPPORTED = 7;
    public static final int ATRSRV_URID_NOT_FOUND = 8;
    public static final int ATRSRV_NO_UR_FOR_RM = 9;
    public static final int ATRSRV_NOT_AUTH = 10;
    public static final int ATRSRV_NOT_SAF_AUTH = 11;
    public static final int ATRSRV_RRS_DOWNLEVEL = 12;
    public static final int ATRSRV_GNAME_INVALID = 15;
    public static final int ATRSRV_SYSNAME_INVALID = 16;
    public static final int ATRSRV_INSTANCE_FAILURE = 22;
    public static final int ATRSRV_REMOTE_WARNING = 23;
    public static final int ATRSRV_REMOTE_ERROR = 24;
    public static final int ATRSRV_RESP_NOT_RECEIVED = 25;
    public static final int ATRSRV_REMOTE_NOT_ACTIVE = 26;
    public static final int ATRSRV_UR_HAS_NO_INT = 27;
    public static final int ATRSRV_UR_NOT_TOP = 28;
    public static final int ATRSRV_UNEXPECTED_ERROR = 4095;

    public TransactionHARecoveryAlarm(byte[] byArray, byte[] byArray2, String string, String string2, RecoveryManager recoveryManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<INIT>", new Object[]{byArray, byArray2, string, string2, recoveryManager});
        }
        this._fsToken = byArray;
        this._failedServerShortName = string;
        this._serverUUID = string2;
        this._logProps = byArray2;
        this._recoveryManager = recoveryManager;
        _configuredRetryWait = TransactionImpl.heuristicRetryWait;
        _configuredRetryLimit = TransactionImpl.heuristicRetryLimit;
        _configuredHeuristicCompletion = TransactionImpl.lpsHeuristicCompletion;
        this._recoveryAttemptsLimit = _configuredRetryLimit;
        FailureScopeController failureScopeController = Configuration.getFailureScopeController();
        ScalableFailureScope scalableFailureScope = (ScalableFailureScope)failureScopeController.failureScope();
        this._hostServerName = scalableFailureScope.serverShortName();
        this._workManagerName = TransactionHARecoveryAlarm.buildWorkManagerName(this._failedServerShortName);
        try {
            this._enqName = TransactionHARecoveryAlarm.getEnqName(this._failedServerShortName);
            this._haEnqName = TransactionHARecoveryAlarm.getHAEnqName(this._failedServerShortName);
        }
        catch (Throwable throwable) {
            this._recoveryManager.recoveryComplete();
            if (tc.isEntryEnabled()) {
                Tr.event(tc, "Failed to get ENQ Name. No recovery performed.", new Object[]{this._failedServerShortName, this._hostServerName, throwable});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<INIT>");
            }
            return;
        }
        this._enq = Enq.instance();
        if (this._enq.test(this._enqName, 42) == 0) {
            int n = this._enq.obtainExclusive(this._haEnqName, 42);
            if (n != 0) {
                this._recoveryManager.recoveryComplete();
                if (tc.isEntryEnabled()) {
                    Tr.event(tc, "Recovery alarm failed to obtain HA ENQ. No recovery done.", new Object[]{new Integer(n), this._failedServerShortName, this._hostServerName});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "<INIT>");
                }
                return;
            }
        } else {
            this._recoveryManager.recoveryComplete();
            if (tc.isEntryEnabled()) {
                Tr.event(tc, "Failed server restarted. Stopping HA recovery.", new Object[]{this._failedServerShortName, this._hostServerName});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<INIT>");
            }
            return;
        }
        this.start();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<INIT>");
        }
    }

    public static void startRecovery(byte[] byArray, byte[] byArray2, String string, String string2, RecoveryManager recoveryManager) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "startRecovery");
        }
        TransactionHARecoveryAlarm transactionHARecoveryAlarm = new TransactionHARecoveryAlarm(byArray, byArray2, string, string2, recoveryManager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "startRecovery");
        }
    }

    public void start() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start");
        }
        int n = this.computeSnoozeDuration();
        this._alarm = AlarmManager.createNonDeferrable((long)n * 1000L, this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public synchronized void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (this._alarm != null) {
            this._alarm.cancel();
            this._alarm = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", object);
        }
        boolean bl = false;
        try {
            bl = this.initiateRecovery();
        }
        catch (Throwable throwable) {
            Tr.event(tc, "Exception caught during recovery. Recovery not completed", new Object[]{throwable, this._tranList});
            this._recoveryManager.recoveryComplete();
            int n = this._enq.release(this._haEnqName, 42);
            if (n != 0 && tc.isEntryEnabled()) {
                Tr.event(tc, "Recovery alarm fialed to release HA ENQ.", new Object[]{new Integer(n), this._failedServerShortName, this._hostServerName});
            }
            if (this._tranList != null) {
                TransactionHARecoveryAlarm.freeMemory(this._tranList);
                this._tranList = null;
            }
        }
        finally {
            if (bl && this._tranList != null) {
                if (tc.isEntryEnabled()) {
                    Tr.info(tc, "Freeing memory allocated for HA recovery.", this._tranList);
                }
                TransactionHARecoveryAlarm.freeMemory(this._tranList);
                this._tranList = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm");
        }
    }

    private boolean initiateRecovery() {
        Object object;
        String[] stringArray;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initiateRecovery");
        }
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        Object object2 = 0;
        Object object3 = 0;
        int n = 3;
        if (this._enq.test(this._enqName, 42) != 0) {
            bl4 = true;
            if (tc.isEntryEnabled()) {
                Tr.event(tc, "Failed server restarted. Stopping HA recovery.", new Object[]{this._failedServerShortName, this._hostServerName});
            }
        } else {
            bl4 = this._recoveryManager.shutdownInProgress();
        }
        if (bl4) {
            this._recoveryManager.recoveryComplete();
            int n2 = this._enq.release(this._haEnqName, 42);
            if (n2 != 0 && tc.isEntryEnabled()) {
                Tr.event(tc, "Recovery alarm fialed to release HA ENQ.", new Object[]{new Integer(n2), this._failedServerShortName, this._hostServerName});
            }
            return bl;
        }
        if (this._tranList == null) {
            Object[] objectArray = TransactionHARecoveryAlarm.getTransactions(this._workManagerName);
            if (objectArray == null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Nothing to recover.", new Object[]{new Integer((int)object3), new Integer((int)object2), this._tranList});
                }
                this._recoveryManager.recoveryComplete();
                int n3 = this._enq.release(this._haEnqName, 42);
                if (n3 != 0 && tc.isEntryEnabled()) {
                    Tr.event(tc, "Recovery alarm fialed to release HA ENQ.", new Object[]{new Integer(n3), this._failedServerShortName, this._hostServerName});
                }
                return bl;
            }
            int[] nArray = (int[])objectArray[0];
            object3 = nArray[0];
            object2 = nArray[1];
            this._tranList = (ByteBuffer)objectArray[1];
            if (object3 != 0) {
                switch (object2) {
                    case 2: 
                    case 24: 
                    case 25: {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Remote failure while getting URs form RRS", new Object[]{new Integer((int)object3), new Integer((int)object2), this._tranList});
                        }
                        bl = false;
                        break;
                    }
                    case 3: 
                    case 23: {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Warning issued while getting URs form RRS.", new Object[]{new Integer((int)object3), new Integer((int)object2), this._tranList});
                        }
                        INTERNAL iNTERNAL = new INTERNAL(-910026393, CompletionStatus.COMPLETED_NO);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "initiateRecovery", (Object)iNTERNAL);
                        }
                        throw iNTERNAL;
                    }
                    default: {
                        if (tc.isEventEnabled()) {
                            Tr.event(tc, "Failure occurred while getting URs form RRS.", new Object[]{new Integer((int)object3), new Integer((int)object2), this._tranList});
                        }
                        INTERNAL iNTERNAL = new INTERNAL(-910026393, CompletionStatus.COMPLETED_NO);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "initiateRecovery", (Object)iNTERNAL);
                        }
                        throw iNTERNAL;
                    }
                }
            }
        }
        int n4 = 0;
        boolean bl5 = true;
        Object object4 = null;
        while (n4 > 0 || n4 == 0 && bl5) {
            block70: {
                block71: {
                    Object object5;
                    block69: {
                        bl5 = false;
                        bl2 = true;
                        bl3 = false;
                        this._tranList.position(n4);
                        stringArray = this._tranList.slice();
                        object = new TransactionURData((ByteBuffer)stringArray);
                        int[] nArray = TransactionHARecoveryAlarm.getTransaction(this._tranList, this._tranList.capacity(), this._workManagerName, ((TransactionURData)object).getUrId());
                        object3 = nArray[0];
                        object2 = nArray[1];
                        if (object3 != 0) {
                            switch (object2) {
                                case 2: 
                                case 24: 
                                case 25: {
                                    if (tc.isEventEnabled()) {
                                        Tr.event(tc, "Remote failure while updating UR data.", new Object[]{new Integer((int)object3), new Integer((int)object2), this._tranList});
                                    }
                                    bl2 = false;
                                    break;
                                }
                                case 3: 
                                case 23: {
                                    if (tc.isEventEnabled()) {
                                        Tr.event(tc, "Warning issued while updating UR data.", new Object[]{new Integer((int)object3), new Integer((int)object2), this._tranList});
                                    }
                                    bl2 = false;
                                    break;
                                }
                                default: {
                                    if (tc.isEventEnabled()) {
                                        Tr.event(tc, "Failed updating UR data.", new Object[]{new Integer((int)object3), new Integer((int)object2), this._tranList});
                                    }
                                    bl2 = false;
                                }
                            }
                        }
                        if (!bl2) {
                            bl = false;
                            break;
                        }
                        int n5 = ((TransactionURData)object).getUrState();
                        switch (n5) {
                            case 4: {
                                if (_configuredRetryLimit > 0 && this._alarmIterations > _configuredRetryLimit) {
                                    object5 = new XidImpl(((TransactionURData)object).getXid());
                                    String string = String.valueOf(((XidImpl)object5).getFormatId());
                                    String string2 = Util.toHexString(((XidImpl)object5).getGlobalTransactionId());
                                    String string3 = Util.toHexString(((XidImpl)object5).getBranchQualifier());
                                    String string4 = Util.toHexString(((TransactionURData)object).getUrId());
                                    if (_configuredHeuristicCompletion == 1) {
                                        n = 1;
                                        Tr.error(tc, "BBOT0031_HEURISTIC_OUTCOME_COMMIT", new Object[]{this._failedServerShortName, string4, string, string2, string3, new Integer(_configuredRetryLimit), this._hostServerName});
                                        break;
                                    }
                                    if (_configuredHeuristicCompletion == 0) {
                                        n = 2;
                                        Tr.error(tc, "BBOT0032_HEUISTIC_OUTCOME_ROLBACK", new Object[]{this._failedServerShortName, string4, string, string2, string3, new Integer(_configuredRetryLimit), this._hostServerName});
                                        break;
                                    }
                                    Tr.info(tc, "BBOT0033_REQUIRES_MANUAL_RESOLUTION", new Object[]{this._failedServerShortName, string4, string, string2, string3, new Integer(_configuredRetryLimit), this._hostServerName});
                                    if (object4 != null) {
                                        ((TransactionURData)object4).setNextUrOffset(((TransactionURData)object).getNextUrOffset());
                                    }
                                    bl3 = true;
                                    break;
                                }
                                n = this.findUrOutcome((TransactionURData)object);
                                break;
                            }
                            case 5: {
                                n = 1;
                                break;
                            }
                            case 6: {
                                n = 2;
                                break;
                            }
                            default: {
                                if (tc.isEventEnabled()) {
                                    Tr.event(tc, "Incorrect UR state.", new Object[]{new Integer(n5), this._tranList});
                                }
                                if (object4 != null) {
                                    ((TransactionURData)object4).setNextUrOffset(((TransactionURData)object).getNextUrOffset());
                                }
                                bl3 = true;
                            }
                        }
                        if (bl3) {
                            n4 = ((TransactionURData)object).getNextUrOffset();
                            object4 = object;
                            continue;
                        }
                        switch (n) {
                            case 1: 
                            case 2: {
                                bl2 = this.resolveUR((TransactionURData)object, n);
                                break;
                            }
                            default: {
                                bl2 = false;
                                if (!tc.isEventEnabled()) break;
                                Tr.event(tc, "NO UR outcome found. Try again later..", new Integer(n));
                            }
                        }
                        if (bl2) break block69;
                        bl = false;
                        break block70;
                    }
                    object5 = TransactionHARecoveryAlarm.removeInterests(this._workManagerName, ((TransactionURData)object).getUrId());
                    object3 = object5[0];
                    object2 = object5[1];
                    if (object3 == 0) break block71;
                    switch (object2) {
                        case 9: {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Remove interest found nothing to remove", new Object[]{new Integer((int)object3), new Integer((int)object2)});
                            }
                            this.cleanupCompletedUR((ByteBuffer)stringArray);
                            if (object4 != null) {
                                ((TransactionURData)object4).setNextUrOffset(((TransactionURData)object).getNextUrOffset());
                                break;
                            }
                            break block70;
                        }
                        case 3: 
                        case 24: 
                        case 25: 
                        case 26: {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Remote failure while removing interest", new Object[]{new Integer((int)object3), new Integer((int)object2)});
                            }
                            bl = false;
                            break;
                        }
                        case 23: {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Remote failure while removing interest", new Object[]{new Integer((int)object3), new Integer((int)object2)});
                            }
                            this.cleanupCompletedUR((ByteBuffer)stringArray);
                            if (object4 != null) {
                                ((TransactionURData)object4).setNextUrOffset(((TransactionURData)object).getNextUrOffset());
                                break;
                            }
                            break block70;
                        }
                        default: {
                            if (tc.isEventEnabled()) {
                                Tr.event(tc, "Remove interest failed.", new Object[]{new Integer((int)object3), new Integer((int)object2)});
                            }
                            bl = false;
                            break;
                        }
                    }
                    break block70;
                }
                this.cleanupCompletedUR((ByteBuffer)stringArray);
                if (object4 != null) {
                    ((TransactionURData)object4).setNextUrOffset(((TransactionURData)object).getNextUrOffset());
                }
            }
            n4 = ((TransactionURData)object).getNextUrOffset();
            object4 = object;
        }
        if (!bl) {
            if (this._recoveryAttemptsLimit > 0 && this._alarmIterations > this._recoveryAttemptsLimit) {
                this._recoveryAttemptsLimit += _configuredRetryLimit;
                if (this._alarmIterations > 2 * _configuredRetryLimit) {
                    stringArray = new String[]{this._failedServerShortName, this._hostServerName, Integer.toString(_configuredRetryLimit)};
                    object = null;
                    while (((String)(object = RasHelper.wtorMessage(28, (String)object, false, stringArray))).compareToIgnoreCase("CONTINUE") != 0 || ((String)object).compareToIgnoreCase("TERMINATE") != 0) {
                    }
                    if (((String)object).compareToIgnoreCase("CONTINUE") == 0) {
                        RasHelper.wtorMessage(29, (String)object, true, stringArray);
                        Tr.info(tc, "BBOT0029_HA_CONTINUE", new Object[]{this._failedServerShortName, this._hostServerName, new Integer(_configuredRetryLimit)});
                        this.start();
                    } else {
                        Tr.info(tc, "BBOT0030_HA_TERM", new Object[]{this._failedServerShortName, this._hostServerName, new Integer(_configuredRetryLimit)});
                        this._recoveryManager.recoveryComplete();
                        int n6 = this._enq.release(this._haEnqName, 42);
                        if (n6 != 0 && tc.isEntryEnabled()) {
                            Tr.event(tc, "Recovery alarm fialed to release HA ENQ.", new Object[]{new Integer(n6), this._failedServerShortName, this._hostServerName});
                        }
                        bl = true;
                    }
                } else {
                    this.start();
                }
            } else {
                this.start();
            }
        } else {
            this._recoveryManager.recoveryComplete();
            int n7 = this._enq.release(this._haEnqName, 42);
            if (n7 != 0 && tc.isEntryEnabled()) {
                Tr.event(tc, "Recovery alarm fialed to release HA ENQ.", new Object[]{new Integer(n7), this._failedServerShortName, this._hostServerName});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initiateRecovery", new Boolean(bl));
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean resolveUR(TransactionURData transactionURData, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveUR", new Object[]{transactionURData, new Integer(n)});
        }
        boolean bl = true;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int[] nArray = null;
        if (transactionURData.getUrState() == 4 && (nArray = n == 1 ? TransactionHARecoveryAlarm.commit(this._workManagerName, transactionURData.getUrId()) : TransactionHARecoveryAlarm.backout(this._workManagerName, transactionURData.getUrId())) != null) {
            n3 = nArray[0];
            n2 = nArray[1];
        }
        if (n3 != 0) {
            switch (n2) {
                case 3: 
                case 24: 
                case 25: 
                case 26: {
                    if (tc.isEntryEnabled()) {
                        Tr.event(tc, "Remote failure while updating the UR state.", new Object[]{new Integer(n3), new Integer(n2)});
                    }
                    bl = false;
                    break;
                }
                case 23: {
                    if (!tc.isEntryEnabled()) break;
                    Tr.event(tc, "Remote warning while updating the UR state.", new Object[]{new Integer(n3), new Integer(n2)});
                    break;
                }
                default: {
                    if (tc.isEntryEnabled()) {
                        Tr.event(tc, "Failure while updating the UR state.", new Object[]{new Integer(n3), new Integer(n2)});
                    }
                    bl = false;
                }
            }
        }
        int n4 = transactionURData.getUriOffset();
        while (n4 > 0) {
            TransactionURInterestData transactionURInterestData;
            block60: {
                this._tranList.position(n4);
                ByteBuffer byteBuffer = this._tranList.slice();
                transactionURInterestData = new TransactionURInterestData(byteBuffer, this._tranList);
                if (transactionURInterestData.isHeuristic()) {
                    bl = false;
                } else if (transactionURInterestData.getRole() == 3) {
                    try {
                        if (!transactionURInterestData.getSyncpointInterest().xaEnlisted()) {
                            transactionURInterestData.setCompleted();
                        }
                        if (transactionURInterestData.isCompleted()) break block60;
                        bl2 = this.driveXAOutcome(transactionURData, transactionURInterestData, n);
                        if (!bl2) {
                            transactionURInterestData.setCompleted();
                            break block60;
                        }
                        transactionURInterestData.setHeuristic(true);
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        if (tc.isEntryEnabled()) {
                            Tr.event(tc, "Exception caught while resolving XA resources.", new Object[]{new Boolean(bl2), new Integer(n), new Boolean(bl), throwable});
                        }
                        bl = false;
                    }
                } else if (transactionURInterestData.getPdata() != null) {
                    if (!transactionURInterestData.isCompleted()) {
                        Resource resource;
                        WSATCRAsyncResource wSATCRAsyncResource;
                        byte by = PersistentInterestData.getType(transactionURInterestData.getPdata());
                        if (by == 2) {
                            wSATCRAsyncResource = null;
                            resource = transactionURInterestData.getResourceInterest().getResource();
                        } else if (by == 3) {
                            resource = null;
                            wSATCRAsyncResource = transactionURInterestData.getResourceInterest().getAsyncResource();
                        } else {
                            wSATCRAsyncResource = null;
                            resource = null;
                        }
                        switch (n) {
                            case 1: {
                                Throwable throwable;
                                PrivilegedExceptionAction privilegedExceptionAction;
                                try {
                                    if (resource != null) {
                                        privilegedExceptionAction = new PrivilegedExceptionAction(){

                                            public Object run() throws HeuristicRollback, HeuristicMixed, HeuristicHazard, NotPrepared, SystemException {
                                                resource.commit();
                                                return null;
                                            }
                                        };
                                        TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
                                        transactionURInterestData.setCompleted();
                                        break;
                                    }
                                    if (wSATCRAsyncResource != null) break;
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    throwable = privilegedActionException.getCause();
                                    if (throwable instanceof OBJECT_NOT_EXIST) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.event(tc, "O_N_E while attempting to commit UR.", throwable);
                                        }
                                        transactionURInterestData.setCompleted();
                                        break;
                                    }
                                    if (throwable instanceof HeuristicRollback) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.event(tc, "HeuristicRollback exception on commit.", throwable);
                                        }
                                        transactionURInterestData.setHeuristic(true);
                                        bl = false;
                                        break;
                                    }
                                    if (throwable instanceof HeuristicMixed) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.event(tc, "HeuristicMixed exception on commit.", throwable);
                                        }
                                        transactionURInterestData.setHeuristic(true);
                                        bl = false;
                                        break;
                                    }
                                    if (throwable instanceof HeuristicHazard) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.event(tc, "HeuristicHazard exception on commit.", throwable);
                                        }
                                        transactionURInterestData.setHeuristic(true);
                                        bl = false;
                                        break;
                                    }
                                    if (tc.isEntryEnabled()) {
                                        Tr.event(tc, "Exception encountered on commit.", new Object[]{new Integer(n), new Boolean(bl), new Boolean(bl2), throwable});
                                    }
                                    transactionURInterestData.setHeuristic(false);
                                    bl = false;
                                }
                                break;
                            }
                            case 2: {
                                Throwable throwable;
                                PrivilegedExceptionAction privilegedExceptionAction;
                                try {
                                    if (resource != null) {
                                        privilegedExceptionAction = new PrivilegedExceptionAction(){

                                            public Object run() throws HeuristicCommit, HeuristicMixed, HeuristicHazard, SystemException {
                                                resource.rollback();
                                                return null;
                                            }
                                        };
                                        TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
                                        transactionURInterestData.setCompleted();
                                        break;
                                    }
                                    if (wSATCRAsyncResource != null) break;
                                }
                                catch (PrivilegedActionException privilegedActionException) {
                                    throwable = privilegedActionException.getCause();
                                    if (throwable instanceof OBJECT_NOT_EXIST) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.event(tc, "O_N_E while attempting to rollback UR.", throwable);
                                        }
                                        transactionURInterestData.setCompleted();
                                        break;
                                    }
                                    if (throwable instanceof HeuristicCommit) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.event(tc, "HeuristicCommit exception on rollback.", throwable);
                                        }
                                        transactionURInterestData.setHeuristic(true);
                                        bl = false;
                                        break;
                                    }
                                    if (throwable instanceof HeuristicMixed) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.event(tc, "HeuristicMixed exception on rollback.", throwable);
                                        }
                                        transactionURInterestData.setHeuristic(true);
                                        bl = false;
                                        break;
                                    }
                                    if (throwable instanceof HeuristicHazard) {
                                        if (tc.isEntryEnabled()) {
                                            Tr.event(tc, "HeuristicHazard exception on commit.", throwable);
                                        }
                                        transactionURInterestData.setHeuristic(true);
                                        bl = false;
                                        break;
                                    }
                                    if (tc.isEntryEnabled()) {
                                        Tr.event(tc, "Exception encountered on commit.", new Object[]{new Integer(n), new Boolean(bl), new Boolean(bl2), throwable});
                                    }
                                    transactionURInterestData.setHeuristic(false);
                                    bl = false;
                                }
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else if (!transactionURInterestData.isCompleted()) {
                    bl = false;
                    if (tc.isEntryEnabled()) {
                        Tr.event(tc, "Waiting for non-WebSphere interest to resolve.", new Object[]{transactionURInterestData, new Integer(n), new Boolean(bl)});
                    }
                } else if (tc.isEntryEnabled()) {
                    Tr.event(tc, "Non-WebSphere resolved.", new Object[]{transactionURInterestData, new Integer(n), new Boolean(bl)});
                }
            }
            if (!transactionURInterestData.isCompleted()) {
                bl = false;
            }
            n4 = transactionURInterestData.getNextUriOffset();
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolveUR", new Boolean(bl));
        }
        return bl;
    }

    private boolean driveXAOutcome(TransactionURData transactionURData, TransactionURInterestData transactionURInterestData, int n) {
        boolean bl;
        block14: {
            XARecoveryAgent xARecoveryAgent;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "driveXAOutcome", new Object[]{transactionURData, transactionURInterestData, new Integer(n)});
            }
            bl = false;
            final int n2 = n;
            byte[] byArray = transactionURInterestData.getPdata();
            byte[] byArray2 = NativeServerInstanceData.getRecoveryServantStoken();
            Iterator iterator = AdminServiceImpl.getPlatformUtils().getSRAggregator(new XARecoveryAgentImpl(), false, byArray2);
            try {
                xARecoveryAgent = (XARecoveryAgent)iterator.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "driveXAOutcome", noSuchElementException);
                }
                TRANSIENT tRANSIENT = new TRANSIENT();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Server not available to recover XA resource. Try again later.", (Object)tRANSIENT);
                }
                throw tRANSIENT;
            }
            XidImpl xidImpl = new XidImpl(transactionURData.getXid());
            final XID xID = new XID(xidImpl.getFormatId(), xidImpl.getGlobalTransactionId().length, xidImpl.getBranchQualifier().length, xidImpl.getOtidBytes());
            final byte[] byArray3 = transactionURInterestData.getSyncpointInterest().getXaResourceData();
            try {
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws ResourceManagerException, RecoveryException, HeuristicException {
                        switch (n2) {
                            case 1: {
                                xARecoveryAgent.commit(xID, byArray3, TransactionHARecoveryAlarm.this._fsToken, TransactionHARecoveryAlarm.this._logProps);
                                break;
                            }
                            case 2: {
                                xARecoveryAgent.rollback(xID, byArray3, TransactionHARecoveryAlarm.this._fsToken, TransactionHARecoveryAlarm.this._logProps);
                                break;
                            }
                        }
                        return null;
                    }
                };
                TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof ResourceManagerException) {
                    TRANSIENT tRANSIENT = new TRANSIENT(-910026396, CompletionStatus.COMPLETED_NO);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "An XA resources did not resppond. Try again later.", (Object)tRANSIENT);
                    }
                    throw tRANSIENT;
                }
                if (throwable instanceof RecoveryException) {
                    TRANSIENT tRANSIENT = new TRANSIENT(-910026395, CompletionStatus.COMPLETED_NO);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "RecoveryException while resolving XA resources.", (Object)tRANSIENT);
                    }
                    throw tRANSIENT;
                }
                if (throwable instanceof HeuristicException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Heuristic exception thrown by an XA resource.", throwable);
                    }
                    bl = true;
                }
                if (!tc.isEntryEnabled()) break block14;
                Tr.exit(tc, "Unexpected exception thrown by an XA resource.", new Object[]{throwable, xidImpl});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "driveXAOutcome", new Boolean(bl));
        }
        return bl;
    }

    private void cleanupCompletedUR(ByteBuffer byteBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupCompletedUR", byteBuffer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupCompletedUR");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findUrOutcome(TransactionURData transactionURData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findUrOutcome", transactionURData);
        }
        int n = 3;
        if (transactionURData.isRoot()) {
            n = 2;
        } else {
            n = TransactionHARecoveryAlarm.getOutcome(this._tranList, this._tranList.capacity(), this._workManagerName, transactionURData.getUrId());
            if (n == 3) {
                int n2 = transactionURData.getUriOffset();
                while (n2 > 0) {
                    this._tranList.position(n2);
                    ByteBuffer byteBuffer = this._tranList.slice();
                    TransactionURInterestData transactionURInterestData = new TransactionURInterestData(byteBuffer, this._tranList);
                    if (transactionURInterestData.getRole() == 3 && !transactionURInterestData.getSyncpointInterest().isJcaImported() && transactionURInterestData.getSyncpointInterest().getRecoveryCoordinator() != null) {
                        Status status;
                        block26: {
                            status = Status.StatusUnknown;
                            final RecoveryCoordinator recoveryCoordinator = transactionURInterestData.getSyncpointInterest().getRecoveryCoordinator();
                            final TransactionResource transactionResource = new TransactionResource();
                            FailureScopeController failureScopeController = Configuration.getFailureScopeController();
                            TxPrimaryKey txPrimaryKey = new XidImpl(transactionURData.getXid()).getPrimaryKey();
                            failureScopeController.registerCoordinatorResource(transactionResource, txPrimaryKey.toBytes());
                            try {
                                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                                    public Object run() throws NotPrepared {
                                        return recoveryCoordinator.replay_completion(transactionResource);
                                    }
                                };
                                status = (Status)TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                Throwable throwable = privilegedActionException.getCause();
                                if (throwable instanceof OBJECT_NOT_EXIST) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.event(tc, "Replay completion object not exist.", throwable);
                                    }
                                    status = Status.StatusNoTransaction;
                                    break block26;
                                }
                                if (throwable instanceof COMM_FAILURE) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.event(tc, "Replay completion comm failure.", throwable);
                                    }
                                    status = Status.StatusUnknown;
                                    break block26;
                                }
                                if (throwable instanceof TRANSIENT) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.event(tc, "Replay completion transient.", throwable);
                                    }
                                    status = Status.StatusUnknown;
                                    break block26;
                                }
                                if (throwable instanceof NotPrepared) {
                                    if (tc.isEntryEnabled()) {
                                        Tr.event(tc, "Not prepared.Protocol Violation.", throwable);
                                    }
                                    status = Status.StatusActive;
                                    break block26;
                                }
                                UNKNOWN uNKNOWN = new UNKNOWN();
                                if (tc.isEntryEnabled()) {
                                    Tr.exit(tc, "findUrOutcome", new Object[]{new Integer(n), throwable});
                                }
                                throw uNKNOWN;
                            }
                            finally {
                                failureScopeController.unregisterCoordinatorResource(txPrimaryKey.toBytes());
                            }
                        }
                        switch (status.value()) {
                            case 3: 
                            case 8: {
                                n = 1;
                                break;
                            }
                            case 4: 
                            case 6: 
                            case 9: {
                                n = 2;
                                break;
                            }
                            case 0: 
                            case 1: {
                                n = 2;
                                break;
                            }
                            default: {
                                if (!tc.isEntryEnabled()) break;
                                Tr.event(tc, "Found superior status.", status);
                            }
                        }
                        if (n != 3) break;
                    }
                    n2 = transactionURInterestData.getNextUriOffset();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findUrOutcome", new Integer(n));
        }
        return n;
    }

    private int computeSnoozeDuration() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "computeSnoozeDuration");
        }
        ++this._alarmIterations;
        int n2 = n = _configuredRetryWait > 0 ? _configuredRetryWait : 60;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "computeSnoozeDuration", new Integer(n));
        }
        return n;
    }

    public static byte[] buildWorkManagerName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildWorkManagerName");
        }
        byte[] byArray = TransactionHARecoveryAlarm.buildWorkManagerNameNative(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildWorkManagerName", byArray);
        }
        return byArray;
    }

    public static String getEnqName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEnqName");
        }
        String string2 = null;
        try {
            string2 = new String(TransactionHARecoveryAlarm.buildWorkManagerName(string), "IBM-1047");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            INTERNAL iNTERNAL = new INTERNAL();
            if (tc.isEventEnabled()) {
                Tr.exit(tc, "Problem retrieving work manager name String", unsupportedEncodingException);
            }
            throw iNTERNAL;
        }
        String string3 = "BBOT." + string2 + ".MAIN";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEnqName", string3);
        }
        return string3;
    }

    public static String getHAEnqName(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getHAEnqName");
        }
        String string2 = null;
        try {
            string2 = new String(TransactionHARecoveryAlarm.buildWorkManagerName(string), "IBM-1047");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            INTERNAL iNTERNAL = new INTERNAL();
            if (tc.isEventEnabled()) {
                Tr.exit(tc, "Problem retrieving work manager name String", unsupportedEncodingException);
            }
            throw iNTERNAL;
        }
        String string3 = "BBOT." + string2 + ".HAXX";
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getHAEnqName", string3);
        }
        return string3;
    }

    private static native byte[] buildWorkManagerNameNative(String var0);

    private static native Object[] getTransactions(byte[] var0);

    private static native int[] getTransaction(ByteBuffer var0, int var1, byte[] var2, byte[] var3);

    private static native int getOutcome(ByteBuffer var0, int var1, byte[] var2, byte[] var3);

    private static native int[] commit(byte[] var0, byte[] var1);

    private static native int[] backout(byte[] var0, byte[] var1);

    private static native int[] removeInterests(byte[] var0, byte[] var1);

    private static native void freeMemory(ByteBuffer var0);
}

