/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTA.XidImpl;
import java.util.Arrays;

public class TransactionManagerMessage {
    private static final TraceComponent tc = Tr.register(TransactionManagerMessage.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final byte[] EYECATCHER = new byte[]{-62, -62, -42, -29, -29, -44, -44, 64};
    private static final byte VERSION_0 = 0;
    private static final byte CURRENT_VERSION = 0;
    private boolean _nonInterop = false;
    private boolean _joinedTransaction = true;
    private boolean _cascaded = false;
    private XidImpl _xid = null;
    private byte _version = 0;

    public TransactionManagerMessage(XidImpl xidImpl, boolean bl, boolean bl2) {
        this(xidImpl, bl, bl2, false);
    }

    public TransactionManagerMessage(XidImpl xidImpl, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{xidImpl, new Boolean(bl), new Boolean(bl2), new Boolean(bl3)});
        }
        this._xid = xidImpl;
        this._nonInterop = bl;
        this._joinedTransaction = bl2;
        this._cascaded = bl3;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public TransactionManagerMessage(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byArray);
        }
        if (byArray == null || byArray.length < EYECATCHER.length) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Message length is invalid");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>", illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        byte[] byArray2 = new byte[EYECATCHER.length];
        System.arraycopy(byArray, 0, byArray2, 0, EYECATCHER.length);
        if (!Arrays.equals(byArray2, EYECATCHER)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid TMM eyecatcher");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>", illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        int n = EYECATCHER.length;
        this._version = byArray[n];
        this._cascaded = byArray[++n] == 1;
        this._nonInterop = byArray[++n] == 1;
        this._joinedTransaction = byArray[++n] == 1;
        int n2 = Util.getIntFromBytes(byArray, ++n, 4);
        n += 4;
        if (n2 > 0) {
            this._xid = new XidImpl(byArray, n);
            n += n2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public byte[] toBytes() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toBytes", this);
        }
        byte[] byArray = this._xid != null ? this._xid.toBytes() : null;
        int n = EYECATCHER.length + 4 + 4;
        if (byArray != null) {
            n += byArray.length;
        } else {
            byArray = new byte[]{};
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(EYECATCHER, 0, byArray2, 0, EYECATCHER.length);
        int n2 = EYECATCHER.length;
        byArray2[n2] = this._version;
        byArray2[++n2] = this._cascaded ? (byte)1 : 0;
        byArray2[++n2] = this._nonInterop ? (byte)1 : 0;
        byArray2[++n2] = this._joinedTransaction ? (byte)1 : 0;
        Util.setBytesFromInt(byArray2, ++n2, 4, byArray.length);
        System.arraycopy(byArray, 0, byArray2, n2 += 4, byArray.length);
        n2 += byArray.length;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toBytes", byArray2);
        }
        return byArray2;
    }

    public XidImpl getXid() {
        return this._xid;
    }

    public boolean getNonInterop() {
        return this._nonInterop;
    }

    public boolean getJoinedTransactionBit() {
        return this._joinedTransaction;
    }

    public boolean getCascaded() {
        return this._cascaded;
    }

    public byte getVersion() {
        return this._version;
    }
}

