/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws390.tx.TransactionByteBufferPoolManager;
import java.nio.ByteBuffer;

public final class TransactionMessagePipe {
    private static final TraceComponent tc = Tr.register(TransactionMessagePipe.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private final ByteBuffer _tmpBuffer;
    private static final byte[] EYECATCHER = new byte[]{-29, -44, -41, 64};
    private static final int VERSION = 1;
    private static final int TMP_ID_OFFSET = 0;
    private static final int TMP_SIZE_OFFSET = 4;
    private static final int TMP_VERSION_OFFSET = 8;
    private static final int FLAGS_OFFSET = 12;
    private static final int FUNC_CODE_OFFSET = 14;
    private static final int TIMEOUT_OFFSET = 16;
    private static final int RETURN_CODE_OFFSET = 20;
    private static final int REASON_CODE_OFFSET = 24;
    private static final int ECB_OFFSET = 28;
    private static final int TTOKEN_OFFSET = 32;
    private static final int CTX_TOKEN_OFFSET = 48;
    private static final int GTID_OFFSET = 64;
    private static final int FILLER_OFFSET = 137;
    private static final int EXCEPTION_CODE_OFFSET = 138;
    private static final int EXCEPTION_MCODE_OFFSET = 140;
    private static final int JCA_INBOUND_BQUAL_OFFSET = 144;
    private static final int JCA_INBOUND_FID = 212;
    private static final int JCA_NEW_BQUAL_OFFSET = 216;
    private static final int URI_TOKEN_OFFSET = 284;
    private static final int ATRA_LOG_OPT_OFFSET = 300;
    private static final int CR_ECB_OFFSET = 304;
    private static final int SR_ECB_PTR_OFFSET = 308;
    private static final int SR_ECB_KEY_OFFSET = 312;
    private static final int SR_ASCB_PTR_OFFSET = 316;
    private static final int SR_ORBR_ID_OFFSSET = 320;
    private static final int INITIAL_TIMEOUT_OFFSET = 324;
    private static final int RESERVED_SPACE_OFFSET = 328;
    private static final int VAR_DATA_PTR_OFFSET = 344;
    private static final int VAR_DATA_LENGTH_OFFSET = 348;
    private static final int VAR_DATA_OFFSET = 352;
    private static final int TMP_LENGTH = 353;
    private static final int BOSS_INIT_MASK = 32768;
    private static final int REPORT_HEUR_MASK = 16384;
    private static final int ATRABAK_MASK = 8192;
    private static final int EXPRESS_INTEREST_MASK = 4096;
    private static final int COMMIT_ONE_PHASE_MASK = 2048;
    private static final int BEGIN_FAILED_MASK = 1024;
    private static final int JCA_INIT_MASK = 512;
    private static final int MAX_BQUAL_LENGTH = 64;
    private static final int MAX_GTRID_LENGTH = 64;
    private static final int MAX_GTID_LENGTH = 69;
    private static final int PRIMARY_KEY_LENGTH = 16;
    private static final int ATRA_URI_TOKEN_LENGTH = 16;
    private static final int CTX_TOKEN_LENGTH = 16;
    private static final int TTOKEN_LENGTH = 16;
    private static final int STOKEN_LENGTH = 8;
    public static final short TMP_FUNC_BEGIN = 1;
    public static final short TMP_FUNC_COMMIT = 2;
    public static final short TMP_FUNC_ROLLBACK = 3;
    public static final short TMP_FUNC_ROLLBACK_ONLY = 4;
    public static final short TMP_FUNC_GET_CONTROL = 5;
    public static final short TMP_FUNC_GET_STATUS = 6;
    public static final short TMP_FUNC_SUSPEND = 7;
    public static final short TMP_FUNC_RESUME = 8;
    public static final short TMP_FUNC_FREE_IOR = 9;
    public static final short TMP_FUNC_XA_PREPARE = 10;
    public static final short TMP_FUNC_RESERVED = 11;
    public static final short TMP_FUNC_SET_HEURISTIC = 12;
    public static final short TMP_FUNC_ENLIST_XA = 13;
    public static final short TMP_FUNC_SET_FAILED_XA = 14;
    public static final short TMP_FUNC_SEQ_WRAP = 15;
    public static final short TMP_FUNC_PKEY_WAIT = 16;
    public static final short TMP_FUNC_ADD_TX_ATRIB = 17;
    public static final short TMP_FUNC_REMOVE_TX_ATRIB = 18;
    public static final short TMP_FUNC_FORGET = 19;
    public static final short TMP_FUNC_REGISTER = 20;
    public static final short TMP_FUNC_WSTX_DATA = 21;
    public static final short TMP_FUNC_WSTX_MAP_DATA = 22;
    public static final short TMP_FUNC_DECREM_WSAT = 23;
    private TransactionByteBufferPoolManager _poolMgr = TransactionByteBufferPoolManager.instance();

    public TransactionMessagePipe(ByteBuffer byteBuffer) {
        this._tmpBuffer = byteBuffer;
    }

    TransactionMessagePipe(short s, byte[] byArray) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{new Short(s), byArray});
        }
        int n2 = 353 + (byArray != null ? byArray.length : 0);
        this._tmpBuffer = this._poolMgr.allocateDirect(n2);
        this._poolMgr.clearByteBuffer(this._tmpBuffer);
        for (n = 0; n < EYECATCHER.length; ++n) {
            this._tmpBuffer.put(0 + n, EYECATCHER[n]);
        }
        this._tmpBuffer.putInt(4, n2);
        this._tmpBuffer.putInt(8, 1);
        this._tmpBuffer.putShort(14, s);
        if (byArray != null) {
            this._tmpBuffer.putInt(348, byArray.length);
            for (n = 0; n < byArray.length; ++n) {
                this._tmpBuffer.put(352 + n, byArray[n]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    ByteBuffer getBackingBuffer() {
        return this._tmpBuffer;
    }

    public byte[] getTransactionMessageId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransactionMessageId");
        }
        byte[] byArray = new byte[4];
        this._tmpBuffer.position(0);
        this._tmpBuffer.get(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransactionMessageId", Util.toHexString(byArray));
        }
        return byArray;
    }

    public int getTransactionMessageSize() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransactionMessageSize");
        }
        int n = this._tmpBuffer.getInt(4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransactionMessageSize", new Integer(n));
        }
        return n;
    }

    public int getTransactionMessageVersion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTransactionMessageVersion");
        }
        int n = this._tmpBuffer.getInt(8);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTransactionMessageVersion", new Integer(n));
        }
        return n;
    }

    public short getFlagHolder() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFlagHolder");
        }
        short s = this._tmpBuffer.getShort(12);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFlagHolder", new Short(s));
        }
        return s;
    }

    private void setFlagHolder(short s) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setFlagHolder", new Short(s));
        }
        this._tmpBuffer.putShort(12, s);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setFlagHolder", new Short(s));
        }
    }

    public short getFunctionCode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getFunctionCode");
        }
        short s = this._tmpBuffer.getShort(14);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getFunctionCode", new Short(s));
        }
        return s;
    }

    public int getTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTimeout");
        }
        int n = this._tmpBuffer.getInt(16);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTimeout", new Integer(n));
        }
        return n;
    }

    public void setTimeout(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTimeout", new Integer(n));
        }
        this._tmpBuffer.putInt(16, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTimeout");
        }
    }

    public int getReturnCode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReturnCode");
        }
        int n = this._tmpBuffer.getInt(20);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReturnCode", new Integer(n));
        }
        return n;
    }

    void setReturnCode(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setReturnCode", new Integer(n));
        }
        this._tmpBuffer.putInt(20, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setReturnCode", new Integer(n));
        }
    }

    public int reasonCode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReasonCode");
        }
        int n = this._tmpBuffer.getInt(24);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getReasonCode", new Integer(n));
        }
        return n;
    }

    public int getECB() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getECB");
        }
        int n = this._tmpBuffer.getInt(28);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getECB", new Integer(n));
        }
        return n;
    }

    public byte[] getTToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getTToken");
        }
        byte[] byArray = new byte[16];
        this._tmpBuffer.position(32);
        this._tmpBuffer.get(byArray, 0, 16);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTToken", Util.toHexString(byArray));
        }
        return byArray;
    }

    public byte[] getSToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSToken");
        }
        byte[] byArray = new byte[8];
        this._tmpBuffer.position(32);
        this._tmpBuffer.get(byArray, 0, 8);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSToken", Util.toHexString(byArray));
        }
        return byArray;
    }

    public byte[] getContextToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getContextToken");
        }
        byte[] byArray = new byte[16];
        this._tmpBuffer.position(48);
        this._tmpBuffer.get(byArray, 0, 16);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getContextToken", Util.toHexString(byArray));
        }
        return byArray;
    }

    public void setContextToken(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setContextToken", byArray);
        }
        for (int i = 0; i < 16; ++i) {
            this._tmpBuffer.put(48 + i, byArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setContextToken");
        }
    }

    public byte[] getGtid() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGtid");
        }
        int n = this._tmpBuffer.getInt(64);
        byte[] byArray = new byte[n];
        this._tmpBuffer.position(64);
        this._tmpBuffer.get(byArray, 0, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGtid", Util.toHexString(byArray));
        }
        return byArray;
    }

    public void setGtid(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setGtid", byArray);
        }
        int n = byArray.length < 69 ? byArray.length : 69;
        for (int i = 0; i < n; ++i) {
            this._tmpBuffer.put(64 + i, byArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setContextToken");
        }
    }

    public byte[] getGtrid() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGtrid");
        }
        int n = 9;
        byte[] byArray = this.getGtid();
        int n2 = byArray.length - n;
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGtrid", Util.toHexString(byArray2));
        }
        return byArray2;
    }

    public byte[] getPrimaryKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPrimaryKey");
        }
        byte[] byArray = this.getGtrid();
        byte[] byArray2 = new byte[16];
        System.arraycopy(byArray, 0, byArray2, 0, 16);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPrimaryKey", Util.toHexString(byArray2));
        }
        return byArray2;
    }

    public short getExceptionCode() {
        short s = this._tmpBuffer.getShort(138);
        if (s != 0 && tc.isEventEnabled()) {
            Tr.event(tc, "getExceptionCode", new Short(s));
        }
        return s;
    }

    public int getExceptionMinorCode() {
        int n = this._tmpBuffer.getInt(140);
        if (n != 0 && tc.isEventEnabled()) {
            Tr.event(tc, "getExceptionMinorCode", new Integer(n));
        }
        return n;
    }

    public byte[] getJCAInboundBqual() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getJCAInboundBqual");
        }
        int n = this._tmpBuffer.getInt(144);
        byte[] byArray = new byte[n];
        this._tmpBuffer.position(148);
        this._tmpBuffer.get(byArray, 0, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getJCAInboundBqual", Util.toHexString(byArray));
        }
        return byArray;
    }

    public void setJCAInboundBqual(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJCAInboundBqual", byArray);
        }
        int n = byArray.length < 64 ? byArray.length : 64;
        this._tmpBuffer.putInt(144, n);
        for (int i = 0; i < n; ++i) {
            this._tmpBuffer.put(148 + i, byArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJCAInboundBqual");
        }
    }

    public int getJCAInboundFormatId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " getJCAInboundFormatId");
        }
        int n = this._tmpBuffer.getInt(212);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " getJCAInboundFormatId", new Integer(n));
        }
        return n;
    }

    public void setJCAInboundFormatId(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setJCAInboundFormatId");
        }
        this._tmpBuffer.putInt(212, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setJCAInboundFormatId");
        }
    }

    public byte[] getNewJCABqual() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNewJCABqual");
        }
        int n = this._tmpBuffer.getInt(216);
        byte[] byArray = new byte[n];
        this._tmpBuffer.position(220);
        this._tmpBuffer.get(byArray, 0, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNewJCABqual", Util.toHexString(byArray));
        }
        return byArray;
    }

    public void setNewJCABqual(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNewJCABqual", byArray);
        }
        int n = byArray.length < 64 ? byArray.length : 64;
        this._tmpBuffer.putInt(216, n);
        for (int i = 0; i < n; ++i) {
            this._tmpBuffer.put(220 + i, byArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNewJCABqual");
        }
    }

    public byte[] getURIToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getURIToken");
        }
        byte[] byArray = new byte[16];
        this._tmpBuffer.position(284);
        this._tmpBuffer.get(byArray, 0, 16);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getURIToken", Util.toHexString(byArray));
        }
        return byArray;
    }

    public int getLogOpt() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " getLogOpt");
        }
        int n = this._tmpBuffer.getInt(300);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " getLogOpt", new Integer(n));
        }
        return n;
    }

    public int getCRecb() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " getCRecb");
        }
        int n = this._tmpBuffer.getInt(304);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " getCRecb", new Integer(n));
        }
        return n;
    }

    public byte[] getSRecbPointer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSRecbPointer");
        }
        byte[] byArray = new byte[4];
        this._tmpBuffer.position(308);
        this._tmpBuffer.get(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSRecbPointer", byArray);
        }
        return byArray;
    }

    public int getSRecbKey() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " getSRecbKey");
        }
        int n = this._tmpBuffer.getInt(312);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " getSRecbKey", new Integer(n));
        }
        return n;
    }

    public byte[] getSRascbPointer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSRecbPointer");
        }
        byte[] byArray = new byte[4];
        this._tmpBuffer.position(316);
        this._tmpBuffer.get(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSRecbPointer", byArray);
        }
        return byArray;
    }

    public int getSRorbID() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " getSRorbID");
        }
        int n = this._tmpBuffer.getInt(320);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " getSRorbID", new Integer(n));
        }
        return n;
    }

    public int getInitialTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " getInitialTimeout");
        }
        int n = this._tmpBuffer.getInt(324);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " getInitialTimeout", new Integer(n));
        }
        return n;
    }

    public void setInitialTimeout(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " setInitialTimeout", new Integer(n));
        }
        this._tmpBuffer.putInt(324, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setInitialTimeout");
        }
    }

    public byte[] getVariableDataPointer() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariableDataPointer");
        }
        byte[] byArray = new byte[4];
        this._tmpBuffer.position(344);
        this._tmpBuffer.get(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVariableDataPointer", byArray);
        }
        return byArray;
    }

    public int getVariableDataLength() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " getVariableDataLength");
        }
        int n = this._tmpBuffer.getInt(348);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " getVariableDataLength", new Integer(n));
        }
        return n;
    }

    public void setVariableDataLength(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " setVariableDataLength", new Integer(n));
        }
        this._tmpBuffer.putInt(348, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " setVariableDataLength");
        }
    }

    public byte[] getVariableData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getVariableData");
        }
        int n = this.getVariableDataLength();
        byte[] byArray = null;
        if (n > 0) {
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this._tmpBuffer.get(352 + i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getVariableData", byArray);
        }
        return byArray;
    }

    public char getVariableDataChar() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, " getVariableDataChar");
        }
        char c = this._tmpBuffer.getChar(352);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, " getVariableData", new Character(c));
        }
        return c;
    }

    public boolean getBossInitiatedFlag() {
        boolean bl = false;
        short s = this.getFlagHolder();
        if ((s & 0x8000) == 32768) {
            bl = true;
        }
        return bl;
    }

    public void setBossInitiatedFlag() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setBossInitiatedFlag");
        }
        short s = this.getFlagHolder();
        s = (short)(s | 0x8000);
        this.setFlagHolder(s);
    }

    public boolean getReportHeuristicsFlag() {
        boolean bl = false;
        short s = this.getFlagHolder();
        if ((s & 0x4000) == 16384) {
            bl = true;
        }
        return bl;
    }

    public void setReportHeuristicsFlag() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setReportHeuristicsFlag");
        }
        short s = this.getFlagHolder();
        s = (short)(s | 0x4000);
        this.setFlagHolder(s);
    }

    public boolean getAtrbakFlag() {
        boolean bl = false;
        short s = this.getFlagHolder();
        if ((s & 0x2000) == 8192) {
            bl = true;
        }
        return bl;
    }

    public boolean getExpressInterestFlag() {
        boolean bl = false;
        short s = this.getFlagHolder();
        if ((s & 0x1000) == 4096) {
            bl = true;
        }
        return bl;
    }

    public void setExpressInterestFlag() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setExpressInterestFlag");
        }
        short s = this.getFlagHolder();
        s = (short)(s | 0x1000);
        this.setFlagHolder(s);
    }

    public boolean getCommitOnePhaseFlag() {
        boolean bl = false;
        short s = this.getFlagHolder();
        if ((s & 0x800) == 2048) {
            bl = true;
        }
        return bl;
    }

    public void setCommitOnePhaseFlag() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setCommitOnePhaseFlag");
        }
        short s = this.getFlagHolder();
        s = (short)(s | 0x800);
        this.setFlagHolder(s);
    }

    public boolean getBeginFailedFlag() {
        boolean bl = false;
        short s = this.getFlagHolder();
        if ((s & 0x400) == 1024) {
            bl = true;
        }
        return bl;
    }

    public void setBeginFailedFlag() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setBeginFailed");
        }
        short s = this.getFlagHolder();
        s = (short)(s | 0x400);
        this.setFlagHolder(s);
    }

    public boolean getJcaInitiatedTransactionFlag() {
        boolean bl = false;
        short s = this.getFlagHolder();
        if ((s & 0x200) == 512) {
            bl = true;
        }
        return bl;
    }

    public void setJcaInitiatedTransactionFlag() {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setJcaInitiatedTransactionFlag");
        }
        short s = this.getFlagHolder();
        s = (short)(s | 0x200);
        this.setFlagHolder(s);
    }
}

