/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.TxPrimaryKey;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.ResourceCallback;
import com.ibm.ws.wscoor.ProtocolSecurityHelper;
import com.ibm.ws390.tx.LockHierarchy;
import com.ibm.ws390.tx.ReaderWriterLock;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionRecoveryCoordinatorImpl;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions._RecoveryCoordinatorImplBase;

public class TransactionRecoveryCoordinator
extends _RecoveryCoordinatorImplBase
implements ResourceCallback {
    private static final TraceComponent tc = Tr.register(TransactionRecoveryCoordinator.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private TransactionRecoveryCoordinatorImpl _recCoordImpl;

    public TransactionRecoveryCoordinator(TransactionRecoveryCoordinatorImpl transactionRecoveryCoordinatorImpl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionRecoveryCoordinator");
        }
        this._recCoordImpl = transactionRecoveryCoordinatorImpl;
        TransactionControlRep transactionControlRep = this._recCoordImpl.getControlRep();
        FailureScopeController failureScopeController = Configuration.getFailureScopeController();
        TxPrimaryKey txPrimaryKey = transactionControlRep.getPrimaryKey();
        failureScopeController.registerRecoveryCoordinator(this, txPrimaryKey.toBytes());
        transactionControlRep.addDestroyCallback(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionRecoveryCoordinator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status replay_completion(Resource resource) throws NotPrepared {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replay_completion", resource);
        }
        Status status = null;
        ProtocolSecurityHelper.checkAuthorization();
        TransactionControlRep transactionControlRep = this._recCoordImpl.getControlRep();
        LockHierarchy lockHierarchy = transactionControlRep.getLockHierarchy();
        ReaderWriterLock readerWriterLock = transactionControlRep.getLock();
        readerWriterLock.obtainWrite(lockHierarchy);
        try {
            status = this._recCoordImpl.replay_completion(resource);
        }
        finally {
            readerWriterLock.releaseWrite(lockHierarchy);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replay_completion", status);
        }
        return status;
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "destroy", this);
        }
        FailureScopeController failureScopeController = Configuration.getFailureScopeController();
        TxPrimaryKey txPrimaryKey = this._recCoordImpl.getControlRep().getPrimaryKey();
        failureScopeController.unregisterRecoveryCoordinator(txPrimaryKey.toBytes());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "destroy", this);
        }
    }
}

