/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.runtime.component.TxServiceImpl;
import com.ibm.ws390.tx.BranchRegistryTable;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.LockHierarchy;
import com.ibm.ws390.tx.NativeServerInstanceData;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.ResourceManager;
import com.ibm.ws390.tx.SyncpointInterest;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionCoordinatorImpl;
import com.ibm.ws390.tx.TransactionResource;
import com.ibm.ws390.tx.TransactionalUnitOfWork;
import com.ibm.ws390.tx.XARecoveryAgentImpl;
import com.ibm.ws390.tx.xarecovery.HeuristicException;
import com.ibm.ws390.tx.xarecovery.RecoveryException;
import com.ibm.ws390.tx.xarecovery.ResourceManagerException;
import com.ibm.ws390.tx.xarecovery.XARecoveryAgent;
import com.ibm.ws390.tx.xarecovery.XID;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.TRANSIENT;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinator;
import org.omg.CosTransactions.Status;

public class TransactionResolver
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(TransactionResolver.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final int FAILED_XA_TIMEOUT = 30;
    private TransactionControlRep _controlRep;
    private TransactionalUnitOfWork _uow;
    private int _snoozeReason;
    private int _snoozeIterations;
    private int _snoozeDuration;
    private int _lastSnoozeDuration;
    public static int _configuredRetryWait = TransactionImpl.heuristicRetryWait;
    public static int _configuredRetryLimit = TransactionImpl.heuristicRetryLimit;
    public static int _configuredHeuristicCompletion = TransactionImpl.lpsHeuristicCompletion;
    private static boolean _disableGracePeriod = false;
    private int _resolutionType;
    private boolean _blockingResolutionActive;
    private boolean _superiorStatusActive;
    private boolean _redispatchFailActive;
    private int _currentToken = 0;
    private Alarm _alarm;
    private long _startTime;
    public static final int INITIAL = 0;
    public static final int APPLICATION_TIMEOUT = 1;
    public static final int TX_COMPLETION = 2;
    public static final int COMMIT_FAILED_XA = 3;
    public static final int ROLLBACK_FAILED_XA = 4;
    public static final int RESOLUTION_NOT_REQUIRED = 0;
    public static final int RESOLUTION_COMMIT = 1;
    public static final int RESOLUTION_ROLLBACK = 2;
    public static final int RESOLUTION_FORGET = 3;
    public static final int RESOLUTION_MANUAL = 4;
    private final int RESON_NONE = 0;
    private final int REASON_DEFAULT = 1;
    private final int REASON_APP_TIMEOUT_APP_BUSY = 2;
    private final int REASON_APP_TIMEOUT_APP_FREE = 3;
    private final int REASON_APP_TIMEOUT_DURING_SYNCPT = 4;
    private final int REASON_TX_COMPLETION = 5;
    private final int REASON_RESOLVER_ACTIVE = 6;
    private final int REASON_RESTARTED_DBT_RESOLVER = 7;
    private final int REASON_RESTARTED_CMT_RB_RESOLVER = 8;
    public final int INITSD_NONE = 0;
    public final int INITSD_DEFAULT = 60;
    public final int INITSD_APP_TIMEOUT_APP_BUSY = 60;
    public final int INITSD_APP_TIMEOUT_APP_FREE = 20;
    public final int INITSD_APP_TIMEOUT_DURING_SYNCPT = 30;
    public final int INITSD_TX_COMPLETION = 20;
    public final int INITSD_TX_RESTART_COMPLETION = 10;
    public final int INITSD_RESOLVER_ACTIVE = 20;
    public final int INITSD_RESTARTED_DBT_RESOLVER = 1;
    public final int INITSD_RESTARTED_CMT_RB_RESOLVER = 30;
    private final int MAXSD_NONE = 0;
    private final int MAXSD_DEFAULT = 60;
    private final int MAXSD_APP_TIMEOUT_APP_BUSY = 200;
    private final int MAXSD_APP_TIMEOUT_APP_FREE = 20;
    private final int MAXSD_APP_TIMEOUT_DURING_SYNCPT = 300;
    private final int MAXSD_TX_COMPLETION = 200;
    private final int MAXSD_TX_RESTART_COMPLETION = 45;
    private final int MAXSD_RESOLVER_ACTIVE = 200;
    private final int MAXSD_RESTARTED_DBT_RESOLVER = 1;
    private final int MAXSD_RESTARTED_CMT_RB_RESOLVER = 600;
    private final int BCKOFF_NONE = 0;
    private final int BCKOFF_DEFAULT = 0;
    private final int BCKOFF_APP_TIMEOUT_APP_BUSY = 4;
    private final int BCKOFF_APP_TIMEOUT_APP_FREE = 4;
    private final int BCKOFF_APP_TIMEOUT_DURING_SYNCPT = 4;
    private final int BCKOFF_TX_COMPLETION = 2;
    private final int BCKOFF_TX_RESTART_COMPLETION = 8;
    private final int BCKOFF_RESOLVER_ACTIVE = 8;
    private final int BCKOFF_RESTARTED_DBT_RESOLVER = 0;
    private final int BCKOFF_RESTARTED_CMT_RB_RESOLVER = 4;

    public TransactionResolver(TransactionControlRep transactionControlRep) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionResolver");
        }
        this._controlRep = transactionControlRep;
        this._uow = transactionControlRep.getUnitOfWork();
        this._snoozeIterations = 0;
        this._snoozeDuration = 0;
        this._lastSnoozeDuration = 0;
        this._redispatchFailActive = false;
        this._superiorStatusActive = false;
        this._blockingResolutionActive = false;
        this._startTime = System.currentTimeMillis();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionResolver");
        }
    }

    private int computeSnoozeDuration(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "computeSnoozeDuration", new Integer(n));
        }
        int n2 = 30;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                n3 = 60;
                n4 = 60;
                n6 = 0;
                break;
            }
            case 2: {
                n3 = 60;
                n4 = 200;
                n6 = 4;
                break;
            }
            case 3: {
                n3 = 20;
                n4 = 20;
                n6 = 4;
                break;
            }
            case 4: {
                n3 = 30;
                n4 = 300;
                n6 = 4;
                break;
            }
            case 5: {
                ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
                ResourceManager resourceManager = controllerTransactionManagerSet.getResourceManager();
                if (resourceManager.isRestartOnlyMode()) {
                    n3 = 10;
                    n4 = 45;
                    n6 = 8;
                } else {
                    n3 = 20;
                    n4 = 200;
                    n6 = 2;
                }
                Random random = new Random();
                n5 = (int)(30.0 * (double)random.nextInt() / 2.147483647E9 + 1.0);
                n5 -= 15;
                break;
            }
            case 6: {
                n3 = 20;
                n4 = 200;
                n6 = 8;
                break;
            }
            case 7: {
                n3 = 1;
                n4 = 1;
                n6 = 0;
                break;
            }
            case 8: {
                n3 = 30;
                n4 = 600;
                n6 = 4;
                break;
            }
            default: {
                String string = "The reason for snoozing this alarm is invalid.";
                INTERNAL iNTERNAL = new INTERNAL(string, -910026408, CompletionStatus.COMPLETED_NO);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "computeSnoozeDuration", (Object)iNTERNAL);
                }
                throw iNTERNAL;
            }
        }
        n2 = this._snoozeDuration;
        if (this._snoozeReason == n) {
            ++this._snoozeIterations;
            if (_configuredRetryLimit > 0 && this._snoozeIterations > _configuredRetryLimit) {
                this._snoozeIterations = 0;
            }
            if (_configuredRetryWait > 0) {
                n2 = _configuredRetryWait;
            } else {
                if (this._snoozeIterations == 1) {
                    n2 = n3;
                }
                if (n6 > 0) {
                    if (n2 < n4) {
                        if ((n2 += n2 / n6) + n5 > 0) {
                            n2 += n5;
                        }
                    } else {
                        n2 = n4;
                        if (n4 + n5 > 0) {
                            n2 = n4 + n5;
                        }
                    }
                }
            }
        } else {
            n2 = _configuredRetryWait > 0 ? _configuredRetryWait : n3;
            this._snoozeReason = n;
            this._snoozeIterations = 0;
        }
        this._snoozeDuration = n2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "computeSnoozeDuration", new Integer(n2));
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", new Object[]{object, this});
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        int n = 0;
        if (!(object instanceof Integer)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid alarmContext");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "alarm", illegalArgumentException);
            }
            throw illegalArgumentException;
        }
        n = (Integer)object;
        ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
        LockHierarchy lockHierarchy = controllerTransactionManagerSet.getLockHierarchy();
        this._controlRep.getLock().obtainWrite(lockHierarchy);
        try {
            boolean bl5;
            boolean bl6 = this._controlRep.isRoot();
            boolean bl7 = this._uow.isDelegate();
            boolean bl8 = this._controlRep.isNormal();
            int n2 = 0;
            int n3 = this._controlRep.getState();
            boolean bl9 = bl5 = n3 == 8 || n3 == 10 || n3 == 15 || n3 == 16 || n3 == 17;
            if (n != this._currentToken) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Alarm with token " + n + " popped " + "but current token is " + this._currentToken);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "alarm", this);
                }
                return;
            }
            this._alarm = null;
            if (this.isActive() && !bl5) {
                n2 = this.computeSnoozeDuration(6);
                this.start(n2);
            } else {
                block3 : switch (this._resolutionType) {
                    case 1: {
                        switch (n3) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                if (n3 != 4) {
                                    TransactionCoordinatorImpl transactionCoordinatorImpl = this._controlRep.getCoordinatorImpl();
                                    if (transactionCoordinatorImpl != null) {
                                        try {
                                            transactionCoordinatorImpl.rollback_only();
                                        }
                                        catch (Inactive inactive) {}
                                    } else {
                                        throw new IllegalStateException("Transaction with no Coordinator");
                                    }
                                }
                                this._controlRep.setTimedOut();
                                if (this._controlRep.isContextActive() || this._controlRep.outstandingReplies()) {
                                    if (this._snoozeIterations > 1 || _disableGracePeriod) {
                                        bl2 = true;
                                    }
                                    n2 = this.computeSnoozeDuration(2);
                                    if (this._controlRep.getTransactionExecutionType() == 4 && n2 > 200) {
                                        bl3 = true;
                                    }
                                    this.start(n2);
                                    break block3;
                                }
                                if (n3 == 1 || n3 == 2) {
                                    bl = true;
                                    break block3;
                                }
                                this.setResolutionType(2);
                                n2 = this.computeSnoozeDuration(3);
                                bl = this.resolve();
                                break block3;
                            }
                        }
                        this.setResolutionType(2);
                        n2 = this.computeSnoozeDuration(4);
                        this.start(n2);
                        break;
                    }
                    case 2: {
                        bl = this.resolve();
                        if (bl || _configuredRetryLimit > 0 && this._snoozeIterations >= _configuredRetryLimit && n3 == 7 && _configuredHeuristicCompletion == 2) break;
                        n2 = this.computeSnoozeDuration(5);
                        this.start(n2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        boolean bl10 = false;
                        if (this._uow.getFailedXAResourceFlag()) {
                            byte[] byArray;
                            int n4 = 2;
                            if (this._resolutionType == 3) {
                                n4 = 1;
                            }
                            if (bl10 = (byArray = this._uow.getXAPdata()) != null ? this.resolveXAResources(bl6, bl8, byArray, n4) : true) {
                                this._uow.setFailedXAResourceFlag(false);
                                this._uow.setXAPdata(null);
                            }
                        } else {
                            bl10 = true;
                        }
                        if (bl10) {
                            if (bl6 || this._controlRep.isJCA()) {
                                bl = this.blockingResolution(3, bl6, bl8);
                            } else {
                                this.setResolutionType(2);
                            }
                        }
                        if (bl10 && bl) break;
                        n2 = this.computeSnoozeDuration(5);
                        this.start(n2);
                        break;
                    }
                    default: {
                        String string = "Invalid Resolution type.";
                        INTERNAL iNTERNAL = new INTERNAL(string);
                        throw iNTERNAL;
                    }
                }
            }
            if (bl3) {
                this._controlRep.getLock().releaseWrite(lockHierarchy);
                bl4 = false;
                RasHelper.exit(-910026609, false);
            }
            if (bl) {
                this._controlRep.destroy(lockHierarchy);
                this.stop();
            } else {
                XidImpl xidImpl = this._controlRep.getXid();
                this._controlRep.getLock().releaseWrite(lockHierarchy);
                bl4 = false;
                if (bl2) {
                    byte[] byArray = BranchRegistryTable.xidToGtid(xidImpl);
                    TransactionResolver.tranTimeoutCleanup(byArray);
                }
            }
        }
        finally {
            if (bl4) {
                this._controlRep.getLock().releaseWrite(lockHierarchy);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm", this);
        }
    }

    private static final native void tranTimeoutCleanup(byte[] var0);

    /*
     * Unable to fully structure code
     */
    public boolean blockingResolution(int var1_1, boolean var2_2, boolean var3_3) {
        if (TransactionResolver.tc.isEntryEnabled()) {
            Tr.entry(TransactionResolver.tc, "blockingResolution", new Object[]{new Integer(var1_1), new Boolean(var2_2), new Boolean(var3_3)});
        }
        var4_4 = null;
        var5_5 = null;
        var6_6 = false;
        var7_7 = false;
        var8_8 = 0;
        var9_9 = this.isActive();
        var10_10 = false;
        var11_11 = false;
        if (var9_9) {
            var12_12 = this._uow.getURID();
            if (TransactionResolver.tc.isEntryEnabled()) {
                Tr.exit(TransactionResolver.tc, "blockingResolution", var12_12);
            }
            RasHelper.exit(-910026496, false);
        }
        this._blockingResolutionActive = true;
        if (var1_1 != 4) {
            var8_8 = this.computeSnoozeDuration(5);
            this.start(var8_8);
        }
        switch (var1_1) {
            case 1: {
                var10_10 = true;
                var11_11 = this._uow.isXAEnlisted();
                if (!var2_2) ** GOTO lbl49
                if (var11_11) {
                    var10_10 = false;
                }
                try {
                    this._uow.commitRoot(var10_10);
                }
                catch (HeuristicMixed var12_13) {
                }
                catch (Throwable var12_14) {
                    this._blockingResolutionActive = false;
                    var13_24 = new INTERNAL();
                    if (TransactionResolver.tc.isEntryEnabled()) {
                        Tr.exit(TransactionResolver.tc, "blockingResolution", var12_14);
                    }
                    throw var13_24;
                }
                if (!var3_3) ** GOTO lbl46
                var4_4 = this._controlRep.getTerminatorImpl();
                try {
                    var4_4.afterCompletion();
                }
                catch (Throwable var12_15) {
                    if (!TransactionResolver.tc.isDebugEnabled()) ** GOTO lbl46
                    Tr.debug(TransactionResolver.tc, "commit root after completion exc.", var12_15);
                }
lbl46:
                // 4 sources

                if (var11_11) break;
                var6_6 = true;
                break;
lbl49:
                // 1 sources

                if (var11_11) {
                    var10_10 = false;
                }
                try {
                    this._uow.commitSubordinate(var10_10);
                }
                catch (HeuristicMixed var12_16) {
                    var7_7 = true;
                }
                catch (Throwable var12_17) {
                    this._blockingResolutionActive = false;
                    var13_25 = new INTERNAL(-910026608, CompletionStatus.COMPLETED_MAYBE);
                    if (TransactionResolver.tc.isEntryEnabled()) {
                        Tr.exit(TransactionResolver.tc, "blockingResolution", var12_17);
                    }
                    throw var13_25;
                }
                if (!var3_3) ** GOTO lbl71
                var5_5 = this._controlRep.getResourceImpl();
                try {
                    this._controlRep.afterCompletion(this._controlRep.getStatus());
                }
                catch (Throwable var12_18) {
                    if (!TransactionResolver.tc.isDebugEnabled()) ** GOTO lbl71
                    Tr.debug(TransactionResolver.tc, "commit subordinate after completion exc", var12_18);
                }
lbl71:
                // 4 sources

                if (var11_11) break;
                if (!var7_7) {
                    var6_6 = true;
                    break;
                }
                this._controlRep.changeState(12);
                break;
            }
            case 2: {
                var10_10 = true;
                var11_11 = this._uow.isXAEnlisted();
                if (!var2_2) ** GOTO lbl103
                if (var11_11) {
                    var10_10 = false;
                }
                try {
                    this._uow.rollbackRoot(var10_10);
                }
                catch (Throwable var12_19) {
                    this._blockingResolutionActive = false;
                    var13_26 = new INTERNAL(-910026608, CompletionStatus.COMPLETED_MAYBE);
                    if (TransactionResolver.tc.isEntryEnabled()) {
                        Tr.exit(TransactionResolver.tc, "blockingResolution", var12_19);
                    }
                    throw var13_26;
                }
                if (!var3_3) ** GOTO lbl100
                var4_4 = this._controlRep.getTerminatorImpl();
                try {
                    var4_4.afterCompletion();
                }
                catch (Throwable var12_20) {
                    if (!TransactionResolver.tc.isDebugEnabled()) ** GOTO lbl100
                    Tr.debug(TransactionResolver.tc, "rollback root exception", var12_20);
                }
lbl100:
                // 4 sources

                if (var11_11) break;
                var6_6 = true;
                break;
lbl103:
                // 1 sources

                if (var11_11) {
                    var10_10 = false;
                }
                try {
                    this._uow.rollbackSubordinate(var10_10);
                }
                catch (HeuristicMixed var12_21) {
                    var7_7 = true;
                }
                catch (Throwable var12_22) {
                    this._blockingResolutionActive = false;
                    var13_27 = new INTERNAL(-910026608, CompletionStatus.COMPLETED_MAYBE);
                    if (TransactionResolver.tc.isEntryEnabled()) {
                        Tr.exit(TransactionResolver.tc, "blockingResolution", var12_22);
                    }
                    throw var13_27;
                }
                if (!var3_3) ** GOTO lbl125
                var5_5 = this._controlRep.getResourceImpl();
                try {
                    this._controlRep.afterCompletion(this._controlRep.getStatus());
                }
                catch (Throwable var12_23) {
                    if (!TransactionResolver.tc.isDebugEnabled()) ** GOTO lbl125
                    Tr.debug(TransactionResolver.tc, "rollback subordinate exception", var12_23);
                }
lbl125:
                // 4 sources

                if (var11_11) break;
                if (!var7_7) {
                    var6_6 = true;
                    break;
                }
                this._controlRep.changeState(12);
                break;
            }
            case 3: {
                if (this._controlRep.isCascaded()) {
                    this.redispatchFailedExitBackends();
                } else if (!this._uow.isUrForgotten()) {
                    this._uow.forget();
                }
                var6_6 = true;
                break;
            }
            case 4: {
                this._controlRep.setManualOutcome();
            }
        }
        this._blockingResolutionActive = false;
        if (TransactionResolver.tc.isEntryEnabled()) {
            Tr.exit(TransactionResolver.tc, "blockingResolution", new Boolean(var6_6));
        }
        return var6_6;
    }

    public void start(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "start", new Object[]{this, new Integer(n)});
        }
        if (this._alarm != null) {
            this.stop();
        }
        Integer n2 = new Integer(this._currentToken);
        this._startTime = System.currentTimeMillis();
        this._lastSnoozeDuration = n;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Registering a new alarm", new Object[]{this, new Integer(n), n2});
        }
        this._alarm = AlarmManager.createNonDeferrable((long)n * 1000L, this, n2);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "start");
        }
    }

    public boolean resolve() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resolve");
        }
        SyncpointInterest syncpointInterest = null;
        Status status = Status.StatusUnknown;
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this._controlRep.isRoot();
        boolean bl4 = this._uow.isDelegate();
        boolean bl5 = this._controlRep.isCascaded();
        boolean bl6 = this._controlRep.isNormal();
        int n2 = this._controlRep.getState();
        int n3 = 0;
        byte[] byArray = this._uow.getXAPdata();
        byte[] byArray2 = this._uow.getURID();
        if (this._superiorStatusActive || this._blockingResolutionActive) {
            syncpointInterest = this._uow.getSyncpointInterest();
            if (!syncpointInterest.isSyncpointComplete()) {
                this.redispatchFailedExitBackends();
            }
            n = 0;
        } else {
            block0 : switch (n2) {
                case 4: {
                    if (bl5) {
                        n = 0;
                        break;
                    }
                    n = 2;
                    break;
                }
                case 5: {
                    n = 0;
                    break;
                }
                case 7: {
                    if (bl3) {
                        n = 2;
                        break;
                    }
                    if (bl5) {
                        n = 0;
                        break;
                    }
                    if (!bl4) {
                        status = this.getSuperiorStatus();
                        switch (status.value()) {
                            case 3: 
                            case 8: {
                                n = 1;
                                break block0;
                            }
                            case 4: 
                            case 6: 
                            case 9: {
                                n = 2;
                                break block0;
                            }
                            case 0: 
                            case 1: {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Protocol vilation. invalis superior state");
                                }
                                n = 2;
                                break block0;
                            }
                            case 2: 
                            case 5: 
                            case 7: {
                                n = 0;
                                break block0;
                            }
                        }
                        INTERNAL iNTERNAL = new INTERNAL(-910026608, CompletionStatus.COMPLETED_MAYBE);
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "resolve");
                        }
                        throw iNTERNAL;
                    }
                    n = 1;
                    break;
                }
                case 15: 
                case 16: {
                    int n4;
                    int n5;
                    if (byArray != null) {
                        n5 = 0;
                        n4 = 2;
                        n4 = n2 == 16 || !bl6 && bl3 && this._uow.getHeuristicFlag() ? 2 : 1;
                        n5 = this.resolveXAResources(bl3, bl6, byArray, n4) ? 1 : 0;
                        if (n5 != 0) {
                            this._uow.setXAPdata(null);
                        }
                        n = 0;
                        break;
                    }
                    syncpointInterest = this._uow.getSyncpointInterest();
                    if (syncpointInterest.isSyncpointComplete()) {
                        if (n2 == 15) {
                            n = 1;
                            break;
                        }
                        n = 2;
                        bl = true;
                        break;
                    }
                    this.redispatchFailedExitBackends();
                    n = 0;
                    break;
                }
                case 6: 
                case 17: {
                    int n5;
                    syncpointInterest = this._uow.getSyncpointInterest();
                    if (!syncpointInterest.isSyncpointComplete()) {
                        n5 = this._uow.getState();
                        if (n5 == 5) {
                            this._controlRep.changeState(8);
                            this.redispatchFailedExitBackends();
                        } else if (n5 == 6) {
                            this._controlRep.changeState(10);
                            this.redispatchFailedExitBackends();
                        }
                    }
                    n = 0;
                    break;
                }
                case 8: 
                case 10: {
                    syncpointInterest = this._uow.getSyncpointInterest();
                    if (!syncpointInterest.isSyncpointComplete()) {
                        this.redispatchFailedExitBackends();
                    }
                    n = 0;
                    break;
                }
                case 9: 
                case 11: {
                    int n4;
                    int n5;
                    if (!(byArray == null || bl5 && bl6)) {
                        n5 = 0;
                        n4 = 0;
                        n4 = n2 == 11 || !bl6 && bl3 && this._uow.getHeuristicFlag() ? 2 : 1;
                        n5 = this.resolveXAResources(bl3, bl6, byArray, n4) ? 1 : 0;
                        if (n5 != 0) {
                            this._uow.setXAPdata(null);
                            if (!bl6 || !this._controlRep.isServantAlive()) {
                                this._controlRep.changeState(12);
                                n = 3;
                                break;
                            }
                            n = 0;
                            break;
                        }
                        n = 0;
                        break;
                    }
                    if (this._controlRep.isTxMBeanResolved()) {
                        this._controlRep.changeState(12);
                        n = 3;
                        break;
                    }
                    n = 0;
                    break;
                }
                case 12: {
                    bl2 = this._uow.isForgetPending();
                    if (bl3 || bl2) {
                        n = 3;
                        break;
                    }
                    status = this.getSuperiorStatus();
                    switch (status.value()) {
                        case 6: {
                            if (bl6) {
                                n = 3;
                                break block0;
                            }
                            n3 = this._uow.getRestartedState();
                            if (n3 == 7 && tc.isDebugEnabled()) {
                                Tr.debug(tc, "Protocol violation.  Invalid superior state");
                            }
                            n = 3;
                            break block0;
                        }
                        case 0: 
                        case 1: 
                        case 2: 
                        case 7: {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Protocol violation.  Invalid superior state");
                            }
                            n = 3;
                            break block0;
                        }
                        case 3: 
                        case 4: 
                        case 5: 
                        case 8: 
                        case 9: {
                            n = 0;
                            break block0;
                        }
                    }
                    INTERNAL iNTERNAL = new INTERNAL(-910026608, CompletionStatus.COMPLETED_MAYBE);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resolve");
                    }
                    throw iNTERNAL;
                }
                default: {
                    n = 0;
                }
            }
            byArray = this._uow.getXAPdata();
            if (_configuredRetryLimit > 0 && this._snoozeIterations >= _configuredRetryLimit && n2 == 7) {
                XidImpl xidImpl = this._controlRep.getXid();
                String string = String.valueOf(xidImpl.getFormatId());
                String string2 = Util.toHexString(xidImpl.getGlobalTransactionId());
                String string3 = Util.toHexString(xidImpl.getBranchQualifier());
                String string4 = Util.toHexString(byArray2);
                String string5 = Configuration.getServerName();
                if (_configuredHeuristicCompletion == 1) {
                    this._uow.setHeuristicFlag();
                    n = 1;
                    Tr.error(tc, "BBOT0031_HEURISTIC_OUTCOME_COMMIT", new Object[]{string5, string4, string, string2, string3, new Integer(_configuredRetryLimit), string5});
                } else if (_configuredHeuristicCompletion == 2) {
                    n = 4;
                    Tr.info(tc, "BBOT0033_REQUIRES_MANUAL_RESOLUTION", new Object[]{string5, string4, string, string2, string3, new Integer(_configuredRetryLimit), string5});
                } else {
                    this._uow.setHeuristicFlag();
                    n = 2;
                    Tr.error(tc, "BBOT0032_HEUISTIC_OUTCOME_ROLBACK", new Object[]{string5, string4, string, string2, string3, new Integer(_configuredRetryLimit), string5});
                }
            }
            switch (n) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (byArray != null) {
                        boolean bl7 = false;
                        bl7 = this.resolveXAResources(bl3, bl6, byArray, n);
                        if (bl7) {
                            byArray = null;
                            this._uow.setXAPdata(null);
                        }
                    }
                    bl = this.blockingResolution(n, bl3, bl6);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    INTERNAL iNTERNAL = new INTERNAL(-910026608, CompletionStatus.COMPLETED_MAYBE);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "resolve");
                    }
                    throw iNTERNAL;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolve", new Boolean(bl));
        }
        return bl;
    }

    public Status getSuperiorStatus() {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSuperiorStatus");
        }
        Status status = Status.StatusUnknown;
        XidImpl xidImpl = this._controlRep.getXid();
        int n = 0;
        final TransactionResource transactionResource = this._controlRep.getResourceImpl().getRemoteResource();
        final RecoveryCoordinator recoveryCoordinator = this._uow.getRecoveryCoordinator();
        int n2 = this._controlRep.getState();
        this._superiorStatusActive = true;
        this._controlRep.releaseTxLock();
        try {
            object = new PrivilegedExceptionAction(){

                public Object run() throws NotPrepared {
                    return recoveryCoordinator.replay_completion(transactionResource);
                }
            };
            status = (Status)TxServiceImpl.runAsSystemOrSpecified(object);
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            SyncpointInterest syncpointInterest = this._uow.getSyncpointInterest();
            byte[] byArray = syncpointInterest.getURIToken();
            if (throwable instanceof OBJECT_NOT_EXIST) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Superior does not exist or not available", new Object[]{byArray, throwable});
                }
                status = Status.StatusNoTransaction;
            }
            if (throwable instanceof COMM_FAILURE) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Communication Failure while contacting superior.  Operation will be retried.", new Object[]{byArray, throwable});
                }
                status = Status.StatusUnknown;
            }
            if (throwable instanceof TRANSIENT) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Failed to reach superior. Operation will be retried.", new Object[]{byArray, throwable});
                }
                status = Status.StatusUnknown;
            }
            if (throwable instanceof NO_PERMISSION) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No permission detected. Operation will be retried.", new Object[]{throwable, byArray, xidImpl});
                }
                status = Status.StatusUnknown;
                ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
                String string = String.valueOf(xidImpl.getFormatId());
                String string2 = Util.toHexString(xidImpl.getGlobalTransactionId());
                String string3 = Util.toHexString(xidImpl.getBranchQualifier());
                byte[] byArray2 = this._uow.getURID();
                String string4 = Util.toHexString(byArray2);
                String[] stringArray = controllerTransactionManagerSet.getHostInfoFromObject(transactionResource);
                Tr.info(tc, "BBOT0036_NO_PERMISSION", new Object[]{"GetSuperiorStatus", string4, Integer.toString(xidImpl.getFormatId()), string2, string3, stringArray[0], stringArray[1], stringArray[2]});
            }
            if (throwable instanceof NotPrepared) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Superior either active or markedRoolback", new Object[]{byArray, throwable});
                }
                status = Status.StatusActive;
            }
            this._superiorStatusActive = false;
            INTERNAL iNTERNAL = new INTERNAL(-910026608, CompletionStatus.COMPLETED_MAYBE);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "failed to obtain superior's status.", byArray);
            }
            throw iNTERNAL;
        }
        this._controlRep.obtainExclusiveTxLock();
        this._superiorStatusActive = false;
        n = this._controlRep.getState();
        if (n2 != n) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "Transaction state error.", new Object[]{new Integer(n2), new Integer(n)});
            }
            object = new INTERNAL(-910026608, CompletionStatus.COMPLETED_MAYBE);
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSuperiorStatus", status);
        }
        return status;
    }

    public void redispatchFailedExitBackends() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "redispatchFailedExitBackends");
        }
        if (this._redispatchFailActive) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Resolver already active trying to redispatch failed backends", this._uow.getURID());
            }
        } else {
            this._redispatchFailActive = true;
            this._uow.redispatchFailedExitBackends();
            this._redispatchFailActive = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "redispatchFailedExitBackends");
        }
    }

    public boolean resolveXAResources(boolean bl, boolean bl2, byte[] byArray, int n) {
        byte[] byArray2;
        boolean bl3;
        boolean bl4;
        block15: {
            XARecoveryAgent xARecoveryAgent;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "resolveXAResources", new Object[]{new Boolean(bl), new Boolean(bl2), byArray, new Integer(n)});
            }
            bl4 = false;
            bl3 = false;
            final int n2 = n;
            byArray2 = byArray;
            byte[] byArray3 = NativeServerInstanceData.getRecoveryServantStoken();
            Iterator iterator = AdminServiceImpl.getPlatformUtils().getSRAggregator(new XARecoveryAgentImpl(), false, byArray3);
            try {
                xARecoveryAgent = (XARecoveryAgent)iterator.next();
            }
            catch (NoSuchElementException noSuchElementException) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "driveXARecoveryAgent", noSuchElementException);
                }
                return false;
            }
            XidImpl xidImpl = this._controlRep.getXid();
            final XID xID = new XID(xidImpl.getFormatId(), xidImpl.getGlobalTransactionId().length, xidImpl.getBranchQualifier().length, xidImpl.getOtidBytes());
            if (tc.isEventEnabled()) {
                Tr.event(tc, "XID, XARID", new Object[]{xidImpl, xID});
            }
            final byte[] byArray4 = new byte[]{};
            final byte[] byArray5 = new byte[]{};
            try {
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                    public Object run() throws ResourceManagerException, RecoveryException, HeuristicException {
                        switch (n2) {
                            case 1: {
                                xARecoveryAgent.commit(xID, byArray2, byArray5, byArray4);
                                break;
                            }
                            case 2: {
                                xARecoveryAgent.rollback(xID, byArray2, byArray5, byArray4);
                                break;
                            }
                            case 3: {
                                xARecoveryAgent.forget(xID, byArray2);
                                break;
                            }
                        }
                        return null;
                    }
                };
                TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
                bl4 = true;
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof ResourceManagerException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "XA resource did not respond. Try again later.", throwable);
                    }
                }
                if (throwable instanceof RecoveryException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Unexpected exception thrown by an XA resource. Try again later", throwable);
                    }
                }
                if (throwable instanceof HeuristicException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "Heuristic exception thrown by an XA resource.", throwable);
                    }
                    this._uow.setHeuristicFlag();
                    bl3 = true;
                }
                if (!tc.isEntryEnabled()) break block15;
                Tr.exit(tc, "Unexpected exception thrown by an XA resource.", new Object[]{throwable, xidImpl, xID});
            }
        }
        if (bl3) {
            bl4 = this.resolveXAResources(bl, bl2, byArray2, 3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resolveXAResources", new Boolean(bl4));
        }
        return bl4;
    }

    public void setResolutionType(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setResolutionType", new Integer(n));
        }
        this._resolutionType = n;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setResolutionType", new Integer(this._resolutionType));
        }
    }

    public int getResolutionType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResolutionType");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResolutionType", new Integer(this._resolutionType));
        }
        return this._resolutionType;
    }

    public boolean isActive() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isActive");
        }
        boolean bl = false;
        if (this._redispatchFailActive || this._superiorStatusActive || this._blockingResolutionActive) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isActive", new Boolean(bl));
        }
        return bl;
    }

    public synchronized void stop() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stop");
        }
        if (this._alarm != null) {
            this._alarm.cancel();
            this._alarm = null;
            ++this._currentToken;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "stop");
        }
    }

    public synchronized boolean disableAlarm() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "disableAlarm");
        }
        boolean bl = false;
        if (AlarmManager.disableAlarm(this._alarm)) {
            bl = true;
            this._alarm = null;
        } else {
            ++this._currentToken;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "disableAlarm", new Boolean(bl));
        }
        return bl;
    }

    public synchronized int getRemainingTime() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRemainingTime");
        }
        int n = 0;
        long l = System.currentTimeMillis();
        int n2 = (int)((l - this._startTime) / 1000L);
        n = n2 > this._lastSnoozeDuration ? 0 : this._lastSnoozeDuration - n2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRemainingTime", new Integer(n));
        }
        return n;
    }

    public static final void disableGracePeriod() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "disableGracePeriod");
        }
        _disableGracePeriod = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TransactionResolver@");
        stringBuffer.append(Util.toHexString(this._controlRep.getPrimaryKey().toBytes()));
        stringBuffer.append(", Snooze Reason = ");
        stringBuffer.append(this._snoozeReason);
        stringBuffer.append(", Resolution Type = ");
        stringBuffer.append(this._resolutionType);
        stringBuffer.append(", Current Token = ");
        stringBuffer.append(this._currentToken);
        stringBuffer.append("; ");
        return stringBuffer.toString();
    }
}

