/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.runtime.component.TxServiceImpl;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.LockHierarchy;
import com.ibm.ws390.tx.SyncpointManagerImpl;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionalUnitOfWork;
import com.ibm.ws390.tx.syncpoint.SyncpointFailedException;
import com.ibm.ws390.tx.syncpoint.SyncpointManager;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.omg.CORBA.INTERNAL;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Synchronization;

public class TransactionSynchronizer {
    private static final TraceComponent tc = Tr.register(TransactionSynchronizer.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    ArrayList _syncs;
    private TransactionControlRep _controlRep;
    private TransactionalUnitOfWork _uow;

    public TransactionSynchronizer(TransactionControlRep transactionControlRep) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionSynchronizer", transactionControlRep);
        }
        this._controlRep = transactionControlRep;
        this._uow = transactionControlRep.getUnitOfWork();
        this._syncs = new ArrayList();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionSynchronizer");
        }
    }

    public void register_synchronization(Synchronization synchronization) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerSynchronization", synchronization);
        }
        this._syncs.add(synchronization);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerSynchronization");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void before_completion() throws SyncpointFailedException {
        Object object;
        Object object2;
        LockHierarchy lockHierarchy;
        block17: {
            block18: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "before_completion");
                }
                lockHierarchy = ControllerTransactionManagerSet.instance().getLockHierarchy();
                if (PlatformHelperFactory.getPlatformHelper().isServantJvm() || PlatformHelperFactory.getPlatformHelper().isClientJvm() || this._controlRep.isJCA()) break block17;
                if (!this._controlRep.isRoot()) break block18;
                if (this._controlRep.getTransactionType() != 7) break block17;
            }
            object2 = this.getSyncpointManager();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Driving beforeCompletion into servant");
            }
            object = this._controlRep.getXid().getPrimaryKey().toBytes();
            this._controlRep.getLock().releaseWrite(lockHierarchy);
            try {
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction((SyncpointManager)object2, (byte[])object){
                    private final /* synthetic */ SyncpointManager val$syncManager;
                    private final /* synthetic */ byte[] val$txPrimaryKey;
                    {
                        this.val$syncManager = syncpointManager;
                        this.val$txPrimaryKey = byArray;
                    }

                    public Object run() throws SyncpointFailedException {
                        this.val$syncManager.beforeCompletion(this.val$txPrimaryKey);
                        return null;
                    }
                };
                TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "Before completion threw an exception.", new Object[]{object2, throwable});
                }
                throw new SyncpointFailedException();
            }
            finally {
                this._controlRep.getLock().obtainWrite(lockHierarchy);
            }
        }
        object2 = this._syncs.iterator();
        while (object2 != null && object2.hasNext()) {
            object = (Synchronization)object2.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Driving sync beforeCompletion", object);
            }
            this._controlRep.getLock().releaseWrite(lockHierarchy);
            try {
                object.before_completion();
            }
            finally {
                this._controlRep.getLock().obtainWrite(lockHierarchy);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "before_completion");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after_completion(Status status) {
        Object object;
        LockHierarchy lockHierarchy;
        block20: {
            boolean bl;
            block21: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "after_completion", status);
                }
                lockHierarchy = ControllerTransactionManagerSet.instance().getLockHierarchy();
                if (PlatformHelperFactory.getPlatformHelper().isServantJvm() || PlatformHelperFactory.getPlatformHelper().isClientJvm() || this._controlRep.isJCA()) break block20;
                if (!this._controlRep.isRoot()) break block21;
                if (this._controlRep.getTransactionType() != 7) break block20;
            }
            object = this.getSyncpointManager();
            boolean bl2 = bl = status.value() == 3;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Driving afterCompletion into servant");
            }
            byte[] byArray = this._controlRep.getXid().getPrimaryKey().toBytes();
            this._controlRep.getLock().releaseWrite(lockHierarchy);
            try {
                PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction((SyncpointManager)object, byArray, bl){
                    private final /* synthetic */ SyncpointManager val$syncManager;
                    private final /* synthetic */ byte[] val$txPrimaryKey;
                    private final /* synthetic */ boolean val$committed;
                    {
                        this.val$syncManager = syncpointManager;
                        this.val$txPrimaryKey = byArray;
                        this.val$committed = bl;
                    }

                    public Object run() throws SyncpointFailedException {
                        this.val$syncManager.afterCompletion(this.val$txPrimaryKey, this.val$committed);
                        return null;
                    }
                };
                TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "After completion threw an exception.", new Object[]{object, throwable});
                }
                if (this._uow.isXAEnlisted()) {
                    this._uow.setFailedXAResourceFlag(true);
                    this._uow.setHeuristicFlag();
                }
            }
            finally {
                this._controlRep.getLock().obtainWrite(lockHierarchy);
            }
        }
        object = this._syncs.iterator();
        while (object != null && object.hasNext()) {
            Synchronization synchronization = (Synchronization)object.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Driving sync afterCompletion", synchronization);
            }
            this._controlRep.getLock().releaseWrite(lockHierarchy);
            try {
                synchronization.after_completion(status);
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                Tr.event(tc, "Failure while driving after completion on sync object", new Object[]{synchronization, throwable});
            }
            finally {
                this._controlRep.getLock().obtainWrite(lockHierarchy);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "after_completion");
        }
    }

    SyncpointManager getSyncpointManager() {
        SyncpointManager syncpointManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSyncpointManager");
        }
        byte[] byArray = this._controlRep.getServantStoken();
        Iterator iterator = AdminServiceImpl.getPlatformUtils().getSRAggregator(new SyncpointManagerImpl(), false, byArray, false);
        try {
            syncpointManager = (SyncpointManager)iterator.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            String string = "Aggregator failed to obtain Transaction Manager reference";
            INTERNAL iNTERNAL = new INTERNAL(string);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "before_completion", (Object)iNTERNAL);
            }
            throw iNTERNAL;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSyncpointManager", syncpointManager);
        }
        return syncpointManager;
    }
}

