/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionSynchronizer;
import com.ibm.ws390.tx.TransactionTerminator;
import com.ibm.ws390.tx.TransactionalUnitOfWork;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Status;

public final class TransactionTerminatorImpl {
    private static final TraceComponent tc = Tr.register(TransactionTerminatorImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private TransactionControlRep _controlRep;
    private TransactionTerminator _remoteTerminator;
    private TransactionalUnitOfWork _uow;
    private TransactionSynchronizer _sync;

    public TransactionTerminatorImpl(TransactionControlRep transactionControlRep) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TransactionTerminatorImpl", transactionControlRep);
        }
        this._controlRep = transactionControlRep;
        this._uow = this._controlRep.getUnitOfWork();
        this._sync = this._controlRep.getSynchronizer();
        this._remoteTerminator = new TransactionTerminator(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TransactionTerminatorImpl");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void commit(boolean bl) throws HeuristicMixed {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", new Boolean(bl));
        }
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        try {
            Object object;
            int n2 = this._controlRep.getState();
            if (this._controlRep.isContextActive()) {
                if (n2 != 4) {
                    this._uow.rollbackOnly();
                }
                String string = "Transaction executing on another thread. Transaction rolled back";
                TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(string, -910026705, CompletionStatus.COMPLETED_NO);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "commit", (Object)tRANSACTION_ROLLEDBACK);
                }
                throw tRANSACTION_ROLLEDBACK;
            }
            if (this._controlRep.outstandingReplies()) {
                if (n2 != 4) {
                    this._uow.rollbackOnly();
                }
                String string = "Transaction has outstanding replies. Transaction rolled back";
                TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(string, -910026704, CompletionStatus.COMPLETED_NO);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "commit", (Object)tRANSACTION_ROLLEDBACK);
                }
                throw tRANSACTION_ROLLEDBACK;
            }
            switch (n2) {
                case 3: {
                    this._controlRep.changeState(5);
                    try {
                        this._sync.before_completion();
                    }
                    catch (Throwable throwable) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "befororeCompletion failed during commit.Transaction will be rolled back.", throwable);
                        }
                        this._uow.rollbackOnly();
                    }
                    try {
                        this._uow.commitOnePhase();
                        break;
                    }
                    catch (TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK) {
                        bl2 = true;
                        bl3 = true;
                        n = tRANSACTION_ROLLEDBACK.minor;
                        break;
                    }
                    catch (HeuristicMixed heuristicMixed) {
                        bl4 = true;
                        if (!bl) break;
                        bl3 = true;
                        break;
                    }
                    catch (Throwable throwable) {
                        UNKNOWN uNKNOWN = new UNKNOWN(throwable.toString());
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "commit", new Object[]{uNKNOWN, throwable});
                        }
                        throw uNKNOWN;
                    }
                }
                case 4: {
                    try {
                        this._uow.rollbackRoot(!this._uow.isXAEnlisted());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    bl3 = true;
                    bl2 = true;
                    n = -910026675;
                    break;
                }
                default: {
                    String string = "Terminator commit call on an already rolled back transaction.";
                    TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(string, -910026676, CompletionStatus.COMPLETED_NO);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commit", (Object)tRANSACTION_ROLLEDBACK);
                    }
                    throw tRANSACTION_ROLLEDBACK;
                }
            }
            this.afterCompletion();
            if (this._controlRep.getTransactionType() == 7) {
                this._controlRep.destroy(this._controlRep.getLockHierarchy());
            } else {
                this._controlRep.releaseTxLock();
                bl5 = false;
            }
            if (bl2) {
                if (bl3) {
                    object = new TRANSACTION_ROLLEDBACK(n, CompletionStatus.COMPLETED_NO);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commit", object);
                    }
                    throw object;
                }
                object = "Transaction rolled back during terminator commit";
                TRANSACTION_ROLLEDBACK tRANSACTION_ROLLEDBACK = new TRANSACTION_ROLLEDBACK(object, -910026721, CompletionStatus.COMPLETED_NO);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "commit", (Object)tRANSACTION_ROLLEDBACK);
                }
                throw tRANSACTION_ROLLEDBACK;
            }
            if (bl3 && bl4) {
                object = new HeuristicMixed();
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "commit", object);
                }
                throw object;
            }
        }
        finally {
            if (bl5) {
                this._controlRep.releaseTxLock();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback");
        }
        try {
            int n = this._controlRep.getState();
            if (this._controlRep.isContextActive() || this._controlRep.outstandingReplies()) {
                if (n != 4) {
                    this._uow.rollbackOnly();
                }
                return;
            }
            switch (n) {
                case 3: 
                case 4: 
                case 7: {
                    try {
                        this._uow.rollbackRoot(!this._uow.isXAEnlisted());
                    }
                    catch (Throwable throwable) {}
                    break;
                }
                default: {
                    return;
                }
            }
            this.afterCompletion();
            if (this._controlRep.getTransactionType() == 7) {
                this._controlRep.destroy(this._controlRep.getLockHierarchy());
            }
        }
        finally {
            this._controlRep.releaseTxLock();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    public TransactionControlRep getControlRep() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getControlRep");
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getControlRep", this._controlRep);
        }
        return this._controlRep;
    }

    public TransactionTerminator getRemoteTranTerminator() {
        if (tc.isDebugEnabled()) {
            Tr.entry(tc, "getRemoteTranTerminator");
        }
        if (tc.isDebugEnabled()) {
            Tr.exit(tc, "getRemoteTranTerminator", this._remoteTerminator);
        }
        return this._remoteTerminator;
    }

    public synchronized void afterCompletion() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "afterCompletion");
        }
        Status status = this._controlRep.getStatus();
        try {
            this._sync.after_completion(status);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "afterCompletion");
        }
    }
}

