/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import java.nio.ByteBuffer;

public final class TransactionURData {
    private static final TraceComponent tc = Tr.register(TransactionURData.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private ByteBuffer _urData;
    private static final int ATR_UR_ID_OFFSET = 0;
    private static final int ATR_UR_STATE_OFFSET = 16;
    private static final int XID_OFFSET = 20;
    private static final int URI_COUNT_OFFSET = 160;
    private static final int HEURISTIC_OFFSET = 164;
    private static final int ROOT_OFFSET = 165;
    private static final int FILLER_OFFSET = 166;
    private static final int URI_OFFSET = 168;
    private static final int NEXT_UR_OFFSET = 172;
    public static final int LEN_UR_ID = 16;
    public static final int LEN_XID = 140;
    public static final int URDATA_SIZE = 172;

    public TransactionURData(ByteBuffer byteBuffer) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byteBuffer);
        }
        this._urData = byteBuffer;
        int n = this._urData.capacity();
        int n2 = this._urData.limit();
        int n3 = this._urData.remaining();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public byte[] getUrId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUrId");
        }
        byte[] byArray = new byte[16];
        this._urData.position(0);
        this._urData.get(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUrId", Util.toHexString(byArray));
        }
        return byArray;
    }

    public int getUrState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUrState");
        }
        int n = this._urData.capacity();
        int n2 = this._urData.limit();
        int n3 = this._urData.remaining();
        this._urData.position(16);
        int n4 = this._urData.getInt();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUrState", new Integer(n4));
        }
        return n4;
    }

    public byte[] getXid() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getXid");
        }
        byte[] byArray = new byte[140];
        this._urData.position(20);
        this._urData.get(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXid", Util.toHexString(byArray));
        }
        return byArray;
    }

    public int getUriCount() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUriCount");
        }
        int n = this._urData.getInt(160);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUriCount", new Integer(n));
        }
        return n;
    }

    public boolean isHeuristic() {
        byte by;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isHeuristic");
        }
        boolean bl2 = bl = new Byte(by = this._urData.get(164)).intValue() == 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isHeuristic", new Boolean(bl));
        }
        return bl;
    }

    public boolean isRoot() {
        byte by;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRoot");
        }
        boolean bl2 = bl = new Byte(by = this._urData.get(165)).intValue() == 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRoot", new Boolean(bl));
        }
        return bl;
    }

    public int getUriOffset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUriOffset");
        }
        int n = this._urData.capacity();
        int n2 = this._urData.limit();
        int n3 = this._urData.remaining();
        this._urData.position(168);
        int n4 = this._urData.getInt();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUriOffset", new Integer(n4));
        }
        return n4;
    }

    public int getNextUrOffset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextUrOffset");
        }
        int n = this._urData.getInt(172);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextUrOffset", new Integer(n));
        }
        return n;
    }

    public void setNextUrOffset(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setNextUrOffset", new Integer(n));
        }
        this._urData.position(172);
        this._urData.putInt(n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setNextUrOffset");
        }
    }
}

