/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws390.tx.ResourceInterest;
import com.ibm.ws390.tx.SyncpointInterest;
import com.ibm.ws390.tx.rrs.RetrieveURInterestReturnType;
import java.nio.ByteBuffer;

public final class TransactionURInterestData {
    private static final TraceComponent tc = Tr.register(TransactionURInterestData.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private ByteBuffer _uriData;
    private ByteBuffer _urData;
    private static final int ATR_URI_TOKEN_OFFSET = 0;
    private static final int ATR_RES_MGR_NAME_OFFSET = 16;
    private static final int ATR_INTEREST_TYPE_OFFSET = 48;
    private static final int ATR_ROLE_OFFSET = 52;
    private static final int PDATA_LENGTH_OFFSET = 56;
    private static final int PDATA_OFFSET = 60;
    private static final int FLG_COMPLETED_OFFSET = 64;
    private static final int FLG_THREW_HEURISTIC_OFFSET = 65;
    private static final int FILLER_OFFSET = 66;
    private static final int NEXT_URI_OFFSET = 68;
    public static final int LEN_RM_NAME = 32;
    public static final int LEN_URI_TOKEN = 16;

    public TransactionURInterestData(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byteBuffer);
        }
        this._uriData = byteBuffer;
        this._urData = byteBuffer2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public byte[] getUriToken() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUriToken");
        }
        byte[] byArray = new byte[16];
        this._uriData.position(0);
        this._uriData.get(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUriToken", Util.toHexString(byArray));
        }
        return byArray;
    }

    public byte[] getRmName() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRmName");
        }
        byte[] byArray = new byte[32];
        this._uriData.position(16);
        this._uriData.get(byArray, 0, byArray.length);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRmName", Util.toHexString(byArray));
        }
        return byArray;
    }

    public int getInterestType() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInterestType");
        }
        int n = this._uriData.getInt(48);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInterestType", new Integer(n));
        }
        return n;
    }

    public int getRole() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRole");
        }
        int n = this._uriData.getInt(52);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRole", new Integer(n));
        }
        return n;
    }

    public int getPdataLength() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPdataLength");
        }
        int n = this._uriData.getInt(56);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPdataLength", new Integer(n));
        }
        return n;
    }

    public int getPdataOffset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPdataOffset");
        }
        int n = this._uriData.getInt(60);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPdataOffset", new Integer(n));
        }
        return n;
    }

    public byte[] getPdata() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPdata");
        }
        byte[] byArray = null;
        int n = this.getPdataOffset();
        if (n > 0) {
            int n2 = this.getPdataLength();
            byArray = new byte[n2];
            this._urData.position(n);
            this._urData.get(byArray, 0, n2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPdata", Util.toHexString(byArray));
        }
        return byArray;
    }

    public boolean isCompleted() {
        byte by;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isCompleted");
        }
        boolean bl2 = bl = new Byte(by = this._uriData.get(64)).intValue() == 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isCompleted", new Boolean(bl));
        }
        return bl;
    }

    public boolean isHeuristic() {
        byte by;
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isHeuristic");
        }
        boolean bl2 = bl = new Byte(by = this._uriData.get(65)).intValue() == 1;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isHeuristic", new Boolean(bl));
        }
        return bl;
    }

    public int getNextUriOffset() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getNextUriOffset");
        }
        int n = this._uriData.getInt(68);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNextUriOffset", new Integer(n));
        }
        return n;
    }

    public SyncpointInterest getSyncpointInterest() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSyncpointInterest");
        }
        RetrieveURInterestReturnType retrieveURInterestReturnType = new RetrieveURInterestReturnType(0, null, null, null, this.getRole(), 0, this.getPdata());
        SyncpointInterest syncpointInterest = new SyncpointInterest(retrieveURInterestReturnType);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSyncpointInterest", syncpointInterest);
        }
        return syncpointInterest;
    }

    public ResourceInterest getResourceInterest() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceInterest");
        }
        RetrieveURInterestReturnType retrieveURInterestReturnType = new RetrieveURInterestReturnType(0, null, null, null, this.getRole(), 0, this.getPdata());
        ResourceInterest resourceInterest = new ResourceInterest(retrieveURInterestReturnType, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceInterest", resourceInterest);
        }
        return resourceInterest;
    }

    public void setCompleted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCompleted");
        }
        this._uriData.position(64);
        this._uriData.put(new Integer(1).byteValue());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCompleted");
        }
    }

    public void setHeuristic(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setHeuristic", new Boolean(bl));
        }
        byte by = bl ? new Integer(1).byteValue() : new Integer(0).byteValue();
        this._uriData.position(65);
        this._uriData.put(by);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setHeuristic");
        }
    }
}

