/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.wstx.WSATAsyncResource;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.ExitHandler;
import com.ibm.ws390.tx.NonPersistentInterestData;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionalUnitOfWork;
import com.ibm.ws390.tx.WSATCRControlSet;
import com.ibm.ws390.tx.rrs.RRS;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public final class WSATCRAsyncResource {
    private static final TraceComponent tc = Tr.register(WSATCRAsyncResource.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final Hashtable responseTimers = new Hashtable();
    private static ControllerTransactionManagerSet _tmSet = ControllerTransactionManagerSet.instance();
    private TransactionControlRep _controlRep;
    private TransactionalUnitOfWork _uow;
    private byte[] _logData;
    private String _transactionID;
    private String _timerKey;
    private String _resourceID;
    private WSATAsyncResource _res;
    private ExitHandler _handler;
    public static final int COMMIT_RESPONSE = 1;
    public static final int ROLLBACK_RESPONSE = 2;
    public static final int NO_RESPONSE = 3;
    private boolean _prepare_response_received;
    private int _completion_response_received = 3;
    private int _prepare_rc = -3;
    private int _completion_rc = -3;
    public static final int ACTION_COMPLETE = 0;
    public static final int ACTION_ROLLBACK = 1;
    public static final int ACTION_INVALIDSTATE = 2;
    private static final int INT_SIZE = 4;

    public WSATCRAsyncResource(byte[] byArray, TransactionControlRep transactionControlRep) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{byArray, transactionControlRep});
        }
        this._uow = transactionControlRep.getUnitOfWork();
        this.initialize(byArray, transactionControlRep);
        this._uow.registerResource(this);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WSATCRAsyncResource(byte[] byArray, TransactionalUnitOfWork transactionalUnitOfWork, ExitHandler exitHandler) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{byArray, transactionalUnitOfWork, exitHandler});
        }
        this._uow = transactionalUnitOfWork;
        this._handler = exitHandler;
        this.initialize(byArray, transactionalUnitOfWork.getControl());
        WSATCRControlSet.instance().addTransactionBranch(this._transactionID, this._controlRep);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    private void initialize(byte[] byArray, TransactionControlRep transactionControlRep) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize", new Object[]{byArray, transactionControlRep});
        }
        this._controlRep = transactionControlRep;
        this._logData = byArray;
        try {
            int n;
            int n2;
            int n3;
            Object object;
            int n4;
            int n5 = 0;
            if (byArray[0] == 90) {
                if (byArray.length < (n5 += 4) + 4) {
                    throw new ArrayIndexOutOfBoundsException("Bad zipLen in logData");
                }
                n4 = Util.getIntFromBytes(byArray, 1, 3);
                int n6 = Util.getIntFromBytes(byArray, n5, 4);
                byte[] byArray2 = new byte[n6];
                object = new Inflater();
                ((Inflater)object).setInput(byArray, n5 += 4, n4);
                n3 = ((Inflater)object).inflate(byArray2);
                ((Inflater)object).end();
                if (n3 != n6) {
                    throw new ArrayIndexOutOfBoundsException("Bad zipped data in logData");
                }
                byArray = byArray2;
                n5 = 0;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unzipped logData", byArray);
                }
            }
            if (byArray.length < n5 + 4) {
                throw new ArrayIndexOutOfBoundsException("Bad pLen in logData");
            }
            if (byArray.length < (n5 += 4) + (n4 = Util.getIntFromBytes(byArray, n5, 4))) {
                throw new ArrayIndexOutOfBoundsException("Bad participantEPR in logData");
            }
            byte[] byArray3 = Util.duplicateByteArray(byArray, n5, n4);
            if (byArray.length < (n5 += n4) + 4) {
                throw new ArrayIndexOutOfBoundsException("Bad cLen in logData");
            }
            if (byArray.length < (n5 += 4) + (n2 = Util.getIntFromBytes(byArray, n5, 4))) {
                throw new ArrayIndexOutOfBoundsException("Bad coordinatorEPR in logData");
            }
            object = Util.duplicateByteArray(byArray, n5, n2);
            n3 = 0;
            for (n = n5 += n2; n < byArray.length && byArray[n] != 0; ++n) {
                ++n3;
            }
            if (n3 > 0) {
                this._transactionID = new String(byArray, n5, n3, "UTF-8");
                n = 0;
                for (int i = n5 += n3 + 1; i < byArray.length && byArray[i] != 0; ++i) {
                    ++n;
                }
                if (n <= 0) {
                    throw new ArrayIndexOutOfBoundsException("Bad resourceID in logData");
                }
            } else {
                throw new ArrayIndexOutOfBoundsException("Bad transactionID in logData");
            }
            this._resourceID = new String(byArray, n5, n, "UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray3);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            EndpointReference endpointReference = (EndpointReference)objectInputStream.readObject();
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream((byte[])object);
            ObjectInputStream objectInputStream2 = new ObjectInputStream(byteArrayInputStream2);
            EndpointReference endpointReference2 = (EndpointReference)objectInputStream2.readObject();
            int n7 = transactionControlRep.getXid().getBqualBranchIndex();
            this._res = new WSATAsyncResource(endpointReference, endpointReference2, this._transactionID, new Integer(n7).toString());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.tx.WSATCRAsyncResource.initialize", "274", this);
            Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"initialize", this.getClass().getName(), exception});
            INTERNAL iNTERNAL = new INTERNAL(-910026488, CompletionStatus.COMPLETED_NO);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize", (Object)iNTERNAL);
            }
            throw iNTERNAL;
        }
        this._timerKey = WSATCRAsyncResource.getLookupKey(this._transactionID, this._resourceID, this._res.getWSATBranchId());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean registerWsTx(String string, String string2, String string3, EndpointReference endpointReference, EndpointReference endpointReference2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "registerWsTx", new Object[]{string, string2, string3, endpointReference, endpointReference2});
        }
        boolean bl = true;
        TransactionControlRep transactionControlRep = WSATCRControlSet.instance().findControlRep(string, string3);
        if (transactionControlRep != null) {
            try {
                byte[] byArray = WSATCRAsyncResource.serialize(endpointReference2, endpointReference, string, string2);
                WSATCRAsyncResource wSATCRAsyncResource = new WSATCRAsyncResource(byArray, transactionControlRep);
            }
            catch (Exception exception) {
                FFDCFilter.processException(exception, "com.ibm.ws390.tx.WSATCRAsyncResource.registerWsTx", "325");
                Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"registerWsTx", "com.ibm.ws390.tx.WSATCRAsyncResource", exception});
                bl = false;
            }
            finally {
                transactionControlRep.releaseTxLock();
            }
        } else {
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "registerWsTx", new Boolean(bl));
        }
        return bl;
    }

    public static byte[] serialize(EndpointReference endpointReference, EndpointReference endpointReference2, String string, String string2) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "serialize", new Object[]{endpointReference, endpointReference2, string, string2});
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(endpointReference);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream2);
        objectOutputStream2.writeObject(endpointReference2);
        byte[] byArray2 = byteArrayOutputStream2.toByteArray();
        int n = byArray.length;
        int n2 = byArray2.length;
        byte[] byArray3 = string.getBytes("UTF-8");
        byte[] byArray4 = string2.getBytes("UTF-8");
        int n3 = byArray3.length;
        int n4 = byArray4.length;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "participantData " + n, byArray);
            Tr.debug(tc, "coordinatorData " + n2, byArray2);
            Tr.debug(tc, "txID " + n3, string);
            Tr.debug(tc, "resourceID " + n4, string2);
        }
        int n5 = 4 + n + 4 + n2 + n3 + 1 + n4 + 1;
        int n6 = (n5 + 3) / 4 * 4;
        byte[] byArray5 = new byte[n6];
        int n7 = 0;
        Util.setBytesFromInt(byArray5, n7, 4, n);
        System.arraycopy(byArray, 0, byArray5, n7 += 4, n);
        Util.setBytesFromInt(byArray5, n7 += n, 4, n2);
        System.arraycopy(byArray2, 0, byArray5, n7 += 4, n2);
        System.arraycopy(byArray3, 0, byArray5, n7 += n2, n3);
        System.arraycopy(byArray4, 0, byArray5, n7 += n3 + 1, n4);
        if (n5 > 3072) {
            Deflater deflater = new Deflater(9);
            deflater.setInput(byArray5, 0, n5);
            deflater.finish();
            byte[] byArray6 = new byte[n6];
            int n8 = deflater.deflate(byArray6, 0, n6);
            if (n8 > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "zipped size is " + n8);
                }
                n6 = (n8 + 4 + 4 + 3) / 4 * 4;
                byArray5 = new byte[n6];
                n7 = 0;
                byArray5[0] = 90;
                Util.setBytesFromInt(byArray5, n7 + 1, 3, n8);
                Util.setBytesFromInt(byArray5, n7 += 4, 4, n5);
                System.arraycopy(byArray6, 0, byArray5, n7 += 4, n8);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "serialize", byArray5);
        }
        return byArray5;
    }

    void setExitHandler(ExitHandler exitHandler) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setExitHandler", exitHandler);
        }
        this._handler = exitHandler;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setExitHandler");
        }
    }

    byte[] toLogData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toLogData");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toLogData", this._logData);
        }
        return this._logData;
    }

    boolean isEqual(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEqual", string);
        }
        boolean bl = false;
        if (this._resourceID != null && string != null) {
            bl = string.equals(this._resourceID);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEqual", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int prepare() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepare", this);
        }
        int n = -3;
        this._controlRep.obtainExclusiveTxLock();
        try {
            if (this._prepare_response_received) {
                n = this._prepare_rc;
            } else {
                this._prepare_rc = -4;
                try {
                    this._res.prepareOperation(null);
                    ResponseTimer responseTimer = new ResponseTimer(1, this._timerKey);
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, "com.ibm.ws390.tx.WSATCRAsyncResource.prepare", "499", this);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception from prepareOperation", throwable);
                    }
                    this._prepare_rc = 8;
                    this._prepare_response_received = true;
                    n = this._prepare_rc;
                }
            }
        }
        finally {
            this._controlRep.releaseTxLock();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepare", WSATCRAsyncResource.traceRRSCode(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int commit() {
        if (WSATCRAsyncResource.tc.isEntryEnabled()) {
            Tr.entry(WSATCRAsyncResource.tc, "commit", this);
        }
        var1_1 = -3;
        this._controlRep.obtainExclusiveTxLock();
        try {
            switch (this._completion_response_received) {
                case 1: {
                    var1_1 = 16;
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 2: {
                    var1_1 = 44;
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                default: {
                    this._completion_rc = -4;
                    this._prepare_rc = -3;
                    try {
                        this._res.commitOperation(null);
                        var2_2 = new ResponseTimer(2, this._timerKey);
                        ** break;
lbl22:
                        // 1 sources

                    }
                    catch (Throwable var2_3) {
                        FFDCFilter.processException(var2_3, "com.ibm.ws390.tx.WSATCRAsyncResource.commit", "555", this);
                        if (WSATCRAsyncResource.tc.isDebugEnabled()) {
                            Tr.debug(WSATCRAsyncResource.tc, "Exception from commitOperation", var2_3);
                        }
                        var1_1 = -1;
                        this._completion_rc = -3;
                    }
                    break;
                }
            }
        }
        finally {
            this._controlRep.releaseTxLock();
        }
        if (WSATCRAsyncResource.tc.isEntryEnabled()) {
            Tr.exit(WSATCRAsyncResource.tc, "commit", WSATCRAsyncResource.traceRRSCode(var1_1));
        }
        return var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    int rollback() {
        if (WSATCRAsyncResource.tc.isEntryEnabled()) {
            Tr.entry(WSATCRAsyncResource.tc, "rollback", this);
        }
        var1_1 = -3;
        this._controlRep.obtainExclusiveTxLock();
        try {
            switch (this._completion_response_received) {
                case 1: {
                    var1_1 = 44;
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 2: {
                    var1_1 = 16;
                    ** break;
lbl14:
                    // 1 sources

                    break;
                }
                default: {
                    this._completion_rc = -4;
                    this._prepare_rc = -3;
                    try {
                        this._res.rollbackOperation(null);
                        var2_2 = new ResponseTimer(2, this._timerKey);
                        ** break;
lbl22:
                        // 1 sources

                    }
                    catch (Throwable var2_3) {
                        FFDCFilter.processException(var2_3, "com.ibm.ws390.tx.WSATCRAsyncResource.rollback", "611", this);
                        if (WSATCRAsyncResource.tc.isDebugEnabled()) {
                            Tr.debug(WSATCRAsyncResource.tc, "Exception from rollbackOperation", var2_3);
                        }
                        var1_1 = -1;
                        this._completion_rc = -3;
                    }
                    break;
                }
            }
        }
        finally {
            this._controlRep.releaseTxLock();
        }
        if (WSATCRAsyncResource.tc.isEntryEnabled()) {
            Tr.exit(WSATCRAsyncResource.tc, "rollback", WSATCRAsyncResource.traceRRSCode(var1_1));
        }
        return var1_1;
    }

    private static String traceRRSCode(int n) {
        switch (n) {
            case 0: {
                return "ATRX_OK";
            }
            case 16: {
                return "ATRX_FORGET";
            }
            case 44: {
                return "ATRX_HM";
            }
            case 8: {
                return "ATRX_BACKOUT";
            }
            case -3: {
                return "Async resource";
            }
            case -4: {
                return "Async response pending";
            }
        }
        return "" + n;
    }

    private int prepared() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepared", this);
        }
        switch (this._controlRep.getState()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                this._uow.rollbackOnly();
                n = 2;
                break;
            }
            case 6: 
            case 17: {
                this._prepare_response_received = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_prepare_rc", WSATCRAsyncResource.traceRRSCode(this._prepare_rc));
                }
                if (this._prepare_rc == -4) {
                    if (_tmSet.isTxDebugEnabled()) {
                        String[] stringArray = new String[]{new ByteArray(this._uow.getURID()).toString(), new String("IN-PREPARE")};
                        String string = RasHelper.wtorMessage(5, null, false, stringArray);
                    }
                    this._prepare_rc = 0;
                    n = this.notifyRRS(this._prepare_rc);
                    break;
                }
                if (this._prepare_rc == 8) {
                    n = 1;
                    break;
                }
                this._prepare_rc = 8;
                n = 2;
                break;
            }
            default: {
                n = 0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepared", WSATCRAsyncResource.traceActionCode(n));
        }
        return n;
    }

    private int readonly() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readonly", this);
        }
        switch (this._controlRep.getState()) {
            case 7: 
            case 8: 
            case 15: {
                n = 2;
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_prepare_rc", WSATCRAsyncResource.traceRRSCode(this._prepare_rc));
                }
                this._prepare_response_received = true;
                if (this._prepare_rc == -4) {
                    this._prepare_rc = 16;
                    this.notifyRRS(this._prepare_rc);
                } else if (this._prepare_rc != 8) {
                    this._prepare_rc = 16;
                }
                n = 0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readonly", WSATCRAsyncResource.traceActionCode(n));
        }
        return n;
    }

    private int aborted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aborted", this);
        }
        int n = 0;
        switch (this._controlRep.getState()) {
            case 7: {
                n = 2;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n = 0;
                break;
            }
            default: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_completion_rc", WSATCRAsyncResource.traceRRSCode(this._completion_rc));
                    Tr.debug(tc, "_prepare_rc", WSATCRAsyncResource.traceRRSCode(this._prepare_rc));
                }
                if (this._completion_rc == -4) {
                    if (this._handler == null) break;
                    NonPersistentInterestData nonPersistentInterestData = this._handler.getNonPersistentInterestData();
                    int n2 = nonPersistentInterestData.getLastExit();
                    if (n2 == 4) {
                        if (_tmSet.isTxDebugEnabled()) {
                            String[] stringArray = new String[]{new ByteArray(this._uow.getURID()).toString(), new String("IN-COMMIT")};
                            String string = RasHelper.wtorMessage(5, null, false, stringArray);
                        }
                        this._completion_rc = 44;
                    } else {
                        this._completion_rc = 16;
                    }
                    this._completion_response_received = 2;
                    this.notifyRRS(this._completion_rc);
                    break;
                }
                if (this._prepare_rc == -4) {
                    this._prepare_rc = 8;
                    this._prepare_response_received = true;
                    NonPersistentInterestData nonPersistentInterestData = this._handler.getNonPersistentInterestData();
                    nonPersistentInterestData.preReplyBackout(16);
                    this.notifyRRS(this._prepare_rc);
                    break;
                }
                this._completion_response_received = 2;
                this._prepare_response_received = true;
                this._prepare_rc = 8;
                this._uow.rollbackOnly();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "aborted", WSATCRAsyncResource.traceActionCode(n));
        }
        return n;
    }

    private int committed() {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "committed", this);
        }
        switch (this._controlRep.getState()) {
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "_completion_rc", WSATCRAsyncResource.traceRRSCode(this._completion_rc));
                }
                if (this._completion_rc == -4) {
                    if (this._handler != null) {
                        NonPersistentInterestData nonPersistentInterestData = this._handler.getNonPersistentInterestData();
                        int n2 = nonPersistentInterestData.getLastExit();
                        this._completion_rc = n2 == 5 ? 44 : 16;
                        this._completion_response_received = 1;
                        this.notifyRRS(this._completion_rc);
                    }
                } else {
                    this._completion_response_received = 1;
                }
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: {
                n = 0;
                break;
            }
            default: {
                n = 2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "committed", WSATCRAsyncResource.traceActionCode(n));
        }
        return n;
    }

    private int notifyRRS(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "notifyRRS", WSATCRAsyncResource.traceRRSCode(n));
        }
        int n2 = 0;
        if (this._handler != null) {
            NonPersistentInterestData nonPersistentInterestData = this._handler.getNonPersistentInterestData();
            int n3 = nonPersistentInterestData.getLastExit();
            byte[] byArray = this._handler.getURIToken();
            int n4 = RRS.postDeferredURExit(byArray, n3, n);
            switch (n4) {
                case 0: 
                case 16: {
                    break;
                }
                case 1794: 
                case 3840: {
                    Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRPDUE", new Integer(n)});
                    RasHelper.exit(-910026664, true);
                    n2 = 1;
                    break;
                }
                default: {
                    Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{"ATRPDUE", new Integer(n)});
                    RasHelper.exit(-910026663, false);
                    n2 = 1;
                }
            }
            nonPersistentInterestData.markFailed(false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "notifyRRS", WSATCRAsyncResource.traceActionCode(n2));
        }
        return n2;
    }

    private void retry() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "retry", this);
        }
        if (this._handler != null) {
            if (this._prepare_rc == -4) {
                this._prepare_rc = 8;
                this._prepare_response_received = true;
                this.notifyRRS(this._prepare_rc);
            } else if (this._completion_rc == -4) {
                NonPersistentInterestData nonPersistentInterestData = this._handler.getNonPersistentInterestData();
                int n = nonPersistentInterestData.getLastExit();
                if (n == 5 && !this._prepare_response_received) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Abandonning retry of unprepared rollback");
                    }
                    this._completion_rc = 16;
                    this.notifyRRS(this._completion_rc);
                } else {
                    nonPersistentInterestData.markFailed(true);
                    this._uow.rescheduleResolverIfRequired(false);
                    this._completion_rc = -3;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "retry");
        }
    }

    private static String traceActionCode(int n) {
        switch (n) {
            case 0: {
                return "action complete";
            }
            case 2: {
                return "send invalidState";
            }
            case 1: {
                return "send rollback";
            }
        }
        return "" + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int prepared(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepared", new Object[]{string, string2, string3});
        }
        int n = 0;
        String string4 = WSATCRAsyncResource.getLookupKey(string, string2, string3);
        ResponseTimer responseTimer = (ResponseTimer)responseTimers.remove(string4);
        if (responseTimer != null && responseTimer.getResponseType() != 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Duplicate timer found", string2);
            }
            responseTimers.put(string4, responseTimer);
            responseTimer = null;
        }
        if (responseTimer != null) {
            responseTimer.cancelAlarm();
            n = responseTimer.preparedOperation();
        } else {
            TransactionControlRep transactionControlRep = WSATCRControlSet.instance().findControlRep(string, string3);
            if (transactionControlRep != null) {
                try {
                    WSATCRAsyncResource wSATCRAsyncResource = WSATCRAsyncResource.findAsyncResource(transactionControlRep, string2);
                    if (wSATCRAsyncResource != null) {
                        n = wSATCRAsyncResource.prepared();
                    }
                    n = 1;
                }
                finally {
                    transactionControlRep.releaseTxLock();
                }
            } else {
                n = 1;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepared", WSATCRAsyncResource.traceActionCode(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readonly(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "readonly", new Object[]{string, string2, string3});
        }
        int n = 0;
        String string4 = WSATCRAsyncResource.getLookupKey(string, string2, string3);
        ResponseTimer responseTimer = (ResponseTimer)responseTimers.remove(string4);
        if (responseTimer != null && responseTimer.getResponseType() != 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Duplicate timer found", string2);
            }
            responseTimers.put(string4, responseTimer);
            responseTimer = null;
        }
        if (responseTimer != null) {
            responseTimer.cancelAlarm();
            n = responseTimer.readonlyOperation();
        } else {
            TransactionControlRep transactionControlRep = WSATCRControlSet.instance().findControlRep(string, string3);
            if (transactionControlRep != null) {
                try {
                    WSATCRAsyncResource wSATCRAsyncResource = WSATCRAsyncResource.findAsyncResource(transactionControlRep, string2);
                    if (wSATCRAsyncResource != null) {
                        n = wSATCRAsyncResource.readonly();
                    }
                    n = 2;
                }
                finally {
                    transactionControlRep.releaseTxLock();
                }
            } else {
                n = 0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "readonly", WSATCRAsyncResource.traceActionCode(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int aborted(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "aborted", new Object[]{string, string2, string3});
        }
        int n = 0;
        String string4 = WSATCRAsyncResource.getLookupKey(string, string2, string3);
        ResponseTimer responseTimer = (ResponseTimer)responseTimers.remove(string4);
        if (responseTimer != null) {
            responseTimer.cancelAlarm();
            n = responseTimer.abortedOperation();
        } else {
            TransactionControlRep transactionControlRep = WSATCRControlSet.instance().findControlRep(string, string3);
            if (transactionControlRep != null) {
                try {
                    WSATCRAsyncResource wSATCRAsyncResource = WSATCRAsyncResource.findAsyncResource(transactionControlRep, string2);
                    if (wSATCRAsyncResource != null) {
                        n = wSATCRAsyncResource.aborted();
                    }
                    n = 2;
                }
                finally {
                    transactionControlRep.releaseTxLock();
                }
            } else {
                n = 0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "aborted", WSATCRAsyncResource.traceActionCode(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int committed(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "committed", new Object[]{string, string2, string3});
        }
        int n = 0;
        String string4 = WSATCRAsyncResource.getLookupKey(string, string2, string3);
        ResponseTimer responseTimer = (ResponseTimer)responseTimers.remove(string4);
        if (responseTimer != null) {
            responseTimer.cancelAlarm();
            n = responseTimer.committedOperation();
        } else {
            TransactionControlRep transactionControlRep = WSATCRControlSet.instance().findControlRep(string, string3);
            if (transactionControlRep != null) {
                try {
                    WSATCRAsyncResource wSATCRAsyncResource = WSATCRAsyncResource.findAsyncResource(transactionControlRep, string2);
                    if (wSATCRAsyncResource != null) {
                        n = wSATCRAsyncResource.committed();
                    }
                    n = 2;
                }
                finally {
                    transactionControlRep.releaseTxLock();
                }
            } else {
                n = 0;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "committed", WSATCRAsyncResource.traceActionCode(n));
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int replay(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replay", new Object[]{string, string2, string3});
        }
        int n = 0;
        String string4 = WSATCRAsyncResource.getLookupKey(string, string2, string3);
        ResponseTimer responseTimer = (ResponseTimer)responseTimers.remove(string4);
        if (responseTimer != null) {
            responseTimer.cancelAlarm();
            n = responseTimer.retryOperation();
        } else {
            TransactionControlRep transactionControlRep = WSATCRControlSet.instance().findControlRep(string, string3);
            if (transactionControlRep != null) {
                try {
                    WSATCRAsyncResource wSATCRAsyncResource = WSATCRAsyncResource.findAsyncResource(transactionControlRep, string2);
                    if (wSATCRAsyncResource != null) {
                        wSATCRAsyncResource.retry();
                    }
                    n = 1;
                }
                finally {
                    transactionControlRep.releaseTxLock();
                }
            } else {
                n = 1;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replay", WSATCRAsyncResource.traceActionCode(n));
        }
        return n;
    }

    private static WSATCRAsyncResource findAsyncResource(TransactionControlRep transactionControlRep, String string) {
        TransactionalUnitOfWork transactionalUnitOfWork = transactionControlRep.getUnitOfWork();
        return transactionalUnitOfWork.findAsyncResource(string);
    }

    public static String getLookupKey(String string, String string2, String string3) {
        int n = string.length() + string2.length() + string3.length() + 2;
        StringBuffer stringBuffer = new StringBuffer(n);
        String string4 = stringBuffer.append(string).append(" ").append(string2).append(" ").append(string3).toString();
        return string4;
    }

    private class ResponseTimer
    implements AlarmListener {
        public static final int responseTypePrepare = 1;
        public static final int responseTypeComplete = 2;
        private final int _responseType;
        private final String _key;
        private Alarm _alarm;
        private boolean _responseDelivered;

        ResponseTimer(int n, String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ResponseTimer", string);
            }
            this._responseType = n;
            this._key = string;
            this._alarm = AlarmManager.createDeferrable(Configuration.getAsyncResponseTimeout(), this, null);
            responseTimers.put(this._key, this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ResponseTimer", this);
            }
        }

        public void alarm(Object object) {
            ResponseTimer responseTimer;
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ResponseTimer.alarm", this);
            }
            if ((responseTimer = (ResponseTimer)responseTimers.remove(this._key)) != null && responseTimer != this) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Duplicate timer found", this._key);
                }
                responseTimers.put(this._key, responseTimer);
                responseTimer = null;
            }
            if (tc.isEventEnabled()) {
                switch (this._responseType) {
                    case 1: {
                        Tr.event(tc, "Prepare response not received - rolling back", this._key);
                        break;
                    }
                    default: {
                        Tr.event(tc, "Completion response not received - retrying", this._key);
                    }
                }
            }
            this.retryOperation();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ResponseTimer.alarm");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int preparedOperation() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ResponseTimer.preparedOperation");
            }
            int n = 0;
            if (!this._responseDelivered) {
                WSATCRAsyncResource.this._controlRep.obtainExclusiveTxLock();
                try {
                    n = WSATCRAsyncResource.this.prepared();
                }
                finally {
                    WSATCRAsyncResource.this._controlRep.releaseTxLock();
                }
                this._responseDelivered = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ResponseTimer.preparedOperation", WSATCRAsyncResource.traceActionCode(n));
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int readonlyOperation() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ResponseTimer.readonlyOperation");
            }
            int n = 0;
            if (!this._responseDelivered) {
                WSATCRAsyncResource.this._controlRep.obtainExclusiveTxLock();
                try {
                    n = WSATCRAsyncResource.this.readonly();
                }
                finally {
                    WSATCRAsyncResource.this._controlRep.releaseTxLock();
                }
                this._responseDelivered = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ResponseTimer.readonlyOperation", WSATCRAsyncResource.traceActionCode(n));
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int abortedOperation() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ResponseTimer.abortedOperation");
            }
            int n = 0;
            if (!this._responseDelivered) {
                WSATCRAsyncResource.this._controlRep.obtainExclusiveTxLock();
                try {
                    n = WSATCRAsyncResource.this.aborted();
                }
                finally {
                    WSATCRAsyncResource.this._controlRep.releaseTxLock();
                }
                this._responseDelivered = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ResponseTimer.abortedOperation", WSATCRAsyncResource.traceActionCode(n));
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int committedOperation() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ResponseTimer.committedOperation");
            }
            int n = 0;
            if (!this._responseDelivered) {
                WSATCRAsyncResource.this._controlRep.obtainExclusiveTxLock();
                try {
                    n = WSATCRAsyncResource.this.committed();
                }
                finally {
                    WSATCRAsyncResource.this._controlRep.releaseTxLock();
                }
                this._responseDelivered = true;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ResponseTimer.committedOperation", WSATCRAsyncResource.traceActionCode(n));
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized int retryOperation() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ResponseTimer.retryOperation");
            }
            int n = 0;
            if (!this._responseDelivered) {
                WSATCRAsyncResource.this._controlRep.obtainExclusiveTxLock();
                try {
                    WSATCRAsyncResource.this.retry();
                }
                finally {
                    WSATCRAsyncResource.this._controlRep.releaseTxLock();
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ResponseTimer.retryOperation", WSATCRAsyncResource.traceActionCode(n));
            }
            return n;
        }

        public void cancelAlarm() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cancelAlarm", this._alarm);
            }
            if (this._alarm != null) {
                this._alarm.cancel();
                this._alarm = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "cancelAlarm");
            }
        }

        public int getResponseType() {
            return this._responseType;
        }
    }
}

