/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ejs.util.Util;
import com.ibm.ejs.util.locking.Semaphore;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.JTS.ResourceCallback;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATServices;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws.wscoor.ServiceHelper;
import com.ibm.ws.wscoor.WSCoorServices;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionCoordinatorImpl;
import com.ibm.ws390.tx.TransactionManagerMessage;
import com.ibm.ws390.tx.TransactionalUnitOfWork;
import com.ibm.ws390.tx.WSATCRRecoveryCoordinator;
import com.ibm.wsspi.http.channel.HttpConstants;
import com.ibm.wsspi.soapchannel.monitor.SOAPRequestController;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.util.HashMap;
import java.util.Map;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CosTransactions.RecoveryCoordinator;

public final class WSATCRControlSet {
    private static final TraceComponent tc = Tr.register(WSATCRControlSet.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static WSATCRControlSet _instance = new WSATCRControlSet();
    private final HashMap _txIDToGtidMap = new HashMap();
    private final HashMap _txIDBqualToControlRepMap = new HashMap();
    private byte[] _portData;
    private ControllerTransactionManagerSet _tm;
    private int _defaultTimeout;
    private Semaphore _gtidLock;

    public static WSATCRControlSet instance() {
        return _instance;
    }

    private WSATCRControlSet() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        WSATServices.getWSATCoordinatorURI();
        WSCoorServices.getRegistrationCoordinatorURI();
        this._portData = ServiceHelper.marshalPortData();
        if (this._portData == null) {
            Tr.error(tc, "WTRN0115_NO_CFW_AVAILABLE");
        }
        this._tm = ControllerTransactionManagerSet.instance();
        this._defaultTimeout = Configuration.getMaximumTransactionTimeout();
        this._gtidLock = new Semaphore();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    byte[] marshalPortData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "marshalPortData");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "marshalPortData", this._portData);
        }
        return this._portData;
    }

    final void addTransaction(String string, TransactionControlRep transactionControlRep) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTransaction", new Object[]{string, transactionControlRep});
        }
        try {
            this._gtidLock.lock();
        }
        catch (InterruptedException interruptedException) {
            String string2 = "Thread interrupted.";
            INTERNAL iNTERNAL = new INTERNAL(string2, -910026572, CompletionStatus.COMPLETED_NO);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "addTransaction", (Object)iNTERNAL);
            }
            throw iNTERNAL;
        }
        boolean bl = this._txIDToGtidMap.put(string, transactionControlRep.getXid()) == null;
        this._gtidLock.unlock();
        if (bl) {
            transactionControlRep.addDestroyCallback(new WSATGtidMapCallback(string));
        }
        this.addTransactionBranch(string, transactionControlRep);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean addTransactionBranch(String string, TransactionControlRep transactionControlRep) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addTransactionBranch", new Object[]{string, transactionControlRep});
        }
        int n = transactionControlRep.getXid().getBqualBranchIndex();
        String string2 = WSATControlSet.createContextKey(string, n);
        HashMap hashMap = this._txIDBqualToControlRepMap;
        synchronized (hashMap) {
            bl = this._txIDBqualToControlRepMap.put(string2, transactionControlRep) == null;
        }
        if (bl) {
            transactionControlRep.addDestroyCallback(new WSATCRMapCallback(string2));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addTransactionBranch", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TransactionControlRep findControlRep(String string, String string2) {
        TransactionControlRep transactionControlRep;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findControlRep", new Object[]{string, string2});
        }
        if (string == null || string.equals("")) {
            transactionControlRep = null;
        } else {
            int n = string2 == null || string2.equals("") ? 0 : Integer.parseInt(string2);
            String string3 = WSATControlSet.createContextKey(string, n);
            HashMap hashMap = this._txIDBqualToControlRepMap;
            synchronized (hashMap) {
                transactionControlRep = (TransactionControlRep)this._txIDBqualToControlRepMap.get(string3);
            }
            if (transactionControlRep != null) {
                transactionControlRep.obtainExclusiveTxLock();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findControlRep", transactionControlRep);
        }
        return transactionControlRep;
    }

    public boolean peekWSATContext(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "peekWSATContext", map);
        }
        boolean bl = false;
        CoordinationContext coordinationContext = (CoordinationContext)map.get("com.ibm.websphere.transaction.wstx");
        if (coordinationContext != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "coordContext", coordinationContext);
            }
            String string = coordinationContext.getIdentifier().getURI().toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "txID", string);
            }
            String string2 = coordinationContext.getExpires();
            int n = (int)(WSATControlSet.convertExpires(string2) / 1000L);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "timeout", new Integer(n));
            }
            try {
                this.importWSATContext(string, true, null, null, null, map, n);
                bl = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "updated invokeContext map", map);
                }
            }
            catch (Throwable throwable) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "importWSATContext threw exception", throwable);
                }
                throw new INTERNAL();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "peekWSATContext", new Boolean(bl));
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int importWSATContext(String string, boolean bl, byte[] byArray, byte[] byArray2, SOAPRequestController sOAPRequestController, Map map, int n) throws Exception {
        int n2;
        block21: {
            block16: {
                Object object;
                TransactionControlRep transactionControlRep;
                block18: {
                    Object object2;
                    block19: {
                        block20: {
                            block17: {
                                boolean bl2;
                                if (tc.isEntryEnabled()) {
                                    Tr.entry(tc, "importWSATContext", new Object[]{string, new Boolean(bl), byArray, byArray2, sOAPRequestController, map, new Integer(n)});
                                }
                                n2 = 0;
                                transactionControlRep = null;
                                boolean bl3 = false;
                                if (string == null) break block16;
                                this._gtidLock.lock();
                                XidImpl xidImpl = (XidImpl)this._txIDToGtidMap.get(string);
                                if (xidImpl == null) {
                                    xidImpl = this._tm.createNewServerXid();
                                    this._txIDToGtidMap.put(string, xidImpl);
                                    bl3 = true;
                                }
                                if (!(bl2 = this.addTransactionBranch(string, transactionControlRep = this._tm.import_WSAT_request(xidImpl, this._gtidLock)))) break block17;
                                xidImpl = transactionControlRep.getXid();
                                int n3 = xidImpl.getBqualBranchIndex();
                                object = new WSATCRRecoveryCoordinator(string, n3);
                                TransactionCoordinatorImpl transactionCoordinatorImpl = transactionControlRep.getCoordinatorImpl();
                                transactionCoordinatorImpl.setSuperiorRecCoord((RecoveryCoordinator)object);
                                if (bl3) {
                                    transactionControlRep.addDestroyCallback(new WSATGtidMapCallback(string));
                                }
                                transactionControlRep.changeState(2);
                                if (bl) {
                                    if (n == 0 || n > this._defaultTimeout) {
                                        n = this._defaultTimeout;
                                    }
                                    this._tm.dispatch_WSAT_request(transactionControlRep, byArray, n, byArray2);
                                    if (map != null) {
                                        TransactionManagerMessage transactionManagerMessage = new TransactionManagerMessage(xidImpl, false, true);
                                        String string2 = Util.toString(transactionManagerMessage.toBytes());
                                        map.put("WLM_TMM_FOR_SR", string2);
                                    }
                                } else {
                                    transactionControlRep.releaseTxLock();
                                }
                                n2 = n3;
                                break block18;
                            }
                            this._tm.dispatch_WSAT_request(transactionControlRep, byArray, 0, byArray2);
                            if (map == null) break block18;
                            ByteArray byteArray = new ByteArray(transactionControlRep.getServantStoken());
                            object = map.put("WLM_AGGREGATOR_STOKEN", byteArray);
                            if (object == null) break block19;
                            if (!(object instanceof ByteArray)) break block20;
                            object2 = (ByteArray)object;
                            if (((ByteArray)object2).equals(byteArray)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Aggregator stoken key in Sib Map matches currrent stoken");
                                }
                                break block19;
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Aggregator stoken key in Sib Map fails to match current stoken", object);
                                }
                                throw new IllegalStateException("Aggregator stokens fail to match");
                            }
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Aggregator stoken key in Sib Map is non-ByteArray", object);
                        }
                        throw new ClassCastException("Aggregator stoken is in an invalid class");
                    }
                    object2 = new TransactionManagerMessage(transactionControlRep.getXid(), false, true);
                    String string3 = Util.toString(((TransactionManagerMessage)object2).toBytes());
                    map.put("WLM_TMM_FOR_SR", string3);
                }
                if (sOAPRequestController != null) {
                    TransactionManagerMessage transactionManagerMessage = new TransactionManagerMessage(transactionControlRep.getXid(), false, true);
                    object = Util.toString(transactionManagerMessage.toBytes());
                    sOAPRequestController.setHeader(HttpConstants.HDR_ZOS_TRAN_XID, (String)object);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "added ZOS_TRAN_XID to http header");
                    }
                }
                break block21;
            }
            if (map == null) {
                this._tm.dispatch_WSAT_request(null, null, 0, byArray2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "importWSATContext", new Integer(n2));
        }
        return n2;
    }

    public boolean continueImportWSATContext(String string, int n, byte[] byArray, EndpointReference endpointReference, byte[] byArray2, int n2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "continueImportWSATContext", new Object[]{string, new Integer(n), byArray, endpointReference, byArray2, new Integer(n2)});
        }
        boolean bl = false;
        TransactionControlRep transactionControlRep = this.findControlRep(string, String.valueOf(n));
        if (transactionControlRep != null) {
            TransactionCoordinatorImpl transactionCoordinatorImpl = transactionControlRep.getCoordinatorImpl();
            WSATCRRecoveryCoordinator wSATCRRecoveryCoordinator = (WSATCRRecoveryCoordinator)transactionCoordinatorImpl.getSuperiorRecCoord();
            wSATCRRecoveryCoordinator.setCoordinatorEPR(endpointReference);
            if (n2 == 0 || n2 > this._defaultTimeout) {
                n2 = this._defaultTimeout;
            }
            this._tm.dispatch_WSAT_request(transactionControlRep, byArray, n2, byArray2);
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "continueImportWSATContext", new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failImportWSATContext(String string, int n) {
        TransactionControlRep transactionControlRep;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "failImportWSATContext", new Object[]{string, new Integer(n)});
        }
        if ((transactionControlRep = this.findControlRep(string, String.valueOf(n))) != null) {
            try {
                TransactionalUnitOfWork transactionalUnitOfWork = transactionControlRep.getUnitOfWork();
                transactionalUnitOfWork.rollbackSubordinate(true);
            }
            catch (Throwable throwable) {
            }
            finally {
                transactionControlRep.releaseTxLock();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "failImportWSATContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markRollbackOnly(String string, String string2) {
        TransactionControlRep transactionControlRep;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "markRollbackOnly", new Object[]{string, string2});
        }
        if ((transactionControlRep = this.findControlRep(string, string2)) != null) {
            try {
                TransactionalUnitOfWork transactionalUnitOfWork = transactionControlRep.getUnitOfWork();
                transactionalUnitOfWork.rollbackOnly();
            }
            finally {
                transactionControlRep.releaseTxLock();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "markRollbackOnly");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean setFault(String var1_1, String var2_2) {
        if (WSATCRControlSet.tc.isEntryEnabled()) {
            Tr.entry(WSATCRControlSet.tc, "setFault", new Object[]{var1_1, var2_2});
        }
        var3_3 = false;
        var4_4 = this.findControlRep(var1_1, var2_2);
        if (var4_4 != null) {
            try {
                var5_5 = var4_4.getUnitOfWork();
                var6_6 = var4_4.getState();
                switch (var6_6) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        var5_5.rollbackOnly();
                        ** break;
lbl13:
                        // 1 sources

                        break;
                    }
                    default: {
                        var5_5.setHeuristicFlag();
                        break;
                    }
                }
            }
            finally {
                var4_4.releaseTxLock();
            }
            var3_3 = true;
        }
        if (WSATCRControlSet.tc.isEntryEnabled()) {
            Tr.exit(WSATCRControlSet.tc, "setFault", new Boolean(var3_3));
        }
        return var3_3;
    }

    private class WSATCRMapCallback
    implements ResourceCallback {
        private final String _crKey;

        public WSATCRMapCallback(String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSATCRMapCallback.<init>", string);
            }
            this._crKey = string;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "WSATCRMapCallback.<init>", this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void destroy() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSATCRMapCallback.destroy", this);
            }
            HashMap hashMap = WSATCRControlSet.this._txIDBqualToControlRepMap;
            synchronized (hashMap) {
                WSATCRControlSet.this._txIDBqualToControlRepMap.remove(this._crKey);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "WSATCRMapCallback.destroy", this);
            }
        }
    }

    private class WSATGtidMapCallback
    implements ResourceCallback {
        private final String _txID;

        public WSATGtidMapCallback(String string) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSATGtidMapCallback.<init>", string);
            }
            this._txID = string;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "WSATGtidMapCallback.<init>", this);
            }
        }

        public void destroy() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "WSATGtidMapCallback.destroy", this);
            }
            try {
                WSATCRControlSet.this._gtidLock.lock();
                WSATCRControlSet.this._txIDToGtidMap.remove(this._txID);
                WSATCRControlSet.this._gtidLock.unlock();
            }
            catch (InterruptedException interruptedException) {
                WSATCRControlSet.this._txIDToGtidMap.remove(this._txID);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "WSATGtidMapCallback.destroy", this);
            }
        }
    }
}

