/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.Util;
import com.ibm.ws.Transaction.wstx.WSATRecoveryCoordinator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.WSATCRControlSet;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions._RecoveryCoordinatorImplBase;

public final class WSATCRRecoveryCoordinator
extends _RecoveryCoordinatorImplBase {
    private static final TraceComponent tc = Tr.register(WSATCRRecoveryCoordinator.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private byte[] _logData;
    private EndpointReference _coordinatorEPR;
    private EndpointReference _participantEPR;
    private String _txID;
    private int _branchIndex;
    private boolean _dirtyData;
    private static final int INT_SIZE = 4;

    public WSATCRRecoveryCoordinator(String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{string, new Integer(n)});
        }
        this._txID = string;
        this._branchIndex = n;
        this._dirtyData = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WSATCRRecoveryCoordinator(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", byArray);
        }
        this._logData = byArray;
        try {
            int n;
            int n2;
            Object object;
            int n3;
            int n4 = 0;
            if (byArray[0] == 90) {
                if (byArray.length < (n4 += 4) + 4) {
                    throw new ArrayIndexOutOfBoundsException("Bad zipLen in logData");
                }
                n3 = Util.getIntFromBytes(byArray, 1, 3);
                int n5 = Util.getIntFromBytes(byArray, n4, 4);
                byte[] byArray2 = new byte[n5];
                object = new Inflater();
                ((Inflater)object).setInput(byArray, n4 += 4, n3);
                n2 = ((Inflater)object).inflate(byArray2);
                ((Inflater)object).end();
                if (n2 != n5) {
                    throw new ArrayIndexOutOfBoundsException("Bad zipped data in logData");
                }
                byArray = byArray2;
                n4 = 0;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unzipped logData", byArray);
                }
            }
            if (byArray.length < n4 + 4) {
                throw new ArrayIndexOutOfBoundsException("Bad cLen in logData");
            }
            if (byArray.length < (n4 += 4) + (n3 = Util.getIntFromBytes(byArray, n4, 4))) {
                throw new ArrayIndexOutOfBoundsException("Bad coordinatorEPR in logData");
            }
            byte[] byArray3 = Util.duplicateByteArray(byArray, n4, n3);
            if (byArray.length < (n4 += n3) + 4) {
                throw new ArrayIndexOutOfBoundsException("Bad pLen in logData");
            }
            if (byArray.length < (n4 += 4) + (n = Util.getIntFromBytes(byArray, n4, 4))) {
                throw new ArrayIndexOutOfBoundsException("Bad participantEPR in logData");
            }
            object = Util.duplicateByteArray(byArray, n4, n);
            n2 = 0;
            for (int i = n4 += n; i < byArray.length && byArray[i] != 0; ++i) {
                ++n2;
            }
            if (n2 > 0) {
                this._txID = new String(byArray, n4, n2, "UTF-8");
                if (byArray.length < (n4 += n2 + 1) + 4) {
                    throw new ArrayIndexOutOfBoundsException("Bad branch index in logData");
                }
            } else {
                throw new ArrayIndexOutOfBoundsException("Bad transactionID in logData");
            }
            this._branchIndex = Util.getIntFromBytes(byArray, n4, 4);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            this._participantEPR = (EndpointReference)objectInputStream.readObject();
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray3);
            ObjectInputStream objectInputStream2 = new ObjectInputStream(byteArrayInputStream2);
            this._coordinatorEPR = (EndpointReference)objectInputStream2.readObject();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.tx.WSATCRRecoveryCoordinator.<init>", "165", this);
            Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"<init>", this.getClass().getName(), exception});
            INTERNAL iNTERNAL = new INTERNAL(-910026485, CompletionStatus.COMPLETED_NO);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "<init>", (Object)iNTERNAL);
            }
            throw iNTERNAL;
        }
        this._dirtyData = false;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    void setControlRep(TransactionControlRep transactionControlRep) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setControlRep", transactionControlRep);
        }
        WSATCRControlSet.instance().addTransactionBranch(this._txID, transactionControlRep);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setControlRep");
        }
    }

    public Status replay_completion(Resource resource) throws NotPrepared {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "replay_completion", resource);
        }
        Status status = Status.StatusUnknown;
        if (this._txID != null && this._participantEPR != null && this._coordinatorEPR != null) {
            try {
                WSATRecoveryCoordinator wSATRecoveryCoordinator = new WSATRecoveryCoordinator(this._txID, this._participantEPR, false);
                wSATRecoveryCoordinator.setSuperiorCoordinatorEPR(this._coordinatorEPR);
                status = wSATRecoveryCoordinator.replay_completion();
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws390.tx.WSATCRRecoveryCoordinator.replay_completion", "230", this);
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Exception during replay_completion", throwable);
                }
            }
        } else {
            NotPrepared notPrepared = new NotPrepared();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "replay_completion", (Object)notPrepared);
            }
            throw notPrepared;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "replay_completion", status);
        }
        return status;
    }

    byte[] toLogData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "toLogData");
        }
        if (this._dirtyData) {
            this._logData = null;
            if (this._txID != null && this._participantEPR != null && this._coordinatorEPR != null) {
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                    objectOutputStream.writeObject(this._coordinatorEPR);
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                    ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(byteArrayOutputStream2);
                    objectOutputStream2.writeObject(this._participantEPR);
                    byte[] byArray2 = byteArrayOutputStream2.toByteArray();
                    int n = byArray2.length;
                    int n2 = byArray.length;
                    byte[] byArray3 = this._txID.getBytes("UTF-8");
                    int n3 = byArray3.length;
                    int n4 = 4 + n2 + 4 + n + n3 + 1 + 4;
                    int n5 = (n4 + 3) / 4 * 4;
                    this._logData = new byte[n5];
                    int n6 = 0;
                    Util.setBytesFromInt(this._logData, n6, 4, n2);
                    System.arraycopy(byArray, 0, this._logData, n6 += 4, n2);
                    Util.setBytesFromInt(this._logData, n6 += n2, 4, n);
                    System.arraycopy(byArray2, 0, this._logData, n6 += 4, n);
                    System.arraycopy(byArray3, 0, this._logData, n6 += n, n3);
                    Util.setBytesFromInt(this._logData, n6 += n3 + 1, 4, this._branchIndex);
                    if (n4 > 3584) {
                        Deflater deflater = new Deflater(9);
                        deflater.setInput(this._logData, 0, n4);
                        deflater.finish();
                        byte[] byArray4 = new byte[n5];
                        int n7 = deflater.deflate(byArray4, 0, n5);
                        if (n7 > 0) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "zipped size is " + n7);
                            }
                            n5 = (n7 + 4 + 4 + 3) / 4 * 4;
                            byte[] byArray5 = new byte[n5];
                            n6 = 0;
                            byArray5[0] = 90;
                            Util.setBytesFromInt(byArray5, n6 + 1, 3, n7);
                            Util.setBytesFromInt(byArray5, n6 += 4, 4, n4);
                            System.arraycopy(byArray4, 0, byArray5, n6 += 4, n7);
                            this._logData = byArray5;
                        }
                    }
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, "com.ibm.ws390.tx.WSATCRRecoveryCoordinator.toLogData", "304", this);
                    Tr.error(tc, "WTRN0000_ERR_INT_ERROR", new Object[]{"toLogData", this.getClass().getName(), exception});
                    INTERNAL iNTERNAL = new INTERNAL(-910026170, CompletionStatus.COMPLETED_NO);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "toLogData", (Object)iNTERNAL);
                    }
                    throw iNTERNAL;
                }
            }
            this._dirtyData = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "toLogData", this._logData);
        }
        return this._logData;
    }

    void setParticipantEPR(EndpointReference endpointReference) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParticipantEPR", endpointReference);
        }
        this._dirtyData = true;
        this._participantEPR = endpointReference;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParticipantEPR");
        }
    }

    void setCoordinatorEPR(EndpointReference endpointReference) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCoordinatorEPR", endpointReference);
        }
        if (this._coordinatorEPR == null) {
            this._dirtyData = true;
            this._coordinatorEPR = endpointReference;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCoordinatorEPR");
        }
    }

    EndpointReference getCoordinatorEPR() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCoordinatorEPR");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCoordinatorEPR", this._coordinatorEPR);
        }
        return this._coordinatorEPR;
    }
}

