/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.Util;
import com.ibm.ws.Transaction.JTA.TransactionImpl;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.wstx.WSATControlSet;
import com.ibm.ws.Transaction.wstx.WSATHandlerHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.wscoor.CoordinationContext;
import com.ibm.ws390.tx.TransactionManagerMessage;
import com.ibm.ws390.tx.WSATCRControlSet;
import com.ibm.wsspi.exitpoint.systemcontext.SystemContext;
import com.ibm.wsspi.exitpoint.systemcontext.SystemContextHandler;
import commonj.sdo.DataGraph;
import java.util.Map;

public class WSATJMSSystemContextHandler
implements SystemContextHandler {
    private static final TraceComponent tc = Tr.register(WSATJMSSystemContextHandler.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final String CONTEXT_KEY = "com.ibm.websphere.transaction.wstx";
    public static final String AGGREGATOR_KEY = "WLM_AGGREGATOR_STOKEN";
    public static final String TMM_FOR_SR_KEY = "WLM_TMM_FOR_SR";
    private static WSThreadLocal _context = new WSThreadLocal();

    public WSATJMSSystemContextHandler() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "WSATJMSSystemContextHandler");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "WSATJMSSystemContextHandler", this);
        }
    }

    public boolean extractContext(SystemContext systemContext, Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContext", new Object[]{systemContext, map, this});
        }
        boolean bl = false;
        boolean bl2 = systemContext.propertyExists("transportVersion");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "transportVersion", new Boolean(bl2));
        }
        boolean bl3 = systemContext.propertyExists("soapAction");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "soapAction", new Boolean(bl3));
        }
        if (bl2 && bl3) {
            try {
                DataGraph dataGraph = systemContext.getPayload("SOAP:");
                CoordinationContext coordinationContext = CoordinationContext.extractFromSDODataGraph(dataGraph, "http://schemas.xmlsoap.org/ws/2004/10/wsat");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "coordContext", coordinationContext);
                }
                if (coordinationContext != null) {
                    map.put(CONTEXT_KEY, coordinationContext);
                }
                bl = true;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, "com.ibm.ws390.tx.WSATJMSSystemContextHandler.extractContext", "96");
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Caught exception in extractContext", throwable);
                }
            }
        } else {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContext", bl);
        }
        return bl;
    }

    public boolean insertResponseContext(SystemContext systemContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertResponseContext", new Object[]{systemContext, this});
        }
        boolean bl = true;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertResponseContext", bl);
        }
        return bl;
    }

    public boolean establishContext(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "establishContext", new Object[]{map, this});
        }
        boolean bl = true;
        try {
            if (WSATJMSSystemContextHandler.establishWSATContext(map) > 0) {
                _context.set(map);
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException(exception, "com.ibm.ws390.tx.WSATJMSSystemContextHandler.estabishContext", "189");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception raised from establishWSATContext", exception);
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "establishContext", bl);
        }
        return bl;
    }

    public static int establishWSATContext(Map map) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "establishWSATContext", map);
        }
        int n = 0;
        CoordinationContext coordinationContext = (CoordinationContext)map.get(CONTEXT_KEY);
        String string = (String)map.get(TMM_FOR_SR_KEY);
        if (coordinationContext != null && string != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "coordContext", coordinationContext);
            }
            String string2 = coordinationContext.getIdentifier().getURI().toString();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "txID", string2);
            }
            TransactionManagerMessage transactionManagerMessage = new TransactionManagerMessage(Util.byteArray(string));
            XidImpl xidImpl = transactionManagerMessage.getXid();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got transaction xid from tmm context", xidImpl);
            }
            n = xidImpl.getBqualBranchIndex();
            TransactionImpl transactionImpl = TransactionImpl.findInPrimaryKeyMap(xidImpl.getPrimaryKey());
            if (transactionImpl == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "received first method in this tx", xidImpl);
                }
                byte[] byArray = xidImpl.toBytes();
                WSATControlSet.establishCoordinationContext(coordinationContext, byArray, n);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Received subsequent method in this tx and no tran on thread", xidImpl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "establishWSATContext", new Integer(n));
        }
        return n;
    }

    public void establishContextFailed() {
        Map map;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "establishContextFailed", this);
        }
        if ((map = (Map)_context.get()) != null) {
            String string;
            if (WSATHandlerHelper.isSupportsWSAT() && (string = (String)map.get(TMM_FOR_SR_KEY)) != null) {
                TransactionImpl transactionImpl;
                TransactionManagerMessage transactionManagerMessage = new TransactionManagerMessage(Util.byteArray(string));
                XidImpl xidImpl = transactionManagerMessage.getXid();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got transaction xid from tmm context", xidImpl);
                }
                if ((transactionImpl = TransactionImpl.findInPrimaryKeyMap(xidImpl.getPrimaryKey())) != null) {
                    transactionImpl.setRollbackOnly();
                }
            }
            this.removeEstablishedContext();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "establishContextFailed");
        }
    }

    public void extractContextFailed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractContextFailed", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractContextFailed");
        }
    }

    public void insertResponseContextFailed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertResponseContextFailed", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertResponseContextFailed");
        }
    }

    public boolean peekContext(Map map) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "peekContext", new Object[]{map, this});
        }
        boolean bl = false;
        bl = WSATCRControlSet.instance().peekWSATContext(map);
        if (tc.isDebugEnabled() && bl) {
            Tr.debug(tc, "Updated contextMap", map);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "peekContext", new Boolean(bl));
        }
        return bl;
    }

    public void removeEstablishedContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "removeEstablishedContext", this);
        }
        _context.set((Object)null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "removeEstablishedContext");
        }
    }

    public static int getBranchIndex() {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBranchIndex");
        }
        Map map = (Map)_context.get();
        int n = -1;
        if (map != null && (string = (String)map.get(TMM_FOR_SR_KEY)) != null) {
            TransactionManagerMessage transactionManagerMessage = new TransactionManagerMessage(Util.byteArray(string));
            n = transactionManagerMessage.getXid().getBqualBranchIndex();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBranchIndex", new Integer(n));
        }
        return n;
    }

    public void requestFailed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestFailed", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestFailed");
        }
    }

    public void requestSucceeded() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestSucceeded", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSucceeded");
        }
    }

    public void requestSucceeded(SystemContext systemContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "requestSucceeded", new Object[]{systemContext, this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "requestSucceeded");
        }
    }

    public boolean insertRequestContext(SystemContext systemContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertRequestContext", new Object[]{systemContext, this});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertRequestContext", Boolean.TRUE);
        }
        return true;
    }

    public void insertRequestContextFailed() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "insertRequestContextFailed", this);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "insertRequestContextFailed");
        }
    }
}

