/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws390.tx.ControllerTransactionManagerImpl;
import com.ibm.ws390.tx.ExitHandler;
import com.ibm.ws390.tx.NonPersistentInterestData;
import com.ibm.ws390.tx.RasHelper;
import com.ibm.ws390.tx.TranAttributeMap;
import com.ibm.ws390.tx.TransactionControlRep;
import com.ibm.ws390.tx.TransactionMessagePipe;
import com.ibm.ws390.tx.TransactionResolver;
import com.ibm.ws390.tx.WSATCRControlSet;
import com.ibm.ws390.tx.rrs.RRS;
import java.nio.ByteBuffer;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CosTransactions.Status;

public final class WorkRequestDispatcher {
    private static final TraceComponent tc = Tr.register(WorkRequestDispatcher.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    public static final int ACRW_FAST_TM_PC = 25;
    public static final int ACRW_RRS_EXIT_REQUEST = 100;
    public static final int ACRW_RESOLUTION_REQUEST = 101;
    public static final int ACRW_TM_PC = 102;
    public static final int ACRW_DELETE_TRANSACTION = 103;
    public static final int ACRW_NOTIFICATION_EXIT_REQUEST = 104;
    public static final int ACRW_DELETE_JTA_LTC_REF = 105;

    public static final byte[] dispatch(int n, ByteBuffer byteBuffer, int n2, int n3, int n4, int n5, Object object, ControllerTransactionManagerImpl controllerTransactionManagerImpl) throws SystemException, UserException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispatch", new Object[]{new Integer(n), byteBuffer, new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), object, controllerTransactionManagerImpl});
        }
        byte[] byArray = null;
        switch (n) {
            case 100: {
                ExitHandler exitHandler = (ExitHandler)object;
                WorkRequestDispatcher.dispatchExit(exitHandler);
                break;
            }
            case 101: {
                TransactionResolver transactionResolver = (TransactionResolver)object;
                transactionResolver.resolve();
                break;
            }
            case 103: {
                TransactionControlRep transactionControlRep = (TransactionControlRep)object;
                break;
            }
            case 104: {
                break;
            }
            case 105: {
                break;
            }
            case 25: 
            case 102: {
                TransactionMessagePipe transactionMessagePipe = new TransactionMessagePipe(byteBuffer);
                byArray = WorkRequestDispatcher.dispatchTMPC(transactionMessagePipe, controllerTransactionManagerImpl);
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "ACRW type not implemented", new Integer(n));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispatch", byArray);
        }
        return byArray;
    }

    private static final byte[] dispatchTMPC(TransactionMessagePipe transactionMessagePipe, ControllerTransactionManagerImpl controllerTransactionManagerImpl) throws SystemException, UserException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispatchTMPC", new Object[]{transactionMessagePipe, controllerTransactionManagerImpl});
        }
        byte[] byArray = null;
        switch (transactionMessagePipe.getFunctionCode()) {
            case 2: {
                controllerTransactionManagerImpl.commit(transactionMessagePipe);
                break;
            }
            case 6: {
                Status status = controllerTransactionManagerImpl.getStatus(transactionMessagePipe);
                transactionMessagePipe.setReturnCode(status.value());
                break;
            }
            case 7: {
                throw new NO_IMPLEMENT("suspend");
            }
            case 8: {
                throw new NO_IMPLEMENT("resume");
            }
            case 1: {
                controllerTransactionManagerImpl.begin(transactionMessagePipe);
                break;
            }
            case 3: {
                controllerTransactionManagerImpl.rollback(transactionMessagePipe);
                break;
            }
            case 4: {
                controllerTransactionManagerImpl.rollbackOnly(transactionMessagePipe);
                break;
            }
            case 5: {
                throw new NO_IMPLEMENT("get_control");
            }
            case 10: {
                controllerTransactionManagerImpl.prepare(transactionMessagePipe);
                break;
            }
            case 12: {
                controllerTransactionManagerImpl.setHeuristicBit(transactionMessagePipe);
                break;
            }
            case 13: {
                controllerTransactionManagerImpl.enlistXaResources(transactionMessagePipe);
                break;
            }
            case 14: {
                controllerTransactionManagerImpl.setFailedXaResources(transactionMessagePipe);
                break;
            }
            case 15: {
                controllerTransactionManagerImpl.sequenceWrap();
                break;
            }
            case 16: {
                controllerTransactionManagerImpl.sequenceWait();
                break;
            }
            case 17: {
                TranAttributeMap.instance().addComponent(transactionMessagePipe.getVariableData());
                transactionMessagePipe.setVariableDataLength(0);
                break;
            }
            case 18: {
                TranAttributeMap.instance().removeComponent(transactionMessagePipe.getVariableData());
                transactionMessagePipe.setVariableDataLength(0);
                break;
            }
            case 19: {
                controllerTransactionManagerImpl.forget(transactionMessagePipe);
                break;
            }
            case 20: {
                controllerTransactionManagerImpl.registerWsTx(transactionMessagePipe);
                break;
            }
            case 21: {
                byArray = WSATCRControlSet.instance().marshalPortData();
                break;
            }
            case 22: {
                controllerTransactionManagerImpl.wstxMapData(transactionMessagePipe);
                break;
            }
            case 23: {
                controllerTransactionManagerImpl.decrementWSAT(transactionMessagePipe);
                break;
            }
            default: {
                RasHelper.exit(-910026198, false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispatchACRW", byArray);
        }
        return byArray;
    }

    public static final void dispatchExit(ExitHandler exitHandler) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispatchExit", exitHandler);
        }
        NonPersistentInterestData nonPersistentInterestData = exitHandler.getNonPersistentInterestData();
        int n = 0;
        int n2 = nonPersistentInterestData.getLastExit();
        block0 : switch (n2) {
            case 11: {
                n = exitHandler.prePrepare();
                if (n != -2) break;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "PrePrepare exit backend failed", exitHandler);
                }
                n = 0;
                break;
            }
            case 1: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Error - state check exit driven");
                break;
            }
            case 2: {
                n = exitHandler.prepare();
                switch (n) {
                    case -2: {
                        n = 8;
                    }
                    case 8: 
                    case 12: 
                    case 40: 
                    case 44: {
                        if (nonPersistentInterestData.isCascaded()) break block0;
                        nonPersistentInterestData.preReplyBackout(16);
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                n = exitHandler.commit();
                if (n != -2) break;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Commit exit backend failed", exitHandler);
                }
                n = 44;
                break;
            }
            case 5: {
                n = exitHandler.backout();
                if (n != -2) break;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Backout exit backend failed", exitHandler);
                }
                n = 44;
                break;
            }
            case 6: {
                n = exitHandler.endUR();
                if (n != -2) break;
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "endUR exit backend failed", exitHandler);
                }
                n = 16;
                break;
            }
            case 9: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Error - only agent exit driven");
            }
        }
        if (n != -1 && n != -3) {
            byte[] byArray = exitHandler.getURIToken();
            n = RRS.postDeferredURExit(byArray, n2, n);
            switch (n) {
                case 0: 
                case 16: {
                    break;
                }
                case 1794: 
                case 3840: {
                    Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{new String("ATRPDUE"), Integer.toHexString(n)});
                    RasHelper.exit(-910026664, true);
                    break;
                }
                default: {
                    Tr.audit(tc, "BBOT0004_RRS_SVC_FAIL", new Object[]{new String("ATRPDUE"), Integer.toHexString(n)});
                    RasHelper.exit(-910026663, false);
                }
            }
            nonPersistentInterestData.markFailed(false);
        } else if (n == -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exit backend failed, scheduling retry", new Object[]{new Integer(n2), exitHandler});
            }
            exitHandler.scheduleRetry();
            nonPersistentInterestData.markFailed(true);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispatchExit", exitHandler);
        }
    }
}

