/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.Transaction.JTA.EpochFailureScope;
import com.ibm.ws.Transaction.JTA.FailureScopeController;
import com.ibm.ws.Transaction.JTA.RecoveryManager;
import com.ibm.ws.Transaction.JTA.XAPdataWrapper;
import com.ibm.ws.Transaction.JTA.XARecoveryData;
import com.ibm.ws.Transaction.JTA.XARecoveryWrapper;
import com.ibm.ws.Transaction.JTA.XAReturnCodeHelper;
import com.ibm.ws.Transaction.JTA.XARminst;
import com.ibm.ws.Transaction.JTA.XidImpl;
import com.ibm.ws.Transaction.JTS.Configuration;
import com.ibm.ws.Transaction.XAResourceFactory;
import com.ibm.ws.Transaction.XAResourceInfo;
import com.ibm.ws.Transaction.XAResourceNotAvailableException;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.recoverylog.spi.FailureScope;
import com.ibm.ws.recoverylog.spi.FailureScopeManager;
import com.ibm.ws.recoverylog.spi.InternalLogException;
import com.ibm.ws.recoverylog.spi.InvalidLogPropertiesException;
import com.ibm.ws.recoverylog.spi.LogClosedException;
import com.ibm.ws.recoverylog.spi.LogCursor;
import com.ibm.ws.recoverylog.spi.LogProperties;
import com.ibm.ws.recoverylog.spi.RecoverableUnit;
import com.ibm.ws.recoverylog.spi.RecoverableUnitSection;
import com.ibm.ws.recoverylog.spi.RecoveryLog;
import com.ibm.ws.util.PlatformHelperFactory;
import com.ibm.ws390.tx.NativeTransactionContext;
import com.ibm.ws390.tx.xarecovery.HeuristicException;
import com.ibm.ws390.tx.xarecovery.RecoveryException;
import com.ibm.ws390.tx.xarecovery.ResourceManagerException;
import com.ibm.ws390.tx.xarecovery.XID;
import com.ibm.ws390.tx.xarecovery._XARecoveryAgentImplBase;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.UserException;

public class XARecoveryAgentImpl
extends _XARecoveryAgentImplBase {
    private static final TraceComponent tc = Tr.register(XARecoveryAgentImpl.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static boolean issuedRecoveryMessage = false;

    public XARecoveryAgentImpl() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void rollbackUnknownTransactions(XID[] xIDArray, int n, byte[] byArray) throws RecoveryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackUnknownTransactions", new Object[]{xIDArray, new Integer(n), byArray});
        }
        XARecoveryAgentThread xARecoveryAgentThread = new XARecoveryAgentThread();
        xARecoveryAgentThread.rollbackUnknownTransactions(xIDArray, n, byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackUnknownTransactions");
        }
    }

    public void rollbackUnknownTransactions(XID[] xIDArray, int n, byte[] byArray, XARecoveryAgentThread xARecoveryAgentThread) throws RecoveryException {
        Object object;
        RecoveryLog recoveryLog;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollbackUnknownTransactions", new Object[]{xIDArray, new Integer(n), byArray, xARecoveryAgentThread});
        }
        boolean bl = true;
        byte[] byArray2 = NativeTransactionContext.getServerUUID();
        int n2 = 0;
        if (xIDArray != null) {
            n2 = xIDArray.length;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Current Epoch", new Integer(n));
            Tr.debug(tc, "Native XIDs", new Integer(n2));
            Tr.debug(tc, "CRUUID", byArray2);
            Tr.debug(tc, "Stoken", byArray);
        }
        boolean bl2 = byArray != null && byArray.length != 0;
        FailureScopeController failureScopeController = Configuration.getFailureScopeController();
        RecoveryManager recoveryManager = failureScopeController.getRecoveryManager();
        LogCursor logCursor = null;
        if (bl2) {
            try {
                recoveryLog = failureScopeController.getPartnerLog();
                logCursor = recoveryLog.recoverableUnits();
            }
            catch (LogClosedException logClosedException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Partner Log was closed", logClosedException);
                }
                throw new RecoveryException(0, logClosedException.toString());
            }
        }
        try {
            recoveryLog = failureScopeController.getRecoveryPartnerLog();
            logCursor = recoveryLog.recoverableUnits();
        }
        catch (LogClosedException logClosedException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Restart Partner Log was closed", logClosedException);
            }
            throw new RecoveryException(0, logClosedException.toString());
        }
        int n3 = 0;
        if (logCursor != null) {
            n3 = logCursor.initialSize();
        }
        if (n3 == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollbackUnknownTransactions - Nothing to recover");
            }
            return;
        }
        if (!bl2 && !issuedRecoveryMessage || bl2) {
            if (n2 == 1) {
                Tr.audit(tc, "WTRN0027_RECOVERING_TXN");
            } else {
                Tr.audit(tc, "WTRN0028_RECOVERING_TXNS", new Integer(n2));
            }
            if (!bl2) {
                issuedRecoveryMessage = true;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "There are {0} resources to recover", new Integer(n3));
        }
        ExtClassLoader extClassLoader = (ExtClassLoader)Thread.currentThread().getContextClassLoader();
        try {
            int n4;
            Object object2;
            Xid[] xidArray;
            object = new ArrayList<XARecoveryData>(n3);
            while (logCursor.hasNext()) {
                xidArray = (Xid[])logCursor.next();
                RecoverableUnitSection recoverableUnitSection = xidArray.lookupSection(34);
                if (recoverableUnitSection != null) {
                    object2 = recoverableUnitSection.lastData();
                    XARecoveryData xARecoveryData = new XARecoveryData(recoveryLog, (byte[])object2, xidArray.identity());
                    object.add(xARecoveryData);
                    continue;
                }
                if (!tc.isEventEnabled()) continue;
                Tr.event(tc, "RecoverableUnit did not have an XAResource associated with it", new Long(xidArray.identity()));
            }
            logCursor.close();
            xidArray = new Xid[xIDArray.length];
            for (n4 = 0; n4 < xIDArray.length; ++n4) {
                xidArray[n4] = new XidImpl(this.rrsXidToByteArray(xIDArray[n4]), 0);
            }
            for (n4 = 0; n4 < object.size(); ++n4) {
                object2 = (XARecoveryData)object.get(n4);
                if (((XARecoveryData)object2).recover((ClassLoader)extClassLoader, xidArray, byArray, byArray2, n)) continue;
                bl = false;
            }
        }
        catch (Throwable throwable) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Caught exception during recovery", throwable);
            }
            if (throwable instanceof RecoveryException) {
                throw (RecoveryException)((Object)throwable);
            }
            throw new RecoveryException(0, throwable.toString());
        }
        if (!bl) {
            object = new RecoveryException(0, "Resources were not able to be recovered, must retry");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "rollbackUnknownTransactions", object);
            }
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollbackUnknownTransactions");
        }
    }

    private String addRMInfo(String string, Object object) {
        String string2 = string;
        if (string == null || string.length() == 0) {
            string2 = object == null ? "" : object.toString();
        } else if (object != null) {
            string2 = string + ", " + object.toString();
        }
        return string2;
    }

    public void commit(XID xID, byte[] byArray, byte[] byArray2, byte[] byArray3) throws ResourceManagerException, RecoveryException, HeuristicException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", new Object[]{xID, byArray, byArray2, byArray3});
        }
        XARecoveryAgentThread xARecoveryAgentThread = new XARecoveryAgentThread();
        xARecoveryAgentThread.commit(xID, byArray, byArray2, byArray3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(XID xID, byte[] byArray, byte[] byArray2, byte[] byArray3, XARecoveryAgentThread xARecoveryAgentThread) throws ResourceManagerException, RecoveryException, HeuristicException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commit", new Object[]{xID, byArray, byArray2, byArray3, xARecoveryAgentThread});
        }
        RecoveryLog recoveryLog = null;
        try {
            if (xID == null || byArray == null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Passed null data to commit");
                }
                RecoveryException recoveryException = new RecoveryException(0, "Passed null data to commit");
                FFDCFilter.processException((Throwable)((Object)recoveryException), this.getClass().getName() + ".commit", "418", this);
                throw recoveryException;
            }
            boolean bl = false;
            byte[] byArray4 = this.rrsXidToByteArray(xID);
            XAPdataWrapper xAPdataWrapper = null;
            try {
                xAPdataWrapper = new XAPdataWrapper(byArray);
            }
            catch (Throwable throwable) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Could not inflate pdata", throwable);
                }
                throw new RecoveryException(0, "Could not inflate PData");
            }
            int n = xAPdataWrapper.getNumberOfResources();
            byte[] byArray5 = xAPdataWrapper.getStoken();
            Object object = Configuration.getClassLoader();
            RecoveryManager recoveryManager = null;
            if (!(byArray2 != null && byArray2.length != 0 || byArray3 != null && byArray3.length != 0)) {
                recoveryManager = Configuration.getFailureScopeController().getRecoveryManager();
                recoveryManager.addExtraPaths();
            } else {
                recoveryLog = this.getPartnerLog(byArray2, byArray3);
                recoveryLog.openLog();
            }
            String string = null;
            for (int i = 0; i < n; ++i) {
                Object object2;
                Object object3;
                XidImpl xidImpl;
                block52: {
                    Object object4;
                    long l = xAPdataWrapper.getResourceToken(i);
                    int n2 = xAPdataWrapper.getSequenceNumber(i);
                    xidImpl = new XidImpl(byArray4, n2, byArray5);
                    XARecoveryData xARecoveryData = null;
                    if (!(byArray2 != null && byArray2.length != 0 || byArray3 != null && byArray3.length != 0)) {
                        xARecoveryData = (XARecoveryData)recoveryManager.getPartnerLogTable().findEntry(l);
                    } else {
                        block51: {
                            object4 = null;
                            try {
                                object4 = recoveryLog.lookupRecoverableUnit(l);
                            }
                            catch (LogClosedException logClosedException) {
                                if (!tc.isEventEnabled()) break block51;
                                Tr.event(tc, "Partner log is closed", logClosedException);
                            }
                        }
                        if (object4 != null && (object3 = object4.lookupSection(34)) != null) {
                            object2 = object3.lastData();
                            xARecoveryData = new XARecoveryData(recoveryLog, (byte[])object2, object4.identity());
                            xARecoveryData.deserialize((ClassLoader)object);
                        }
                    }
                    if (xARecoveryData == null) {
                        Tr.error(tc, "WTRN0030_XARESOURCE_RECOVER_FAILURE", new String(" because recovery id " + l + " could not be found in the log"));
                        continue;
                    }
                    object4 = this.inflateXaRecoveryWrapper(xARecoveryData, (ClassLoader)object);
                    object3 = this.inflateXaResource((XARecoveryWrapper)object4, (ClassLoader)(object = xARecoveryData.getRecoveryClassLoader()));
                    object2 = ((XARminst)object3).getXaResource();
                    if (object2 == null) {
                        string = this.addRMInfo(string, object2);
                        continue;
                    }
                    try {
                        ((XARminst)object3).recover();
                    }
                    catch (Throwable throwable) {
                        if (!tc.isEventEnabled()) break block52;
                        Tr.event(tc, "Caught exception driving recover before commit", throwable);
                    }
                }
                try {
                    object2.commit(xidImpl, false);
                    continue;
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, this.getClass().getName() + ".commit", "571", this);
                    int n3 = xAException.errorCode;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Resource threw XAException during commit: error code" + XAReturnCodeHelper.convertXACode(n3), xAException);
                    }
                    if (n3 == 8 || n3 == 7 || n3 == 6 || n3 == 5) {
                        bl = true;
                        continue;
                    }
                    if (n3 == -4) {
                        continue;
                    }
                    if (n3 == -3) {
                        Tr.warning(tc, "WTRN0047_XAER_RMERR_ON_COMMIT", object2);
                    } else if (n3 == -7) {
                        Tr.warning(tc, "WTRN0048_XAER_RMFAIL_ON_COMMIT", object2);
                    } else {
                        Tr.warning(tc, "WTRN0050_UNEXPECTED_XA_ERROR_ON_COMMIT", new Integer(xAException.errorCode));
                    }
                    string = this.addRMInfo(string, object2);
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName() + ".commit", "693", this);
                    Tr.warning(tc, "WTRN0058_RECOVERY_EXCEPTION_IN_COMMIT", new Object[]{xidImpl, throwable});
                    string = this.addRMInfo(string, object2);
                    continue;
                }
                finally {
                    ((XARminst)object3).closeConnection();
                }
            }
            if (string != null) {
                ResourceManagerException resourceManagerException = new ResourceManagerException(string);
                FFDCFilter.processException((Throwable)((Object)resourceManagerException), this.getClass().getName() + ".commit", "514", this);
                throw resourceManagerException;
            }
            if (bl) {
                HeuristicException heuristicException = new HeuristicException();
                FFDCFilter.processException((Throwable)((Object)heuristicException), this.getClass().getName() + ".commit", "531", this);
                throw heuristicException;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof HeuristicException) {
                throw (HeuristicException)((Object)throwable);
            }
            if (throwable instanceof RecoveryException) {
                throw (RecoveryException)((Object)throwable);
            }
            if (throwable instanceof ResourceManagerException) {
                throw (ResourceManagerException)((Object)throwable);
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Encountered unexpected exception during commit processing", throwable);
            }
            throw new RecoveryException(0, throwable.toString());
        }
        finally {
            if (recoveryLog != null) {
                try {
                    recoveryLog.closeLog();
                }
                catch (InternalLogException internalLogException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unable to close the partner log", internalLogException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commit");
                    }
                    throw new RecoveryException(0, internalLogException.toString());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "commit");
        }
    }

    public void rollback(XID xID, byte[] byArray, byte[] byArray2, byte[] byArray3) throws ResourceManagerException, RecoveryException, HeuristicException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback", new Object[]{xID, byArray, byArray2, byArray3});
        }
        XARecoveryAgentThread xARecoveryAgentThread = new XARecoveryAgentThread();
        xARecoveryAgentThread.rollback(xID, byArray, byArray2, byArray3);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(XID xID, byte[] byArray, byte[] byArray2, byte[] byArray3, XARecoveryAgentThread xARecoveryAgentThread) throws ResourceManagerException, RecoveryException, HeuristicException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rollback", new Object[]{xID, byArray, byArray2, byArray3, xARecoveryAgentThread});
        }
        RecoveryLog recoveryLog = null;
        try {
            if (xID == null || byArray == null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Passed null data to rollback");
                }
                RecoveryException recoveryException = new RecoveryException(0, "Passed null data to rollback");
                FFDCFilter.processException((Throwable)((Object)recoveryException), this.getClass().getName() + ".rollback", "578", this);
                throw recoveryException;
            }
            boolean bl = false;
            byte[] byArray4 = this.rrsXidToByteArray(xID);
            XAPdataWrapper xAPdataWrapper = null;
            try {
                xAPdataWrapper = new XAPdataWrapper(byArray);
            }
            catch (Throwable throwable) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Could not inflate pdata", throwable);
                }
                throw new RecoveryException(0, throwable.toString());
            }
            int n = xAPdataWrapper.getNumberOfResources();
            byte[] byArray5 = xAPdataWrapper.getStoken();
            Object object = Configuration.getClassLoader();
            RecoveryManager recoveryManager = null;
            if (!(byArray2 != null && byArray2.length != 0 || byArray3 != null && byArray3.length != 0)) {
                recoveryManager = Configuration.getFailureScopeController().getRecoveryManager();
                recoveryManager.addExtraPaths();
            } else {
                recoveryLog = this.getPartnerLog(byArray2, byArray3);
                recoveryLog.openLog();
            }
            String string = null;
            for (int i = 0; i < n; ++i) {
                Object object2;
                Object object3;
                XidImpl xidImpl;
                block50: {
                    Object object4;
                    long l = xAPdataWrapper.getResourceToken(i);
                    int n2 = xAPdataWrapper.getSequenceNumber(i);
                    xidImpl = new XidImpl(byArray4, n2, byArray5);
                    XARecoveryData xARecoveryData = null;
                    if (!(byArray2 != null && byArray2.length != 0 || byArray3 != null && byArray3.length != 0)) {
                        xARecoveryData = (XARecoveryData)recoveryManager.getPartnerLogTable().findEntry(l);
                    } else {
                        block49: {
                            object4 = null;
                            try {
                                object4 = recoveryLog.lookupRecoverableUnit(l);
                            }
                            catch (LogClosedException logClosedException) {
                                if (!tc.isEventEnabled()) break block49;
                                Tr.event(tc, "Partner log is closed", logClosedException);
                            }
                        }
                        if (object4 != null && (object3 = object4.lookupSection(34)) != null) {
                            object2 = object3.lastData();
                            xARecoveryData = new XARecoveryData(recoveryLog, (byte[])object2, object4.identity());
                            xARecoveryData.deserialize((ClassLoader)object);
                        }
                    }
                    if (xARecoveryData == null) {
                        Tr.error(tc, "WTRN0030_XARESOURCE_RECOVER_FAILURE", new String(" because recovery id " + l + " could not be found in the log"));
                        continue;
                    }
                    object4 = this.inflateXaRecoveryWrapper(xARecoveryData, (ClassLoader)object);
                    object3 = this.inflateXaResource((XARecoveryWrapper)object4, (ClassLoader)(object = xARecoveryData.getRecoveryClassLoader()));
                    object2 = ((XARminst)object3).getXaResource();
                    if (object2 == null) {
                        string = this.addRMInfo(string, object2);
                        continue;
                    }
                    try {
                        ((XARminst)object3).recover();
                    }
                    catch (Throwable throwable) {
                        if (!tc.isEventEnabled()) break block50;
                        Tr.event(tc, "Caught exception driving recover before rollback", throwable);
                    }
                }
                try {
                    object2.rollback(xidImpl);
                    continue;
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, this.getClass().getName() + ".rollback", "807", this);
                    int n3 = xAException.errorCode;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Resource threw XAException during rollback: error code" + XAReturnCodeHelper.convertXACode(n3), xAException);
                    }
                    if (n3 == 8 || n3 == 7 || n3 == 6 || n3 == 5) {
                        bl = true;
                        continue;
                    }
                    if (n3 >= 100 && n3 <= 107) continue;
                    if (n3 == -4) {
                        continue;
                    }
                    if (n3 == -3) {
                        Tr.warning(tc, "WTRN0049_XAER_RMFAIL_ON_ROLLBACK", object2);
                    } else {
                        Tr.warning(tc, "WTRN0051_UNEXPECTED_XA_ERROR_ON_ROLLBACK", new Integer(xAException.errorCode));
                    }
                    string = this.addRMInfo(string, object2);
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName() + ".commit", "693", this);
                    Tr.warning(tc, "WTRN0059_RECOVERY_EXCEPTION_IN_ROLLBACK", new Object[]{xidImpl, throwable});
                    string = this.addRMInfo(string, object2);
                    continue;
                }
                finally {
                    ((XARminst)object3).closeConnection();
                }
            }
            if (string != null) {
                ResourceManagerException resourceManagerException = new ResourceManagerException(string);
                FFDCFilter.processException((Throwable)((Object)resourceManagerException), this.getClass().getName() + ".commit", "514", this);
                throw resourceManagerException;
            }
            if (bl) {
                HeuristicException heuristicException = new HeuristicException();
                FFDCFilter.processException((Throwable)((Object)heuristicException), this.getClass().getName() + ".rollback", "674", this);
                throw heuristicException;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof HeuristicException) {
                throw (HeuristicException)((Object)throwable);
            }
            if (throwable instanceof RecoveryException) {
                throw (RecoveryException)((Object)throwable);
            }
            if (throwable instanceof ResourceManagerException) {
                throw (ResourceManagerException)((Object)throwable);
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Encountered unexpected exception during rollback processing", throwable);
            }
            throw new RecoveryException(0, throwable.toString());
        }
        finally {
            if (recoveryLog != null) {
                try {
                    recoveryLog.closeLog();
                }
                catch (InternalLogException internalLogException) {
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Unable to close the partner log", internalLogException);
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "commit");
                    }
                    throw new RecoveryException(0, internalLogException.toString());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rollback");
        }
    }

    public void forget(XID xID, byte[] byArray) throws ResourceManagerException, RecoveryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forget", new Object[]{xID, byArray});
        }
        XARecoveryAgentThread xARecoveryAgentThread = new XARecoveryAgentThread();
        xARecoveryAgentThread.forget(xID, byArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "forget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forget(XID xID, byte[] byArray, XARecoveryAgentThread xARecoveryAgentThread) throws ResourceManagerException, RecoveryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "forget", new Object[]{xID, byArray, xARecoveryAgentThread});
        }
        try {
            if (xID == null || byArray == null) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Passed null data to forget");
                }
                RecoveryException recoveryException = new RecoveryException(0, "Passed null data to forget");
                FFDCFilter.processException((Throwable)((Object)recoveryException), this.getClass().getName() + ".forget", "717", this);
                throw recoveryException;
            }
            byte[] byArray2 = this.rrsXidToByteArray(xID);
            XAPdataWrapper xAPdataWrapper = null;
            try {
                xAPdataWrapper = new XAPdataWrapper(byArray);
            }
            catch (Throwable throwable) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Could not inflate pdata", throwable);
                }
                throw new RecoveryException(0, throwable.toString());
            }
            int n = xAPdataWrapper.getNumberOfResources();
            byte[] byArray3 = xAPdataWrapper.getStoken();
            Object object = Configuration.getClassLoader();
            RecoveryManager recoveryManager = Configuration.getFailureScopeController().getRecoveryManager();
            recoveryManager.addExtraPaths();
            String string = null;
            for (int i = 0; i < n; ++i) {
                XAResource xAResource;
                XARminst xARminst;
                XidImpl xidImpl;
                block27: {
                    long l = xAPdataWrapper.getResourceToken(i);
                    int n2 = xAPdataWrapper.getSequenceNumber(i);
                    xidImpl = new XidImpl(byArray2, n2, byArray3);
                    XARecoveryData xARecoveryData = (XARecoveryData)recoveryManager.getPartnerLogTable().findEntry(l);
                    if (xARecoveryData == null) {
                        Tr.error(tc, "WTRN0030_XARESOURCE_RECOVER_FAILURE", new String(" because recovery id " + l + " could not be found in the log"));
                        continue;
                    }
                    XARecoveryWrapper xARecoveryWrapper = this.inflateXaRecoveryWrapper(xARecoveryData, (ClassLoader)object);
                    xARminst = this.inflateXaResource(xARecoveryWrapper, (ClassLoader)(object = xARecoveryData.getRecoveryClassLoader()));
                    xAResource = xARminst.getXaResource();
                    if (xAResource == null) {
                        string = this.addRMInfo(string, xAResource);
                        continue;
                    }
                    try {
                        xARminst.recover();
                    }
                    catch (Throwable throwable) {
                        if (!tc.isEventEnabled()) break block27;
                        Tr.event(tc, "Caught exception driving recover before forget", throwable);
                    }
                }
                try {
                    xAResource.forget(xidImpl);
                    continue;
                }
                catch (XAException xAException) {
                    FFDCFilter.processException((Throwable)xAException, this.getClass().getName() + ".forget", "1015", this);
                    int n3 = xAException.errorCode;
                    if (tc.isEventEnabled()) {
                        Tr.event(tc, "Resource threw XAException during forget: error code" + XAReturnCodeHelper.convertXACode(n3), xAException);
                    }
                    if (n3 == -4) {
                        continue;
                    }
                    Tr.warning(tc, "WTRN0054_XA_FORGET_ERROR", new Object[]{new Integer(n3), xAException});
                    string = this.addRMInfo(string, xAResource);
                    continue;
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException(throwable, this.getClass().getName() + ".commit", "693", this);
                    Tr.warning(tc, "WTRN0060_RECOVERY_EXCEPTION_IN_FORGET", new Object[]{xidImpl, throwable});
                    string = this.addRMInfo(string, xAResource);
                    continue;
                }
                finally {
                    xARminst.closeConnection();
                }
            }
            if (string != null) {
                ResourceManagerException resourceManagerException = new ResourceManagerException(string);
                FFDCFilter.processException((Throwable)((Object)resourceManagerException), this.getClass().getName() + ".commit", "514", this);
                throw resourceManagerException;
            }
        }
        catch (Throwable throwable) {
            if (throwable instanceof RecoveryException) {
                throw (RecoveryException)((Object)throwable);
            }
            if (throwable instanceof ResourceManagerException) {
                throw (ResourceManagerException)((Object)throwable);
            }
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Encountered unexpected exception during rollback processing", throwable);
            }
            throw new RecoveryException(0, throwable.toString());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "forget");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rrsRecoveryComplete() throws RecoveryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rrsRecoveryComplete");
        }
        FailureScopeController failureScopeController = Configuration.getFailureScopeController();
        RecoveryManager recoveryManager = failureScopeController.getRecoveryManager();
        RecoveryLog recoveryLog = failureScopeController.getRecoveryPartnerLog();
        LogCursor logCursor = null;
        try {
            logCursor = recoveryLog.recoverableUnits();
            if (logCursor != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Number of units to remove", new Integer(logCursor.initialSize()));
                }
                while (logCursor.hasNext()) {
                    RecoverableUnitSection recoverableUnitSection;
                    RecoverableUnit recoverableUnit = (RecoverableUnit)logCursor.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing RecoverableUnit", new Long(recoverableUnit.identity()));
                    }
                    if ((recoverableUnitSection = recoverableUnit.lookupSection(34)) != null) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Removing RecoverableUnit");
                        }
                        logCursor.remove();
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Keeping RecoverableUnit");
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "RecoveryComplete processing encountered an error while compressing the partner log", throwable);
            }
            throw new RecoveryException(0, throwable.toString());
        }
        finally {
            if (logCursor != null) {
                logCursor.close();
            }
        }
        try {
            logCursor = recoveryLog.recoverableUnits();
            if (logCursor != null && logCursor.initialSize() > 1) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Compressed log has more than one entry in it");
                }
                throw new RecoveryException(0, "Compressed log has more than one entry in it");
            }
        }
        catch (LogClosedException logClosedException) {
        }
        finally {
            if (logCursor != null) {
                logCursor.close();
            }
        }
        recoveryManager.setLowWatermark();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rrsRecoveryComplete");
        }
    }

    private XARecoveryWrapper inflateXaRecoveryWrapper(XARecoveryData xARecoveryData, ClassLoader classLoader) {
        XARecoveryWrapper xARecoveryWrapper;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inflateXaRecoveryWrapper", new Object[]{xARecoveryData, classLoader});
        }
        if ((xARecoveryWrapper = xARecoveryData.getXARecoveryWrapper()) == null) {
            xARecoveryData.deserialize(classLoader);
            xARecoveryWrapper = xARecoveryData.getXARecoveryWrapper();
        }
        if (xARecoveryWrapper == null) {
            Tr.error(tc, "WTRN0030_XARESOURCE_RECOVER_FAILURE", new String(" because the recovery data for id " + xARecoveryData.getRecoveryId() + " could not " + " be deserialized from the log"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inflateXaRecoveryWrapper", xARecoveryWrapper);
        }
        return xARecoveryWrapper;
    }

    private XARminst inflateXaResource(XARecoveryWrapper xARecoveryWrapper, ClassLoader classLoader) throws RecoveryException {
        Object object;
        Serializable serializable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "inflateXaResource", new Object[]{xARecoveryWrapper, classLoader});
        }
        String string = xARecoveryWrapper.getXAResourceFactoryClassName();
        XAResourceFactory xAResourceFactory = null;
        try {
            serializable = null;
            serializable = classLoader != null ? Class.forName(string, true, classLoader) : Class.forName(string);
            xAResourceFactory = (XAResourceFactory)serializable.newInstance();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName() + ".inflateXaResource", "911", this);
            Tr.fatal(tc, "WTRN0004_CANT_CREATE_XARESOURCEFACTORY", new Object[]{string, throwable});
            throw new RecoveryException(0, throwable.toString());
        }
        serializable = xARecoveryWrapper.getXAResourceInfo();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Attempting to re-inflate resource", xARecoveryWrapper.toString());
        }
        XAResource xAResource = null;
        ClassLoader classLoader2 = null;
        try {
            if (classLoader != null) {
                object = Thread.currentThread();
                classLoader2 = ((Thread)object).getContextClassLoader();
                ((Thread)object).setContextClassLoader(classLoader);
            }
            xAResource = xAResourceFactory.getXAResource((XAResourceInfo)serializable);
        }
        catch (XAResourceNotAvailableException xAResourceNotAvailableException) {
            FFDCFilter.processException((Throwable)xAResourceNotAvailableException, this.getClass().getName() + ".inflateXaResource", "936", this);
            Tr.warning(tc, "WTRN0005_CANT_RECREATE_XARESOURCE", new Object[]{serializable, xAResourceNotAvailableException});
            if (tc.isEventEnabled()) {
                Tr.event(tc, "An XAResource for a transaction participant could not be recreated and transaction recovery may not be able to complete properly: ", xAResourceNotAvailableException);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, this.getClass().getName() + ".inflateXaResource", "955", this);
            Tr.fatal(tc, "WTRN0005_CANT_RECREATE_XARESOURCE", new Object[]{serializable, throwable});
            throw new RecoveryException(0, throwable.toString());
        }
        finally {
            if (classLoader2 != null) {
                Thread.currentThread().setContextClassLoader(classLoader2);
            }
        }
        object = new XARminst(xAResource, xAResourceFactory);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "inflateXaResource", object);
        }
        return object;
    }

    private byte[] rrsXidToByteArray(XID xID) {
        byte[] byArray = new byte[4 + xID.gtridLength + xID.bqualLength + xID.tid.length];
        byArray[0] = (byte)(0xFF & xID.formatID >> 24);
        byArray[1] = (byte)(0xFF & xID.formatID >> 16);
        byArray[2] = (byte)(0xFF & xID.formatID >> 8);
        byArray[3] = (byte)(0xFF & xID.formatID);
        byArray[4] = (byte)(0xFF & xID.gtridLength >> 24);
        byArray[5] = (byte)(0xFF & xID.gtridLength >> 16);
        byArray[6] = (byte)(0xFF & xID.gtridLength >> 8);
        byArray[7] = (byte)(0xFF & xID.gtridLength);
        byArray[8] = (byte)(0xFF & xID.bqualLength >> 24);
        byArray[9] = (byte)(0xFF & xID.bqualLength >> 16);
        byArray[10] = (byte)(0xFF & xID.bqualLength >> 8);
        byArray[11] = (byte)(0xFF & xID.bqualLength);
        System.arraycopy(xID.tid, 0, byArray, 12, xID.gtridLength + xID.bqualLength);
        return byArray;
    }

    private RecoveryLog getPartnerLog(byte[] byArray, byte[] byArray2) throws RecoveryException {
        Object object;
        Object object2;
        RecoveryLog recoveryLog = null;
        FailureScope failureScope = FailureScopeManager.toFailureScope(byArray);
        String string = failureScope.serverName();
        LogProperties logProperties = null;
        try {
            object2 = new ByteArrayInputStream(byArray2);
            object = new ObjectInputStream((InputStream)object2);
            Object object3 = ((ObjectInputStream)object).readObject();
            ((ObjectInputStream)object).close();
            logProperties = (LogProperties)object3;
        }
        catch (Exception exception) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to serialize/deserialize an object/byteArray from the byte stream", exception);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPartnerLog");
            }
            throw new RecoveryException(0, exception.toString());
        }
        object2 = Configuration.getLogManager();
        try {
            object = new EpochFailureScope(0L, false, string);
            recoveryLog = object2.getRecoveryLog((FailureScope)object, logProperties);
        }
        catch (InvalidLogPropertiesException invalidLogPropertiesException) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Unable to get the partnerLog from the rlm", invalidLogPropertiesException);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getPartnerLog");
            }
            throw new RecoveryException(0, invalidLogPropertiesException.toString());
        }
        return recoveryLog;
    }

    static {
        if (!PlatformHelperFactory.getPlatformHelper().runningWhereConfigured()) {
            try {
                String string = System.getProperty("com.ibm.vm.bitmode");
                int n = Integer.parseInt(string);
                if (n == 64) {
                    System.loadLibrary("bbgtots");
                } else {
                    System.loadLibrary("bbotots");
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Tr.debug(tc, "Unable to load native library", unsatisfiedLinkError);
            }
        }
    }

    public class XARecoveryAgentThread
    extends Thread {
        private int RBUNKNOWN = 0;
        private int ROLLBACK = 1;
        private int COMMIT = 2;
        private int FORGET = 3;
        private int _request = -1;
        private XID[] _xidArray = null;
        private int _epoch = -1;
        private byte[] _token = null;
        private byte[] _fsToken = null;
        private byte[] _logProperties = null;
        private ClassLoader _cl = null;
        private UserException _ex = null;

        public XARecoveryAgentThread() {
            FailureScopeController failureScopeController = Configuration.getFailureScopeController();
            RecoveryManager recoveryManager = failureScopeController.getRecoveryManager();
            this._cl = recoveryManager.addExtraPaths();
        }

        public void setException(UserException userException) {
            this._ex = userException;
        }

        public void rollbackUnknownTransactions(XID[] xIDArray, int n, byte[] byArray) throws RecoveryException {
            this._request = this.RBUNKNOWN;
            this._xidArray = xIDArray;
            this._epoch = n;
            this._token = byArray;
            try {
                this.setDaemon(true);
                this.start();
                this.join();
            }
            catch (Throwable throwable) {
                this._ex = new RecoveryException(0, "Caught " + throwable.toString() + " during method");
            }
            if (this._ex != null) {
                if (this._ex instanceof RecoveryException) {
                    throw (RecoveryException)this._ex;
                }
                throw new RecoveryException(0, this._ex.toString());
            }
        }

        public void commit(XID xID, byte[] byArray, byte[] byArray2, byte[] byArray3) throws ResourceManagerException, RecoveryException, HeuristicException {
            this._request = this.COMMIT;
            this.driveResource(xID, byArray, byArray2, byArray3);
        }

        public void rollback(XID xID, byte[] byArray, byte[] byArray2, byte[] byArray3) throws ResourceManagerException, RecoveryException, HeuristicException {
            this._request = this.ROLLBACK;
            this.driveResource(xID, byArray, byArray2, byArray3);
        }

        public void forget(XID xID, byte[] byArray) throws ResourceManagerException, RecoveryException {
            this._request = this.FORGET;
            try {
                this.driveResource(xID, byArray, null, null);
            }
            catch (HeuristicException heuristicException) {
                throw new RecoveryException(0, heuristicException.toString());
            }
        }

        private void driveResource(XID xID, byte[] byArray, byte[] byArray2, byte[] byArray3) throws HeuristicException, RecoveryException, ResourceManagerException {
            this._xidArray = new XID[]{xID};
            this._token = byArray;
            this._fsToken = byArray2;
            this._logProperties = byArray3;
            try {
                this.setDaemon(true);
                this.start();
                this.join();
            }
            catch (Throwable throwable) {
                this._ex = new RecoveryException(0, "Caught " + throwable.toString() + " during method");
            }
            if (this._ex != null) {
                if (this._ex instanceof RecoveryException) {
                    throw (RecoveryException)this._ex;
                }
                if (this._ex instanceof ResourceManagerException) {
                    throw (ResourceManagerException)this._ex;
                }
                if (this._ex instanceof HeuristicException) {
                    throw (HeuristicException)this._ex;
                }
                throw new RecoveryException(0, this._ex.toString());
            }
        }

        public void run() {
            block9: {
                XARecoveryAgentImpl xARecoveryAgentImpl = new XARecoveryAgentImpl();
                if (this._cl != null) {
                    try {
                        this.setContextClassLoader(this._cl);
                    }
                    catch (Throwable throwable) {
                        this._ex = new RecoveryException(0, "Could not set classloader, " + throwable.toString());
                    }
                }
                try {
                    if (this._request == this.RBUNKNOWN) {
                        xARecoveryAgentImpl.rollbackUnknownTransactions(this._xidArray, this._epoch, this._token, this);
                        break block9;
                    }
                    if (this._request == this.COMMIT) {
                        xARecoveryAgentImpl.commit(this._xidArray[0], this._token, this._fsToken, this._logProperties, this);
                        break block9;
                    }
                    if (this._request == this.ROLLBACK) {
                        xARecoveryAgentImpl.rollback(this._xidArray[0], this._token, this._fsToken, this._logProperties, this);
                        break block9;
                    }
                    if (this._request == this.FORGET) {
                        xARecoveryAgentImpl.forget(this._xidArray[0], this._token, this);
                        break block9;
                    }
                    throw new RecoveryException(0, "Illegal Operation");
                }
                catch (UserException userException) {
                    this.setException(userException);
                }
            }
        }
    }
}

