/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws390.tx;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ws.management.AdminServiceImpl;
import com.ibm.ws.runtime.component.TxServiceImpl;
import com.ibm.ws390.tx.ControllerTransactionManagerSet;
import com.ibm.ws390.tx.NativeServerInstanceData;
import com.ibm.ws390.tx.ResourceManager;
import com.ibm.ws390.tx.XARecoveryAgentImpl;
import com.ibm.ws390.tx.xarecovery.RecoveryException;
import com.ibm.ws390.tx.xarecovery.XARecoveryAgent;
import com.ibm.ws390.tx.xarecovery.XID;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;

public class XaRecoveryAlarm
implements AlarmListener {
    private static final TraceComponent tc = Tr.register(XaRecoveryAlarm.class, "Transaction", "com.ibm.ws.Transaction.resources.TransactionMsgs");
    private static final byte[] NULL_STOKEN = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    private static final int INITIAL_SNOOZE_TIME = 5;
    private static final int MAX_SNOOZE_TIME = 60;
    private byte[] _stoken = null;
    private XID[] _xids = null;
    private boolean _delayPrrTranRecovery = false;
    private boolean _resyncComplete = false;
    private boolean _reregister = true;
    private int _snoozeTime = 5;

    XaRecoveryAlarm(byte[] byArray, XID[] xIDArray, boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{byArray != null ? new ByteArray(byArray) : null, xIDArray, new Boolean(bl)});
        }
        this._stoken = byArray;
        this._xids = xIDArray;
        this._delayPrrTranRecovery = bl;
        this._snoozeTime = 5;
        AlarmManager.createNonDeferrable((long)this._snoozeTime * 1000L, this, null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "alarm", object);
        }
        if (this._stoken == null) {
            if (!this._resyncComplete) {
                this.driveCrRecovery();
            } else {
                this.completeCrRecovery();
            }
        } else {
            this.driveSrRecovery();
        }
        if (this._reregister) {
            this._snoozeTime = this.computeSnoozeTime();
            AlarmManager.createNonDeferrable((long)this._snoozeTime * 1000L, this, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "alarm", new Boolean(this._reregister));
        }
    }

    private void driveCrRecovery() {
        ResourceManager resourceManager;
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "driveCrRecovery");
            }
            final XARecoveryAgent xARecoveryAgent = this.getXaRecoveryAgent();
            final byte[] byArray = new byte[]{};
            ControllerTransactionManagerSet controllerTransactionManagerSet = ControllerTransactionManagerSet.instance();
            resourceManager = controllerTransactionManagerSet.getResourceManager();
            try {
                if (xARecoveryAgent != null) {
                    final int n = NativeServerInstanceData.getRestartEpoch();
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public Object run() throws RecoveryException {
                            xARecoveryAgent.rollbackUnknownTransactions(XaRecoveryAlarm.this._xids, n, byArray);
                            return null;
                        }
                    };
                    TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
                    resourceManager.setXaRecoveryDriven();
                    this._resyncComplete = true;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Postponing CR recovery", this._stoken);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Recovery failure while rolling back unknown transactions", privilegedActionException.getCause());
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) break block12;
                Tr.event(tc, "Failure while rolling back unknown transactions", throwable);
            }
        }
        if (this._resyncComplete) {
            if (resourceManager.isColdStart() && !resourceManager.isColdStartInRecoveryMode()) {
                NativeServerInstanceData.setRecoveryComplete(true);
                this._reregister = false;
            } else {
                this.completeCrRecovery();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "driveCrRecovery");
        }
    }

    private void completeCrRecovery() {
        XARecoveryAgent xARecoveryAgent;
        ControllerTransactionManagerSet controllerTransactionManagerSet;
        ResourceManager resourceManager;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "completeCrRecovery");
        }
        if ((resourceManager = (controllerTransactionManagerSet = ControllerTransactionManagerSet.instance()).getResourceManager()).isRecoveryComplete() && (xARecoveryAgent = this.getXaRecoveryAgent()) != null) {
            try {
                NativeServerInstanceData.setRecoveryComplete(true);
                if (!resourceManager.isRestartOnlyMode() || !this._delayPrrTranRecovery) {
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public Object run() throws RecoveryException {
                            xARecoveryAgent.rrsRecoveryComplete();
                            return null;
                        }
                    };
                    TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
                }
                resourceManager.setXaRecoveryComplete();
                this._reregister = false;
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Recovery failure while attempting clean the XA partner log", privilegedActionException.getCause());
                }
                NativeServerInstanceData.setRecoveryComplete(false);
            }
            catch (Throwable throwable) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Failure while  cleaning XA partner log", throwable);
                }
                NativeServerInstanceData.setRecoveryComplete(false);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "completeCrRecovery");
        }
    }

    private void driveSrRecovery() {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "driveSrRecovery");
            }
            final XARecoveryAgent xARecoveryAgent = this.getXaRecoveryAgent();
            try {
                if (xARecoveryAgent != null) {
                    final int n = NativeServerInstanceData.getRestartEpoch();
                    PrivilegedExceptionAction privilegedExceptionAction = new PrivilegedExceptionAction(){

                        public Object run() throws RecoveryException {
                            xARecoveryAgent.rollbackUnknownTransactions(XaRecoveryAlarm.this._xids, n, XaRecoveryAlarm.this._stoken);
                            return null;
                        }
                    };
                    TxServiceImpl.runAsSystemOrSpecified(privilegedExceptionAction);
                    this._reregister = false;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Postponing SR recovery", this._stoken);
                }
            }
            catch (PrivilegedActionException privilegedActionException) {
                if (tc.isEventEnabled()) {
                    Tr.event(tc, "Recovery failure while rolling back unknown transactions", privilegedActionException.getCause());
                }
            }
            catch (Throwable throwable) {
                if (!tc.isEventEnabled()) break block9;
                Tr.event(tc, "Failure while rolling backunknown transactions", throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "driveSrRecovery");
        }
    }

    XARecoveryAgent getXaRecoveryAgent() {
        XARecoveryAgent xARecoveryAgent;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getXaRecoveryAgent");
            }
            xARecoveryAgent = null;
            byte[] byArray = NativeServerInstanceData.getRecoveryServantStoken();
            if (this.isStokenValid(byArray)) {
                Iterator iterator = AdminServiceImpl.getPlatformUtils().getSRAggregator(new XARecoveryAgentImpl(), false, byArray);
                try {
                    xARecoveryAgent = (XARecoveryAgent)iterator.next();
                }
                catch (Throwable throwable) {
                    if (!tc.isEventEnabled()) break block5;
                    Tr.event(tc, "Could not get XARecoveryAgent", throwable);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getXaRecoveryAgent", xARecoveryAgent);
        }
        return xARecoveryAgent;
    }

    private boolean isStokenValid(byte[] byArray) {
        boolean bl = false;
        if (byArray != null && !Arrays.equals(byArray, NULL_STOKEN)) {
            bl = true;
        }
        return bl;
    }

    private int computeSnoozeTime() {
        int n = this._snoozeTime * 5 / 4;
        if (n > 60) {
            n = 60;
        }
        if (n <= 5) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Curiously low snooze time generated", new Integer(n));
            }
            n = 5;
        }
        return n;
    }
}

